/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.config;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.webframework.FrameworkConstants;
import com.trs.webframework.config.LoadingErrorReport;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.config.ServiceConfigHelper;
import com.trs.webframework.provider.IServiceProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ServiceConfig {
    protected static Logger logger = Logger.getLogger(ServiceConfig.class);
    private Map m_mapServices = null;
    private LoadingErrorReport m_oLoadingErrorReport = null;
    private IServiceProvider m_oServiceProvider = null;
    private String m_sServiceId = null;
    private String m_sObjKlassName;

    public ServiceConfig(String _sServiceId) {
        this.m_sServiceId = _sServiceId;
    }

    public String getServiceId() {
        return this.m_sServiceId;
    }

    public Collection getServices() {
        return this.m_mapServices.values();
    }

    public MethodConfig findMethodByName(String _sName) {
        Integer iTypeKey = new Integer(_sName.toLowerCase().hashCode());
        return (MethodConfig)this.m_mapServices.get(iTypeKey);
    }

    public void loadFromFile(String _sConfigFile) {
        this.m_mapServices = new HashMap(4);
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(_sConfigFile);
            Element root = document.getRootElement();
            String sDefaultProviderClassName = root.attributeValue("provider");
            String sDecoratorClassName = root.attributeValue("decorator");
            IServiceProvider oDefaultProvider = null;
            oDefaultProvider = sDecoratorClassName != null && sDecoratorClassName.trim().length() != 0 ? ServiceConfigHelper.makeProvider(sDefaultProviderClassName, sDecoratorClassName) : ServiceConfigHelper.makeProvider(sDefaultProviderClassName);
            if (oDefaultProvider == null) {
                return;
            }
            this.m_sObjKlassName = root.attributeValue("objclass");
            this.m_oServiceProvider = oDefaultProvider;
            Iterator i = root.elementIterator("method");
            while (i.hasNext()) {
                Element elMethod = (Element)i.next();
                String sType = elMethod.attributeValue("name");
                if (sType == null || (sType = sType.trim()).length() == 0) continue;
                int nType = sType.toLowerCase().hashCode();
                try {
                    if (nType == 96673) {
                        for (int j = 0; j < FrameworkConstants.METHOD_TYPES.length; ++j) {
                            int nTemp = FrameworkConstants.METHOD_TYPES[j];
                            this.m_mapServices.put(new Integer(nTemp), this.makeMethodConfig(nTemp, elMethod, oDefaultProvider));
                        }
                        continue;
                    }
                    this.m_mapServices.put(new Integer(nType), this.makeMethodConfig(nType, elMethod, oDefaultProvider));
                }
                catch (Throwable ex) {
                    logger.error((Object)(I18NMessage.get(ServiceConfig.class, "ServiceConfig.label1", "\u65b9\u6cd5 [") + sType + I18NMessage.get(ServiceConfig.class, "ServiceConfig.label2", "] \u7684\u914d\u7f6e\u4fe1\u606f\u8bbe\u7f6e\u9519\u8bef\uff01")), ex);
                    if (this.m_oLoadingErrorReport == null) {
                        this.m_oLoadingErrorReport = new LoadingErrorReport();
                    }
                    this.m_oLoadingErrorReport.add(I18NMessage.get(ServiceConfig.class, "ServiceConfig.label1", "\u65b9\u6cd5 [") + sType + I18NMessage.get(ServiceConfig.class, "ServiceConfig.label2", "] \u7684\u914d\u7f6e\u4fe1\u606f\u8bbe\u7f6e\u9519\u8bef\uff01"), ex);
                }
            }
        }
        catch (DocumentException ex) {
            logger.error((Object)(I18NMessage.get(ServiceConfig.class, "ServiceConfig.label3", "\u89e3\u6790\u6587\u4ef6[") + _sConfigFile + I18NMessage.get(ServiceConfig.class, "ServiceConfig.label4", "]\u5931\u8d25!")), (Throwable)ex);
            this.m_oLoadingErrorReport = new LoadingErrorReport(I18NMessage.get(ServiceConfig.class, "ServiceConfig.label3", "\u89e3\u6790\u6587\u4ef6[") + _sConfigFile + I18NMessage.get(ServiceConfig.class, "ServiceConfig.label4", "]\u5931\u8d25!"), ex);
        }
    }

    private Object makeMethodConfig(int _nServiceType, Element _elMethod, IServiceProvider _oDefaultProvider) throws CMyException {
        MethodConfig config = new MethodConfig(_nServiceType, this);
        config.initFrom(_elMethod, _oDefaultProvider);
        return config;
    }

    public LoadingErrorReport getLoadingErrorReport() {
        return this.m_oLoadingErrorReport;
    }

    public Map getMethodConfigsMap() {
        return this.m_mapServices;
    }

    public IServiceProvider getServiceProvider() {
        return this.m_oServiceProvider;
    }

    public String getObjKlassName() {
        return this.m_sObjKlassName;
    }
}

