/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.config;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.webframework.config.ServiceConfig;
import com.trs.webframework.config.ServiceConfigHelper;
import com.trs.webframework.config.TRSPageParameter;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.exception.NoSuchServiceException;
import com.trs.webframework.exception.ServiceCreationFailException;
import com.trs.webframework.provider.IServiceProvider;
import com.trs.webframework.xmlserver.IXMLConvertor;
import com.trs.webframework.xmlserver.XMLConvertorFactory;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class MethodConfig {
    private static Logger logger = Logger.getLogger(MethodConfig.class);
    private boolean m_bIsVirtual = false;
    private int m_nMethdoNameHashCode = 0;
    private IServiceProvider m_oProvider = null;
    private TRSPageParameter[] m_pPageParameter = null;
    private String m_sName = null;
    private String m_sTrueName = null;
    private Method m_oMethod = null;
    private String m_sUri = null;
    private String m_sUrl = null;
    private boolean m_bParamsRequired = true;
    private boolean m_bIsSingleton = false;
    private String m_sProviderClassName = null;
    private ServiceConfig m_oServiceConfig = null;
    private String m_sConvertorValue = null;
    private String m_sLoggerName;
    private boolean m_zLogged;
    private String m_sLogObjClassName;
    private String m_sDesc;
    private int m_nConvertorType = 0;

    public MethodConfig(int _nMethodNameHashCode, ServiceConfig _ServiceConfig2) {
        this.m_nMethdoNameHashCode = _nMethodNameHashCode;
        this.m_oServiceConfig = _ServiceConfig2;
        this.m_sLogObjClassName = this.m_oServiceConfig.getObjKlassName();
    }

    public IServiceProvider getProvider() {
        if (this.m_oProvider == null || this.m_sProviderClassName == null) {
            return null;
        }
        if (this.m_bIsSingleton) {
            return this.m_oProvider;
        }
        return this.createProvider(this.m_sProviderClassName);
    }

    public TRSPageParameter[] getPageParameter() {
        return this.m_pPageParameter;
    }

    public void initFrom(Element _elMethod, IServiceProvider _oDefaultProvider) throws CMyException {
        String sIsSingleton;
        this.m_sName = _elMethod.attributeValue("name");
        if (this.m_sName == null || (this.m_sName = this.m_sName.trim()).length() == 0) {
            throw new CMyException(I18NMessage.get(MethodConfig.class, "MethodConfig.label1", "\u6ca1\u6709\u8bbe\u7f6ename\uff01"));
        }
        this.m_sTrueName = _elMethod.attributeValue("truename");
        if (this.m_sTrueName != null && !this.m_sTrueName.equalsIgnoreCase(this.m_sName)) {
            this.m_bIsVirtual = true;
        }
        this.m_sLoggerName = _elMethod.attributeValue("logger");
        if (CMyString.isEmpty(this.m_sLoggerName) && this.m_bIsVirtual) {
            MethodConfig realMethodConf = this.m_oServiceConfig.findMethodByName(this.m_sTrueName);
            this.m_sLoggerName = realMethodConf.getLoggerName();
        }
        this.m_zLogged = !CMyString.isEmpty(this.m_sLoggerName);
        String klassName = _elMethod.attributeValue("objclass");
        if (!CMyString.isEmpty(klassName)) {
            this.m_sLogObjClassName = klassName;
        }
        this.m_sDesc = _elMethod.attributeValue("desc");
        if (CMyString.isEmpty(this.m_sDesc) && this.m_bIsVirtual) {
            MethodConfig realMethodConf = this.m_oServiceConfig.findMethodByName(this.m_sTrueName);
            this.m_sDesc = realMethodConf.getDesc();
        }
        if ((sIsSingleton = _elMethod.attributeValue("isSingleton")) != null && ((sIsSingleton = sIsSingleton.trim().toLowerCase()) == "true" || sIsSingleton == "1")) {
            this.m_bIsSingleton = true;
        }
        this.m_sUri = _elMethod.attributeValue("uri");
        this.m_sUrl = _elMethod.attributeValue("url");
        if (this.m_sUri == null && this.m_sUrl == null) {
            this.initNormalParams(_elMethod, _oDefaultProvider);
        } else if (this.m_sUri != null && this.m_sUri.trim().length() == 0 && this.m_sUrl != null && this.m_sUrl.trim().length() == 0) {
            throw new ServiceCreationFailException(I18NMessage.get(MethodConfig.class, "MethodConfig.label2", "\u65e0\u6cd5\u4e3a\u65b9\u6cd5[") + this.m_sName + I18NMessage.get(MethodConfig.class, "MethodConfig.label3", "]\u521b\u5efa\u6307\u5b9a\u4e3a\u7a7a\u4e32\u7684\u670d\u52a1\u8df3\u8f6c\u94fe\u63a5\uff01"));
        }
        String sConvertor = _elMethod.attributeValue("convertor");
        if (sConvertor != null && (sConvertor = sConvertor.trim()).length() > 0) {
            int nPos = sConvertor.indexOf(58);
            if (nPos <= 0) {
                logger.error((Object)(this.getServiceConfig().getServiceId() + "." + this.getName() + I18NMessage.get(MethodConfig.class, "MethodConfig.label4", "\u6307\u5b9a\u7684Convertor[") + sConvertor + I18NMessage.get(MethodConfig.class, "MethodConfig.label5", "]\u4e0d\u7b26\u5408\u62df\u5b9a\u7684\u534f\u8bae\uff01")));
            } else {
                String sConvertorType = sConvertor.substring(0, nPos).toUpperCase();
                if (sConvertorType.equals("URI")) {
                    this.m_nConvertorType = 1;
                } else if (sConvertorType.equals("URL")) {
                    this.m_nConvertorType = 2;
                } else if (sConvertorType.equals("XML")) {
                    this.m_nConvertorType = 3;
                } else if (sConvertorType.equals("JSON")) {
                    this.m_nConvertorType = 4;
                }
                this.m_sConvertorValue = sConvertor.substring(nPos + 1);
            }
        }
        this.initPageParameters(_elMethod);
        if (this.isDefaultURI()) {
            this.m_nConvertorType = 1;
        }
    }

    public boolean isDefaultURI() {
        String sServiceId = this.getServiceConfig().getServiceId();
        String sMethodName = this.getTrueName();
        return "wcm6_Default".equalsIgnoreCase(sServiceId) && "forword".equalsIgnoreCase(sMethodName);
    }

    private void initNormalParams(Element _elService, IServiceProvider _oDefaultProvider) {
        IServiceProvider service = this.createProvider(_elService, _oDefaultProvider);
        if (service == null) {
            return;
        }
        this.m_oProvider = ServiceConfigHelper.validateProvider(this.m_nMethdoNameHashCode, service);
        if (this.m_oProvider == null) {
            return;
        }
        if (ServiceConfigHelper.isSelfDefinedMethodName(this.m_nMethdoNameHashCode)) {
            String sParamsRequired = _elService.attributeValue("params-required");
            if (sParamsRequired != null && (sParamsRequired = sParamsRequired.trim()).length() > 0) {
                this.m_bParamsRequired = sParamsRequired.compareToIgnoreCase("true") == 0 || sParamsRequired.equals("1");
            }
            try {
                this.m_oMethod = this.m_bParamsRequired ? this.m_oProvider.getClass().getMethod(this.getTrueName(), MethodContext.class) : this.m_oProvider.getClass().getMethod(this.getTrueName(), null);
            }
            catch (SecurityException ex) {
                throw new NoSuchServiceException(I18NMessage.get(MethodConfig.class, "MethodConfig.label6", "\u65e0\u6cd5\u4ece Service \u63d0\u4f9b\u8005[") + this.getProvider().getClass().getName() + I18NMessage.get(MethodConfig.class, "MethodConfig.label7", "]\u83b7\u53d6\u65b9\u6cd5[") + this.m_sName + "]\uff01", ex);
            }
            catch (NoSuchMethodException ex) {
                throw new NoSuchServiceException(I18NMessage.get(MethodConfig.class, "MethodConfig.label8", "Service \u63d0\u4f9b\u8005[") + this.getProvider().getClass().getName() + I18NMessage.get(MethodConfig.class, "MethodConfig.label9", "]\u6ca1\u6709\u5b9a\u4e49\u65b9\u6cd5[") + this.m_sName + "(" + (this.m_bParamsRequired ? "MethodContext" : "") + ")]\uff01", ex);
            }
        }
        if (this.m_oProvider instanceof IXMLConvertor) {
            IXMLConvertor convertor = (IXMLConvertor)((Object)this.m_oProvider);
            String[] pTargetClassName = convertor.registerTargetClassName();
            for (int i = 0; i < pTargetClassName.length; ++i) {
                XMLConvertorFactory.registerConvertor(convertor, pTargetClassName[i]);
            }
        }
    }

    private IServiceProvider createProvider(Element _elService, IServiceProvider _oDefaultProvider) {
        String sProviderClassName = _elService.attributeValue("provider");
        String sDecoratorClassName = _elService.attributeValue("decorator");
        IServiceProvider service = null;
        if (sProviderClassName != null && sProviderClassName.length() > 0) {
            service = ServiceConfigHelper.makeProvider(sProviderClassName, sDecoratorClassName);
            this.m_sProviderClassName = sDecoratorClassName == null ? sProviderClassName : sDecoratorClassName;
        } else {
            service = _oDefaultProvider;
            this.m_sProviderClassName = _oDefaultProvider.getClass().getName();
        }
        return service;
    }

    private IServiceProvider createProvider(String _sProviderClassName) {
        return ServiceConfigHelper.makeProvider(_sProviderClassName, null);
    }

    private void initPageParameters(Element _elService) throws CMyException {
        List listParameter = _elService.elements("parameter");
        int nParametersSize = listParameter.size();
        if (this.m_bIsVirtual) {
            MethodConfig config = this.m_oServiceConfig.findMethodByName(this.m_sTrueName);
            if (config == null) {
                throw new CMyException(I18NMessage.get(MethodConfig.class, "MethodConfig.label10", "\u65b9\u6cd5[") + this.m_sTrueName + I18NMessage.get(MethodConfig.class, "MethodConfig.label11", "]\u6ca1\u6709\u627e\u5230\uff01"));
            }
            TRSPageParameter[] pageParameters = config.getPageParameter();
            this.m_pPageParameter = new TRSPageParameter[nParametersSize + pageParameters.length];
            this.m_sTrueName = config.getTrueName();
            System.arraycopy(pageParameters, 0, this.m_pPageParameter, nParametersSize, pageParameters.length);
        } else {
            this.m_pPageParameter = new TRSPageParameter[nParametersSize];
        }
        for (int i = 0; i < nParametersSize; ++i) {
            Element elParameter = (Element)listParameter.get(i);
            if (elParameter == null) continue;
            TRSPageParameter parameter = new TRSPageParameter();
            parameter.fromXML(elParameter);
            if (this.m_bIsVirtual) {
                boolean bContainsParameter = false;
                for (int j = 0; j < this.m_pPageParameter.length; ++j) {
                    if (this.m_pPageParameter[j] == null || !parameter.getName().equalsIgnoreCase(this.m_pPageParameter[j].getName())) continue;
                    this.m_pPageParameter[j] = parameter;
                    this.m_pPageParameter[i] = null;
                    bContainsParameter = true;
                }
                if (bContainsParameter) continue;
            }
            this.m_pPageParameter[i] = parameter;
        }
    }

    public int getMethdoNameHashCode() {
        return this.m_nMethdoNameHashCode;
    }

    public Method getMethod() {
        return this.m_oMethod;
    }

    public void setMethod(Method method) {
        this.m_oMethod = method;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String name) {
        this.m_sName = name;
    }

    public String getTrueName() {
        if (this.m_sTrueName == null || this.m_sTrueName.length() == 0) {
            this.m_sTrueName = this.m_sName;
        }
        return this.m_sTrueName;
    }

    public void setTrueName(String trueName) {
        this.m_sTrueName = trueName;
        if (this.m_sTrueName != null) {
            this.m_sTrueName = this.m_sTrueName.trim();
        }
    }

    public void setMethdoNameHashCode(int methdoNameHashCode) {
        this.m_nMethdoNameHashCode = methdoNameHashCode;
    }

    public boolean isPageParametersEmpty() {
        return this.m_pPageParameter == null || this.m_pPageParameter.length == 0;
    }

    public String toString() {
        return this.getTrueName();
    }

    public String getUri() {
        return this.m_sUri;
    }

    public void setUri(String uri) {
        this.m_sUri = uri;
    }

    public String getUrl() {
        return this.m_sUrl;
    }

    public void setUrl(String url) {
        this.m_sUrl = url;
    }

    public boolean isParamsRequired() {
        return this.m_bParamsRequired;
    }

    public ServiceConfig getServiceConfig() {
        return this.m_oServiceConfig;
    }

    public int getConvertorType() {
        return this.m_nConvertorType;
    }

    public String getConvertorValue() {
        return this.m_sConvertorValue;
    }

    public String getLoggerName() {
        return this.m_sLoggerName;
    }

    public boolean isLogged() {
        return this.m_zLogged;
    }

    public String getLogObjClassName() {
        return this.m_sLogObjClassName;
    }

    public String getDesc() {
        return this.m_sDesc;
    }
}

