/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.publish;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.store.FileService;
import com.trs.presentation.plugin.PluginConfig;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.impl.ImageMagickCmd;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ImgFileParserHelper {
    private static Logger logger = Logger.getLogger(ImgFileParserHelper.class);
    private static final Set IMAGE_SUFFIX_SET = new HashSet(8);
    private static final long MIN_FILE_SIZE = 10L;

    public static String makeAbsoluteFilePathAndConvert(String _sImgFileName, PublishTagContext _oTagContext) throws WCMException {
        int nMaxTryTimes;
        String sFileName = CMyFile.extractFileName(_sImgFileName);
        FilesMan filesMan = FilesMan.getFilesMan();
        String sAbsoluteFilePath = filesMan.mapFilePath(sFileName, 0);
        String sSrcAbsoluteFile = sAbsoluteFilePath + sFileName;
        if (_oTagContext.getAttribute("ImgReturnSource", false)) {
            return sSrcAbsoluteFile;
        }
        IImageLibConfig m_libConf = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        if (!m_libConf.isCmdUsed() && !PluginConfig.isStartPhoto()) {
            return sSrcAbsoluteFile;
        }
        String sFileExt = "";
        int nPos = sFileName.lastIndexOf(46);
        if (nPos > 0) {
            sFileExt = sFileName.substring(nPos + 1);
        }
        if (!ImgFileParserHelper.isImageFile(sFileExt)) {
            return sSrcAbsoluteFile;
        }
        int nNewWidth = _oTagContext.getAttribute("InWidth", -1);
        if (nNewWidth == -1) {
            nNewWidth = _oTagContext.getAttribute("Width", -1);
        }
        String sDefaultImgRate = ConfigServer.getServer().getSysConfigValue("IMG_RATE_DEFAULT", "75");
        int nNewRate = _oTagContext.getAttribute("ImgRate", Integer.parseInt(sDefaultImgRate));
        boolean bToJPG = _oTagContext.getAttribute("ImgToJPG", false);
        String sNewFileExt = ("png".equalsIgnoreCase(sFileExt) || "bmp".equalsIgnoreCase(sFileExt)) && bToJPG ? "jpg" : sFileExt;
        String sNewAbsoluteFile = sAbsoluteFilePath + sFileName.substring(0, nPos) + (nNewWidth > 0 ? "_w" + nNewWidth : "") + (nNewRate < 100 ? "_r" + nNewRate : "") + "." + sNewFileExt;
        boolean bNeedToCreate = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("Need_Create_New", "false"));
        if (ImgFileParserHelper.isValidFile(sNewAbsoluteFile) && !bNeedToCreate) {
            return sNewAbsoluteFile;
        }
        if (!CMyFile.fileExists(sSrcAbsoluteFile) || !CMyFile.validImageFile(sSrcAbsoluteFile, 0, 0)) {
            logger.warn((Object)("The file not exists![File=" + sSrcAbsoluteFile + "]"), (Throwable)new Exception("who call me?"));
            return sAbsoluteFilePath + sFileName;
        }
        for (int i = nMaxTryTimes = 16; i >= 0; --i) {
            block15: {
                FileService file = new FileService(sNewAbsoluteFile);
                if (file.exists() && file.length() > 10L && !bNeedToCreate) {
                    return sNewAbsoluteFile;
                }
                try {
                    sNewAbsoluteFile = ImageMagickCmd.convert(sSrcAbsoluteFile, sNewAbsoluteFile, nNewRate, nNewWidth);
                    file = new FileService(sNewAbsoluteFile);
                    if (file.exists() && file.length() > 10L) {
                        return sNewAbsoluteFile;
                    }
                }
                catch (Exception e) {
                    if (i != 0) break block15;
                    throw new WCMException("Fail to scale image!", e);
                }
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Wait some millis to retry scale: " + sNewAbsoluteFile));
                }
                Thread.sleep(150L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.warn((Object)("Failed to generate the scale image: " + sNewAbsoluteFile + ", the original file returned: " + sSrcAbsoluteFile));
        return sSrcAbsoluteFile;
    }

    public static String makeFileNameAndConvert(String _sImageFileName, PublishTagContext _context) throws WCMException {
        String sNewAbsoluteFilePath = ImgFileParserHelper.makeAbsoluteFilePathAndConvert(_sImageFileName, _context);
        return CMyFile.extractFileName(sNewAbsoluteFilePath);
    }

    private static boolean isImageFile(String sFileExt) {
        return sFileExt != null && IMAGE_SUFFIX_SET.contains(sFileExt.toLowerCase());
    }

    private static boolean isValidFile(String fileName) {
        FileService file = new FileService(fileName);
        return file.exists() && file.isFile() && file.length() > 10L;
    }

    static {
        IMAGE_SUFFIX_SET.add("png");
        IMAGE_SUFFIX_SET.add("jpg");
        IMAGE_SUFFIX_SET.add("jpeg");
        IMAGE_SUFFIX_SET.add("gif");
        IMAGE_SUFFIX_SET.add("bmp");
    }
}

