/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.tools.ResourceAnalyzer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommonResourceBuilder {
    static ArrayList m_lstCommonJs = new ArrayList();
    static ArrayList m_lstCommonCss;
    static Object[][] m_arrXxxData;
    private static String m_sJsEncoding;
    static Map combinedMapping;
    public static String locale;

    static boolean isWidgetCss(String filename) {
        return filename.startsWith("js/");
    }

    public static void outContent(String fn, StringBuffer out, boolean compress, boolean cur) throws Exception {
        if (!cur && fn.endsWith("js/source/wcmlib/pagecontext/AbsList.js")) {
            CommonResourceBuilder.doAbsList(fn, out);
            return;
        }
        if (!cur && fn.endsWith("js/source/wcmlib/pagecontext/AbsThumb.js")) {
            CommonResourceBuilder.doAbsThumb(fn, out);
            return;
        }
        if (!cur && fn.indexOf("js/data/combine.jsp") != -1) {
            CommonResourceBuilder.doJsDataCombine(fn, out);
            return;
        }
        FileService file = new FileService(fn);
        if (!file.exists() || file.isHidden() || !file.canRead()) {
            return;
        }
        String sFileName = file.getName();
        if (!sFileName.endsWith(".css") && !sFileName.endsWith(".js")) {
            return;
        }
        System.out.println(fn);
        String sContent = CMyFile.readFile(fn, CharsetDetector.detect(fn));
        if (sContent.length() >= 2) {
            byte[] bytes = sContent.substring(0, 2).getBytes("utf-8");
            if (bytes[0] == -17 && bytes[1] == -69) {
                bytes = sContent.getBytes("utf-8");
                byte[] newbytes = new byte[bytes.length - 3];
                System.arraycopy(bytes, 3, newbytes, 0, bytes.length - 3);
                sContent = new String(newbytes, "utf-8");
            }
        } else {
            return;
        }
        if (compress) {
            sContent = sContent.replaceAll("(^|[^/])/\\*(.|\n)+?\\*/", "$1");
            sContent = sContent.replaceAll("(?m)^\\s*([^'\"]*?)//.*$", "$1\n").replaceAll("(?m)^\\s*(.*)\\s*$", "$1\n").replaceAll("([\\{;])\\s*\n", "$1\n").replaceAll("\\s*\n(\\})", "\n$1").replaceAll("\n{2,}", "\n").replaceAll("[ \t]{1,}", " ");
        }
        out.append(sContent);
        out.append("\n");
    }

    private static void outFolder(String realPath, String subFolder, StringBuffer out) throws Exception {
        int i;
        FileService file = new FileService(realPath + subFolder);
        if (!file.exists()) {
            return;
        }
        FileStore[] files = file.listFiles();
        if (files != null && files.length > 0) {
            for (i = 0; i < files.length; ++i) {
                if (!files[i].isFile()) continue;
                CommonResourceBuilder.outContent(files[i].getAbsolutePath(), out, true, false);
            }
        }
        if (files != null && files.length > 0) {
            for (i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                CommonResourceBuilder.outFolder(realPath + subFolder + File.separator, files[i].getName(), out);
            }
        }
    }

    private static void outFolder(FileStore folder, StringBuffer out) throws Exception {
        int i;
        if (folder == null || !folder.exists() || !folder.isDirectory()) {
            return;
        }
        FileStore[] files = folder.listFiles();
        if (files != null && files.length > 0) {
            for (i = 0; i < files.length; ++i) {
                if (!files[i].isFile()) continue;
                CommonResourceBuilder.outContent(files[i].getAbsolutePath(), out, true, false);
            }
        }
        if (files != null && files.length > 0) {
            for (i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                CommonResourceBuilder.outFolder(files[i], out);
            }
        }
    }

    private static void doJsDataCombine(String fn, StringBuffer out) throws Exception {
        String realPath = fn.replaceAll("combine\\.jsp.*$", "");
        String[] folders = fn.replaceAll("^.*combine\\.jsp\\?s=", "").split(",");
        for (int i = 0; i < folders.length; ++i) {
            CommonResourceBuilder.outFolder(realPath, folders[i], out);
        }
    }

    private static void doAbsList(String fn, StringBuffer out) throws Exception {
        String realPath = fn.replaceAll("AbsList\\.js$", "");
        String[] fileNames = new String[]{"PageContext.js", "BubblePanel.js", "PageLayout.js", "PageFilter.js", "PageGrid.js", "PageOper.js", "PageNav.js", "PageTab.js", "PageLiterator.js", "KeyProvider.js", "PageContextAdapter.js"};
        for (int i = 0; i < fileNames.length; ++i) {
            CommonResourceBuilder.outContent(realPath + fileNames[i], out, true, false);
        }
    }

    private static void doAbsThumb(String fn, StringBuffer out) throws Exception {
        String realPath = fn.replaceAll("AbsThumb\\.js$", "");
        String[] fileNames = new String[]{"PageContext.js", "BubblePanel.js", "PageLayout.js", "PageFilter.js", "AbsThumb.js", "PageOper.js", "PageNav.js", "PageTab.js", "PageLiterator.js", "KeyProvider.js", "PageContextAdapter.js"};
        for (int i = 0; i < fileNames.length; ++i) {
            if ("AbsThumb.js".equals(fileNames[i])) {
                CommonResourceBuilder.outContent(realPath + fileNames[i], out, true, true);
                continue;
            }
            CommonResourceBuilder.outContent(realPath + fileNames[i], out, true, false);
        }
    }

    public static ArrayList getMapped(String filename) {
        return (ArrayList)combinedMapping.get(filename);
    }

    public static void main(String[] args) throws Exception {
        try {
            CommonResourceBuilder.build("E:/MyWorkspace/TRS.WCM.V6.1.Std/release/cn/wcm/app");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void replaceLocaleJS() {
        int length = m_lstCommonJs.size();
        for (int i = 0; i < length; ++i) {
            Object[] pairs = (Object[])m_lstCommonJs.get(i);
            String[] jsFiles = (String[])pairs[1];
            for (int j = 0; j < jsFiles.length; ++j) {
                jsFiles[j] = jsFiles[j].replaceAll("\\$locale\\$", locale);
            }
        }
    }

    public static void build(String wcmPath) throws Exception {
        String fromFile;
        int j;
        StringBuffer outx;
        String toFile;
        Object[] pairs;
        int i;
        CommonResourceBuilder.replaceLocaleJS();
        combinedMapping.clear();
        String m_sSourceWcmPath = wcmPath == null ? ResourceAnalyzer.m_sSourceWcmPath : wcmPath;
        m_sSourceWcmPath = CMyString.setStrEndWith(m_sSourceWcmPath, '/');
        System.out.println("1.common js");
        for (i = 0; i < m_lstCommonJs.size(); ++i) {
            pairs = (Object[])m_lstCommonJs.get(i);
            toFile = m_sSourceWcmPath + (String)pairs[0];
            outx = new StringBuffer();
            ArrayList<String> toCombined = new ArrayList<String>();
            combinedMapping.put(pairs[0], toCombined);
            String[] fromFiles = (String[])pairs[1];
            for (j = 0; j < fromFiles.length; ++j) {
                fromFile = m_sSourceWcmPath + fromFiles[j];
                if (combinedMapping.containsKey(fromFiles[j])) {
                    toCombined.addAll((ArrayList)combinedMapping.get(fromFiles[j]));
                } else {
                    toCombined.add(fromFiles[j]);
                }
                FileService file = new FileService(fromFile);
                if (file.exists() && file.isDirectory()) {
                    CommonResourceBuilder.outFolder(m_sSourceWcmPath, fromFiles[j], outx);
                    continue;
                }
                CommonResourceBuilder.outContent(fromFile, outx, true, false);
            }
            System.out.println("====>" + toFile);
            CMyFile.writeFile(toFile, outx.toString(), m_sJsEncoding);
        }
        System.out.println("2.common css");
        for (i = 0; i < m_lstCommonCss.size(); ++i) {
            pairs = (Object[])m_lstCommonCss.get(i);
            toFile = m_sSourceWcmPath + (String)pairs[0];
            outx = new StringBuffer();
            String[] fromFiles = (String[])pairs[1];
            ArrayList<String> toCombined = new ArrayList<String>();
            combinedMapping.put(pairs[0], toCombined);
            for (j = 0; j < fromFiles.length; ++j) {
                fromFile = m_sSourceWcmPath + fromFiles[j];
                if (combinedMapping.containsKey(fromFiles[j])) {
                    toCombined.addAll((ArrayList)combinedMapping.get(fromFiles[j]));
                } else {
                    toCombined.add(fromFiles[j]);
                }
                CommonResourceBuilder.outContent(fromFile, outx, true, false);
            }
            CMyFile.writeFile(toFile, outx.toString(), m_sJsEncoding);
        }
        System.out.println("3.xxxData");
        for (i = 0; i < m_arrXxxData.length; ++i) {
            pairs = m_arrXxxData[i];
            String datapath = m_sSourceWcmPath + (String)pairs[0];
            FileService file = new FileService(datapath);
            if (!file.exists() || !file.isDirectory()) continue;
            FileStore[] files = file.listFiles();
            for (int j2 = 0; j2 < files.length; ++j2) {
                String sXxxFileName;
                if (files[j2].isDirectory() || !(sXxxFileName = files[j2].getName()).endsWith(".js")) continue;
                sXxxFileName = sXxxFileName.replaceAll("\\.js$", "");
                String toFile2 = (m_sSourceWcmPath + (String)pairs[1]).replaceAll("\\{0\\}", sXxxFileName);
                ArrayList<String> toCombined = new ArrayList<String>();
                combinedMapping.put(((String)pairs[1]).replaceAll("\\{0\\}", sXxxFileName), toCombined);
                StringBuffer outx2 = new StringBuffer();
                String[] fromFiles = (String[])pairs[2];
                for (int k = 0; k < fromFiles.length; ++k) {
                    String fromFile2 = (m_sSourceWcmPath + fromFiles[k]).replaceAll("\\{0\\}", sXxxFileName);
                    String sTmpKey = fromFiles[k].replaceAll("\\{0\\}", sXxxFileName);
                    if (combinedMapping.containsKey(sTmpKey)) {
                        toCombined.addAll((ArrayList)combinedMapping.get(sTmpKey));
                    } else {
                        toCombined.add(sTmpKey);
                    }
                    CommonResourceBuilder.outContent(fromFile2, outx2, true, false);
                }
                CommonResourceBuilder.joinSameFolder(files[j2], toCombined, outx2);
                CMyFile.writeFile(toFile2, outx2.toString(), m_sJsEncoding);
            }
        }
    }

    private static void joinSameFolder(FileStore currFile, List toCombined, StringBuffer outx) throws Exception {
        int i;
        String sXxxFolder = currFile.getAbsolutePath().replaceAll("\\.js$", "");
        FileService XxxFolder = new FileService(sXxxFolder);
        if (!XxxFolder.exists() || !XxxFolder.isDirectory()) {
            return;
        }
        FileStore[] aFile = XxxFolder.listFiles();
        for (i = 0; i < aFile.length; ++i) {
            if (!aFile[i].isFile()) continue;
            String sFileName = aFile[i].getAbsolutePath();
            if (combinedMapping.containsKey(sFileName)) {
                toCombined.addAll((ArrayList)combinedMapping.get(sFileName));
            } else {
                toCombined.add(sFileName);
            }
            CommonResourceBuilder.outContent(sFileName, outx, true, false);
        }
        for (i = 0; i < aFile.length; ++i) {
            if (!aFile[i].isDirectory()) continue;
            CommonResourceBuilder.outFolder(aFile[i], outx);
        }
    }

    public static String getCombineFile(String[] arrDatas) {
        int nResult = 0;
        for (int i = 0; i < arrDatas.length; ++i) {
            if ("locale".equalsIgnoreCase(arrDatas[i])) {
                ++nResult;
            }
            if ("tab".equalsIgnoreCase(arrDatas[i])) {
                nResult += 2;
            }
            if ("operpanel".equalsIgnoreCase(arrDatas[i])) {
                nResult += 4;
            }
            if ("opers".equalsIgnoreCase(arrDatas[i])) {
                nResult += 8;
            }
            if ("menu".equalsIgnoreCase(arrDatas[i])) {
                nResult += 16;
            }
            if ("contextmenu".equalsIgnoreCase(arrDatas[i])) {
                nResult += 32;
            }
            if (!"cmsobj".equalsIgnoreCase(arrDatas[i])) continue;
            nResult += 64;
        }
        switch (nResult) {
            case 2: 
            case 3: {
                return "js/runtime/data/fittable.js";
            }
            case 1: {
                return "js/runtime/data/locale_all.js";
            }
        }
        return null;
    }

    static {
        m_lstCommonJs.add(new Object[]{"js/runtime/lightlib.js", new String[]{"js/easyversion/lightbase.js", "js/easyversion/extrender.js", "js/easyversion/elementmore.js"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/core_min.js", new String[]{"js/source/wcmlib/WCMConstants.js", "js/source/wcmlib/core/MsgCenter.js", "js/source/wcmlib/core/CMSObj.js", "js/source/wcmlib/core/AuthServer.js"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/core_main.js", new String[]{"js/runtime/core_min.js", "js/source/wcmlib/core/SysOpers.js", "js/source/wcmlib/core/TabManager.js", "js/data/locale/system.js"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/menu_cmsmenu.js", new String[]{"js/source/wcmlib/com.trs.menu/Menu.js", "main/wcmMenuAdapter.js", "js/source/wcmlib/Observable.js", "js/source/wcmlib/simplemenu/SimpleMenu.js", "main/CMSMenu.js"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/dialog_dd.js", new String[]{"js/source/wcmlib/Observable.js", "js/source/wcmlib/dragdrop/dd.js", "js/source/wcmlib/Component.js", "js/source/wcmlib/dialog/Dialog.js"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/components_dd.js", new String[]{"js/source/wcmlib/Observable.js", "js/source/wcmlib/dragdrop/dd.js", "js/source/wcmlib/Component.js", "js/source/wcmlib/dialog/Dialog.js", "js/source/wcmlib/crashboard/CrashBoard.js"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/calendar.js", new String[]{"js/source/wcmlib/calendar/lang/$locale$.js", "js/source/wcmlib/calendar/CTRSCalendar_Obj.js", "js/source/wcmlib/calendar/calendar_lang/cn_utf8.js", "js/source/wcmlib/calendar/CTRSCalendar.js"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/validator.js", new String[]{"js/source/wcmlib/com.trs.validator/lang/$locale$.js", "js/source/wcmlib/com.trs.validator/ValidatorConfig.js", "js/source/wcmlib/com.trs.validator/SystemValidator.js", "js/source/wcmlib/com.trs.validator/MoreCustomValidator.js", "js/source/wcmlib/com.trs.validator/Validator.js"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/ajax_bdh.js", new String[]{"js/easyversion/ajax.js", "js/data/locale/ajax.js", "js/easyversion/basicdatahelper.js", "js/easyversion/web2frameadapter.js"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/widgets_fittable.js", new String[]{"js/easyversion/extjson.js", "js/source/wcmlib/pagecontext/PageContext.js", "js/source/wcmlib/pagecontext/PageTab.js", "js/source/wcmlib/pagecontext/PageLayout.js"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/data/main.js", new String[]{"js/data/combine.jsp?s=opers,menu,tab,cmsobj,contextmenu"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/data/list.js", new String[]{"js/data/combine.jsp?s=tab"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/data/fittable.js", new String[]{"js/data/locale/system.js", "js/data/combine.jsp?s=tab"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/data/locale_all.js", new String[]{"js/data/combine.jsp?s=locale"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/data/oper_channelwebsite.js", new String[]{"js/data/locale/website.js", "js/data/locale/channel.js", "js/data/locale/publish.js", "js/data/opers/website.js", "js/data/opers/channel.js", "js/data/opers/website", "js/data/opers/channel", "js/data/opers/publish.js", "js/data/operpanel/website.js", "js/data/operpanel/channel.js", "js/data/operpanel/publish.js"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/data/oper_website.js", new String[]{"js/data/locale/website.js", "js/data/locale/publish.js", "js/data/opers/website", "js/data/opers/website.js", "js/data/opers/publish.js", "js/data/operpanel/website.js", "js/data/operpanel/publish.js"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/abs_list.js", new String[]{"js/easyversion/list.js", "js/runtime/ajax_bdh.js", "js/runtime/components_dd.js", "js/source/wcmlib/pagecontext/AbsList.js", "js/runtime/validator.js", "js/source/wcmlib/dragdrop/wcm-dd.js", "js/source/wcmlib/components/ProcessBar.js", "js/source/wcmlib/com.trs.floatpanel/FloatPanel.js", "js/source/wcmlib/dialog/DialogAdapter.js", "js/source/wcmlib/crashboard/CrashBoardAdapter.js"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/abs_thumb.js", new String[]{"js/easyversion/list.js", "js/runtime/ajax_bdh.js", "js/runtime/components_dd.js", "js/source/wcmlib/pagecontext/AbsThumb.js", "js/runtime/validator.js", "js/source/wcmlib/dragdrop/wcm-dd.js", "js/source/wcmlib/components/ProcessBar.js", "js/source/wcmlib/com.trs.floatpanel/FloatPanel.js", "js/source/wcmlib/dialog/DialogAdapter.js", "js/source/wcmlib/crashboard/CrashBoardAdapter.js"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/light_comps.js", new String[]{"js/easyversion/ctrsbutton.js", "js/easyversion/ctrsbutton.js", "js/easyversion/calendar_lang/$locale$.js", "js/easyversion/calendar3.js", "js/easyversion/ajax.js", "js/easyversion/basicdatahelper.js", "js/easyversion/web2frameadapter.js", "js/easyversion/bubblepanel.js", "js/easyversion/crashboard.js", "js/easyversion/lockutil.js", "js/easyversion/processbar.js", "js/easyversion/validator52.js", "js/easyversion/colorpicker.js", "js/easyversion/yuiconnect.js"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/abs_list_old.js", new String[]{"js/runtime/components_dd.js", "js/source/wcmlib/dragdrop/wcm-dd.js", "js/source/wcmlib/pagecontext/AbsList.js", "js/runtime/validator.js", "js/source/wcmlib/components/ProcessBar.js", "js/source/wcmlib/com.trs.floatpanel/FloatPanel.js", "js/source/wcmlib/dialog/DialogAdapter.js", "js/source/wcmlib/crashboard/CrashBoardAdapter.js"}});
        m_lstCommonJs.add(new Object[]{"js/runtime/abs_thumb_old.js", new String[]{"js/runtime/components_dd.js", "js/source/wcmlib/dragdrop/wcm-dd.js", "js/source/wcmlib/pagecontext/AbsThumb.js", "js/runtime/validator.js", "js/source/wcmlib/components/ProcessBar.js", "js/source/wcmlib/com.trs.floatpanel/FloatPanel.js", "js/source/wcmlib/dialog/DialogAdapter.js", "js/source/wcmlib/crashboard/CrashBoardAdapter.js"}});
        m_lstCommonCss = new ArrayList();
        m_lstCommonCss.add(new Object[]{"css/common_main.css", new String[]{"css/wcm-common.css", "css/wcm-opers.css"}});
        m_lstCommonCss.add(new Object[]{"css/common_list.css", new String[]{"css/wcm-common.css", "css/wcm-list-common.css", "css/wcm-opers.css", "css/wcm-widget.css"}});
        m_lstCommonCss.add(new Object[]{"css/common_thumb.css", new String[]{"css/wcm-common.css", "css/wcm-list-common.css", "css/wcm-opers.css", "css/wcm-widget.css", "css/list-widget.css"}});
        m_lstCommonCss.add(new Object[]{"css/common_tree.css", new String[]{"css/wcm-common.css", "css/wcm-widget.css", "js/source/wcmlib/com.trs.tree/resource/TreeNav.css", "js/source/wcmlib/crashboard/resource/crashboard.css", "js/source/wcmlib/button/resource/button.css"}});
        m_lstCommonCss.add(new Object[]{"js/resource/all_widgets.css", new String[]{"js/resource/widget.css"}});
        m_lstCommonCss.add(new Object[]{"js/resource/full_widgets.css", new String[]{"js/resource/full-widget.css"}});
        m_arrXxxData = new Object[1][3];
        CommonResourceBuilder.m_arrXxxData[0] = new Object[]{"js/data/opers/", "js/runtime/data/oper_cmsobj_{0}.js", new String[]{"js/data/locale/{0}.js", "js/data/opers/{0}.js", "js/data/cmsobj/{0}.js", "js/data/operpanel/{0}.js"}};
        m_sJsEncoding = "utf-8";
        combinedMapping = new HashMap();
        locale = "cn";
    }
}

