/*
 * Decompiled with CFR 0.152.
 */
package com.trs.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class SQLInjectionPreventionFilter
implements Filter {
    private static final Node ROOT_NODE = new Node('R');
    private String m_sWarnView;

    public void destroy() {
        this.clear(ROOT_NODE);
    }

    private void clear(Node node) {
        List nodes = node.nodes;
        if (nodes != null && !nodes.isEmpty()) {
            int size = nodes.size();
            for (int i = size - 1; i >= 0; --i) {
                this.clear((Node)nodes.get(i));
            }
            nodes.clear();
        }
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (this.isVlunable(req, resp)) {
            this.forward2WarnView(req, resp);
            return;
        }
        chain.doFilter(req, resp);
    }

    private void forward2WarnView(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        RequestDispatcher rd = req.getRequestDispatcher(this.m_sWarnView);
        rd.forward(req, resp);
    }

    public void init(FilterConfig conf) throws ServletException {
        String param = conf.getInitParameter("filterwords");
        if (param == null || param.trim().length() == 0) {
            return;
        }
        this.createTree(param);
        this.m_sWarnView = conf.getInitParameter("warnview");
    }

    private boolean isVlunable(ServletRequest req, ServletResponse resp) {
        Map params = req.getParameterMap();
        if (params == null || params.isEmpty()) {
            return false;
        }
        Iterator itr = params.entrySet().iterator();
        boolean zVlunable = false;
        while (itr.hasNext() && !zVlunable) {
            Map.Entry ent = itr.next();
            Object value = ent.getValue();
            if (value instanceof String[]) {
                String[] v = (String[])value;
                int len = v.length;
                for (int i = 0; i < len && !zVlunable; ++i) {
                    zVlunable = this.isVlunable(v[i]);
                }
                continue;
            }
            zVlunable = this.isVlunable(value.toString());
        }
        return zVlunable;
    }

    protected boolean isVlunable(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        char[] chars = str.toLowerCase().toCharArray();
        Node node = ROOT_NODE;
        StringBuffer buff = new StringBuffer(32);
        for (int i = 0; i < chars.length; ++i) {
            if ((node = this.findNode(node, chars[i])) == null) {
                node = ROOT_NODE;
                i -= buff.length();
                buff.setLength(0);
                continue;
            }
            if (node.flag == 1) {
                return true;
            }
            buff.append(chars[i]);
        }
        return false;
    }

    private void createTree(String param) {
        if (param == null || param.trim().length() == 0) {
            return;
        }
        char[] chars = param.toLowerCase().toCharArray();
        int commaIndex = 0;
        int lastCommaIndex = 0;
        while ((commaIndex = param.indexOf(44, lastCommaIndex)) != -1) {
            this.insertNode(ROOT_NODE, this.copyOfRange(chars, lastCommaIndex, commaIndex), 0);
            lastCommaIndex = commaIndex + 1;
        }
        if (chars.length > lastCommaIndex) {
            this.insertNode(ROOT_NODE, this.copyOfRange(chars, lastCommaIndex, chars.length), 0);
        }
    }

    private char[] copyOfRange(char[] original, int from, int to) {
        int newLength = to - from;
        char[] copy = new char[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    private void insertNode(Node node, char[] cs, int index) {
        Node n = this.findNode(node, cs[index]);
        if (n == null) {
            n = new Node(cs[index]);
            node.nodes.add(n);
        }
        if (index == cs.length - 1) {
            n.flag = 1;
        }
        if (++index < cs.length) {
            this.insertNode(n, cs, index);
        }
    }

    private Node findNode(Node node, char c) {
        List nodes = node.nodes;
        Node rn = null;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            Node n = (Node)nodes.get(i);
            if (n.c != c) continue;
            rn = n;
            break;
        }
        return rn;
    }

    public static void main(String[] args) {
        SQLInjectionPreventionFilter t = new SQLInjectionPreventionFilter();
        t.createTree("delete");
        System.out.println(t.isVlunable("my;delete:"));
    }

    private static class Node {
        public char c;
        public int flag;
        public List nodes = new ArrayList();

        public Node(char c) {
            this.c = c;
            this.flag = 0;
        }
    }
}

