/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.infoview.InfoViewEmployMgr;
import com.trs.components.infoview.InfoViewMgr;
import com.trs.components.infoview.InfoViewReplyNoticeSender;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewField;
import com.trs.components.infoview.persistent.InfoViewFields;
import com.trs.components.infoview.persistent.InfoViewGroup;
import com.trs.components.infoview.persistent.InfoViewView;
import com.trs.components.infoview.persistent.InfoViews;
import com.trs.components.metadata.service.MetaDataDefServiceProvider;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.DocReply;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.presentation.right.PluginAdminAuth;
import com.trs.service.IInfoViewService;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class InfoViewService
implements IInfoViewService {
    private InfoViewMgr m_oInfoViewMgr = (InfoViewMgr)DreamFactory.createObjectById("InfoViewMgr");
    private InfoViewEmployMgr m_oIVEmployMgr = (InfoViewEmployMgr)DreamFactory.createObjectById("InfoViewEmployMgr");

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public void delete(InfoView _oInfoView) throws WCMException {
        if (_oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label1", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u5220\u9664!"));
        }
        User loginUser = this.getLoginUser();
        if (!(loginUser.isAdministrator() || PluginAdminAuth.hasRight(loginUser) || loginUser.getName().equals(_oInfoView.getCrUserName()))) {
            throw new WCMException(1002, "\u5bf9\u4e0d\u8d77,\u60a8\u6ca1\u6709\u5220\u9664\u8be5\u8868\u5355\u7684\u6743\u9650!");
        }
        try {
            this.m_oInfoViewMgr.delete(_oInfoView);
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(InfoViewService.class, "InfoViewService.label2", "\u5220\u9664\u8868\u5355\u51fa\u9519!"), ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(InfoViewService.class, "InfoViewService.label2", "\u5220\u9664\u8868\u5355\u51fa\u9519!"), ex);
        }
    }

    @Override
    public Reports delete(InfoViews _oInfoViews) throws WCMException {
        if (_oInfoViews == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label3", "\u65e0\u6548\u7684\u8868\u5355\u96c6\u5408,\u65e0\u6cd5\u5220\u9664!"));
        }
        Reports reports = new Reports(I18NMessage.get(MetaDataDefServiceProvider.class, "InfoViewService.label14", "\u5220\u9664\u591a\u4e2a\u81ea\u5b9a\u4e49\u8868\u5355"));
        for (int i = 0; i < _oInfoViews.size(); ++i) {
            InfoView infoview = (InfoView)_oInfoViews.getAt(i);
            if (infoview == null) continue;
            try {
                if (!this.testCanDeleteView(infoview)) {
                    String sTip = CMyString.format(I18NMessage.get(InfoViewService.class, "InfoViewService.label4", "\u4e0d\u80fd\u5220\u9664\u81ea\u5b9a\u4e49\u8868\u5355[{0}],\u56e0\u4e3a\u8be5\u81ea\u5b9a\u4e49\u8868\u5355\u88ab\u8868\u5355\u680f\u76ee\u4f7f\u7528"), new String[]{infoview.getDesc()});
                    reports.addFailedReport(sTip, new WCMException(sTip));
                    continue;
                }
                this.delete(infoview);
                reports.addSucessedReport(I18NMessage.get(InfoViewService.class, "InfoViewService.label15", "\u5220\u9664\u591a\u4e2a\u81ea\u5b9a\u4e49\u8868\u5355[") + infoview.getName() + "][" + infoview.getName() + I18NMessage.get(InfoViewService.class, "InfoViewService.label5", "]\u6210\u529f\uff01"));
                continue;
            }
            catch (Exception e) {
                reports.addFailedReport(I18NMessage.get(InfoViewService.class, "InfoViewService.label15", "\u5220\u9664\u591a\u4e2a\u89c6\u56fe[") + infoview.getName() + "][" + infoview.getName() + I18NMessage.get(InfoViewService.class, "InfoViewService.label6", "]\u5931\u8d25\uff01"), e);
            }
        }
        return reports;
    }

    @Override
    public void delete(int _iInfoViewID) throws WCMException {
        InfoView oInfoView = this.findById(_iInfoViewID);
        if (oInfoView != null) {
            this.delete(oInfoView);
        }
    }

    @Override
    public void delete(String _sInfoViewIDs) throws WCMException {
        if (_sInfoViewIDs == null || _sInfoViewIDs.length() == 0) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label4", "\u65e0\u6548\u7684\u8868\u5355ID\u5e8f\u5217,\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c!"));
        }
        User loginUser = this.getLoginUser();
        InfoViews infoViews = InfoViews.findByIds(loginUser, _sInfoViewIDs);
        this.delete(infoViews);
    }

    public boolean testCanDeleteView(InfoView oInfoView) {
        InfoViewEmployMgr infoEmployMgr = (InfoViewEmployMgr)DreamFactory.createObjectById("InfoViewEmployMgr");
        List list = null;
        try {
            list = infoEmployMgr.getInfoViewEmployers(oInfoView);
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
        return list == null || list.size() == 0;
    }

    @Override
    public InfoView findById(int _iInfoViewID) throws WCMException {
        if (_iInfoViewID <= 0) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label5", "\u65e0\u6548\u7684InfoViewId[") + _iInfoViewID + I18NMessage.get(InfoViewService.class, "InfoViewService.label6", "],Id\u5e94\u8be5\u5927\u4e8e0"));
        }
        return InfoView.findById(_iInfoViewID);
    }

    @Override
    public InfoViewView findViewById(int _iViewID) throws WCMException {
        if (_iViewID <= 0) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label7", "\u65e0\u6548\u7684\u89c6\u56feID[") + _iViewID + I18NMessage.get(InfoViewService.class, "InfoViewService.label8", "],\u89c6\u56feID\u5e94\u8be5\u5927\u4e8e0"));
        }
        return InfoViewView.findById(_iViewID);
    }

    @Override
    public String forFillOut(InfoView _oInfoView, InfoViewView _oView) throws WCMException {
        return this.m_oInfoViewMgr.forFillOut(_oInfoView, _oView);
    }

    @Override
    public String forFillOutInner(InfoView _oInfoView, InfoViewView _oView) throws WCMException {
        return this.forFillOutInner(_oInfoView, _oView, false);
    }

    @Override
    public String forFillOutInner(InfoView _oInfoView, InfoViewView _oView, boolean _bNewDocInFlow) throws WCMException {
        return this.m_oInfoViewMgr.forFillOutInner(_oInfoView, _oView, _bNewDocInFlow);
    }

    @Override
    public String forFillOutInFlow(InfoView _oInfoView, InfoViewView _oView, int _flowDocId) throws WCMException, Throwable {
        return this.m_oInfoViewMgr.forFillOutInFlow(_oInfoView, _oView, _flowDocId);
    }

    @Override
    public String filterContentInFlow(InfoView _oInfoView, String _sXmlContent, int nFlowDocId) throws WCMException, Throwable {
        return this.m_oInfoViewMgr.filterContentInFlow(_oInfoView, _sXmlContent, nFlowDocId);
    }

    @Override
    public InfoViews getInfoViews(WCMFilter _filter) throws WCMException {
        return this.m_oInfoViewMgr.getInfoViews(_filter);
    }

    @Override
    public List getInfoViewEmployers(InfoView _employed) throws WCMException {
        if (_employed == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label9", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u83b7\u53d6\u5176\u4f7f\u7528\u4f4d\u7f6e!"));
        }
        return this.m_oIVEmployMgr.getInfoViewEmployers(_employed);
    }

    @Override
    public List getInfoViewEmployers(int _iInfoViewID) throws WCMException {
        InfoView oInfoView = this.findById(_iInfoViewID);
        if (oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label10", "\u6307\u5b9a\u7684\u8868\u5355\u4e0d\u5b58\uff0cID=[") + _iInfoViewID + "]");
        }
        return this.getInfoViewEmployers(oInfoView);
    }

    @Override
    public List getEmployedInfoViews(CMSObj _employer) throws WCMException {
        return this.m_oIVEmployMgr.getEmployedInfoViews(_employer);
    }

    @Override
    public List getEmployedInfoViews(int _iEmployerType, int _iEmployerId) throws WCMException {
        return this.m_oIVEmployMgr.getEmployedInfoViews(_iEmployerType, _iEmployerId);
    }

    @Override
    public void save(InfoView _oInfoView) throws WCMException {
        if (_oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label1", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u5220\u9664!"));
        }
        try {
            this.m_oInfoViewMgr.save(_oInfoView);
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(InfoViewService.class, "InfoViewService.label11", "\u4fee\u6539\u8868\u5355\u51fa\u9519!"), ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(InfoViewService.class, "InfoViewService.label11", "\u4fee\u6539\u8868\u5355\u51fa\u9519!"), ex);
        }
    }

    @Override
    public void rebuildXSLT(InfoView _oInfoView) throws WCMException {
        this.m_oInfoViewMgr.rebuildXSLT(_oInfoView);
    }

    @Override
    public void rebuildXSLTByFields(InfoView _oInfoView, List _lstFields) throws WCMException {
        this.m_oInfoViewMgr.rebuildXSLTByFields(_oInfoView, _lstFields);
    }

    @Override
    public void saveViewByFields(InfoView _oInfoView, List _lstFields) throws WCMException {
        this.m_oInfoViewMgr.saveViewByFields(_oInfoView, _lstFields);
    }

    @Override
    public void save(InfoViewField _oField) throws WCMException {
        this.m_oInfoViewMgr.save(_oField);
    }

    @Override
    public void save(InfoViewGroup _oGroup) throws WCMException {
        this.m_oInfoViewMgr.save(_oGroup);
    }

    @Override
    public void save(InfoViewView _oView) throws WCMException {
        this.m_oInfoViewMgr.save(_oView);
    }

    @Override
    public void setEmployedInfoView(CMSObj _employer, InfoView _oInfoView) throws WCMException {
        if (_employer == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label12", "\u9891\u9053\u5bf9\u8c61\u4e3a[null]!"));
        }
        if (_oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label13", "\u8868\u5355\u5bf9\u8c61\u4e3a[null]!"));
        }
        this.m_oIVEmployMgr.setEmployedInfoView(_employer, _oInfoView.getId());
    }

    @Override
    public void setEmployedInfoViews(CMSObj _employer, String _sInfoViewIDs) throws WCMException {
        if (_employer == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label12", "\u9891\u9053\u5bf9\u8c61\u4e3a[null]!"));
        }
        if (_sInfoViewIDs == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label14", "\u8868\u5355ID\u5217\u8868\u4e3a[null]!"));
        }
        if ((_sInfoViewIDs = _sInfoViewIDs.trim()).length() == 0) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label15", "\u8868\u5355ID\u5217\u8868\u4e3a\u7a7a!"));
        }
        int[] aInfoViewIDs = CMyString.splitToInt(_sInfoViewIDs, ",");
        if (aInfoViewIDs.length < 1) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label16", "\u8868\u5355ID\u5217\u8868\u4e2d\u6ca1\u6709\u6709\u6548\u7684ID!"));
        }
        this.m_oIVEmployMgr.setEmployedInfoViews(_employer, aInfoViewIDs);
    }

    @Override
    public List getAppendixList(Document dom4jDocument) throws WCMException {
        List fileNodes = dom4jDocument.selectNodes("//@trs_is_inline_file");
        List fileAppendixes = this.processAppendix(fileNodes, 10);
        List picNodes = dom4jDocument.selectNodes("//@trs_is_inline_image");
        List picAppendixes = this.processAppendix(picNodes, 20);
        List linkNodes = dom4jDocument.selectNodes("//@trs_is_linked_image");
        List linkAppendixes = this.processAppendix(linkNodes, 40);
        ArrayList result = new ArrayList();
        result.addAll(fileAppendixes);
        result.addAll(picAppendixes);
        result.addAll(linkAppendixes);
        return result;
    }

    private List processAppendix(List nodes, int nFlag) throws WCMException {
        ArrayList<Appendix> appendixes = new ArrayList<Appendix>(nodes.size());
        Node tempNode = null;
        String srcfile = null;
        Appendix appendix = null;
        for (int i = 0; i < nodes.size(); ++i) {
            tempNode = (Node)nodes.get(i);
            srcfile = tempNode.getParent().getTextTrim();
            tempNode.detach();
            appendix = new Appendix();
            appendix.setFlag(nFlag);
            appendix.setSrcFile(srcfile);
            appendix.setFile(srcfile);
            appendixes.add(appendix);
        }
        return appendixes;
    }

    @Override
    public List getAppendixList(String xmlContent) throws WCMException {
        try {
            Document xmlDoc = DocumentHelper.parseText((String)xmlContent);
            return this.getAppendixList(xmlDoc);
        }
        catch (DocumentException e) {
            throw new WCMException(150, I18NMessage.get(InfoViewService.class, "InfoViewService.label17", "\u89e3\u91caXML\u5b57\u7b26\u5931\u8d25!"), e);
        }
    }

    @Override
    public String getDocumentTitle(InfoView _oInfoView, Document dom4jDocument) throws WCMException {
        return this.m_oInfoViewMgr.getDocumentTitle(_oInfoView, dom4jDocument);
    }

    @Override
    public String getDocumentTitle(InfoView _oInfoView, String xmlContent) throws WCMException {
        return this.getDocumentTitle(_oInfoView, this.getDOM4JDocument(xmlContent));
    }

    @Override
    public String getDocumentTitle(InfoView _oInfoView, Document dom4jDocument, String sPostUserName) throws WCMException {
        return this.m_oInfoViewMgr.getDocumentTitle(_oInfoView, dom4jDocument, sPostUserName);
    }

    public String getDocumentTitle(InfoView _oInfoView, String xmlContent, String sPostUserName) throws WCMException {
        return this.getDocumentTitle(_oInfoView, this.getDOM4JDocument(xmlContent), sPostUserName);
    }

    @Override
    public Document getDOM4JDocument(String xmlContent) throws WCMException {
        try {
            StringReader reader = new StringReader(xmlContent);
            SAXReader xmlReader = new SAXReader();
            return xmlReader.read((Reader)reader);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(InfoViewService.class, "InfoViewService.label18", "\u6784\u9020DOM4J\u5bf9\u8c61\u5931\u8d25"), e);
        }
    }

    @Override
    public String getInfoViewSerial(int _iInfoViewId) throws WCMException {
        return this.m_oInfoViewMgr.getInfoViewSerial(_iInfoViewId);
    }

    @Override
    public String getInfoViewSerial(InfoView _oInfoView) throws WCMException {
        return this.m_oInfoViewMgr.getInfoViewSerial(_oInfoView);
    }

    @Override
    public void sendReplyNotice(int _iInfoViewId, int _iDocumentId, int _iDocReplyId, boolean _zSendEmail, boolean _zSendMessage) throws WCMException {
        InfoView infoView = InfoView.findById(_iInfoViewId);
        com.trs.components.wcm.content.persistent.Document document = com.trs.components.wcm.content.persistent.Document.findById(_iDocumentId);
        DocReply docReply = DocReply.findById(_iDocReplyId);
        this.sendReplyNotice(infoView, document, docReply, _zSendEmail, _zSendMessage);
    }

    @Override
    public void sendReplyNotice(InfoView _oInfoView, com.trs.components.wcm.content.persistent.Document _document, DocReply _docReply, boolean _zSendEmail, boolean _zSendMessage) throws WCMException {
        InfoViewReplyNoticeSender sender = new InfoViewReplyNoticeSender(_oInfoView, _document, _docReply);
        sender.setSendEmail(_zSendEmail);
        sender.setSendMessage(_zSendMessage);
        sender.sendNotice();
    }

    @Override
    public void setFieldsReadOnly(InfoView _oInfoView, InfoViewFields _oInfoViewFields, boolean _bReadonly) throws WCMException {
        this.m_oInfoViewMgr.setFieldsReadOnly(_oInfoView, _oInfoViewFields, _bReadonly);
    }
}

