/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.components.common.calendar.Event;
import com.trs.components.common.calendar.EventMgr;
import com.trs.components.common.calendar.EventShareIdsMan;
import com.trs.components.common.calendar.Events;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.service.IEventService;

public class EventService
implements IEventService {
    EventMgr currMgr = null;

    private EventMgr getEventMgr() throws WCMException {
        if (this.currMgr != null) {
            return this.currMgr;
        }
        this.currMgr = (EventMgr)DreamFactory.createObjectById("EventMgr");
        if (this.currMgr == null) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label1", "EventMgr\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u7684\u4e0d\u6b63\u786e\uff01"));
        }
        return this.currMgr;
    }

    @Override
    public Events getSharedEvents(User _user, CMyDateTime _date, boolean _bAll) throws WCMException {
        if (_user.getId() != this.getLoginUser().getId()) {
            throw new WCMException("\u60a8\u53ea\u80fd\u67e5\u770b\u81ea\u5df1\u7684\u65e5\u7a0b\uff01");
        }
        return this.getEventMgr().getEvents(_user, _date, _bAll, null);
    }

    @Override
    public Events getSharedEvents(User _user, CMyDateTime _date) throws WCMException {
        return this.getSharedEvents(_user, _date, true);
    }

    @Override
    public Events getSharedEvents(User _user, CMyDateTime _date, boolean _bAll, WCMFilter _filter) throws WCMException {
        return this.getEventMgr().getEvents(_user, _date, _bAll, _filter);
    }

    @Override
    public Groups getSharedGroups(Event _aEvent) throws WCMException {
        return this.getEventMgr().getGroups(_aEvent);
    }

    @Override
    public Users getSharedUsers(Event _aEvent) throws WCMException {
        return this.getEventMgr().getUsers(_aEvent);
    }

    @Override
    public Event save(Event _aEvent) throws WCMException {
        this.validRight(_aEvent);
        return this.getEventMgr().save(_aEvent);
    }

    @Override
    public boolean delete(int _nEventId) throws WCMException {
        Event anEvent = Event.findById(_nEventId);
        if (anEvent == null) {
            return true;
        }
        this.validRight(anEvent);
        return this.delete(anEvent);
    }

    @Override
    public boolean delete(Event _aEvent) throws WCMException {
        if (_aEvent == null) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label2", "\u65e0\u6548\u7684\u7ad9\u70b9/\u9891\u9053\u5bf9\u8c61"));
        }
        this.validRight(_aEvent);
        return this.getEventMgr().delete(_aEvent);
    }

    @Override
    public boolean delete(String _sIds) throws WCMException {
        Events anEvents = Events.findByIds(this.getLoginUser(), _sIds);
        for (int i = 0; i < anEvents.size(); ++i) {
            Event event = (Event)anEvents.getAt(i);
            this.validRight(event);
        }
        return this.delete(anEvents);
    }

    @Override
    public boolean delete(Events _anEvents) throws WCMException {
        if (_anEvents == null || _anEvents.isEmpty()) {
            return true;
        }
        Event anEvent = null;
        for (int i = 0; i < _anEvents.size(); ++i) {
            anEvent = (Event)_anEvents.getAt(i);
            this.validRight(anEvent);
            this.delete(anEvent);
        }
        return true;
    }

    @Override
    public Events getEvents(WCMFilter _filter) throws WCMException {
        return this.getEventMgr().getEvents(_filter);
    }

    @Override
    public void shareTo(Event _aEvent, User _assignToUser) throws WCMException {
        if (_aEvent == null) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label3", "\u4f20\u5165Event\u4e3a\u7a7a\uff01"));
        }
        if (_assignToUser == null) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label4", "\u4f20\u5165\u7528\u6237\u4e3a\u7a7a\uff01"));
        }
        this.validRight(_aEvent);
        this.shareEventTo(_aEvent, "" + _assignToUser.getId(), _assignToUser.getWCMType());
    }

    @Override
    public void shareTo(Event _aEvent, Groups _assignToGroups) throws WCMException {
        if (_aEvent == null) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label3", "\u4f20\u5165Event\u4e3a\u7a7a\uff01"));
        }
        if (_assignToGroups == null || _assignToGroups.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label5", "\u4f20\u5165\u7528\u6237\u96c6\u5408\u4e3a\u7a7a\uff01"));
        }
        this.validRight(_aEvent);
        this.shareEventTo(_aEvent, _assignToGroups.getIdListAsString(), 201);
    }

    @Override
    public void cancelShare(Event _aEvent, User _assignToUser) throws WCMException {
        this.validRight(_aEvent);
        this.getEventMgr().cancelShare(_aEvent, _assignToUser);
    }

    @Override
    public User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public void shareTo(Event _aEvent, Group _assignToGroup) throws WCMException {
        if (_aEvent == null) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label3", "\u4f20\u5165Event\u4e3a\u7a7a\uff01"));
        }
        if (_assignToGroup == null) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label6", "\u4f20\u5165\u7ec4\u7ec7\u4e3a\u7a7a\uff01"));
        }
        this.validRight(_aEvent);
        this.shareEventTo(_aEvent, "" + _assignToGroup.getId(), _assignToGroup.getWCMType());
    }

    @Override
    public void shareTo(Event _aEvent, Users _assignToUsers) throws WCMException {
        if (_aEvent == null) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label3", "\u4f20\u5165Event\u4e3a\u7a7a\uff01"));
        }
        if (_assignToUsers == null || _assignToUsers.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label5", "\u4f20\u5165\u7528\u6237\u96c6\u5408\u4e3a\u7a7a\uff01"));
        }
        this.validRight(_aEvent);
        this.shareTo(_aEvent, _assignToUsers.getIdListAsString());
    }

    @Override
    public void shareTo(Event _aEvent, String _sUserIds) throws WCMException {
        if (_sUserIds == null || _sUserIds.trim().length() <= 0) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label7", "\u4f20\u5165\u7528\u6237ID\u5e8f\u5217\u4e3a\u7a7a\uff01"));
        }
        this.validRight(_aEvent);
        this.shareEventTo(_aEvent, _sUserIds, 204);
    }

    @Override
    public void cancelShare(Event _aEvent, Users _assignToUsers) throws WCMException {
        if (_assignToUsers == null || _assignToUsers.isEmpty()) {
            return;
        }
        this.validRight(_aEvent);
        for (int i = 0; i < _assignToUsers.size(); ++i) {
            this.getEventMgr().cancelShare(_aEvent, (User)_assignToUsers.getAt(i));
        }
    }

    @Override
    public void cancelShare(Event _aEvent, Group _assignToGroup) throws WCMException {
        this.validRight(_aEvent);
        this.getEventMgr().cancelShare(_aEvent, _assignToGroup);
    }

    @Override
    public void cancelShares(Event _aEvent) throws WCMException {
        if (_aEvent == null) {
            return;
        }
        this.validRight(_aEvent);
        this.getEventMgr().cancelShares(_aEvent);
    }

    public void shareEventTo(Event _eventToShare, String _sSharerIds, int _nSharerType) throws WCMException {
        this.validRight(_eventToShare);
        EventShareIdsMan shareMan = new EventShareIdsMan(_eventToShare.getId(), _nSharerType);
        shareMan.dowithIds(_sSharerIds);
    }

    private boolean validRight(Event _currEvent) throws WCMException {
        User oNewUserOwner = _currEvent.getOwner();
        boolean bChangeOwner = false;
        if (_currEvent.isChangeProperty("OWNER")) {
            String sNewOwner = _currEvent.getNewPropertyAsString("OWNER");
            oNewUserOwner = User.findByName(sNewOwner);
            bChangeOwner = true;
        }
        User loginUser = this.getLoginUser();
        if (oNewUserOwner == null || oNewUserOwner.getId() != loginUser.getId() || _currEvent.isChangeProperty("OWNER")) {
            throw new WCMException(_currEvent.isAddMode() ? "\u60a8\u4e0d\u80fd\u4e3a\u4ed6\u4eba\u521b\u5efa\u65e5\u7a0b\uff01" : (bChangeOwner ? "\u4e0d\u80fd\u5c06\u81ea\u5df1\u7684\u65e5\u7a0b\u4fee\u6539\u4e3a\u4ed6\u4eba\u7684\uff01" : "\u60a8\u53ea\u80fd\u64cd\u4f5c\u81ea\u5df1\u7684\u65e5\u7a0b\uff01"));
        }
        return true;
    }
}

