/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.publish.domain;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.BaseServer;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.Accounts;
import com.trs.scm.persistent.SCMMicroContent;
import com.trs.scm.publish.domain.SCMMCPublishTaskCacheMgr;
import com.trs.scm.publish.persistent.SCMMCPublishTask;
import com.trs.scm.publish.persistent.SCMMCPublishTasks;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SCMMCPublishServer
extends BaseServer {
    private static final Logger logger = Logger.getLogger(SCMMCPublishServer.class);
    private SCMMCPublishTaskCacheMgr m_taskmgrworker = SCMMCPublishTaskCacheMgr.getInstance();

    public static SCMMCPublishServer getInstance() {
        SCMMCPublishServer server = (SCMMCPublishServer)DreamFactory.createObjectById("SCMMCPublishServer");
        if (!server.isStarted()) {
            server.startup();
            if (!server.isStarted()) {
                logger.error((Object)"SCMMCPublishServer\u672a\u542f\u52a8\uff01");
            }
        }
        return server;
    }

    @Override
    protected void doShutdown() {
        this.m_taskmgrworker.clear();
    }

    @Override
    protected boolean doStart() throws WCMException {
        this.m_taskmgrworker.init();
        this.m_taskmgrworker.start();
        return true;
    }

    public SCMMCPublishTask getRunningTask() throws WCMException {
        return SCMMCPublishTaskCacheMgr.getRunningTask();
    }

    public SCMMicroContent getRunningPublishContent() throws WCMException {
        return SCMMCPublishTaskCacheMgr.getRunningPublishContent();
    }

    public boolean publish(Accounts _oCurrAccounts, SCMMicroContent _oSCMMicroContent, HashMap _hashMap) throws WCMException {
        String sErrorMsg = "";
        for (int n = 0; n < _oCurrAccounts.size(); ++n) {
            Account oCurrAccount = (Account)_oCurrAccounts.getAt(n);
            if (oCurrAccount == null) continue;
            try {
                SCMMCPublishTask oNewPublishTask = SCMMCPublishTask.createNewInstance();
                oNewPublishTask.setAccountID(oCurrAccount.getId());
                oNewPublishTask.setAttempts(0);
                oNewPublishTask.setCrUser(_oSCMMicroContent.getCrUser());
                CMyDateTime dScheduleTime = null;
                if (_hashMap != null) {
                    dScheduleTime = (CMyDateTime)_hashMap.get("ScheduleTime");
                }
                if (dScheduleTime != null) {
                    oNewPublishTask.setScheduleTime(dScheduleTime);
                    oNewPublishTask.setIsScheduledTask(true);
                }
                oNewPublishTask.setSCMMCID(_oSCMMicroContent.getId());
                if (_oSCMMicroContent.getStatusId() != 30) {
                    oNewPublishTask.setPublishStatus(20);
                } else if (dScheduleTime != null) {
                    oNewPublishTask.setPublishStatus(1);
                } else {
                    oNewPublishTask.setPublishStatus(30);
                }
                oNewPublishTask.save(_oSCMMicroContent.getCrUser());
                continue;
            }
            catch (Exception e) {
                sErrorMsg = sErrorMsg + (CMyString.isEmpty(sErrorMsg) ? "" : ",\u8d26\u53f7[" + oCurrAccount.getAccountName() + "]");
            }
        }
        if (!CMyString.isEmpty(sErrorMsg)) {
            logger.error((Object)("\u975e\u5e38\u62b1\u6b49\uff01\u521b\u5efa" + sErrorMsg + "\u7684\u53d1\u5e03\u4efb\u52a1\u5931\u8d25\uff01\u8bf7\u60a8\u5c1d\u8bd5\u91cd\u65b0\u53d1\u5e03\uff01"));
        }
        return true;
    }

    public void deleteSCMMCPublishContent(SCMMicroContent _scmmicrocontent) throws Exception {
        SCMMCPublishTasks oResults;
        int nRunningContentId = -1;
        if (SCMMCPublishTaskCacheMgr.getRunningPublishContent() != null) {
            nRunningContentId = SCMMCPublishTaskCacheMgr.getRunningPublishContent().getId();
        }
        if (nRunningContentId == _scmmicrocontent.getId()) {
            logger.error((Object)"\u5f85\u5220\u9664\u7684\u5fae\u535a\u5df2\u8fdb\u5165\u53d1\u5e03\u72b6\u6001\uff0c\u5220\u9664\u5931\u8d25\uff01");
        }
        if ((oResults = SCMMCPublishTaskCacheMgr.getInstance().queryPublishTasksForSCMMC(_scmmicrocontent.getId())) != null && oResults.size() > 0) {
            oResults.removeAll(true);
        }
        if (_scmmicrocontent.getStatusId() == 30) {
            User oUser = _scmmicrocontent.getCrUser();
            _scmmicrocontent.validCanDeleteAndLock(oUser);
            _scmmicrocontent.delete(oUser);
        }
    }

    public void deleteSCMMCPublishTask(SCMMCPublishTask _scmtask) throws Exception {
        int nRunningTaskId = -1;
        if (SCMMCPublishTaskCacheMgr.getRunningTask() != null) {
            nRunningTaskId = SCMMCPublishTaskCacheMgr.getRunningTask().getId();
        }
        if (nRunningTaskId == _scmtask.getId()) {
            logger.error((Object)"\u5f85\u5220\u9664\u7684\u53d1\u5e03\u4efb\u52a1\u5df2\u8fdb\u5165\u53d1\u5e03\u72b6\u6001\uff0c\u5220\u9664\u5931\u8d25\uff01");
        }
        SCMMCPublishTasks oResult = SCMMCPublishTasks.findByIds(User.getSystem(), _scmtask.getId() + "");
        oResult.remove(_scmtask, true);
        SCMMicroContent oPublishingContent = _scmtask.getSCMMicroContent();
        if (oPublishingContent.getStatusId() == 30) {
            User oUser = oPublishingContent.getCrUser();
            SCMMCPublishTasks oWaitingTasks = SCMMCPublishTaskCacheMgr.getInstance().queryPublishTasksForSCMMC(oPublishingContent.getId());
            if (oWaitingTasks == null || oWaitingTasks.size() == 0) {
                oPublishingContent.validCanDeleteAndLock(oUser);
                oPublishingContent.delete(oUser);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redoSCMMCPublishTask(SCMMCPublishTask _scmtask) throws Exception {
        int nPublishStatus = _scmtask.getPublishStatus();
        if (nPublishStatus != 8 && nPublishStatus != 9) {
            logger.error((Object)"\u5f53\u524d\u53d1\u5e03\u4efb\u52a1\u7684\u72b6\u6001\u4e0d\u7b26\u5408\u91cd\u65b0\u53d1\u5e03\u8981\u6c42\uff01\u8bf7\u786e\u8ba4\u53d1\u5e03\u4efb\u52a1\u4e3a\u5931\u8d25\u4efb\u52a1\u6216\u8fc7\u671f\u4efb\u52a1\uff01");
        }
        _scmtask.validCanEditAndLock(_scmtask.getCrUser());
        try {
            SCMMCPublishServer sCMMCPublishServer = this;
            synchronized (sCMMCPublishServer) {
                _scmtask.setAttempts(0);
                _scmtask.setErrorMsg("");
                _scmtask.setPublishStatus(30);
                if (nPublishStatus == 8) {
                    _scmtask.setScheduleTime(null);
                    _scmtask.setIsScheduledTask(false);
                    _scmtask.setPriority(9);
                }
                _scmtask.save(_scmtask.getCrUser());
            }
        }
        catch (WCMException e) {
            logger.error((Object)"\u5f53\u524d\u53d1\u5e03\u4efb\u52a1\u7684\u72b6\u6001\u4e0d\u7b26\u5408\u91cd\u65b0\u53d1\u5e03\u8981\u6c42\uff01\u8bf7\u786e\u8ba4\u53d1\u5e03\u4efb\u52a1\u4e3a\u5931\u8d25\u4efb\u52a1\u6216\u8fc7\u671f\u4efb\u52a1\uff01");
            e.printStackTrace();
        }
        finally {
            _scmtask.unlock();
        }
    }

    public void pauseSCMMCPublishTask(SCMMCPublishTask _scmtask) throws WCMException {
    }

    public void resumeSCMMCPublishTask(SCMMCPublishTask _scmtask) throws WCMException {
    }

    public void cancelSCMMCPublishTask(SCMMCPublishTask _scmtask) throws Exception {
    }

    public boolean updateSCMMCPublishTask(SCMMCPublishTask _scmmcpublishtask) throws Exception {
        return false;
    }
}

