/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.process;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.scm.domain.impl.SCMMicroContentMgr;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.Accounts;
import com.trs.scm.persistent.SCMGroup;
import com.trs.scm.persistent.SCMMicroContent;
import com.trs.scm.persistent.SCMMicroContents;
import com.trs.scm.sdk.model.MicroContent;
import org.apache.log4j.Logger;

public class FlowContentSCMMicroContentImpl
implements IFlowContent {
    private SCMMicroContent m_oSCMMicroContent = null;
    private int m_nSCMMcrConID = 0;
    private boolean m_bLost = false;
    private FlowDoc m_oFlowDoc = null;
    private Flow m_oFlow = null;
    private CMyDateTime m_dtStartTime = null;
    private long m_lSerialNum = -1L;
    private final String DEFAULT_CONTENTADDEDITPAGE = "../scm/index.jsp";
    private static Logger logger = Logger.getLogger(FlowContentSCMMicroContentImpl.class);

    public FlowContentSCMMicroContentImpl(SCMMicroContent _currSCMMicroContent) {
        try {
            this.makeFrom(_currSCMMicroContent);
        }
        catch (WCMException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public FlowContentSCMMicroContentImpl(int _nId) {
        try {
            this.loadById(_nId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public FlowContentSCMMicroContentImpl() {
    }

    public SCMMicroContent getSCMMicroContent() throws WCMException {
        if (this.m_oSCMMicroContent == null && !this.m_bLost) {
            this.m_oSCMMicroContent = SCMMicroContent.findById(this.m_nSCMMcrConID);
            if (this.m_oSCMMicroContent == null) {
                this.m_bLost = true;
            }
        }
        return this.m_oSCMMicroContent;
    }

    @Override
    public boolean canEdit(User _currUser) throws WCMException {
        if (this.getSCMMicroContent() == null) {
            return false;
        }
        return this.getSCMMicroContent().canEdit(_currUser);
    }

    @Override
    public void cancelUpdate(User user) throws WCMException {
        this.getSCMMicroContent().cancelUpdate(user);
    }

    @Override
    public String getContentAddEditPage() throws WCMException {
        return "../scm/index.jsp?SCMGroupId=" + this.m_oSCMMicroContent.getGroupId();
    }

    @Override
    public String getContentShowPage() throws WCMException {
        return "../scm/index.jsp?SCMGroupId=" + this.m_oSCMMicroContent.getGroupId();
    }

    @Override
    public int getContentType() {
        return 1844552626;
    }

    @Override
    public User getCrUser() throws WCMException {
        return this.m_oSCMMicroContent.getCrUser();
    }

    @Override
    public String getDeletePage() throws WCMException {
        return "serviceId=wcm61_scmmicrocontent&methodName=delete&ObjectIds=" + this.getId();
    }

    @Override
    public String getDesc() throws WCMException {
        if (this.getSCMMicroContent() == null) {
            return "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6587\u6863[ID=" + this.m_nSCMMcrConID + "]";
        }
        boolean isRetweeted = this.m_oSCMMicroContent.isRetweeted();
        if (!isRetweeted) {
            return this.m_oSCMMicroContent.toString();
        }
        String sDesc = this.m_oSCMMicroContent.toString();
        if (CMyString.isEmpty(sDesc)) {
            sDesc = "\u8f6c\u53d1\u5fae\u535a:";
        }
        Accounts oAccounts = Accounts.findByIds(ContextHelper.getLoginUser(), this.m_oSCMMicroContent.getPublishAccountIds());
        int nAccountId = oAccounts.getAt(0).getId();
        Account oCurrAccount = Account.findById(nAccountId);
        MicroContent oRetweetMC = null;
        try {
            oRetweetMC = this.getSCMMicroContentMgr().findById(oCurrAccount, this.m_oSCMMicroContent.getRetweetedID());
        }
        catch (Exception e) {
            String sMsg = e.getMessage();
            throw new WCMException(sMsg);
        }
        sDesc = oRetweetMC != null ? sDesc + oRetweetMC.getContent() : sDesc + "\u672a\u83b7\u53d6\u5230\u8f6c\u53d1\u5fae\u535a\u5185\u5bb9\uff01";
        return sDesc.length() > 20 ? sDesc.substring(0, 20) + "..." : sDesc;
    }

    @Override
    public FlowDoc getFlowDoc() {
        return this.m_oFlowDoc;
    }

    @Override
    public Flow getOwnerFlow() throws WCMException {
        if (this.m_oFlow != null) {
            return this.m_oFlow;
        }
        return null;
    }

    @Override
    public String getProperty(String name) throws WCMException {
        return this.m_oSCMMicroContent.getPropertyAsString(name);
    }

    @Override
    public String getPublishPage() throws WCMException {
        return "../scm/index.jsp?SCMGroupId=" + this.m_oSCMMicroContent.getGroupId();
    }

    @Override
    public long getSerialNum() {
        return this.m_lSerialNum;
    }

    @Override
    public CMyDateTime getStartTime() {
        return this.m_dtStartTime;
    }

    @Override
    public String getStatusDesc() throws WCMException {
        if (this.getSCMMicroContent() == null) {
            throw new WCMException("\u65e0\u6cd5\u627e\u5230\u8981\u5ba1\u6838\u7684\u5fae\u535a\u5185\u5bb9!");
        }
        Status oStatus = this.getSCMMicroContent().getFlowStatus();
        return oStatus.getDesc();
    }

    @Override
    public int getStatusId() throws WCMException {
        if (this.getSCMMicroContent() == null) {
            return -1;
        }
        return this.m_oSCMMicroContent.getStatusId();
    }

    @Override
    public CMSObj getSubinstance() throws WCMException {
        return this.m_oSCMMicroContent;
    }

    @Override
    public int getSubinstanceId() throws WCMException {
        return this.m_nSCMMcrConID;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public void setFlow(Flow flow) {
        this.m_oFlow = flow;
    }

    @Override
    public void setFlowDoc(FlowDoc doc) {
        this.m_oFlowDoc = doc;
    }

    @Override
    public void setSerialNum(long serialNum) {
        this.m_lSerialNum = serialNum;
    }

    @Override
    public void setStartTime(CMyDateTime startTime) {
        this.m_dtStartTime = startTime;
    }

    @Override
    public void setSubinstance(int subinstanceId) throws WCMException {
        this.m_nSCMMcrConID = subinstanceId;
    }

    @Override
    public void setSubinstance(CMSObj _subinstance) throws WCMException {
        this.m_oSCMMicroContent = (SCMMicroContent)_subinstance;
        this.setSubinstance(_subinstance.getId());
    }

    @Override
    public void updateStatus(User user, int statusId) throws WCMException {
        SCMMicroContent oSCMMicroContent = this.getSCMMicroContent();
        int nOldStatusId = oSCMMicroContent.getStatusId();
        if (nOldStatusId == 1027) {
            return;
        }
        this.getSCMMicroContentMgr().changeFlowStatus(oSCMMicroContent, Status.findById(statusId));
    }

    private SCMMicroContentMgr getSCMMicroContentMgr() {
        return (SCMMicroContentMgr)DreamFactory.createObjectById("ISCMMicroContentMgr");
    }

    @Override
    public int getId() {
        return this.m_nSCMMcrConID;
    }

    @Override
    public String getInfo() {
        try {
            return this.getDesc();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u83b7\u53d6\u63cf\u8ff0\u51fa\u73b0\u5f02\u5e38\uff01\uff01\uff01";
        }
    }

    @Override
    public CMSObj getSubstance() {
        return this.m_oSCMMicroContent;
    }

    @Override
    public int getType() {
        return 1844552626;
    }

    @Override
    public boolean loadById(int id) throws WCMException {
        if (id <= 0) {
            throw new NullPointerException("\u5b9e\u4f8b\u5316\u5de5\u4f5c\u6d41\u5bf9\u8c61\u5931\u8d25\uff01\u4f20\u5165\u7684\u5fae\u535a\u5bf9\u8c61ID\u4e0d\u5408\u6cd5\uff01SCMMicroContentId = " + id);
        }
        String sIds = String.valueOf(id);
        User oUser = ContextHelper.getLoginUser();
        SCMMicroContents oSCMMicroContents = SCMMicroContents.findByIds(oUser, sIds);
        if (oSCMMicroContents == null || oSCMMicroContents.size() == 0) {
            logger.error((Object)("\u5b9e\u4f8b\u5316\u5de5\u4f5c\u6d41\u5bf9\u8c61\u5931\u8d25\uff01\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u5fae\u535a\u5bf9\u8c61\uff01SCMMicroContentId = " + id));
            return false;
        }
        SCMMicroContent oSCMMicroContent = (SCMMicroContent)oSCMMicroContents.getAt(0);
        this.makeFrom(oSCMMicroContent);
        return true;
    }

    @Override
    public void makeFrom(CMSObj obj) throws WCMException {
        if (!(obj instanceof SCMMicroContent)) {
            throw new RuntimeException("\u5b9e\u4f8b\u5316\u5de5\u4f5c\u6d41\u5bf9\u8c61\u5931\u8d25\uff01\u4f20\u5165\u7684\u5bf9\u8c61\u4e3a\u975e\u6cd5\u5fae\u535a\u5bf9\u8c61\uff1a" + obj.getClassName(true));
        }
        SCMMicroContent oSCMMicroContent = (SCMMicroContent)obj;
        this.makeFrom(oSCMMicroContent);
    }

    private void makeFrom(SCMMicroContent _oSCMMicroContent) throws WCMException {
        this.m_oSCMMicroContent = _oSCMMicroContent;
        this.m_nSCMMcrConID = _oSCMMicroContent.getId();
        this.setStartTime(CMyDateTime.now());
        this.setOwnerFlow();
    }

    @Override
    public void setSubstance(CMSObj obj) {
        if (obj instanceof SCMMicroContent) {
            this.m_oSCMMicroContent = (SCMMicroContent)obj;
            this.m_nSCMMcrConID = this.m_oSCMMicroContent.getId();
            try {
                this.setOwnerFlow();
            }
            catch (WCMException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void setOwnerFlow() throws WCMException {
        int nGroupId = this.m_oSCMMicroContent.getGroupId();
        if (nGroupId > 0) {
            String sWorkFlowIds;
            SCMGroup oGroup = SCMGroup.findById(nGroupId);
            if (oGroup == null) {
                logger.error((Object)("\u83b7\u53d6\u5206\u7ec4\u4e3a\u7a7a\uff01\u5206\u7ec4ID\uff1a[" + nGroupId + "]"));
                return;
            }
            int nWorkFlowOfGroup = oGroup.getWorkFlow();
            if (nWorkFlowOfGroup < 0) {
                this.m_oFlow = null;
                return;
            }
            Flow oFlow = Flow.findById(nWorkFlowOfGroup);
            if (nWorkFlowOfGroup == 0 || oFlow == null) {
                String sDefaultWorkFlow = ConfigServer.getServer().getSysConfigValue("DEFAULT_WORKFLOW_FOR_SCM", "0");
                if (sDefaultWorkFlow.equals("0") || CMyString.isEmpty(sDefaultWorkFlow)) {
                    this.m_oFlow = null;
                    return;
                }
                int nDefaultWorkFlow = Integer.valueOf(sDefaultWorkFlow);
                oFlow = Flow.findById(nDefaultWorkFlow);
                if (oFlow == null) {
                    logger.error((Object)("\u7528\u6237\u914d\u7f6e\u7684SCM\u9ed8\u8ba4\u5de5\u4f5c\u6d41ID\u6709\u8bef\uff01\u4e0d\u5b58\u5728\u5de5\u4f5c\u6d41ID\u4e3a[" + nDefaultWorkFlow + "]\u7684\u5de5\u4f5c\u6d41"));
                }
            }
            if (CMyString.isEmpty(sWorkFlowIds = ConfigServer.getServer().getSysConfigValue("WORKFLOWS_FOR_SCM", ""))) {
                this.m_oFlow = null;
                return;
            }
            String[] pWorkFlowId = sWorkFlowIds.split(",");
            for (int i = 0; i < pWorkFlowId.length; ++i) {
                int nCurrWorkFlowId = -1;
                try {
                    nCurrWorkFlowId = Integer.valueOf(pWorkFlowId[i]);
                }
                catch (Exception e) {
                    logger.error((Object)("\u7528\u6237\u914d\u7f6e\u7684SCM\u5de5\u4f5c\u6d41ID\u5e8f\u5217\u5b58\u5728\u9519\u8bef\uff01\u9519\u8bef\u5de5\u4f5c\u6d41ID\uff1a[" + pWorkFlowId[i] + "]"));
                    continue;
                }
                if (nCurrWorkFlowId == -1) {
                    logger.error((Object)("\u7528\u6237\u914d\u7f6e\u7684SCM\u5de5\u4f5c\u6d41ID\u5e8f\u5217\u5b58\u5728\u9519\u8bef\uff01\u9519\u8bef\u5de5\u4f5c\u6d41ID\uff1a[" + pWorkFlowId[i] + "]"));
                    continue;
                }
                Flow oCurrFlow = Flow.findById(nCurrWorkFlowId);
                if (oCurrFlow == null) {
                    logger.error((Object)("\u7528\u6237\u914d\u7f6e\u7684SCM\u5de5\u4f5c\u6d41ID\u5e8f\u5217\u5b58\u5728\u9519\u8bef\uff01\u9519\u8bef\u5de5\u4f5c\u6d41ID\uff1a[" + pWorkFlowId[i] + "]"));
                    continue;
                }
                if (oFlow == null || oFlow.getId() != oCurrFlow.getId()) continue;
                this.setFlow(oFlow);
                return;
            }
        }
        this.m_oFlow = null;
    }
}

