/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.persistent;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.Flows;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;

public class SCMGroup
extends CMSObj {
    public static final int OBJ_TYPE = 1658813822;
    public static final String DB_TABLE_NAME = "XWCMSCMGROUP";
    public static final String DB_ID_NAME = "SCMGROUPID";
    public static final int ID_UNGROUPED = 1;
    public static final int UN_REMOVEABLE = 0;
    public static final int REMOVEABLE = 1;
    public static final int SCMWORKFLOWCONFIG_REMOVED = -2;
    public static final int WORKFLOW_REMOVED = -3;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 1658813822;
    }

    public String getGroupName() {
        return this.getPropertyAsString("GROUPNAME");
    }

    public boolean setGroupName(String _sGroupName) throws WCMException {
        return this.setProperty("GROUPNAME", _sGroupName);
    }

    public int getRemovable() {
        return this.getPropertyAsInt("REMOVABLE", 0);
    }

    public boolean setRemovable(int _nRemovable) throws WCMException {
        return this.setProperty("REMOVABLE", _nRemovable);
    }

    public int getWorkFlow() {
        int nWorkFlowId = this.getPropertyAsInt("WORKFLOW", 0);
        if (nWorkFlowId == 0 || nWorkFlowId == -1) {
            return nWorkFlowId;
        }
        Flow oCurrFlow = null;
        try {
            oCurrFlow = Flow.findById(nWorkFlowId);
        }
        catch (WCMException wCMException) {
            // empty catch block
        }
        if (oCurrFlow == null) {
            return -3;
        }
        String sWorkFlowIds = null;
        try {
            sWorkFlowIds = ConfigServer.getServer().getSysConfigValue("WORKFLOWS_FOR_SCM", "");
        }
        catch (WCMException wCMException) {
            // empty catch block
        }
        if (CMyString.isEmpty(sWorkFlowIds)) {
            return -2;
        }
        String[] pWorkFlowIds = sWorkFlowIds.split(",");
        sWorkFlowIds = "";
        for (int i = 0; i < pWorkFlowIds.length; ++i) {
            int nCurrWorkFlowId = -1;
            try {
                nCurrWorkFlowId = Integer.valueOf(pWorkFlowIds[i]);
            }
            catch (Exception e) {
                continue;
            }
            if (nCurrWorkFlowId <= 0) continue;
            sWorkFlowIds = sWorkFlowIds + nCurrWorkFlowId + ",";
        }
        sWorkFlowIds = sWorkFlowIds.substring(0, sWorkFlowIds.length() - 1);
        Flows oResult = Flows.findByIds(ContextHelper.getLoginUser(), sWorkFlowIds);
        if (oResult == null || oResult.size() == 0) {
            return -2;
        }
        if (oResult.indexOf(oCurrFlow) < 0) {
            return -2;
        }
        return nWorkFlowId;
    }

    public boolean setWorkFlow(int _nFlowId) throws WCMException {
        return this.setProperty("WORKFLOW", _nFlowId);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("GROUPNAME") == null) {
                throw new WCMException(1106, "\u5c5e\u6027GroupName\u6ca1\u6709\u8bbe\u7f6e(SCMGroup.isValid)");
            }
            if (this.getProperty("REMOVABLE") == null) {
                this.setRemovable(1);
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(SCMGroup.isValid)");
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    public static final SCMGroup findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (SCMGroup)BaseObj.findById(SCMGroup.class, _nId);
    }

    public static final SCMGroup createNewInstance() throws WCMException {
        return (SCMGroup)BaseObj.createNewInstance(SCMGroup.class);
    }

    public static final SCMGroup findByKey(Object _oKey) throws WCMException {
        return (SCMGroup)BaseObj.findByKey(SCMGroup.class, _oKey);
    }

    @Override
    public int delete(User user) throws WCMException {
        if (this.getRemovable() == 0) {
            throw new WCMException("\u5206\u7ec4[" + this.getGroupName() + "]\u4e0d\u80fd\u88ab\u5220\u9664\uff0c\u56e0\u4e3a\u5206\u7ec4\u6307\u5b9a\u7684\u5c5e\u6027removeable\u4e3a0");
        }
        return super.delete(user);
    }

    @Override
    public int delete() throws WCMException {
        if (this.getRemovable() == 0) {
            throw new WCMException("\u5206\u7ec4[" + this.getGroupName() + "]\u4e0d\u80fd\u88ab\u5220\u9664\uff0c\u56e0\u4e3a\u5206\u7ec4\u6307\u5b9a\u7684\u5c5e\u6027removeable\u4e3a0");
        }
        return super.delete();
    }

    public int getParentId() throws WCMException {
        return this.getPropertyAsInt("PARENTID", 0);
    }

    public SCMGroup getParent() throws WCMException {
        return SCMGroup.findById(this.getParentId());
    }

    public String getParentPath() throws WCMException {
        StringBuffer sbParentPath = new StringBuffer(1024);
        ArrayList<String> pGroups = new ArrayList<String>();
        pGroups.add(this.getGroupName());
        SCMGroup tempSCMGroup = (SCMGroup)this.clone();
        while (tempSCMGroup.getParent() != null) {
            pGroups.add(tempSCMGroup.getParent().getGroupName());
            tempSCMGroup = tempSCMGroup.getParent();
        }
        if (pGroups != null && pGroups.size() > 0) {
            for (int i = pGroups.size() - 1; i >= 0; --i) {
                if (i == pGroups.size() - 1) {
                    sbParentPath.append(((String)pGroups.get(i)).toString());
                    continue;
                }
                sbParentPath.append("/").append(((String)pGroups.get(i)).toString());
            }
        }
        return sbParentPath.toString();
    }
}

