/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.domain.impl;

import com.trs.infra.util.CMyString;
import com.trs.scm.domain.ISCMCommentMgr;
import com.trs.scm.domain.OAuthObjUtil;
import com.trs.scm.persistent.Account;
import com.trs.scm.sdk.ICommentMgr;
import com.trs.scm.sdk.factory.PlatformFactory;
import com.trs.scm.sdk.model.Comment;
import com.trs.scm.sdk.model.CommentWrapper;
import com.trs.scm.sdk.model.ExtraParams;
import com.trs.scm.sdk.model.OAuth;
import java.util.Map;

public class SCMCommentMgr
implements ISCMCommentMgr {
    @Override
    public Comment createComment(Account _oAccount, String _sContent, String _sMicroContentId, String _sCommentId, boolean _bReplyComment, Map _oExtraParams) throws Exception {
        if (_bReplyComment) {
            if (CMyString.isEmpty(_sCommentId)) {
                throw new Exception("\u8981\u56de\u590d\u7684\u8bc4\u8bba\u7684Id\u4e3a\u7a7a\uff01");
            }
        } else if (CMyString.isEmpty(_sMicroContentId)) {
            throw new Exception("\u8981\u8bc4\u8bba\u7684\u5fae\u535a\u7684Id\u4e3a\u7a7a\uff01");
        }
        ICommentMgr oCommentMgr = this.queryCommentMgrByAccount(_oAccount);
        ExtraParams oExtraParams = this.getExtraParams(_oExtraParams);
        Comment oComment = null;
        oComment = _bReplyComment ? oCommentMgr.replyComment(_sContent, _sCommentId, oExtraParams) : oCommentMgr.createComment(_sContent, _sMicroContentId, oExtraParams);
        return oComment;
    }

    private ExtraParams getExtraParams(Map _oExtraParamMap) {
        if (_oExtraParamMap == null) {
            return null;
        }
        ExtraParams oExtraParams = new ExtraParams();
        oExtraParams.setParams(_oExtraParamMap);
        return oExtraParams;
    }

    @Override
    public boolean destroyComment(Account _oAccount, String _sCommentId) throws Exception {
        if (CMyString.isEmpty(_sCommentId)) {
            throw new Exception("\u8981\u5220\u9664\u7684\u8bc4\u8bba\u7684Id\u4e3a\u7a7a\uff01");
        }
        ICommentMgr oCommentMgr = this.queryCommentMgrByAccount(_oAccount);
        return oCommentMgr.destroyComment(_sCommentId);
    }

    @Override
    public CommentWrapper queryCommentMentions(Account _oAccount, int _nPageIndex, int _nPageSize, Map _oExtraParams) throws Exception {
        ICommentMgr oCommentMgr = this.queryCommentMgrByAccount(_oAccount);
        ExtraParams oExtraParams = this.getExtraParams(_oExtraParams);
        CommentWrapper oCommentWrapper = oCommentMgr.getCommentMentions(_nPageIndex, _nPageSize, oExtraParams);
        return oCommentWrapper;
    }

    @Override
    public CommentWrapper queryCommentsByMCId(Account _oAccount, String _sMicroContentId, int _nPageIndex, int _nPageSize, Map _oExtraParams) throws Exception {
        ICommentMgr oCommentMgr = this.queryCommentMgrByAccount(_oAccount);
        ExtraParams oExtraParams = this.getExtraParams(_oExtraParams);
        CommentWrapper oCommentWrapper = oCommentMgr.getCommentsByMCId(_sMicroContentId, _nPageIndex, _nPageSize, oExtraParams);
        return oCommentWrapper;
    }

    @Override
    public CommentWrapper queryCommentsByMe(Account account, int _nPageIndex, int _nPageSize, Map _oExtraParams) throws Exception {
        ICommentMgr oCommentMgr = this.queryCommentMgrByAccount(account);
        ExtraParams oExtraParams = this.getExtraParams(_oExtraParams);
        CommentWrapper oCommentWrapper = oCommentMgr.getCommentsByMe(_nPageIndex, _nPageSize, oExtraParams);
        return oCommentWrapper;
    }

    @Override
    public CommentWrapper queryCommentsToMe(Account _oAccount, int _nPageIndex, int _nPageSize, Map _oExtraParams) throws Exception {
        ICommentMgr oCommentMgr = this.queryCommentMgrByAccount(_oAccount);
        ExtraParams oExtraParams = this.getExtraParams(_oExtraParams);
        CommentWrapper oCommentWrapper = oCommentMgr.getCommentsToMe(_nPageIndex, _nPageSize, oExtraParams);
        return oCommentWrapper;
    }

    private ICommentMgr queryCommentMgrByAccount(Account _oAccount) throws Exception {
        if (_oAccount == null) {
            throw new Exception("\u6307\u5b9a\u7684\u8d26\u53f7\u4e3a\u7a7a\uff01");
        }
        OAuth oOAuth = OAuthObjUtil.constructOAuth(_oAccount);
        String sPlatform = _oAccount.getPlatform();
        ICommentMgr oCommentMgr = PlatformFactory.createCommentMgr(sPlatform, oOAuth);
        return oCommentMgr;
    }
}

