/*
 * Decompiled with CFR 0.152.
 */
package com.trs.recycle;

import com.trs.infra.util.CMyJAXPXMLParser;
import com.trs.recycle.RecycleObjConfXML;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ObjectRecycleXmlHandler
extends DefaultHandler {
    public static String OBJ_RECYCLE_CONFIG = "recyclebean.xml";
    private static HashMap pObjectMsg;
    private RecycleObjConfXML currObject;
    private HashMap hRights;
    private HashMap hFields;
    private static ObjectRecycleXmlHandler xmlHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (pObjectMsg != null) {
            return;
        }
        pObjectMsg = new HashMap();
        InputStream xmlStream = null;
        try {
            SAXParserFactory factory = CMyJAXPXMLParser.newSAXParserFactory();
            SAXParser parser = factory.newSAXParser();
            xmlStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(OBJ_RECYCLE_CONFIG);
            parser.parse(xmlStream, (DefaultHandler)this.getClass().newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (xmlStream != null) {
                try {
                    xmlStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public HashMap getRecycleXmlConfig() {
        if (pObjectMsg == null) {
            this.init();
        }
        return pObjectMsg;
    }

    public RecycleObjConfXML getObject(int objType) {
        return (RecycleObjConfXML)this.getRecycleXmlConfig().get(String.valueOf(objType));
    }

    public static ObjectRecycleXmlHandler newInstance() {
        if (xmlHandler == null) {
            xmlHandler = new ObjectRecycleXmlHandler();
        }
        return xmlHandler;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("OBJECT".equalsIgnoreCase(qName)) {
            this.currObject = new RecycleObjConfXML();
            this.currObject.setObjNameField(attributes.getValue("objnamefield"));
            this.currObject.setObjType(Integer.parseInt(attributes.getValue("type")));
            this.currObject.setObjDesc(attributes.getValue("desc"));
            this.currObject.setObjClassDesc(attributes.getValue("class"));
            this.hRights = new HashMap();
            this.hFields = new HashMap();
            this.currObject.setOperRights(this.hRights);
            this.currObject.setViewFields(this.hFields);
            pObjectMsg.put(attributes.getValue("type"), this.currObject);
        }
        if (this.currObject != null && "right".equalsIgnoreCase(qName)) {
            this.hRights.put(attributes.getValue("name"), attributes.getValue("value"));
        }
        if (this.currObject != null && "field".equalsIgnoreCase(qName)) {
            this.hFields.put(attributes.getValue("name"), attributes.getValue("desc"));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("OBJECT".equals(qName.toUpperCase())) {
            this.currObject = null;
        }
    }

    static {
        xmlHandler = new ObjectRecycleXmlHandler();
    }
}

