/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.locale;

import com.trs.infra.I18NMessage;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.util.CMyFilenameFilter;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

final class LocaleDefinitions {
    private static Logger logger = Logger.getLogger(LocaleDefinitions.class);
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String RESOURCE = "locale";
    private static final String BASENAME = "presentation";
    private static final char UNDERSCORE = '_';
    private static final char DOT = '.';
    private Map m_cachedLocales;

    Map caculateLocales() {
        if (this.m_cachedLocales == null) {
            List localeDefinitions = this.caculateLocaleDefinitions();
            this.m_cachedLocales = new HashMap(localeDefinitions.size());
            String localeDef = null;
            for (int i = 0; i < localeDefinitions.size(); ++i) {
                localeDef = (String)localeDefinitions.get(i);
                this.m_cachedLocales.put(localeDef, this.createLocale(localeDef));
            }
        }
        return this.m_cachedLocales;
    }

    private Locale createLocale(String _sLocaleDef) {
        Locale locale = null;
        int nPos = BASENAME.length();
        if (nPos == _sLocaleDef.length()) {
            locale = new Locale("", "");
        } else {
            String temp = _sLocaleDef.substring(nPos + 1);
            if ((nPos = temp.indexOf(95)) == -1) {
                locale = new Locale(temp, "", "");
                nPos = BASENAME.length();
            } else {
                String language = temp.substring(0, nPos);
                if ((nPos = (temp = temp.substring(nPos + 1)).indexOf(95)) == -1) {
                    locale = new Locale(language, temp, "");
                    nPos = BASENAME.length();
                } else {
                    String country = temp.substring(0, nPos);
                    temp = temp.substring(nPos + 1);
                    locale = new Locale(language, country, temp);
                }
            }
        }
        return locale;
    }

    public static FileStore[] listFiles(String _dir, String _extendName) {
        FileService fDir = new FileService(_dir);
        if (_extendName.charAt(0) != '.') {
            _extendName = "." + _extendName;
        }
        FileStore[] Files = fDir.listFiles(new CMyFilenameFilter(_extendName));
        return Files;
    }

    private List caculateLocaleDefinitions() {
        String sDir = ConfigConstants.DIR_APPROOT + RESOURCE + File.separatorChar;
        FileStore[] localeDefinitions = LocaleDefinitions.listFiles(sDir, PROPERTIES_SUFFIX);
        if (localeDefinitions == null) {
            logger.error((Object)(I18NMessage.get(LocaleDefinitions.class, "LocaleDefinitions.label1", "\u8bfb\u53d6\u591a\u8bed\u79cd\u8d44\u6e90\u6587\u4ef6\u65f6\u51fa\u9519\uff01[\u8bbf\u95ee\u76ee\u5f55\u4e3a<") + sDir + I18NMessage.get(LocaleDefinitions.class, "LocaleDefinitions.label2", ">\uff0c\u8981\u83b7\u53d6\u7684\u8d44\u6e90\u6587\u4ef6\u683c\u5f0f\u4e3a<*.") + PROPERTIES_SUFFIX + ">]"));
            return new ArrayList();
        }
        ArrayList<String> listLocaleDefinitions = new ArrayList<String>(localeDefinitions.length);
        String localeName = null;
        for (int i = 0; i < localeDefinitions.length; ++i) {
            localeName = localeDefinitions[i].getName();
            localeName = localeName.substring(0, localeName.indexOf(46));
            listLocaleDefinitions.add(localeName);
        }
        return listLocaleDefinitions;
    }
}

