/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.documetimport.xml;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDOM4jHelper;
import com.trs.infra.util.XmlDocWithDom4j;
import com.trs.infra.util.store.FileService;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class DocumentImportXmlHelper {
    public static String[][] getImportSources(String _strDefaultXslPath) throws WCMException {
        Element rootElement = CMyDOM4jHelper.buildXmlFile(_strDefaultXslPath, null);
        List listElements = rootElement.elements("ref");
        int nSize = listElements.size();
        String[][] returnArray = new String[nSize][3];
        Element tempElement = null;
        for (int i = 0; i < nSize; ++i) {
            tempElement = (Element)listElements.get(i);
            returnArray[i][0] = tempElement.attributeValue("tag-value");
            returnArray[i][1] = tempElement.attributeValue("tag-name");
            returnArray[i][2] = tempElement.attributeValue("flag");
        }
        return returnArray;
    }

    public static void addImportSource(String _strAddFilePath) throws WCMException {
        FileService file = new FileService(_strAddFilePath);
        if (file.exists()) {
            throw new WCMException(10, I18NMessage.get(DocumentImportXmlHelper.class, "DocumentImportXmlHelper.label1", "\u6587\u4ef6\u5df2\u5b58\u5728"));
        }
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            throw new WCMException(10, I18NMessage.get(DocumentImportXmlHelper.class, "DocumentImportXmlHelper.label2", "\u65e0\u6cd5\u65b0\u5efa\u6587\u4ef6"), e);
        }
        Element rootElement = DocumentHelper.createElement((String)"custom-setings");
        Element defaultElement = rootElement.addElement("ref");
        defaultElement.addAttribute("tag-value", "APPFLAG");
        defaultElement.addAttribute("tag-name", "ex_appendix_type");
        Element titleElement = rootElement.addElement("ref");
        titleElement.addAttribute("tag-value", "DOCTITLE");
        titleElement.addAttribute("tag-name", I18NMessage.get(DocumentImportXmlHelper.class, "DocumentImportXmlHelper.label3", "\u6807\u9898"));
        Element contentElement = rootElement.addElement("ref");
        contentElement.addAttribute("tag-value", "DOCCONTENT");
        contentElement.addAttribute("tag-name", I18NMessage.get(DocumentImportXmlHelper.class, "DocumentImportXmlHelper.label4", "\u6b63\u6587"));
        CMyDOM4jHelper.toXMLFile(rootElement, "utf-8", _strAddFilePath, null);
    }

    public static void editImportSource(String _strDefaultXslPath, String _strXMLField, String _strTRSField, String _strSQLField) throws WCMException {
        Element root = CMyDOM4jHelper.buildXmlFile(_strDefaultXslPath, null);
        Element element = null;
        if ("".equals(_strXMLField)) {
            Element preElement = root.addElement("ref");
            if ("10".equals(_strSQLField) || "20".equals(_strSQLField)) {
                preElement.addAttribute("tag-value", "DOCAPPENDIXS");
                preElement.addAttribute("tag-name", _strTRSField);
                preElement.addAttribute("flag", _strSQLField);
            } else {
                preElement.addAttribute("tag-value", _strSQLField);
                preElement.addAttribute("tag-name", _strTRSField);
            }
        } else if ("".equals(_strTRSField) && "".equals(_strSQLField)) {
            element = DocumentImportXmlHelper.getElementByValue(root, _strXMLField);
            root.remove(element);
        } else {
            element = DocumentImportXmlHelper.getElementByValue(root, _strXMLField);
            if (element != null) {
                if ("10".equals(_strSQLField) || "20".equals(_strSQLField)) {
                    element.addAttribute("tag-value", "DOCAPPENDIXS");
                    if (element.attribute("flag") == null) {
                        element.addAttribute("flag", _strSQLField);
                    } else {
                        element.addAttribute("flag", _strSQLField);
                    }
                    element.addAttribute("tag-name", _strTRSField);
                } else {
                    element.addAttribute("tag-name", _strTRSField);
                    element.addAttribute("tag-value", _strSQLField);
                    if (element.attribute("flag") != null) {
                        element.remove(element.attribute("flag"));
                    }
                }
            }
        }
        try {
            XmlDocWithDom4j.write(root.getDocument(), "utf-8", _strDefaultXslPath);
        }
        catch (Exception ex) {
            throw new WCMException(10, I18NMessage.get(DocumentImportXmlHelper.class, "DocumentImportXmlHelper.label5", "\u4fdd\u5b58xml\u6587\u4ef6\u51fa\u9519[") + _strDefaultXslPath + "]", ex);
        }
    }

    private static Element getElementByValue(Element rootElement, String _value) {
        Element tempElement = null;
        String strValue = null;
        int nNodeCount = rootElement.nodeCount();
        for (int i = 0; i < nNodeCount; ++i) {
            Node node = rootElement.node(i);
            if (!(node instanceof Element) || (strValue = (tempElement = (Element)node).attributeValue("tag-name")) == null || !strValue.equalsIgnoreCase(_value)) continue;
            return tempElement;
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

