/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.sql;

import com.trs.infra.util.store.FileService;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;

public class DbUpdSqlLogMaker {
    private static final String ENCODING = "GBK";
    private BufferedWriter oraWriter = null;
    private BufferedWriter sqlWriter = null;
    private BufferedWriter sybWriter = null;
    private BufferedWriter db2Writer = null;

    public static void main(String[] args) {
        try {
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
            String url = "jdbc:jtds:sqlserver://192.9.200.145:1433/TRSWCM52_Developer";
            Connection conn = DriverManager.getConnection(url, "trswcm", "trs");
            int version = 1091;
            String info = "TRSWCMV65.1091(2).sp2\u66f4\u65b0";
            String start = "2010-06-01 15:00:28";
            DbUpdSqlLogMaker maker = new DbUpdSqlLogMaker("/f:/tempfiles", "trswcmv65.1091.sp2");
            Statement stmt = conn.createStatement();
            String sql = "select logtitle,dbupdatelogid,submitor,oraclesql,sysbasesql,sqlserver,db2sql from WCMDBUPDATELOG where logproductor like 'TRS.WCM.V6.1%' and crtime>='#t'";
            ResultSet rs = stmt.executeQuery(sql.replaceAll("#t", start));
            StringBuffer buff = new StringBuffer(128);
            while (rs.next()) {
                buff.append("--");
                buff.append(rs.getString(1));
                buff.append('-').append(rs.getInt(2));
                buff.append(" by ").append(rs.getString(3));
                maker.write(buff.toString(), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7));
                buff.setLength(0);
            }
            maker.end(version, info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    DbUpdSqlLogMaker(String dir, String name) throws Exception {
        FileService file = new FileService(dir, name + ".ora");
        this.oraWriter = new BufferedWriter(new OutputStreamWriter(file.getOutputStream(), ENCODING));
        file = new FileService(dir, name + ".mssql");
        this.sqlWriter = new BufferedWriter(new OutputStreamWriter(file.getOutputStream(), ENCODING));
        file = new FileService(dir, name + ".sybase");
        this.sybWriter = new BufferedWriter(new OutputStreamWriter(file.getOutputStream(), ENCODING));
        file = new FileService(dir, name + ".db2");
        this.db2Writer = new BufferedWriter(new OutputStreamWriter(file.getOutputStream(), ENCODING));
    }

    public void write(String title, String ora, String mssql, String sybase, String db2) throws Exception {
        this.write(this.oraWriter, title, ora);
        this.write(this.sqlWriter, title, mssql);
        this.write(this.sybWriter, title, sybase);
        this.write(this.db2Writer, title, db2);
    }

    private void write(BufferedWriter writer, String title, String sql) throws Exception {
        writer.write(title);
        writer.write("\n");
        writer.write(this.showNull(sql));
        writer.write("\n");
        writer.flush();
    }

    private String showNull(String string) {
        return string != null ? string : "-- Not provided?";
    }

    public void end(int version, String info) throws Exception {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String sql = "\nINSERT INTO WCMDBUPDATE (updversion, updinfo, upduser, updtime)\n";
        sql = sql + "VALUES (" + version;
        sql = sql + ", '" + info + "', 'WCM Team',";
        this.oraWriter.write(sql + "to_date('" + now + "','yyyy-MM-dd HH24:MI:SS'));\ncommit;");
        this.sqlWriter.write(sql + "'" + now + "');\ngo");
        this.sybWriter.write(sql + "'" + now + "');\ngo");
        this.db2Writer.write(sql + "'" + now + "');\ncommit;");
        this.close(this.oraWriter);
        this.close(this.sqlWriter);
        this.close(this.sybWriter);
        this.close(this.db2Writer);
    }

    private void close(Writer writer) {
        try {
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

