/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.dataprocess;

import com.trs.infra.util.store.FileService;
import com.trs.infra.util.upgrade.DbConfig;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;

public class PhotoLibConfig {
    private static final String CKEY_WMSCALES = "SCALE_RELATE_MARK";
    private String dbconf;
    private String srcconf;

    public PhotoLibConfig(String dbconf, String srcconf) {
        this.dbconf = dbconf;
        this.srcconf = srcconf;
    }

    public void doAction() throws Exception {
        FileService file;
        DbConfig config = new DbConfig();
        config.load(this.dbconf);
        Properties props = new Properties();
        if (this.srcconf != null && (file = new FileService(this.srcconf)).exists()) {
            try {
                InputStream fins = file.getInputStream();
                props.load(fins);
                fins.close();
            }
            catch (Exception fins) {
                // empty catch block
            }
        }
        Class.forName(config.getJdbcDriver());
        Connection conn = DriverManager.getConnection(config.getOldUrl(), config.getOldUser(), config.getOldPasswd());
        String sql = "delete from WCMCONFIG where upper(CKEY) in ('SUPPORTIMAGEFILESEXTS','SCALESIZEDESCS','DEFAULTCONVERTIMAGEFILEEXT','SCALESIZES','WATERMARKSCALES')";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.executeUpdate();
        pstmt.close();
        sql = "select max(CONFIGID)+1  from WCMCONFIG";
        pstmt = conn.prepareStatement(sql);
        ResultSet rs = pstmt.executeQuery();
        int id = 1;
        if (rs.next()) {
            id = rs.getInt(1);
        }
        rs.close();
        pstmt.close();
        sql = "insert into WCMCONFIG(CONFIGID,CTYPE,CKEY,CVALUE,CDESC) values(?,?,?,?,?)";
        pstmt = conn.prepareStatement(sql);
        String[] keys = new String[]{"DEFAULT_CONVERT_IMAGE_FILE_EXT", "SUPPORT_IMAGE_FILE_EXTS", "SCALE_SIZE", "SCALE_SIZE_DESC", CKEY_WMSCALES};
        String[] values = new String[]{"gif", "gif,jpg,jpeg,bmp,png", "124,133,240,500,640", "\u56fe\u7247\u5217\u8868,\u53d1\u5e03\u6982\u89c8,\u4e2d\u56fe,\u5927\u56fe,\u8d85\u5927\u56fe", "640:120,240:50,500:100"};
        String[] descs = new String[]{"\u9ed8\u8ba4BMP\u56fe\u7247\u8f6c\u5316\u683c\u5f0f", "\u56fe\u7247\u5e93\u652f\u6301\u7684\u540e\u7f00", "\u56fe\u7247\u5e93\u5404\u538b\u7f29\u89c4\u683c", "\u56fe\u7247\u5e93\u5404\u538b\u7f29\u89c4\u683c\u63cf\u8ff0", "\u56fe\u7247\u5e93\u9ed8\u8ba4\u6c34\u5370\u5339\u914d\u89c4\u683c"};
        if (conn.getMetaData().supportsBatchUpdates()) {
            conn.setAutoCommit(false);
            int len = keys.length;
            for (int i = 0; i < len; ++i) {
                String key = keys[i];
                int ix = 1;
                pstmt.setInt(ix++, id++);
                pstmt.setInt(ix++, 20);
                if (CKEY_WMSCALES.equals(key)) {
                    pstmt.setString(ix++, "WaterMarkScales");
                } else {
                    pstmt.setString(ix++, key);
                }
                pstmt.setString(ix++, props.getProperty(key, values[i]));
                pstmt.setString(ix++, descs[i]);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            conn.commit();
            conn.setAutoCommit(true);
        } else {
            int len = keys.length;
            for (int i = 0; i < len; ++i) {
                String key = keys[i];
                int ix = 1;
                pstmt.setInt(ix++, id++);
                pstmt.setInt(ix++, 20);
                if (CKEY_WMSCALES.equals(key)) {
                    pstmt.setString(ix++, "WaterMarkScales");
                } else {
                    pstmt.setString(ix++, key);
                }
                pstmt.setString(ix++, props.getProperty(key, values[i]));
                pstmt.setString(ix++, descs[i]);
                pstmt.executeUpdate();
            }
        }
        pstmt.close();
        sql = "update WCMID set NEXTID=0 where upper(TABLENAME)=?";
        pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, "WCMCONFIG");
        pstmt.executeUpdate();
        pstmt.close();
        conn.close();
    }

    public static void main(String[] args) throws Exception {
        String dbconf = null;
        if (args.length > 1) {
            dbconf = args[0];
        }
        String srcconf = null;
        if (args.length > 2) {
            srcconf = args[1];
        }
        PhotoLibConfig config = new PhotoLibConfig(dbconf, srcconf);
        config.doAction();
    }
}

