/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.uftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.uftp.FtpConfig;
import com.trs.infra.util.uftp.FtpConnection;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FtpConnectionImpSSH
extends FtpConnection {
    private static Logger s_logger = Logger.getLogger(FtpConnectionImpSSH.class);
    private Session m_oSftpSession;
    private ChannelSftp m_oSftpChannel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String verifyConfig() {
        String message = null;
        Session session = null;
        ChannelSftp channel = null;
        FtpConfig config = this.getFtpConfig();
        try {
            try {
                String user = config.getUserName();
                String host = config.getHost();
                int port = config.getPort();
                session = new JSch().getSession(user, host, port);
                session.setPassword(config.getPassWord());
                Properties config1 = new Properties();
                config1.put("StrictHostKeyChecking", "no");
                session.setConfig(config1);
                session.connect();
            }
            catch (Exception e) {
                message = I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label1", "\u8fde\u63a5\u5230\u670d\u52a1\u5668\u65f6,\u53d1\u751f\u9519\u8bef:") + e.getMessage() + ".";
                s_logger.info((Object)message, (Throwable)e);
            }
            if (message == null) {
                try {
                    channel = (ChannelSftp)session.openChannel("sftp");
                    channel.connect();
                }
                catch (Exception e) {
                    message = I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label2", "\u6253\u5f00SFTP\u901a\u9053\u65f6,\u53d1\u751f\u9519\u8bef:") + e.getMessage() + ".";
                    s_logger.info((Object)message, (Throwable)e);
                }
            }
            if (message == null) {
                try {
                    channel.cd(config.getRootPath());
                }
                catch (Exception e) {
                    message = I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label3", "\u65e0\u6548\u7684\u7684\u76ee\u6807\u8def\u5f84,\u6ca1\u6709\u6743\u9650\u6216\u8005\u8def\u5f84\u4e0d\u5b58\u5728.");
                    s_logger.info((Object)message, (Throwable)e);
                }
            }
            if (message == null) {
                try {
                    String sTempName = this.getTempFileName(null);
                    channel.mkdir(sTempName);
                    channel.rmdir(sTempName);
                }
                catch (Exception e) {
                    message = I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label4", "SFTP\u7528\u6237\u53ef\u80fd\u5bf9\u76ee\u6807\u670d\u52a1\u5668\u6216\u76ee\u6807\u8def\u5f84\u6ca1\u6709\u4e0a\u4f20\u7684\u6743\u9650.");
                    s_logger.info((Object)message, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            message = I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label5", "\u9a8c\u8bc1SFTP\u914d\u7f6e\u65f6,\u53d1\u751f\u9519\u8bef:") + e.getMessage() + ".";
            s_logger.info((Object)message, (Throwable)e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Exception exception) {}
            }
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        return message;
    }

    @Override
    protected void open() throws Exception {
        if (this.m_oSftpChannel != null && this.m_oSftpChannel.isConnected()) {
            return;
        }
        try {
            FtpConfig config = this.getFtpConfig();
            String user = config.getUserName();
            String host = config.getHost();
            int port = config.getPort();
            this.m_oSftpSession = new JSch().getSession(user, host, port);
            this.m_oSftpSession.setPassword(config.getPassWord());
            Properties config1 = new Properties();
            config1.put("StrictHostKeyChecking", "no");
            this.m_oSftpSession.setConfig(config1);
            this.m_oSftpSession.connect();
            this.m_oSftpChannel = (ChannelSftp)this.m_oSftpSession.openChannel("sftp");
            this.m_oSftpChannel.connect();
            this.m_sHomePath = this.m_oSftpChannel.pwd();
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label6", "SFTP\u670d\u52a1\u5668\u94fe\u63a5\u5931\u8d25"), e);
        }
    }

    @Override
    protected void close() {
        if (this.m_oSftpChannel == null || !this.m_oSftpChannel.isConnected()) {
            return;
        }
        try {
            this.m_oSftpChannel.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_oSftpSession.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_oSftpChannel = null;
        this.m_oSftpSession = null;
        this.m_sHomePath = null;
    }

    private void assertOpen() throws WCMException {
        if (this.m_oSftpChannel != null && this.m_oSftpChannel.isConnected()) {
            return;
        }
        throw new WCMException(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label7", "SFTP\u8fde\u63a5\u610f\u5916\u5730\u5173\u95ed\uff01"));
    }

    @Override
    public void onIdle() throws Exception {
        this.assertOpen();
        this.m_oSftpChannel.pwd();
    }

    @Override
    public boolean isReadOnly() throws Exception {
        this.assertOpen();
        try {
            this.m_oSftpChannel.cd(this.getFtpConfig().getRootPath());
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label3", "\u65e0\u6548\u7684\u7684\u76ee\u6807\u8def\u5f84,\u6ca1\u6709\u6743\u9650\u6216\u8005\u8def\u5f84\u4e0d\u5b58\u5728:") + e + ".");
        }
        String sTempName = this.getTempFileName(null);
        try {
            this.m_oSftpChannel.mkdir(sTempName);
            this.m_oSftpChannel.rmdir(sTempName);
            return false;
        }
        catch (Exception e) {
            s_logger.info((Object)I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label8", "SFTP\u670d\u52a1\u5668\u4e0a\u521b\u5efa\u4e34\u65f6\u76ee\u5f55\u5931\u8d25"), (Throwable)e);
            return true;
        }
    }

    private void insureDirectory(String sPath) throws Exception {
        if (sPath == null || sPath.length() == 0) {
            return;
        }
        if (this.changeDirectory(sPath)) {
            return;
        }
        int iIndex1 = sPath.lastIndexOf(47, sPath.length() - 2);
        if (iIndex1 != -1) {
            String sToChange = sPath.substring(0, iIndex1 + 1);
            this.insureDirectory(sToChange);
            String sToCreate = sPath.substring(iIndex1 + 1, sPath.length() - 1);
            this.createDirectory(sToCreate);
            this.m_oSftpChannel.cd(sToCreate);
        }
    }

    private boolean changeDirectory(String sPath) throws Exception {
        try {
            this.m_oSftpChannel.cd(sPath);
            return true;
        }
        catch (Exception e) {
            s_logger.debug((Object)("enter directory '" + sPath + "' failed"), (Throwable)e);
            return false;
        }
    }

    private boolean createDirectory(String sPath) throws Exception {
        if (sPath == null || sPath.length() == 0) {
            return false;
        }
        try {
            this.m_oSftpChannel.mkdir(sPath);
            return true;
        }
        catch (Exception e) {
            s_logger.debug((Object)("create directory '" + sPath + "' failed"), (Throwable)e);
            return false;
        }
    }

    @Override
    public String toAbsolutePath(String sRelativePath) throws Exception {
        this.assertOpen();
        try {
            this.m_oSftpChannel.cd(sRelativePath);
            return this.m_oSftpChannel.pwd();
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label9", "SFTP\u670d\u52a1\u5668\u83b7\u53d6\u7edd\u5bf9\u8def\u5f84\u5931\u8d25:") + sRelativePath + ".", e);
        }
    }

    @Override
    public boolean uploadFile(String sLocal, String sRemote) throws Exception {
        this.assertOpen();
        int iIndex1 = sRemote.lastIndexOf(47);
        String sRemotePath = sRemote.substring(0, iIndex1 + 1);
        String sRemoteFile = sRemote.substring(iIndex1 + 1);
        try {
            this.insureDirectory(sRemotePath);
            this.m_oSftpChannel.put(sLocal, sRemoteFile);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label10", "SFTP\u670d\u52a1\u5668\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25:") + sRemote + ".", e);
        }
        return true;
    }

    @Override
    public boolean hasTheFile(String sPath) throws Exception {
        this.assertOpen();
        try {
            if (this.m_oSftpChannel.stat(sPath) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean deleteFile(String sPath) throws Exception {
        this.assertOpen();
        try {
            this.m_oSftpChannel.rm(sPath);
            return true;
        }
        catch (Exception e) {
            if (e != null && e instanceof SftpException && ((SftpException)e).id == 2) {
                return true;
            }
            throw new WCMException(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label11", "SFTP\u670d\u52a1\u5668\u5220\u9664\u6587\u4ef6\u5931\u8d25") + sPath + ".", e);
        }
    }

    @Override
    public boolean deleteDirectory(String sPath) throws Exception {
        this.assertOpen();
        if (sPath.endsWith("/")) {
            sPath = sPath.substring(0, sPath.length() - 1);
        }
        try {
            this.m_oSftpChannel.rmdir(sPath);
            return true;
        }
        catch (Exception e) {
            s_logger.info((Object)("remove directory '" + sPath + "' failed"), (Throwable)e);
            int iIndex1 = sPath.lastIndexOf(47);
            String sRemotePath = sPath.substring(0, iIndex1 + 1);
            String sRemote2Del = sPath.substring(iIndex1 + 1);
            String sRemote2Ren = this.getTempFileName(sRemote2Del);
            StringBuffer sb = new StringBuffer(1024);
            sb.append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label12", "\u5220\u9664\u76ee\u5f55["));
            sb.append(sPath);
            sb.append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label13", "]\u5931\u8d25,\u5c1d\u8bd5\u5c06["));
            sb.append(sRemote2Del);
            sb.append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label14", "]\u91cd\u547d\u540d\u4e3a["));
            sb.append(sRemotePath);
            sb.append(sRemote2Ren);
            sb.append("],");
            try {
                this.m_oSftpChannel.cd(sRemotePath);
            }
            catch (Exception e2) {
                return false;
            }
            try {
                this.m_oSftpChannel.rename(sRemote2Del, sRemote2Ren);
                return true;
            }
            catch (Exception e3) {
                sb.append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label16", "\u76ee\u5f55\u91cd\u547d\u540d\u4e3a["));
                sb.append(sRemote2Ren);
                sb.append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label17", "]\u5931\u8d25"));
                throw new WCMException(sb.toString(), e3);
            }
        }
    }

    @Override
    public boolean renameFile(String sSourcePath, String sTargetFile) throws Exception {
        this.assertOpen();
        int iIndex1 = sSourcePath.lastIndexOf(47);
        String sRemotePath = sSourcePath.substring(0, iIndex1 + 1);
        String sRemote2Src = sSourcePath.substring(iIndex1 + 1);
        StringBuffer sb = new StringBuffer(1024);
        sb.append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label18", "\u5c1d\u8bd5\u5c06[")).append(sSourcePath).append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label14", "]\u91cd\u547d\u540d\u4e3a["));
        sb.append(sRemotePath).append(sTargetFile).append("],");
        try {
            this.m_oSftpChannel.cd(sRemotePath);
        }
        catch (Exception e) {
            sb.append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label19", "\u8fdb\u5165\u76ee\u5f55[")).append(sRemotePath).append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label15", "]\u5931\u8d25:"));
            sb.append(e.getMessage() + ".");
            throw new WCMException(1013, sb.toString());
        }
        try {
            this.m_oSftpChannel.rename(sRemote2Src, sTargetFile);
            return true;
        }
        catch (Exception e) {
            sb.append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label20", "\u91cd\u547d\u540d\u4e3a[")).append(sTargetFile).append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label15", "]\u5931\u8d25:"));
            sb.append(e.getMessage() + ".");
            throw new WCMException(sb.toString(), e);
        }
    }

    @Override
    protected void toHomeDirectory() throws Exception {
        this.assertOpen();
        if (this.m_sHomePath == null) {
            return;
        }
        try {
            this.m_oSftpChannel.cd(this.m_sHomePath);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label21", "\u6062\u590d\u521d\u59cb\u76ee\u5f55[") + this.m_sHomePath + I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label17", "]\u5931\u8d25"), e);
        }
    }

    public static void main(String[] args) {
        FtpConfig config = new FtpConfig();
        config.setProtocol("SFTP");
        config.setHost("192.9.100.245");
        config.setPort(22);
        config.setUserName("root");
        config.setPassWord("trsadmin");
        config.setRootPath("/home/WCM");
        config.setPassive(false);
        config.setMaxClient(10);
        FtpConnectionImpSSH ftp = new FtpConnectionImpSSH();
        ftp.setConfig(config);
        System.out.println(ftp.verifyConfig());
    }

    private class MyUserInfo
    implements UserInfo {
        public String getPassword() {
            return FtpConnectionImpSSH.this.getFtpConfig().getPassWord();
        }

        public boolean promptYesNo(String str) {
            return true;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public void showMessage(String message) {
            s_logger.info((Object)message);
        }
    }
}

