/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.store;

import com.trs.infra.util.WCMDiscoveryFactory;
import com.trs.infra.util.store.FileStoreParser;
import com.trs.infra.util.store.RandomAccessFileStore;
import com.trs.infra.util.store.RandomAccessFileStoreParser;
import com.trs.infra.util.store.impl.LocalRandomAccessFileStore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class RandomAccessFileStoreFactory {
    private static final Logger logger = Logger.getLogger(RandomAccessFileStoreFactory.class);
    private static RandomAccessFileStoreFactory instance;
    private Map<String, RandomAccessFileStoreParser> randomAccessfileStoreParsers;

    private RandomAccessFileStoreFactory() {
    }

    public static synchronized RandomAccessFileStoreFactory getInstance() {
        if (instance == null) {
            instance = new RandomAccessFileStoreFactory();
        }
        return instance;
    }

    public RandomAccessFileStore buildRandomAccessFileStore(String pathname, String mode) {
        int nIndex = pathname.indexOf(":");
        if (nIndex < 0) {
            return new LocalRandomAccessFileStore(pathname, mode);
        }
        String sProtocol = pathname.substring(0, nIndex + 1).toLowerCase();
        RandomAccessFileStoreParser parser = this.getRandomAccessFileStoreParsers().get(sProtocol);
        if (parser == null) {
            return new LocalRandomAccessFileStore(pathname, mode);
        }
        return parser.getRandomAccessFileStore(pathname, mode);
    }

    private Map<String, RandomAccessFileStoreParser> getRandomAccessFileStoreParsers() {
        if (this.randomAccessfileStoreParsers != null) {
            return this.randomAccessfileStoreParsers;
        }
        this.randomAccessfileStoreParsers = new HashMap<String, RandomAccessFileStoreParser>();
        Iterator iterator = WCMDiscoveryFactory.getDiscovery().getImplementors(FileStoreParser.class.getName());
        while (iterator != null && iterator.hasNext()) {
            String clazz = (String)iterator.next();
            try {
                RandomAccessFileStoreParser randomAccessFileStoreParser = (RandomAccessFileStoreParser)Class.forName(clazz).newInstance();
                this.randomAccessfileStoreParsers.put(randomAccessFileStoreParser.getProtocol(), randomAccessFileStoreParser);
            }
            catch (Exception e) {
                logger.error((Object)("\u52a0\u8f7d\u7c7b\u51fa\u73b0\u5f02\u5e38\uff3b" + clazz + "]"), (Throwable)e);
            }
        }
        return this.randomAccessfileStoreParsers;
    }
}

