/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.comm.Protocol;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class OSSClientFactory {
    private static final String OSS_CLIENT_CFG = "oss.properties";
    private static String ENDPOINT = "";
    private static String ACCESS_ID = "";
    private static String ACCESS_KEY = "";
    private static ClientConfiguration configInfo = new ClientConfiguration();

    public static OSSClient buildFileStore() {
        OSSClient client = new OSSClient(ENDPOINT, ACCESS_ID, ACCESS_KEY, configInfo);
        return client;
    }

    public static OSSClient buildFileStore(ClientConfiguration config) {
        OSSClient client = new OSSClient(ENDPOINT, ACCESS_ID, ACCESS_KEY, config);
        return client;
    }

    public static void main(String[] args) throws Exception {
        OSSClient client = OSSClientFactory.buildFileStore();
    }

    static {
        InputStream in = OSSClientFactory.class.getClassLoader().getResourceAsStream(OSS_CLIENT_CFG);
        Properties p = new Properties();
        try {
            p.load(in);
            ENDPOINT = p.getProperty("ENDPOINT");
            ACCESS_ID = p.getProperty("ACCESS_ID");
            ACCESS_KEY = p.getProperty("ACCESS_KEY");
            String protocol = p.getProperty("protocol");
            if ("HTTPS".equals(protocol)) {
                configInfo.setProtocol(Protocol.HTTPS);
            } else {
                configInfo.setProtocol(Protocol.HTTP);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

