/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.job;

import com.trs.infra.common.WCMException;
import com.trs.infra.util.job.JobFailedResult;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public abstract class BaseJob
implements Job {
    private JobDataMap m_oDataMap = null;
    private static Logger s_logger = Logger.getLogger(BaseJob.class);

    protected int getArgAsInt(String _sArgName) {
        return this.m_oDataMap.getInt(_sArgName.toUpperCase());
    }

    protected String getArgAsString(String _sArgName) {
        return this.m_oDataMap.getString(_sArgName.toUpperCase());
    }

    protected Object getArgAsObject(String _sArgName) {
        return this.m_oDataMap.get((Object)_sArgName.toUpperCase());
    }

    protected boolean containsArg(String _sArgName) {
        return this.m_oDataMap.containsKey((Object)_sArgName.toUpperCase());
    }

    protected void putArg(String _sArg, int _nValue) {
        this.m_oDataMap.put(_sArg.toUpperCase(), _nValue);
    }

    protected void putArg(String _sArg, String _sValue) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("_sArg:" + _sArg));
            s_logger.debug((Object)("_sValue:" + _sValue));
        }
        this.m_oDataMap.put(_sArg.toUpperCase(), _sValue);
    }

    protected void putArg(String _sArg, Object _oValue) {
        this.m_oDataMap.put((Object)_sArg.toUpperCase(), _oValue);
    }

    public void execute(JobExecutionContext _currContext) {
        this.m_oDataMap = _currContext.getJobDetail().getJobDataMap();
        JobExecutionException result = null;
        try {
            this.execute();
        }
        catch (Exception e) {
            result = new JobExecutionException(e);
            this.recordFailedResult(this.getArgAsString("ScheduleId"), e);
        }
        _currContext.setResult(result);
    }

    private void recordFailedResult(String _sScheduleId, Exception _ex) {
        try {
            int nScheduleId = Integer.parseInt(_sScheduleId);
            JobFailedResult result = new JobFailedResult(nScheduleId, _ex);
            result.insert();
        }
        catch (Exception e) {
            s_logger.error((Object)"failed to record job excute fail result.", (Throwable)e);
        }
    }

    protected abstract void execute() throws WCMException;
}

