/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.jazzlib;

import java.util.Calendar;
import java.util.Date;

public class ZipEntry
implements Cloneable {
    private static int KNOWN_SIZE = 1;
    private static int KNOWN_CSIZE = 2;
    private static int KNOWN_CRC = 4;
    private static int KNOWN_TIME = 8;
    private static Calendar cal = Calendar.getInstance();
    private String name;
    private int size;
    private int compressedSize;
    private int crc;
    private int time;
    private short known = 0;
    private short method = (short)-1;
    private byte[] extra = null;
    private String comment = null;
    int zipFileIndex = -1;
    int flags;
    int offset;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    public ZipEntry(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
    }

    public ZipEntry(ZipEntry e) {
        this.name = e.name;
        this.known = e.known;
        this.size = e.size;
        this.compressedSize = e.compressedSize;
        this.crc = e.crc;
        this.time = e.time;
        this.method = e.method;
        this.extra = e.extra;
        this.comment = e.comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDOSTime(int dostime) {
        int sec = 2 * (dostime & 0x1F);
        int min = dostime >> 5 & 0x3F;
        int hrs = dostime >> 11 & 0x1F;
        int day = dostime >> 16 & 0x1F;
        int mon = (dostime >> 21 & 0xF) - 1;
        int year = (dostime >> 25 & 0x7F) + 1980;
        try {
            Calendar calendar = cal;
            synchronized (calendar) {
                cal.set(year, mon, day, hrs, min, sec);
                this.time = (int)(cal.getTime().getTime() / 1000L);
            }
            this.known = (short)(this.known | KNOWN_TIME);
        }
        catch (RuntimeException ex) {
            this.known = (short)(this.known & ~KNOWN_TIME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getDOSTime() {
        if ((this.known & KNOWN_TIME) == 0) {
            return 0;
        }
        Calendar calendar = cal;
        synchronized (calendar) {
            cal.setTime(new Date((long)this.time * 1000L));
            return (cal.get(1) - 1980 & 0x7F) << 25 | cal.get(2) + 1 << 21 | cal.get(5) << 16 | cal.get(11) << 11 | cal.get(12) << 5 | cal.get(13) >> 1;
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setTime(long time) {
        this.time = (int)(time / 1000L);
        this.known = (short)(this.known | KNOWN_TIME);
    }

    public long getTime() {
        return (this.known & KNOWN_TIME) != 0 ? (long)this.time * 1000L : -1L;
    }

    public void setSize(long size) {
        if ((size & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.size = (int)size;
        this.known = (short)(this.known | KNOWN_SIZE);
    }

    public long getSize() {
        return (this.known & KNOWN_SIZE) != 0 ? (long)this.size & 0xFFFFFFFFL : -1L;
    }

    public void setCompressedSize(long csize) {
        if ((csize & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.compressedSize = (int)csize;
        this.known = (short)(this.known | KNOWN_CSIZE);
    }

    public long getCompressedSize() {
        return (this.known & KNOWN_CSIZE) != 0 ? (long)this.compressedSize & 0xFFFFFFFFL : -1L;
    }

    public void setCrc(long crc) {
        if ((crc & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.crc = (int)crc;
        this.known = (short)(this.known | KNOWN_CRC);
    }

    public long getCrc() {
        return (this.known & KNOWN_CRC) != 0 ? (long)this.crc & 0xFFFFFFFFL : -1L;
    }

    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException();
        }
        this.method = (short)method;
    }

    public int getMethod() {
        return this.method;
    }

    public void setExtra(byte[] extra) {
        if (extra == null) {
            this.extra = null;
            return;
        }
        if (extra.length > 65535) {
            throw new IllegalArgumentException();
        }
        this.extra = extra;
        try {
            int len;
            for (int pos = 0; pos < extra.length; pos += len) {
                byte flags;
                int sig = extra[pos++] & 0xFF | (extra[pos++] & 0xFF) << 8;
                len = extra[pos++] & 0xFF | (extra[pos++] & 0xFF) << 8;
                if (sig != 21589 || ((flags = extra[pos]) & 1) == 0) continue;
                this.time = extra[pos + 1] & 0xFF | (extra[pos + 2] & 0xFF) << 8 | (extra[pos + 3] & 0xFF) << 16 | (extra[pos + 4] & 0xFF) << 24;
                this.known = (short)(this.known | KNOWN_TIME);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return;
        }
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setComment(String comment) {
        if (comment.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isDirectory() {
        int nlen = this.name.length();
        return nlen > 0 && this.name.charAt(nlen - 1) == '/';
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

