/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.jazzlib;

import com.trs.infra.util.jazzlib.DataFormatException;
import com.trs.infra.util.jazzlib.InflaterHuffmanTree;
import com.trs.infra.util.jazzlib.StreamManipulator;

class InflaterDynHeader {
    private static final int LNUM = 0;
    private static final int DNUM = 1;
    private static final int BLNUM = 2;
    private static final int BLLENS = 3;
    private static final int LLENS = 4;
    private static final int DLENS = 5;
    private static final int LREPS = 6;
    private static final int DREPS = 7;
    private static final int FINISH = 8;
    private byte[] blLens;
    private byte[] litlenLens;
    private byte[] distLens;
    private InflaterHuffmanTree blTree;
    private int mode;
    private int lnum;
    private int dnum;
    private int blnum;
    private int repBits;
    private byte repeatedLen;
    private int ptr;
    private static final int[] BL_ORDER = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};

    public boolean decode(StreamManipulator input) throws DataFormatException {
        block20: while (true) {
            switch (this.mode) {
                case 0: {
                    this.lnum = input.peekBits(5);
                    if (this.lnum < 0) {
                        return false;
                    }
                    this.lnum += 257;
                    input.dropBits(5);
                    this.litlenLens = new byte[this.lnum];
                    this.mode = 1;
                }
                case 1: {
                    this.dnum = input.peekBits(5);
                    if (this.dnum < 0) {
                        return false;
                    }
                    ++this.dnum;
                    input.dropBits(5);
                    this.distLens = new byte[this.dnum];
                    this.mode = 2;
                }
                case 2: {
                    this.blnum = input.peekBits(4);
                    if (this.blnum < 0) {
                        return false;
                    }
                    this.blnum += 4;
                    input.dropBits(4);
                    this.blLens = new byte[19];
                    this.ptr = 0;
                    this.mode = 3;
                }
                case 3: {
                    while (this.ptr < this.blnum) {
                        int len = input.peekBits(3);
                        if (len < 0) {
                            return false;
                        }
                        input.dropBits(3);
                        this.blLens[InflaterDynHeader.BL_ORDER[this.ptr]] = (byte)len;
                        ++this.ptr;
                    }
                    this.blTree = new InflaterHuffmanTree(this.blLens);
                    this.blLens = null;
                    this.ptr = 0;
                    this.mode = 4;
                }
                case 4: {
                    int i;
                    int symbol;
                    block22: while (this.ptr < this.lnum) {
                        symbol = this.blTree.getSymbol(input);
                        if (symbol < 0) {
                            return false;
                        }
                        switch (symbol) {
                            default: {
                                this.litlenLens[this.ptr++] = (byte)symbol;
                                continue block22;
                            }
                            case 16: {
                                if (this.ptr == 0) {
                                    throw new DataFormatException("Repeating, but no prev len");
                                }
                                this.repeatedLen = this.litlenLens[this.ptr - 1];
                                this.repBits = 2;
                                i = 3;
                                while (i-- > 0) {
                                    if (this.ptr >= this.lnum) {
                                        throw new DataFormatException();
                                    }
                                    this.litlenLens[this.ptr++] = this.repeatedLen;
                                }
                                this.mode = 6;
                                continue block20;
                            }
                            case 17: {
                                this.repeatedLen = 0;
                                this.repBits = 3;
                                i = 3;
                                while (i-- > 0) {
                                    if (this.ptr >= this.lnum) {
                                        throw new DataFormatException();
                                    }
                                    this.litlenLens[this.ptr++] = this.repeatedLen;
                                }
                                this.mode = 6;
                                continue block20;
                            }
                            case 18: 
                        }
                        this.repeatedLen = 0;
                        this.repBits = 7;
                        i = 11;
                        while (i-- > 0) {
                            if (this.ptr >= this.lnum) {
                                throw new DataFormatException();
                            }
                            this.litlenLens[this.ptr++] = this.repeatedLen;
                        }
                        this.mode = 6;
                        continue block20;
                    }
                    this.ptr = 0;
                    this.mode = 5;
                }
                case 5: {
                    int i;
                    int symbol;
                    block26: while (this.ptr < this.dnum) {
                        symbol = this.blTree.getSymbol(input);
                        if (symbol < 0) {
                            return false;
                        }
                        switch (symbol) {
                            default: {
                                this.distLens[this.ptr++] = (byte)symbol;
                                continue block26;
                            }
                            case 16: {
                                if (this.ptr == 0) {
                                    throw new DataFormatException("Repeating, but no prev len");
                                }
                                this.repeatedLen = this.distLens[this.ptr - 1];
                                this.repBits = 2;
                                i = 3;
                                while (i-- > 0) {
                                    if (this.ptr >= this.dnum) {
                                        throw new DataFormatException();
                                    }
                                    this.distLens[this.ptr++] = this.repeatedLen;
                                }
                                this.mode = 7;
                                continue block20;
                            }
                            case 17: {
                                this.repeatedLen = 0;
                                this.repBits = 3;
                                i = 3;
                                while (i-- > 0) {
                                    if (this.ptr >= this.dnum) {
                                        throw new DataFormatException();
                                    }
                                    this.distLens[this.ptr++] = this.repeatedLen;
                                }
                                this.mode = 7;
                                continue block20;
                            }
                            case 18: 
                        }
                        this.repeatedLen = 0;
                        this.repBits = 7;
                        i = 11;
                        while (i-- > 0) {
                            if (this.ptr >= this.dnum) {
                                throw new DataFormatException();
                            }
                            this.distLens[this.ptr++] = this.repeatedLen;
                        }
                        this.mode = 7;
                        continue block20;
                    }
                    this.mode = 8;
                    return true;
                }
                case 6: {
                    int count = input.peekBits(this.repBits);
                    if (count < 0) {
                        return false;
                    }
                    input.dropBits(this.repBits);
                    while (count-- > 0) {
                        if (this.ptr >= this.lnum) {
                            throw new DataFormatException();
                        }
                        this.litlenLens[this.ptr++] = this.repeatedLen;
                    }
                    this.mode = 4;
                    continue block20;
                }
                case 7: {
                    int count = input.peekBits(this.repBits);
                    if (count < 0) {
                        return false;
                    }
                    input.dropBits(this.repBits);
                    while (count-- > 0) {
                        if (this.ptr >= this.dnum) {
                            throw new DataFormatException();
                        }
                        this.distLens[this.ptr++] = this.repeatedLen;
                    }
                    this.mode = 5;
                    continue block20;
                }
            }
        }
    }

    public InflaterHuffmanTree buildLitLenTree() throws DataFormatException {
        return new InflaterHuffmanTree(this.litlenLens);
    }

    public InflaterHuffmanTree buildDistTree() throws DataFormatException {
        return new InflaterHuffmanTree(this.distLens);
    }
}

