/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.ftp;

import com.jscape.inet.ftp.Ftp;
import com.jscape.inet.ftp.FtpException;
import com.jscape.inet.ftp.FtpFile;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileWrapper;
import java.io.File;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class CMyFtp
implements Runnable {
    private static Logger s_logger = Logger.getLogger(CMyFtp.class);
    private String sFTPServer = "127.0.0.1";
    private String sFTPPort = "21";
    private String sLogin = "anonymous";
    private String sPassword = "trs@trs.com.cn";
    private String sLocalPath = "D:\\\\WCMData\\pub";
    private String sLocalPubPath = "D:\\\\WCMData\\pub";
    private String sRemotePath = "/";
    private Ftp ftpClient = new Ftp();
    public final String ERR_NO_LOCAL_FILE = I18NMessage.get(CMyFtp.class, "CMyFtp.label1", "\u6ca1\u6709\u8bbe\u7f6e\u672c\u5730\u6587\u4ef6\u540d");
    public static int UPLOAD_RETRY_TIMES = 2;
    public static final int LIST_ALL = 0;
    public static final int LIST_FILES = 1;
    public static final int LIST_DIRS = 2;
    private boolean m_bUploading = false;
    private boolean m_bPassive = false;
    private boolean m_bStopNoop = false;

    public CMyFtp() {
        new Thread(this).start();
    }

    public boolean Connect() throws CMyException {
        return this.Connect(this.m_bPassive);
    }

    public boolean Connect(boolean bPassiveMode) throws CMyException {
        try {
            this.ftpClient.setHostname(this.sFTPServer);
            int nPort = Integer.valueOf(this.sFTPPort);
            this.ftpClient.setPort(nPort);
            this.ftpClient.setUsername(this.sLogin);
            this.ftpClient.setPassword(this.sPassword);
            this.ftpClient.setPassive(bPassiveMode);
            this.ftpClient.connect();
            this.ftpClient.setBinary();
            return this.ftpClient.isConnected();
        }
        catch (Exception ex) {
            throw new CMyException(1000, I18NMessage.get(CMyFtp.class, "CMyFtp.label2", "FTP\u670d\u52a1\u5668\u94fe\u63a5\u5931\u8d25\uff01"), ex);
        }
    }

    public boolean Disconnect() throws Exception {
        this.ftpClient.disconnect();
        return true;
    }

    public boolean renameFile(String _sDstFile, String _sNewFile) throws CMyException {
        if (_sDstFile == null || _sNewFile == null || !this.ftpClient.isConnected()) {
            return false;
        }
        if (_sDstFile.trim().length() <= 0 || _sNewFile.trim().length() <= 0) {
            return false;
        }
        try {
            this.ftpClient.renameFile(_sDstFile, _sNewFile);
        }
        catch (Exception ex) {
            throw new CMyException(1001, I18NMessage.get(CMyFtp.class, "CMyFtp.label3", "\u91cd\u547d\u540d\u6587\u4ef6[") + _sDstFile + I18NMessage.get(CMyFtp.class, "CMyFtp.label4", "]\u4e3a[") + _sNewFile + I18NMessage.get(CMyFtp.class, "CMyFtp.label5", "]\u5931\u8d25\uff01"), ex);
        }
        return true;
    }

    public boolean makeDirectory(String _sDir) throws CMyException {
        if (_sDir == null || !this.ftpClient.isConnected()) {
            return false;
        }
        int nIndex = 1;
        while ((nIndex = _sDir.indexOf(47, nIndex + 1)) != -1) {
            try {
                this.ftpClient.setDir(_sDir.substring(0, nIndex));
            }
            catch (Exception ex) {
                try {
                    this.ftpClient.makeDir(_sDir.substring(0, nIndex));
                }
                catch (Exception ex1) {
                    throw new CMyException(1001, I18NMessage.get(CMyFtp.class, "CMyFtp.label6", "\u521b\u5efa\u76ee\u5f55:") + _sDir.substring(0, nIndex) + I18NMessage.get(CMyFtp.class, "CMyFtp.label7", "\u5931\u8d25\uff01"), ex);
                }
            }
        }
        try {
            this.ftpClient.makeDir(_sDir);
            return true;
        }
        catch (Exception ex) {
            throw new CMyException(1002, I18NMessage.get(CMyFtp.class, "CMyFtp.label6", "\u521b\u5efa\u76ee\u5f55:") + _sDir + I18NMessage.get(CMyFtp.class, "CMyFtp.label7", "\u5931\u8d25\uff01"), ex);
        }
    }

    public boolean removeDirectory(String _sDir) throws CMyException {
        if (_sDir == null || !this.ftpClient.isConnected()) {
            return false;
        }
        try {
            this.ftpClient.deleteDir(_sDir);
            return true;
        }
        catch (Exception ex) {
            throw new CMyException(1003, I18NMessage.get(CMyFtp.class, "CMyFtp.label8", "\u5220\u9664\u6587\u4ef6\u5939") + _sDir + I18NMessage.get(CMyFtp.class, "CMyFtp.label7", "\u5931\u8d25\uff01"), ex);
        }
    }

    public void setLocalPubPath(String _sLocalPubPath) {
        if (_sLocalPubPath != null && this.sLocalPubPath.length() > 0) {
            this.sLocalPubPath = _sLocalPubPath.charAt(_sLocalPubPath.length() - 1) == File.separatorChar ? _sLocalPubPath : _sLocalPubPath + File.separatorChar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String _localFile, String _remoteFile) throws CMyException {
        if (_localFile == null) {
            return false;
        }
        this.m_bUploading = true;
        DebugTimer aTimer = new DebugTimer();
        aTimer.start();
        boolean bFileUploaded = true;
        int nUploadCount = 0;
        try {
            do {
                try {
                    _localFile.replace('/', File.separatorChar);
                    int nPos = _localFile.lastIndexOf(File.separatorChar);
                    String sPathName = _localFile.substring(0, nPos);
                    String sFileName = _localFile.substring(nPos + 1);
                    this.ftpClient.setLocalDir((File)new FileWrapper(new FileService(sPathName)));
                    int nPos2 = _remoteFile.lastIndexOf(47);
                    this.changeDirs(_remoteFile.substring(0, nPos2 + 1));
                    this.ftpClient.upload(sFileName, _remoteFile, false);
                    bFileUploaded = true;
                }
                catch (Exception ex) {
                    throw new CMyException(1005, I18NMessage.get(CMyFtp.class, "CMyFtp.label9", "\u4e0a\u4f20\u6587\u4ef6[") + _localFile + I18NMessage.get(CMyFtp.class, "CMyFtp.label10", "]\u5230[") + _remoteFile + I18NMessage.get(CMyFtp.class, "CMyFtp.label11", "]\u5931\u8d25!"), ex);
                }
            } while (!bFileUploaded && ++nUploadCount < UPLOAD_RETRY_TIMES);
        }
        finally {
            this.m_bUploading = false;
        }
        aTimer.stop();
        s_logger.info((Object)(I18NMessage.get(CMyFtp.class, "CMyFtp.label9", "\u4e0a\u4f20\u6587\u4ef6[") + _localFile + I18NMessage.get(CMyFtp.class, "CMyFtp.label12", "]\u6240\u7528\u65f6\u95f4\u4e3a[") + aTimer.getTime() + I18NMessage.get(CMyFtp.class, "CMyFtp.label13", "]\u6beb\u79d2!")));
        return bFileUploaded;
    }

    public void changeDirs(String _sPath) throws CMyException {
        int nIndex = 1;
        while ((nIndex = _sPath.indexOf(47, nIndex + 1)) != -1) {
            String sDirName = _sPath.substring(0, nIndex);
            try {
                this.ftpClient.setDir(sDirName);
            }
            catch (Exception ex) {
                try {
                    this.ftpClient.makeDir(sDirName);
                    this.ftpClient.setDir(sDirName);
                }
                catch (FtpException ftpEx) {
                    throw new CMyException(1006, I18NMessage.get(CMyFtp.class, "CMyFtp.label14", "\u66f4\u6539FTP\u7684\u76ee\u5f55[") + sDirName + I18NMessage.get(CMyFtp.class, "CMyFtp.label5", "]\u5931\u8d25\uff01"), ftpEx);
                }
            }
        }
    }

    public void uploadDirectory(String _localDir, String _remoteDir) throws CMyException {
        this.m_bUploading = true;
        try {
            if (_localDir != null) {
                this.ftpClient.setLocalDir((File)new FileWrapper(new FileService(_localDir)));
            }
            if (_remoteDir != null) {
                this.changeDirs(_remoteDir);
            }
            this.ftpClient.upload((File)new FileWrapper(new FileService(_localDir)), false);
        }
        catch (Exception ex) {
            throw new CMyException(1007, I18NMessage.get(CMyFtp.class, "CMyFtp.label15", "\u6587\u4ef6[") + _localDir + I18NMessage.get(CMyFtp.class, "CMyFtp.label16", "]\u6ca1\u6709\u4e0a\u4f20\u5230[") + _remoteDir + "]", ex);
        }
        finally {
            this.m_bUploading = false;
        }
    }

    public boolean changeDir(String _localDir, boolean bRemote) throws Exception {
        if (!this.ftpClient.isConnected()) {
            return false;
        }
        try {
            if (bRemote) {
                this.ftpClient.setDir(_localDir);
            } else {
                this.ftpClient.setLocalDir((File)new FileWrapper(new FileService(_localDir)));
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void setConnectionInfo(String _sServer, String _sPort, String _sLogin, String _sPassword) {
        this.setConnectionInfo(_sServer, _sPort, _sLogin, _sPassword, false);
    }

    public void setConnectionInfo(String _sServer, String _sPort, String _sLogin, String _sPassword, boolean _bPassive) {
        int nPortIndex;
        if (_sServer != null && _sServer.length() > 0) {
            this.sFTPServer = _sServer;
        }
        this.sFTPServer = this.sFTPServer.trim();
        if (this.sFTPServer.toUpperCase().indexOf("FTP://") == 0) {
            this.sFTPServer = this.sFTPServer.substring(6);
        }
        if ((nPortIndex = this.sFTPServer.indexOf(":")) != -1 && nPortIndex + 1 < this.sFTPServer.length()) {
            this.sFTPPort = this.sFTPServer.substring(nPortIndex + 1, this.sFTPServer.length());
            this.sFTPServer = this.sFTPServer.substring(0, nPortIndex);
        }
        if (this.sFTPPort.length() <= 0 && _sPort != null && _sPort.length() > 0) {
            this.sFTPPort = _sPort;
        }
        if (_sPassword != null && _sPassword.length() > 0) {
            this.sPassword = _sPassword;
        }
        if (_sLogin != null && _sLogin.length() > 0) {
            this.sLogin = _sLogin;
        }
        this.m_bPassive = _bPassive;
    }

    public void setRemotePath(String _sRemotePath) {
        if (_sRemotePath != null && _sRemotePath.length() > 0) {
            _sRemotePath.replace('\\', '/');
            this.sRemotePath = _sRemotePath.charAt(0) != '/' ? "/" : "";
            this.sRemotePath = this.sRemotePath + (_sRemotePath.charAt(_sRemotePath.length() - 1) == '/' ? _sRemotePath : _sRemotePath + "/");
        }
    }

    public void setLocalPath(String _sLocalPath) {
        if (_sLocalPath != null && _sLocalPath.length() > 0) {
            _sLocalPath.replace('/', File.separatorChar);
            this.sLocalPath = _sLocalPath.charAt(0) != File.separatorChar ? File.separator : "";
            this.sLocalPath = this.sLocalPath + (_sLocalPath.charAt(_sLocalPath.length() - 1) == File.separatorChar ? _sLocalPath : _sLocalPath + File.pathSeparator);
        }
    }

    /*
     * Loose catch block
     */
    public boolean downloadFile(String _remoteFile, String _localFile) throws Exception {
        block5: {
            if (this.ftpClient != null && this.ftpClient.isConnected()) break block5;
            return false;
            {
                catch (Exception ex) {
                    throw new CMyException(1010, I18NMessage.get(CMyFtp.class, "CMyFtp.label17", "\u4e0b\u8f7d\u6587\u4ef6[") + _remoteFile + I18NMessage.get(CMyFtp.class, "CMyFtp.label10", "]\u5230[") + _localFile + I18NMessage.get(CMyFtp.class, "CMyFtp.label11", "]\u5931\u8d25!"), ex);
                }
            }
        }
        try {
            this.ftpClient.download(_localFile, _remoteFile);
            return true;
        }
        catch (Exception ex) {
            throw new CMyException(1009, I18NMessage.get(CMyFtp.class, "CMyFtp.label17", "\u4e0b\u8f7d\u6587\u4ef6[") + _remoteFile + I18NMessage.get(CMyFtp.class, "CMyFtp.label10", "]\u5230[") + _localFile + I18NMessage.get(CMyFtp.class, "CMyFtp.label11", "]\u5931\u8d25!"), ex);
        }
    }

    public String getDateTime(String _name, boolean bRemote) throws Exception {
        if (bRemote && !this.ftpClient.isConnected()) {
            return "";
        }
        try {
            if (bRemote) {
                Enumeration enumFiles = this.ftpClient.getDirListing();
                while (enumFiles.hasMoreElements()) {
                    FtpFile file = (FtpFile)enumFiles.nextElement();
                    if (file.getFilename() != _name) continue;
                    return file.getDate() + " " + file.getTime();
                }
            } else {
                Enumeration enumLocalFiles = this.ftpClient.getLocalDirListing();
                while (enumLocalFiles.hasMoreElements()) {
                    File file = (File)enumLocalFiles.nextElement();
                    if (file.getName() != _name) continue;
                    Date date1 = new Date(file.lastModified());
                    StringTokenizer stringtokenizer = new StringTokenizer(date1.toString());
                    stringtokenizer.nextToken();
                    String sDate = stringtokenizer.nextToken() + "-" + stringtokenizer.nextToken();
                    String sTime = stringtokenizer.nextToken();
                    stringtokenizer.nextToken();
                    sDate = sDate + "-" + stringtokenizer.nextToken();
                    return sDate + sTime;
                }
            }
        }
        catch (Exception ex) {
            throw new CMyException(1011, I18NMessage.get(CMyFtp.class, "CMyFtp.label18", "FTP\u63d0\u53d6\u6587\u4ef6[") + _name + I18NMessage.get(CMyFtp.class, "CMyFtp.label19", "]\u65f6\u95f4\u9519\u8bef!"), ex);
        }
        return "";
    }

    public int getFileSize(String _fileName, boolean bRemote) throws Exception {
        if (bRemote && !this.ftpClient.isConnected()) {
            return 0;
        }
        try {
            if (bRemote) {
                Enumeration enumFiles = this.ftpClient.getDirListing();
                while (enumFiles.hasMoreElements()) {
                    FtpFile file = (FtpFile)enumFiles.nextElement();
                    if (file.getFilename() != _fileName) continue;
                    return (int)file.getFilesize();
                }
            } else {
                Enumeration enumLocalFiles = this.ftpClient.getLocalDirListing();
                while (enumLocalFiles.hasMoreElements()) {
                    File file = (File)enumLocalFiles.nextElement();
                    if (file.getName() != _fileName) continue;
                    return (int)file.length();
                }
            }
        }
        catch (Exception ex) {
            throw new CMyException(1012, I18NMessage.get(CMyFtp.class, "CMyFtp.label20", "\u63d0\u53d6\u6587\u4ef6[") + _fileName + I18NMessage.get(CMyFtp.class, "CMyFtp.label21", "]\u5927\u5c0f\u4e0d\u6210\u529f!"), ex);
        }
        return 0;
    }

    public boolean removeFile(String _fileName, boolean bRemote) throws Exception {
        if (bRemote && !this.ftpClient.isConnected()) {
            return false;
        }
        try {
            if (bRemote) {
                this.ftpClient.deleteFile(_fileName);
            } else {
                FileService curFile = new FileService(_fileName);
                curFile.delete();
            }
            return true;
        }
        catch (Exception ex) {
            throw new CMyException(1013, I18NMessage.get(CMyFtp.class, "CMyFtp.label22", "\u5220\u9664\u6587\u4ef6[") + _fileName + I18NMessage.get(CMyFtp.class, "CMyFtp.label23", "]\u9519\u8bef!"), ex);
        }
    }

    public boolean testFtpServer(String _ftpServer, String _ftpUser, String _ftpPwd) throws Exception {
        return this.testFtpServer(_ftpServer, _ftpUser, _ftpPwd, "/", false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean testFtpServer(String _ftpServer, String _ftpUser, String _ftpPwd, String _ftpFolder, boolean _bWrite) throws Exception {
        boolean bServerOK = false;
        this.setConnectionInfo(_ftpServer, "21", _ftpUser, _ftpPwd);
        this.setRemotePath(_ftpFolder);
        if (!this.Connect()) throw new Exception(I18NMessage.get(CMyFtp.class, "CMyFtp.label26", "FTP\u670d\u52a1\u5668\u8fde\u63a5\u4e0d\u6210\u529f(FTP\u7684\u8bbe\u7f6e\u53ef\u80fd\u4e0d\u6b63\u786e)!"));
        if (!this.changeDir(_ftpFolder, true)) throw new Exception(I18NMessage.get(CMyFtp.class, "CMyFtp.label25", "FTP\u670d\u52a1\u5668\u8def\u5f84\u68c0\u6d4b\u4e0d\u6210\u529f(\u8def\u5f84\u53ef\u80fd\u4e0d\u5b58\u5728)!"));
        bServerOK = true;
        if (!_bWrite) return this.Disconnect();
        bServerOK = this.makeDirectory("__test__");
        this.removeDirectory("__test__");
        if (bServerOK) return this.Disconnect();
        throw new Exception(I18NMessage.get(CMyFtp.class, "CMyFtp.label24", "FTP\u670d\u52a1\u5668\u5199\u5165\u68c0\u6d4b\u4e0d\u6210\u529f(\u8bbe\u7f6e\u7684\u76ee\u5f55\u53ef\u80fd\u4e0d\u5177\u6709\u5199\u5165\u6743\u9650)!"));
    }

    public boolean isConnected() throws CMyException {
        if (this.ftpClient == null) {
            return false;
        }
        try {
            boolean bResult = this.ftpClient.isConnected();
            return bResult;
        }
        catch (Exception ex) {
            throw new CMyException(1014, I18NMessage.get(CMyFtp.class, "CMyFtp.label27", "\u68c0\u6d4bFTP\u662f\u5426\u8fde\u63a5\u9519\u8bef\uff01"), ex);
        }
    }

    public String listDirs(String _ftpPath) throws Exception {
        return this.listDirectory(_ftpPath, 2);
    }

    public String listDirectory(String _ftpPath, int _listType) throws Exception {
        if (_ftpPath == null || !this.isConnected()) {
            return "";
        }
        String sResult = "";
        try {
            if (!this.changeDir(_ftpPath, true)) {
                return "";
            }
            Enumeration enumFiles = this.ftpClient.getDirListing();
            block6: while (enumFiles.hasMoreElements()) {
                FtpFile fi = (FtpFile)enumFiles.nextElement();
                switch (_listType) {
                    case 2: {
                        if (!fi.isDirectory()) continue block6;
                        sResult = sResult + fi.getFilename() + ",";
                        continue block6;
                    }
                    case 1: {
                        if (fi.isDirectory()) continue block6;
                        sResult = sResult + fi.getFilename() + ",";
                        continue block6;
                    }
                }
                sResult = sResult + fi.getFilename() + ",";
            }
            return sResult;
        }
        catch (Exception ex) {
            throw new CMyException(1015, I18NMessage.get(CMyFtp.class, "CMyFtp.label28", "\u63d0\u53d6\u76ee\u5f55[") + _ftpPath + I18NMessage.get(CMyFtp.class, "CMyFtp.label23", "]\u9519\u8bef!"), ex);
        }
    }

    public String listAll(String _ftpPath) throws Exception {
        return this.listDirectory(_ftpPath, 0);
    }

    public String listFiles(String _ftpPath) throws Exception {
        return this.listDirectory(_ftpPath, 1);
    }

    public static CMyFtp getFtpConnection() throws Exception {
        CMyFtp currFtp = new CMyFtp();
        currFtp.setConnectionInfo("192.168.12.9", "21", "administrator", "my0743");
        currFtp.setLocalPath("ce");
        currFtp.setRemotePath("/ce/");
        String sPassiveMode = "0";
        boolean bPassive = sPassiveMode.equals("1");
        try {
            if (!currFtp.Connect(bPassive)) {
                throw new CMyException(1000, I18NMessage.get(CMyFtp.class, "CMyFtp.label34", "\u5efa\u7acb\uff26\uff34\uff30\u8fde\u63a5\u4e0d\u6210\u529f!"));
            }
        }
        catch (Exception ex) {
            throw new CMyException(1000, I18NMessage.get(CMyFtp.class, "CMyFtp.label35", "\u5efa\u7acb\uff26\uff34\uff30\u8fde\u63a5\u4e0d\u6210\u529f\u5bfc\u81f4!"));
        }
        return currFtp;
    }

    public static void main(String[] args) {
        CMyFtp aFtp = new CMyFtp();
        aFtp.setConnectionInfo("127.0.0.1", "21", "caohui", "caohui");
        try {
            aFtp.Connect(false);
            Thread.sleep(2000000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CMyFtp currFtp = new CMyFtp();
        currFtp.setConnectionInfo("192.9.200.230", "21", "anonymous", "trs");
        currFtp.setLocalPath("D:\\Temp");
        currFtp.setRemotePath("/");
        try {
            if (!currFtp.Connect(false)) {
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            currFtp = null;
        }
        if (currFtp == null) {
            return;
        }
        String strRemoteFile = "/" + System.currentTimeMillis() + "_2.htm";
        try {
            long lStart = System.currentTimeMillis();
            System.out.println("Upload First....");
            currFtp.uploadFile("D:\\Temp\\2.htm", strRemoteFile);
            currFtp.removeFile("/2.htm", true);
            currFtp.renameFile(strRemoteFile, "/2.htm");
            System.out.println("Upload First OK!");
            System.out.println("Eplased Time:" + (System.currentTimeMillis() - lStart));
            System.out.println("Upload Second....");
            currFtp.uploadFile("D:\\Temp\\2.htm", strRemoteFile);
            currFtp.removeFile("/2.htm", true);
            currFtp.renameFile(strRemoteFile, "/2.htm");
            System.out.println("Upload Second OK!");
            System.out.println("Eplased Time:" + (System.currentTimeMillis() - lStart));
        }
        catch (CMyException e) {
            System.err.println("CMyException Dump:");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Exception Dump:");
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        if (this.ftpClient == null) {
            return;
        }
        while (!this.m_bStopNoop) {
            try {
                Thread.sleep(120000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_bUploading) continue;
            try {
                this.ftpClient.noop();
            }
            catch (Exception ex) {
                s_logger.error((Object)"ftp noop error!", (Throwable)ex);
                if (this.ftpClient.isConnected()) continue;
                try {
                    this.ftpClient.connect();
                }
                catch (Exception ignore) {
                    s_logger.error((Object)I18NMessage.get(CMyFtp.class, "CMyFtp.label36", "\u518d\u6b21\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25\uff01"), (Throwable)ignore);
                }
            }
        }
    }

    public void setStopNoop(boolean stopNoop) {
        this.m_bStopNoop = stopNoop;
    }
}

