/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.cabfile;

import com.trs.infra.util.cabfile.CFData;
import com.trs.infra.util.cabfile.CFFile;
import com.trs.infra.util.cabfile.CFFolder;
import com.trs.infra.util.cabfile.CFHeader;
import com.trs.infra.util.cabfile.CabConstants;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.RandomAccessFileService;
import com.trs.infra.util.store.RandomAccessFileStore;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;

class CabFileReader
implements CabConstants {
    private static final int MAX_SZ_LENGTH = 4096;
    RandomAccessFileStore m_oAccess;
    CFHeader m_oHeader;
    byte[] m_oBuffer;

    CabFileReader(FileStore file) throws FileNotFoundException {
        this.m_oAccess = new RandomAccessFileService(file, "r");
    }

    CabFileReader(FileStore file, CFHeader header) throws FileNotFoundException {
        this.m_oAccess = new RandomAccessFileService(file, "r");
        this.m_oHeader = header;
    }

    void skip(int n) throws IOException {
        this.m_oAccess.skipBytes(n);
    }

    void seek(long pos) throws IOException {
        this.m_oAccess.seek(pos);
    }

    private final void assertHeader() throws IOException {
        if (this.m_oHeader == null) {
            throw new IOException("m_oHeader missing");
        }
    }

    private final void assertSignature() throws IOException {
        int c4;
        int c3;
        int c2;
        int c1 = this.m_oAccess.read();
        if ((c1 | (c2 = this.m_oAccess.read()) | (c3 = this.m_oAccess.read()) | (c4 = this.m_oAccess.read())) < 0) {
            throw new EOFException();
        }
        if (c1 == 77 && c2 == 83 && c3 == 67 && c4 == 70) {
            return;
        }
        throw new IOException("signature not match");
    }

    long readU4() throws IOException {
        int c4;
        int c3;
        int c2;
        int c1 = this.m_oAccess.read();
        if ((c1 | (c2 = this.m_oAccess.read()) | (c3 = this.m_oAccess.read()) | (c4 = this.m_oAccess.read())) < 0) {
            throw new EOFException();
        }
        return (c4 << 24) + (c3 << 16) + (c2 << 8) + (c1 << 0);
    }

    int readU2() throws IOException {
        int c2;
        int c1 = this.m_oAccess.read();
        if ((c1 | (c2 = this.m_oAccess.read())) < 0) {
            throw new EOFException();
        }
        return (c2 << 8) + (c1 << 0);
    }

    final int readU1() throws IOException {
        int c1 = this.m_oAccess.read();
        if (c1 < 0) {
            throw new EOFException();
        }
        return c1;
    }

    private final byte[] getBuffer() {
        if (this.m_oBuffer == null) {
            this.m_oBuffer = new byte[4096];
        }
        return this.m_oBuffer;
    }

    byte[] readSZ() throws IOException {
        int aByte = 0;
        int iCount = 0;
        byte[] buffer = this.getBuffer();
        while (iCount < 4096 && (aByte = this.readU1()) != 0) {
            buffer[iCount++] = (byte)aByte;
        }
        if (iCount == 4096) {
            throw new IOException("SZ string too long: " + iCount);
        }
        byte[] result = new byte[iCount];
        for (int i = 0; i < iCount; ++i) {
            result[i] = buffer[i];
        }
        return result;
    }

    CFHeader readCFHeader() throws IOException {
        this.assertSignature();
        CFHeader header = new CFHeader();
        this.skip(4);
        header.cbCabinet = this.readU4();
        this.skip(4);
        header.coffFiles = this.readU4();
        this.skip(4);
        header.versionMinor = this.readU1();
        header.versionMajor = this.readU1();
        header.cFolders = this.readU2();
        header.cFiles = this.readU2();
        header.flags = this.readU2();
        header.setID = this.readU2();
        header.iCabinet = this.readU2();
        if ((header.flags & 4) != 0) {
            header.cbCFHeader = this.readU2();
            header.cbCFFolder = this.readU1();
            header.cbCFData = this.readU1();
            header.abReserve = new byte[header.cbCFHeader];
            this.read(header.abReserve, 0, header.cbCFHeader);
        }
        if ((header.flags & 1) != 0) {
            header.szCabinetPrev = this.readSZ();
            header.szDiskPrev = this.readSZ();
        }
        if ((header.flags & 2) != 0) {
            header.szCabinetNext = this.readSZ();
            header.szDiskNext = this.readSZ();
        }
        this.m_oHeader = header;
        return this.m_oHeader;
    }

    CFFolder readCFFolder() throws IOException {
        this.assertHeader();
        CFFolder folder = new CFFolder();
        folder.coffCabStart = this.readU4();
        folder.cCFData = this.readU2();
        folder.typeCompress = this.readU2();
        if ((this.m_oHeader.flags & 4) != 0 && this.m_oHeader.cbCFFolder > 0) {
            if (folder.abReserve == null || folder.abReserve.length != this.m_oHeader.cbCFFolder) {
                folder.abReserve = new byte[this.m_oHeader.cbCFFolder];
            }
            this.read(folder.abReserve, 0, this.m_oHeader.cbCFFolder);
        }
        return folder;
    }

    CFFile readCFFile() throws IOException {
        CFFile file = new CFFile();
        file.cbFile = this.readU4();
        file.uoffFolderStart = this.readU4();
        file.iFolder = this.readU2();
        file.date = this.readU2();
        file.time = this.readU2();
        file.attribs = this.readU2();
        file.szName = this.readSZ();
        return file;
    }

    CFData fillCFData(CFData data) throws IOException {
        this.assertHeader();
        data.csum = this.readU4();
        data.cbData = this.readU2();
        data.cbUncomp = this.readU2();
        if ((this.m_oHeader.flags & 4) != 0 && this.m_oHeader.cbCFData > 0) {
            if (data.abReserve == null || data.abReserve.length != this.m_oHeader.cbCFData) {
                data.abReserve = new byte[this.m_oHeader.cbCFData];
            }
            this.read(data.abReserve, 0, this.m_oHeader.cbCFData);
        }
        this.read(data.ab, 0, data.cbData);
        return data;
    }

    private void read(byte[] buffer, int offset, int length) throws IOException {
        while (length > 0) {
            int count = this.m_oAccess.read(buffer, offset, length);
            if (count == -1) {
                throw new EOFException();
            }
            offset += count;
            length -= count;
        }
    }

    void close() {
        if (this.m_oAccess != null) {
            try {
                this.m_oAccess.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

