/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.tools.SymbolC2E;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class JavaScriptVARProcessor {
    private static Logger logger = Logger.getLogger(JavaScriptVARProcessor.class);
    protected String m_sSrcPath = null;
    protected String m_sComparePath = null;
    protected String m_sDstPath = null;
    protected String m_sStartPath = null;
    protected String m_sFileExt = "js";
    protected String m_sFileEncoding = "utf-8";
    private StringBuffer m_sbInfo = new StringBuffer();
    private boolean m_bRecordDetailInfo = false;
    private String m_sAlreadyCompareFile = null;

    public JavaScriptVARProcessor(String _sSrcPath, String _sComparePath, String _sDstPath, String _sStartPath) {
        if (_sSrcPath.endsWith(".js")) {
            _sSrcPath = CMyFile.extractFilePath(_sSrcPath);
        }
        if (_sComparePath.endsWith(".js")) {
            _sComparePath = CMyFile.extractFilePath(_sComparePath);
        }
        this.m_sSrcPath = CMyString.setStrEndWith(_sSrcPath, File.separatorChar);
        this.m_sComparePath = CMyString.setStrEndWith(_sComparePath, File.separatorChar);
        this.m_sDstPath = CMyString.setStrEndWith(_sDstPath, File.separatorChar);
        this.m_sStartPath = CMyString.setStrEndWith(_sStartPath, File.separatorChar);
    }

    public String process() throws Exception {
        FileService file = new FileService(this.m_sSrcPath);
        if (!file.exists()) {
            throw new Exception("\u6307\u5b9a\u7684\u76ee\u5f55[" + this.m_sSrcPath + "]\u4e0d\u5b58\u5728\uff01");
        }
        if (!file.isDirectory()) {
            this.process(this.m_sSrcPath, this.m_sComparePath);
            throw new Exception("\u6307\u5b9a\u7684\u76ee\u5f55[" + this.m_sSrcPath + "]\u4e0d\u662f\u76ee\u5f55\uff01");
        }
        FileStore[] pFiles = file.listFiles();
        for (int i = 0; i < pFiles.length; ++i) {
            String sFileName;
            FileStore oFile = pFiles[i];
            if (!oFile.isFile() || !(sFileName = oFile.getName()).endsWith(this.m_sFileExt)) continue;
            String sAbsoluteFileName = oFile.getAbsolutePath();
            String sCompareFileName = this.m_sComparePath + sFileName;
            this.process(sAbsoluteFileName, sCompareFileName);
        }
        return this.m_sbInfo.toString();
    }

    public String process(String sAbsoluteFileName, String sCompareFileName) throws Exception {
        FileService dstFile = new FileService(sCompareFileName);
        if (!dstFile.exists()) {
            this.m_sbInfo.append(sCompareFileName.substring(this.m_sStartPath.length()) + "\u4e0d\u5b58\u5728\uff01\n");
            CMyFile.copyFile(sAbsoluteFileName, sCompareFileName);
            String sDstFileName = this.makeDstFileName(sCompareFileName);
            CMyFile.copyFile(sAbsoluteFileName, sDstFileName);
            return this.m_sbInfo.toString();
        }
        HashMap hSrcResult = this.toMap(sAbsoluteFileName);
        HashMap hCompareResult = this.toMap(sCompareFileName);
        Iterator itKeys = hSrcResult.keySet().iterator();
        boolean bFindDiff = false;
        StringBuffer sbAppendContent = new StringBuffer();
        while (itKeys.hasNext()) {
            String sKey = (String)itKeys.next();
            String sValue = (String)hCompareResult.get(sKey);
            if (sValue == null) {
                if (!bFindDiff) {
                    this.m_sbInfo.append("\u6587\u4ef6[" + sCompareFileName.substring(this.m_sStartPath.length()) + "]\u5b58\u5728\u95ee\u9898\n");
                }
                bFindDiff = true;
                if (this.m_bRecordDetailInfo) {
                    this.m_sbInfo.append("\t[" + sKey + "]\u6ca1\u6709\u7ffb\u8bd1\n");
                }
                if (!(sValue = (String)hSrcResult.get(sKey)).trim().endsWith(",")) {
                    sValue = sValue + ",";
                }
                sbAppendContent.append("\t" + sKey + " : " + sValue + "\n");
            }
            if (!JavaScriptVARProcessor.isNotEng(sValue)) continue;
            if (!bFindDiff) {
                this.m_sbInfo.append("\u6587\u4ef6[" + sCompareFileName.substring(this.m_sStartPath.length()) + "]\u5b58\u5728\u95ee\u9898\n");
            }
            bFindDiff = true;
            if (!this.m_bRecordDetailInfo) continue;
            this.m_sbInfo.append("\t[" + sKey + "]\u5b58\u5728\u4e2d\u6587[" + sValue + "]\n");
        }
        if (bFindDiff) {
            String sDstFileName = this.makeDstFileName(sCompareFileName);
            if (sbAppendContent.length() == 0) {
                if (this.m_sAlreadyCompareFile == null || !this.m_sAlreadyCompareFile.equals(sCompareFileName)) {
                    SymbolC2E.runtimeSymbols = SymbolC2E.resourceSymbols;
                    SymbolC2E.replaceFile(sCompareFileName, sCompareFileName);
                    SymbolC2E.runtimeSymbols = SymbolC2E.pageSymbols;
                    this.m_sAlreadyCompareFile = sCompareFileName;
                    return this.process(sAbsoluteFileName, sCompareFileName);
                }
                CMyFile.copyFile(sCompareFileName, sDstFileName);
            } else {
                sbAppendContent.setLength(sbAppendContent.length() - 2);
                String sNewContent = this.appendVar(sCompareFileName, sbAppendContent);
                String sEncoding = CharsetDetector.detect(sCompareFileName);
                CMyFile.writeFile(sCompareFileName, sNewContent, sEncoding);
                CMyFile.writeFile(sDstFileName, sNewContent, sEncoding);
            }
        }
        return this.m_sbInfo.toString();
    }

    private String makeDstFileName(String _sCompareFileName) throws Exception {
        int nPos = _sCompareFileName.indexOf(this.m_sStartPath);
        if (nPos < 0) {
            throw new Exception("\u4f20\u5165\u7684\u8d77\u59cb\u8def\u5f84\u6709\u95ee\u9898\uff01");
        }
        String sDstFileName = this.m_sDstPath + _sCompareFileName.substring(this.m_sStartPath.length());
        return sDstFileName;
    }

    private String appendVar(String _sFileName, StringBuffer _sAppendFileContent) throws Exception {
        String sEncoding = CharsetDetector.detect(_sFileName);
        String sContent = CMyFile.readFile(_sFileName, sEncoding);
        sContent = sContent.trim();
        int nPos = sContent.lastIndexOf("\n");
        return sContent.substring(0, nPos) + ",\n" + _sAppendFileContent + sContent.substring(nPos);
    }

    private static boolean isNotEng(String _string) {
        if (_string == null) {
            return false;
        }
        char[] srcBuff = _string.toCharArray();
        for (int i = 0; i < srcBuff.length; ++i) {
            char aChar = srcBuff[i];
            if (aChar <= '\u007f') continue;
            return true;
        }
        return false;
    }

    private HashMap toMap(String _sFileName) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>(30);
        InputStreamReader fileReader = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        String sEncoding = CharsetDetector.detect(_sFileName);
        try {
            String sLine;
            fis = new FileService(_sFileName).getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, sEncoding));
            String sVarName = "";
            String sValue = "";
            while ((sLine = buffReader.readLine()) != null) {
                String sOldLine = sLine;
                if ((sLine = sLine.trim()).startsWith("+") && sVarName.length() > 0) {
                    sValue = sValue + "\n" + sOldLine;
                    result.put(sVarName, sValue);
                    continue;
                }
                int nPos = sLine.indexOf(58);
                if (nPos < 0 || sLine.startsWith("*") || sLine.startsWith("//")) continue;
                sVarName = sLine.substring(0, nPos).trim();
                sValue = sLine.substring(nPos + 1).trim();
                result.put(sVarName, sValue);
            }
        }
        catch (FileNotFoundException ex) {
            throw new CMyException(55, "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230", ex);
        }
        catch (IOException ex) {
            throw new CMyException(53, "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef", ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            String sSrcPath = "E:\\wcm61-media\\temp\\locale-src\\";
            String sComparePath = "E:\\wcm61-media\\temp\\locale-cmp\\";
            String sDstPath = "E:\\wcm61-media\\temp\\locale-dst\\";
            String sStartPath = "E:\\wcm61-media\\temp\\";
            JavaScriptVARProcessor oProcessor = new JavaScriptVARProcessor(sSrcPath, sComparePath, sDstPath, sStartPath);
            oProcessor.process();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

