/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.jazzlib.ZipEntry;
import com.trs.infra.util.jazzlib.ZipFile;
import com.trs.infra.util.jazzlib.ZipInputStream;
import com.trs.infra.util.store.FileService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class CMyUnzip {
    public static boolean IS_DEBUG = false;
    private String zipFileName = null;
    private Hashtable hZipItems = null;
    private String encoding = null;
    private Set m_hStrictFileSet = new HashSet(8);

    public CMyUnzip() {
        String sSuffix = ConfigServer.getServer().getInitProperty("FILE_UPLOAD_ALLOW_SUFFIX");
        sSuffix = CMyString.showNull(sSuffix, "doc,docx,xsl,xls,xlsx,xsn,ppt,pptx,pdf,log,txt,html,htm,js,css,xml,zip,rar,gz,bz2,tar,tbz,tgz,jpg,jpeg,gif,png,bmp,wav,mid,midi,mp3,mpa,mp2,ra,ram,rm,wma,asf,avi,mpg,mpeg,mpe,mov,rm,rmvb,wmv,swf,flv");
        sSuffix = sSuffix + ",shtml,shtm,htm,html,js,css";
        this.addStrictFile(sSuffix);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String _encoding) {
        this.encoding = _encoding;
    }

    private Hashtable getMyZipItems() throws CMyException {
        if (this.hZipItems == null) {
            this.extractZipItems();
        }
        return this.hZipItems;
    }

    private void extractZipItems() throws CMyException {
        if (this.zipFileName == null) {
            throw new CMyException(10, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label1", "zip\u6587\u4ef6\u5c1a\u672a\u8bbe\u7f6e\uff08CMyUnzip.getItems\uff09"));
        }
        this.hZipItems = new Hashtable();
        ZipFile zf = null;
        try {
            zf = new ZipFile(this.zipFileName, this.encoding);
            Enumeration eEntries = zf.entries();
            while (eEntries.hasMoreElements()) {
                ZipEntry ze = (ZipEntry)eEntries.nextElement();
                this.hZipItems.put(ze.getName().trim().toLowerCase(), ze);
            }
        }
        catch (FileNotFoundException ex) {
            throw new CMyException(55, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label2", "zip\u6587\u4ef6(") + this.zipFileName + I18NMessage.get(CMyUnzip.class, "CMyUnzip.label3", ")\u6ca1\u6709\u627e\u5230\uff08CMyUnzip.getItems\uff09"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(50, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label4", "\u63d0\u53d6zip\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff08CMyUnzip.getItems\uff09"), ex);
        }
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setZipFile(String _zipFileName) throws CMyException {
        if (_zipFileName == null || _zipFileName.length() == 0) {
            throw new CMyException(10, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label5", "\u6307\u5b9azip\u6587\u4ef6\u540d\u65e0\u6548\uff08CMyUnzip.setZipFile\uff09"));
        }
        this.zipFileName = _zipFileName;
        if (this.hZipItems != null) {
            this.hZipItems.clear();
            this.hZipItems = null;
        }
    }

    public Enumeration getItems() throws CMyException {
        return this.getMyZipItems().elements();
    }

    public ZipEntry getItem(String _sItemName) throws CMyException {
        if (_sItemName == null) {
            return null;
        }
        Hashtable hMyZipItems = this.getMyZipItems();
        if (hMyZipItems == null) {
            return null;
        }
        return (ZipEntry)hMyZipItems.get(_sItemName.toLowerCase());
    }

    public void unzip(String _sDstPath, boolean _bCreateDstPathIfNotExists) throws CMyException {
        if (this.zipFileName == null) {
            throw new CMyException(10, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label6", "zip\u6587\u4ef6\u5c1a\u672a\u8bbe\u7f6e\uff08CMyUnzip.unzip\uff09"));
        }
        if (!CMyFile.fileExists(_sDstPath)) {
            if (!_bCreateDstPathIfNotExists) {
                throw new CMyException(55, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label7", "\u76ee\u6807\u76ee\u5f55") + _sDstPath + I18NMessage.get(CMyUnzip.class, "CMyUnzip.label8", "\u4e0d\u5b58\u5728\uff08CMyUnzip.unzip\uff09"));
            }
            CMyFile.makeDir(_sDstPath, true);
        }
        InputStream fis = null;
        BufferedInputStream bis = null;
        ZipInputStream zis = null;
        try {
            fis = new FileService(this.zipFileName).getInputStream();
            bis = new BufferedInputStream(fis);
            zis = new ZipInputStream(bis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry(this.encoding)) != null) {
                String sPath;
                if (IS_DEBUG) {
                    System.out.println("[unzip] name=" + ze.getName() + ", size=" + ze.getSize());
                }
                if (ze.isDirectory()) continue;
                String sDstFile = ze.getName();
                if (!this.isStrictFile(sDstFile = sDstFile.replaceAll("\\.\\.|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_"))) continue;
                if (File.separatorChar != '/') {
                    sDstFile = CMyString.replaceStr(sDstFile, "/", File.separator);
                }
                sDstFile = _sDstPath + sDstFile;
                if (IS_DEBUG) {
                    System.out.println("==>Dest=" + sDstFile);
                }
                if (!CMyFile.pathExists(sPath = CMyFile.extractFilePath(sDstFile))) {
                    CMyFile.makeDir(sPath, true);
                }
                OutputStream fos = null;
                try {
                    byte[] buff = new byte[1024];
                    int chunk = 0;
                    fos = new FileService(sDstFile).getOutputStream();
                    while ((chunk = zis.read(buff, 0, buff.length)) != -1) {
                        fos.write(buff, 0, chunk);
                    }
                }
                catch (Exception ex) {
                    throw new CMyException(50, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label9", "\u8bfb\u53d6\u6587\u4ef6\u6570\u636e\u6d41\u5931\u8d25\uff08CMyUnzip.unzip\uff09"), ex);
                }
                finally {
                    if (fos == null) continue;
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (FileNotFoundException ex) {
            throw new CMyException(55, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label10", "\u538b\u7f29\u6587\u4ef6") + this.zipFileName + I18NMessage.get(CMyUnzip.class, "CMyUnzip.label11", "\u6ca1\u6709\u627e\u5230\uff08CMyUnzip.unzip\uff09"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(1, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label12", "\u6587\u4ef6\u89e3\u538b\u7f29\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u5b57\u7b26\u7f16\u7801\u96c6\u4e0d\u5339\u914d\uff08CMyUnzip.unzip\uff09"), ex);
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Exception exception) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void unzip(String _zipFileName, String _dstPath, boolean _bCreateDstPathIfNotExists) throws CMyException {
        CMyUnzip myUnzip = new CMyUnzip();
        myUnzip.setZipFile(_zipFileName);
        myUnzip.unzip(_dstPath, _bCreateDstPathIfNotExists);
    }

    public void addStrictFile(String strict) {
        if (CMyString.isEmpty(strict)) {
            return;
        }
        strict = strict.toLowerCase();
        this.m_hStrictFileSet.addAll(Arrays.asList(CMyString.split(strict, ",")));
    }

    public void setStrictFile(String strict) {
        this.m_hStrictFileSet.clear();
        strict = strict.toLowerCase();
        this.m_hStrictFileSet.addAll(Arrays.asList(CMyString.split(strict, ",")));
    }

    private boolean isStrictFile(String filename) {
        if (this.m_hStrictFileSet.isEmpty()) {
            return true;
        }
        String fileext = CMyFile.extractFileExt(filename);
        return this.m_hStrictFileSet.contains(fileext.toLowerCase());
    }

    public static void main(String[] args) {
        CMyUnzip myUnzip = new CMyUnzip();
        try {
            myUnzip.setZipFile(I18NMessage.get(CMyUnzip.class, "CMyUnzip.label13", "d:\\test\\zip\\\u6d4b\u8bd5.zip"));
            myUnzip.setEncoding("UTF8");
            Enumeration eItems = myUnzip.getItems();
            int nCount = 0;
            while (eItems.hasMoreElements()) {
                ZipEntry ze = (ZipEntry)eItems.nextElement();
                if (ze == null) continue;
                System.out.println("[Item " + ++nCount + "] name=" + ze.getName() + " size=" + ze.getSize() + " compressed size=" + ze.getCompressedSize());
            }
            myUnzip.unzip("d:\\test\\zip\\test\\", true);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }
}

