/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.BASE64EncoderStream;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.HttpClientBuddy;
import com.trs.infra.util.ResponseBuddy;
import com.trs.infra.util.store.FileService;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class CMy3WLib {
    private static Logger logger = Logger.getLogger(CMy3WLib.class);
    protected static int TIME_OUT = 16000;
    public static int MAX_TIME = 2000;
    private static Map s_hmProxyInfo = new HashMap(4);

    public static void setProxyInfo(String _sKey, String _sValue) {
        s_hmProxyInfo.put(_sKey.toUpperCase(), _sValue);
    }

    public static boolean getFile(URL p_urlSrcFile) throws CMyException {
        return CMy3WLib.getFile(p_urlSrcFile, null);
    }

    public static boolean getFile(URL p_urlSrcFile, String p_sDstPathFileName) throws CMyException {
        InputStream isSrcFile = null;
        logger.debug((Object)("[\u5904\u7406\u6587\u4ef6..]" + p_urlSrcFile.toString()));
        try {
            DebugTimer timer = new DebugTimer();
            timer.start();
            if (p_urlSrcFile.getProtocol().equalsIgnoreCase("HTTPS")) {
                isSrcFile = CMy3WLib.openSSLURL(p_urlSrcFile);
            } else {
                URLConnection con = p_urlSrcFile.openConnection();
                System.setProperty("sun.net.client.defaultConnectTimeout", String.valueOf(TIME_OUT));
                System.setProperty("sun.net.client.defaultReadTimeout", String.valueOf(TIME_OUT));
                con.setConnectTimeout(TIME_OUT);
                con.setReadTimeout(TIME_OUT);
                isSrcFile = con.getInputStream();
            }
            timer.stop();
            if (timer.getTime() >= (long)MAX_TIME) {
                logger.warn((Object)("Download the file use[" + timer.getTime() + "]ms! [from=" + p_urlSrcFile.toString() + "]  [to=" + p_sDstPathFileName + "]"));
            }
        }
        catch (Exception ex) {
            if (isSrcFile != null) {
                try {
                    isSrcFile.close();
                }
                catch (Exception con) {
                    // empty catch block
                }
            }
            throw new CMyException(111, I18NMessage.get(CMy3WLib.class, "CMy3WLib.label1", "\u83b7\u53d6\u6e90\u6587\u4ef6\u5931\u8d25(CMy3WLib.getFile)"), ex);
        }
        DataInputStream isFileData = null;
        OutputStream osFileDst = null;
        byte[] buff = null;
        try {
            int nLen;
            isFileData = new DataInputStream(isSrcFile);
            if (p_sDstPathFileName != null) {
                osFileDst = new FileService(p_sDstPathFileName).getOutputStream();
            }
            buff = new byte[2048];
            while ((nLen = isFileData.read(buff, 0, buff.length)) != -1) {
                if (osFileDst == null) continue;
                osFileDst.write(buff, 0, nLen);
            }
        }
        catch (Exception ex) {
            throw new CMyException(50, I18NMessage.get(CMy3WLib.class, "CMy3WLib.label2", "\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25(CMy3WLib.getFile)"), ex);
        }
        finally {
            if (isSrcFile != null) {
                try {
                    isSrcFile.close();
                }
                catch (Exception exception) {}
            }
            if (isFileData != null) {
                try {
                    isFileData.close();
                }
                catch (Exception exception) {}
            }
            if (osFileDst != null) {
                try {
                    osFileDst.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    private static InputStream openSSLURL(URL p_urlSrcFile) {
        try {
            URLConnection urlConnection = p_urlSrcFile.openConnection();
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            HttpsURLConnection sslConnection = (HttpsURLConnection)urlConnection;
            sslConnection.setSSLSocketFactory(ssf);
            return urlConnection.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getURLContent(String p_sSrcFileUrl) throws Exception {
        URL p_urlSrcFile = CMy3WLib.getURL(p_sSrcFileUrl);
        InputStream isSrcFile = null;
        DataInputStream isFileData = null;
        FileOutputStream osFileDst = null;
        byte[] buff = null;
        StringBuffer strHTML = new StringBuffer();
        try {
            isSrcFile = p_urlSrcFile.openStream();
        }
        catch (Exception ex) {
            if (isSrcFile != null) {
                try {
                    isSrcFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new CMyException(111, I18NMessage.get(CMy3WLib.class, "CMy3WLib.label1", "\u83b7\u53d6\u6e90\u6587\u4ef6\u5931\u8d25(CMy3WLib.getFile)"), ex);
        }
        try {
            int nLen;
            isFileData = new DataInputStream(isSrcFile);
            buff = new byte[2048];
            while ((nLen = isFileData.read(buff, 0, buff.length)) != -1) {
                strHTML.append(new String(buff, 0, nLen));
            }
        }
        catch (Exception ex) {
            throw new CMyException(50, I18NMessage.get(CMy3WLib.class, "CMy3WLib.label2", "\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25(CMy3WLib.getFile)"), ex);
        }
        finally {
            if (isSrcFile != null) {
                try {
                    isSrcFile.close();
                }
                catch (Exception exception) {}
            }
            if (isFileData != null) {
                try {
                    isFileData.close();
                }
                catch (Exception exception) {}
            }
            if (osFileDst != null) {
                try {
                    osFileDst.close();
                }
                catch (Exception exception) {}
            }
        }
        return strHTML.toString();
    }

    public static boolean getFile(String p_sSrcFileUrl) throws CMyException {
        return CMy3WLib.getFile(p_sSrcFileUrl, null);
    }

    public static URL getURL(String p_sSrcFileUrl) throws Exception {
        String sProxyHost = (String)s_hmProxyInfo.get("PROXY_HOST");
        if (sProxyHost == null || sProxyHost.length() <= 0) {
            return new URL(p_sSrcFileUrl);
        }
        System.getProperties().put("proxySet", "true");
        System.getProperties().put("proxyHost", sProxyHost);
        System.getProperties().put("proxyPort", s_hmProxyInfo.get("PROXY_PORT"));
        URL newURL = new URL(p_sSrcFileUrl);
        String sProxyUser = (String)s_hmProxyInfo.get("PROXY_USER");
        if (sProxyUser == null || sProxyUser.length() <= 0) {
            return newURL;
        }
        String authString = sProxyUser + ":" + s_hmProxyInfo.get("PROXY_PASSWORD");
        String auth = "Basic " + new String(BASE64EncoderStream.encode(authString.getBytes()));
        URLConnection conn = newURL.openConnection();
        conn.setRequestProperty("Proxy-Authorization", auth);
        return newURL;
    }

    public static boolean getFile(String p_sSrcFileUrl, String p_sDstPathFileName) throws CMyException {
        URL urlSrcFile = null;
        String sTempFileName = CMyFile.extractFileName(p_sSrcFileUrl, "/");
        String sTempFilePath = CMyFile.extractFilePath(p_sSrcFileUrl);
        String sOrigFileName = sTempFileName;
        if (sTempFileName.indexOf("%20") > 0) {
            sTempFileName = sTempFileName.replaceAll("%20", " ");
        }
        if (sTempFileName.indexOf("%") > 0) {
            sTempFileName = sOrigFileName;
        } else {
            try {
                sTempFileName = URLEncoder.encode(sTempFileName, "utf-8").replaceAll("\\+", "%20");
            }
            catch (UnsupportedEncodingException ex) {
                logger.error((Object)ex);
            }
        }
        p_sSrcFileUrl = sTempFilePath + sTempFileName;
        logger.debug((Object)("[\u9700\u8981\u4e0b\u8f7d\u7684\u56fe\u7247\u5730\u5740\uff1a ]" + p_sSrcFileUrl));
        try {
            urlSrcFile = CMy3WLib.getURL(p_sSrcFileUrl);
        }
        catch (Exception ex) {
            throw new CMyException(110, I18NMessage.get(CMy3WLib.class, "CMy3WLib.label3", "\u65e0\u6548\u7684\u6e90\u6587\u4ef6\u5730\u5740(CMy3WLib.getFile)"), ex);
        }
        return CMy3WLib.getFile(urlSrcFile, p_sDstPathFileName);
    }

    public static boolean getFile(String p_sProtocol, String p_sHost, String p_sFile, String p_sDstPathFileName) throws CMyException {
        return CMy3WLib.getFile(p_sProtocol, p_sHost, -1, p_sFile, p_sDstPathFileName);
    }

    public static boolean getFile(String p_sProtocol, String p_sHost, int p_nPort, String p_sFile, String p_sDstPathFileName) throws CMyException {
        URL urlSrcFile = null;
        try {
            urlSrcFile = new URL(p_sProtocol, p_sHost, p_nPort, p_sFile);
        }
        catch (MalformedURLException ex) {
            throw new CMyException(110, I18NMessage.get(CMy3WLib.class, "CMy3WLib.label3", "\u65e0\u6548\u7684\u6e90\u6587\u4ef6\u5730\u5740(CMy3WLib.getFile)"), ex);
        }
        return CMy3WLib.getFile(urlSrcFile, p_sDstPathFileName);
    }

    public static ResponseBuddy doGet(String sURL, Map mContent) throws CMyException {
        HttpClientBuddy hcb = new HttpClientBuddy();
        return hcb.doGet(sURL, mContent);
    }

    public static ResponseBuddy doGet(String sURL, String sContent) throws CMyException {
        HttpClientBuddy hcb = new HttpClientBuddy();
        return hcb.doGet(sURL, sContent);
    }

    public static ResponseBuddy doPost(String sURL, Map mContent) throws CMyException {
        return CMy3WLib.doPost(sURL, mContent, "utf-8");
    }

    public static ResponseBuddy doPost(String sURL, String sContent) throws CMyException {
        return CMy3WLib.doPost(sURL, sContent, "utf-8");
    }

    public static ResponseBuddy doPost(String sURL, Map mContent, String sEncoding) throws CMyException {
        HttpClientBuddy hcb = new HttpClientBuddy(sEncoding);
        return hcb.doPost(sURL, mContent, false);
    }

    public static ResponseBuddy doPost(String sURL, String sContent, String sEncoding) throws CMyException {
        HttpClientBuddy hcb = new HttpClientBuddy(sEncoding);
        return hcb.doPost(sURL, sContent.toString(), false);
    }

    public static void setTimeout(int timeout) {
        TIME_OUT = timeout * 1000;
    }

    public static void main(String[] args) {
        try {
            String sUrl = "http://127.0.0.1:9999/wcm/test.jsp";
            URL url = new URL(sUrl);
            System.out.println(url.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private static class MyX509TrustManager
    implements X509TrustManager {
        private MyX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

