/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.util.BASE64DecoderStream;
import com.trs.infra.util.BASE64EncoderStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;

public class Base64Util {
    private static final String CHARSET = "utf-8";
    private static final int LINELEN = 512;
    private static final String HEAD_FLAG = "__encoded__";
    private static final int HEAD_LEN = "__encoded__".length();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encode(String string) {
        if (string == null || string.trim().length() == 0 || string.startsWith(HEAD_FLAG)) {
            return string;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BASE64EncoderStream encoder = new BASE64EncoderStream(baos, 512);
        try {
            encoder.write(string.getBytes(CHARSET));
            encoder.flush();
            String string2 = HEAD_FLAG + baos.toString();
            return string2;
        }
        catch (Exception e) {
            String string3 = string;
            return string3;
        }
        finally {
            try {
                baos.close();
            }
            catch (Exception exception) {}
            try {
                encoder.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decode(String string) {
        if (string == null || string.trim().length() == 0 || !string.startsWith(HEAD_FLAG)) {
            return string;
        }
        ByteArrayOutputStream bos = null;
        ByteArrayInputStream bains = null;
        FilterInputStream decodeStream = null;
        try {
            byte[] buffer = new byte[1024];
            bos = new ByteArrayOutputStream(1024);
            bains = new ByteArrayInputStream(string.substring(HEAD_LEN).getBytes());
            decodeStream = new BASE64DecoderStream(bains);
            int nLen = 0;
            while ((nLen = decodeStream.read(buffer)) > 0) {
                bos.write(buffer, 0, nLen);
            }
            bos.flush();
            String string2 = bos.toString(CHARSET);
            return string2;
        }
        catch (Exception e) {
            String string3 = string;
            return string3;
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception exception) {}
            }
            if (bains != null) {
                try {
                    bains.close();
                }
                catch (Exception exception) {}
            }
            if (decodeStream != null) {
                try {
                    decodeStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

