/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.util.CMyDOM4jHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.dom4j.Node;

public abstract class AbstractXmlToObjConverter {
    private Map m_mTagClassMap = null;
    private static final String PROPERTIES_ELEMENT = "PROPERTIES";
    private int m_nImportType = 1;
    private String m_sXmlEncoding = "utf-8";
    private Map m_mObjIdMapping = new HashMap();

    public AbstractXmlToObjConverter(int _nImportType) {
        this.m_nImportType = _nImportType;
    }

    public void registPersistentObj(String _sTagName, Class _releatClazz) {
        if (this.m_mTagClassMap == null) {
            this.m_mTagClassMap = new HashMap();
        }
        this.m_mTagClassMap.put(_sTagName, _releatClazz);
    }

    public XmlObject[] convertXml(String _sXmlFile, String _sXslFile, String _sFieldsList) throws WCMException {
        Element rootElement = CMyDOM4jHelper.buildXmlFile(_sXmlFile, _sXslFile);
        if (rootElement.element(PROPERTIES_ELEMENT) == null) {
            return this.convertToObjs(rootElement, _sFieldsList);
        }
        return new XmlObject[]{this.convertToObj(rootElement, _sFieldsList)};
    }

    private XmlObject[] convertToObjs(Element _rootElement, String _sFieldsList) throws WCMException {
        int nSize = _rootElement.nodeCount();
        XmlObject[] pXMLObjects = new XmlObject[]{};
        Element eleChild = null;
        for (int i = 0; i < nSize; ++i) {
            eleChild = this.findChildElement(_rootElement, i);
            if (eleChild == null) continue;
            pXMLObjects = this.addNewXMLObject(pXMLObjects, this.fromXmlElement(eleChild, _sFieldsList));
        }
        return pXMLObjects;
    }

    private XmlObject[] addNewXMLObject(XmlObject[] _pXMLObjects, XmlObject xmlObject) {
        int nOldLength = _pXMLObjects.length;
        XmlObject[] pTemp = new XmlObject[nOldLength + 1];
        if (nOldLength > 0) {
            System.arraycopy(_pXMLObjects, 0, pTemp, 0, nOldLength);
        }
        pTemp[nOldLength] = xmlObject;
        return pTemp;
    }

    private XmlObject convertToObj(Element _rootElement, String _sFieldsList) throws WCMException {
        return this.fromXmlElement(_rootElement, _sFieldsList);
    }

    private XmlObject fromXmlElement(Element _element, String _sFieldsList) throws WCMException {
        String sTagName = _element.getName();
        Element eleProperties = _element.element(PROPERTIES_ELEMENT);
        if (eleProperties == null) {
            throw new WCMException(150, I18NMessage.get(AbstractXmlToObjConverter.class, "AbstractXmlToObjConverter.label5", "\u65e0\u6548\u7684XML\u6587\u4ef6\u683c\u5f0f,\u6216\u8be5XML\u6587\u4ef6\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u63cf\u8ff0WCM\u5bf9\u8c61\u7684\u6587\u4ef6!"));
        }
        XmlObject currXmlObj = new XmlObject();
        Class clazz = this.getBaseObjClass(sTagName);
        if (clazz != null) {
            currXmlObj.setCurrentObj(this.convert(_element.element(PROPERTIES_ELEMENT), _sFieldsList, clazz));
        }
        Element eleChild = null;
        int nSize = _element.nodeCount();
        for (int i = 1; i < nSize; ++i) {
            eleChild = this.findChildElement(_element, i);
            if (eleChild == null) continue;
            currXmlObj.addChild(eleChild.getName(), this.fromChildren(eleChild));
        }
        return currXmlObj;
    }

    private XmlObject[] fromChildren(Element _eleChild) throws WCMException {
        XmlObject[] arXmlObjs = new XmlObject[]{};
        Element eleChild = null;
        int nSize = _eleChild.nodeCount();
        for (int i = 0; i < nSize; ++i) {
            eleChild = this.findChildElement(_eleChild, i);
            if (eleChild == null) continue;
            arXmlObjs = this.addNewXMLObject(arXmlObjs, this.fromXmlElement(eleChild, null));
        }
        return arXmlObjs;
    }

    private Class getBaseObjClass(String _sTagName) throws WCMException {
        if (this.m_mTagClassMap == null) {
            throw new WCMException(150, "finish register first!");
        }
        return (Class)this.m_mTagClassMap.get(_sTagName);
    }

    private BaseObj convert(Element _eleProperties, String _sFieldsList, Class _clazz) throws WCMException {
        boolean zNoSpecial;
        BaseObj currObj = BaseObj.createNewInstance(_clazz);
        String sValue = null;
        int nId = 0;
        Element eleChild = _eleProperties.element(currObj.getIdFieldName());
        if (eleChild != null && (sValue = eleChild.getText()) != null) {
            nId = Integer.parseInt(sValue);
        }
        if (nId > 0) {
            switch (this.m_nImportType) {
                case 2: 
                case 3: {
                    currObj = BaseObj.findById(_clazz, nId);
                    if (currObj != null) break;
                    throw new WCMException(I18NMessage.get(AbstractXmlToObjConverter.class, "AbstractXmlToObjConverter.label6", "\u6307\u5b9a\u7684\u5bf9\u8c61[") + nId + I18NMessage.get(AbstractXmlToObjConverter.class, "AbstractXmlToObjConverter.label7", "]\u6ca1\u6709\u627e\u5230\uff01"));
                }
            }
            this.m_mObjIdMapping.put(currObj, new Integer(nId));
        }
        String sName = null;
        Map specialProperty = this.processSpecialProperties((Element)_eleProperties.clone());
        boolean bl = zNoSpecial = specialProperty.size() <= 0;
        if (_sFieldsList != null && _sFieldsList.length() > 0) {
            StringTokenizer enumKeys = new StringTokenizer(_sFieldsList, ",");
            while (enumKeys.hasMoreElements()) {
                sName = (String)enumKeys.nextElement();
                eleChild = _eleProperties.element(sName);
                if (eleChild == null || eleChild.nodeCount() < 1 || !zNoSpecial && specialProperty.containsKey(sName.toUpperCase())) continue;
                sValue = eleChild.getText();
                this.setProperty(currObj, sName, sValue);
            }
        } else {
            int nNodeCount = _eleProperties.nodeCount();
            for (int i = 0; i < nNodeCount; ++i) {
                eleChild = this.findChildElement(_eleProperties, i, false);
                if (eleChild == null) continue;
                sName = eleChild.getName();
                if (!zNoSpecial && specialProperty.containsKey(sName.toUpperCase())) continue;
                sValue = eleChild.getText();
                this.setProperty(currObj, sName, sValue);
            }
        }
        if (!zNoSpecial) {
            Iterator itrKeys = specialProperty.keySet().iterator();
            String itrKey = null;
            Object itrValue = null;
            while (itrKeys.hasNext()) {
                itrKey = (String)itrKeys.next();
                itrValue = specialProperty.get(itrKey);
                if (itrValue == null) continue;
                this.setProperty(currObj, itrKey, itrValue.toString());
            }
        }
        return currObj;
    }

    protected void setProperty(BaseObj _currObj, String _sName, String _sValue) throws WCMException {
        block2: {
            try {
                _currObj.setPropertyWithString(_sName, _sValue);
            }
            catch (WCMException e) {
                if (e.getErrNo() == 1101) break block2;
                throw e;
            }
        }
    }

    public String getXmlEncoding() {
        return this.m_sXmlEncoding;
    }

    public void setXmlEncoding(String _sXmlEncoding) {
        this.m_sXmlEncoding = _sXmlEncoding;
    }

    public Map getObjIdMapping() {
        return this.m_mObjIdMapping;
    }

    protected abstract Map processSpecialProperties(Element var1) throws WCMException;

    private Element findChildElement(Element _parentElement, int _nChildIndex) {
        return this.findChildElement(_parentElement, _nChildIndex, true);
    }

    private Element findChildElement(Element _parentElement, int _nChildIndex, boolean _bExcludePropertiesNode) {
        Node node = _parentElement.node(_nChildIndex);
        if (!(node instanceof Element)) {
            return null;
        }
        if (_bExcludePropertiesNode && node.getName().toUpperCase().equals(PROPERTIES_ELEMENT)) {
            return null;
        }
        return (Element)node;
    }
}

