/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.db;

import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class QueryFilter
implements Cloneable {
    protected String from = "";
    protected String where = "";
    protected String order = "";
    protected String select = "";
    protected String orderSelect = "";
    protected int maxRowNumber = NOTLIMITED_OPEN_OPEN_RECORD_COUNT;
    protected int m_nPageSize = 20;
    protected String m_SQL = null;
    public static int DEFAULT_OPEN_RECORD_COUNT = 1000;
    public static int NOTLIMITED_OPEN_OPEN_RECORD_COUNT = 0;
    private List m_listSearchValues = null;
    private boolean m_bForceFirstLoadIds = false;

    public QueryFilter() {
    }

    public QueryFilter(QueryFilter _filter) {
        this.copy(_filter);
    }

    public QueryFilter(String _from, String _where, String _order) {
        this(_from, _where, _order, "");
    }

    public QueryFilter(String _from, String _where, String _order, String _select) {
        this.from = _from;
        this.where = _where;
        this.order = _order;
        this.select = _select;
    }

    public QueryFilter(String _from, String _where, String _order, String _select, String _orderSelect) {
        this.from = _from;
        this.where = _where;
        this.order = _order;
        this.select = _select;
        this.orderSelect = _orderSelect;
    }

    public QueryFilter(String _from, String _where, String _order, String _select, int _nMaxSize) {
        this.from = _from;
        this.where = _where;
        this.order = _order;
        this.select = _select;
        this.maxRowNumber = _nMaxSize;
    }

    public void clear() {
        this.from = "";
        this.where = "";
        this.order = "";
        this.select = "";
        this.maxRowNumber = 0;
        this.m_SQL = null;
        if (this.m_listSearchValues != null) {
            this.m_listSearchValues.clear();
            this.m_listSearchValues = null;
        }
    }

    public void copy(QueryFilter _filterSrc) {
        if (_filterSrc == null) {
            this.clear();
        } else {
            this.from = _filterSrc.getFrom();
            this.where = _filterSrc.getWhere();
            this.order = _filterSrc.getOrder();
            this.select = _filterSrc.getSelect();
            this.orderSelect = _filterSrc.getOderSelect();
            this.maxRowNumber = _filterSrc.getMaxRowNumber();
            this.m_listSearchValues = _filterSrc.m_listSearchValues;
            this.m_bForceFirstLoadIds = _filterSrc.m_bForceFirstLoadIds;
            this.m_nPageSize = _filterSrc.m_nPageSize;
            this.m_SQL = null;
        }
    }

    public Object clone() {
        return new QueryFilter(this);
    }

    public String getFrom() {
        return this.from == null ? "" : this.from;
    }

    public void setFrom(String _from) {
        this.from = _from;
        this.m_SQL = null;
    }

    public String getWhere() {
        return this.where == null ? "" : this.where;
    }

    public void setWhere(String _where) {
        this.where = _where;
        this.m_SQL = null;
    }

    public String getOrder() {
        return this.order == null ? "" : this.order;
    }

    public void setOrder(String _order) {
        this.order = _order;
        this.m_SQL = null;
    }

    public String getSelect() {
        return this.select == null ? "" : this.select;
    }

    public void setSelect(String _select) {
        this.select = _select;
        this.m_SQL = null;
    }

    public String getOderSelect() {
        return this.orderSelect == null ? "" : this.orderSelect;
    }

    public void setOrderSelect(String _orderSelect) {
        this.orderSelect = _orderSelect;
    }

    public int getMaxRowNumber() {
        return this.maxRowNumber;
    }

    public void setMaxRowNumber(int _maxRowNumber) {
        this.maxRowNumber = _maxRowNumber;
    }

    public QueryFilter mergeWith(QueryFilter _filter) {
        StringTokenizer stFrom = null;
        String sTableName = "";
        if (_filter == null) {
            return this;
        }
        String sFilterCon = _filter.getSelect();
        if (sFilterCon.length() > 0) {
            this.select = this.select == null || this.select.length() == 0 ? sFilterCon : sFilterCon + "," + this.select;
        }
        if ((sFilterCon = _filter.getFrom()).length() > 0) {
            stFrom = new StringTokenizer(sFilterCon.toUpperCase(), ",");
            while (stFrom.hasMoreElements()) {
                sTableName = (String)stFrom.nextElement();
                if (this.from.indexOf(sTableName.trim()) >= 0) continue;
                if (this.from.length() > 0) {
                    this.from = this.from + ",";
                }
                this.from = this.from + sTableName;
            }
        }
        if ((sFilterCon = _filter.getWhere()).length() > 0) {
            this.where = this.where != null && this.where.length() > 0 ? "(" + this.where + ") and (" + sFilterCon + ")" : sFilterCon;
        }
        if ((sFilterCon = _filter.getOrder()).length() > 0) {
            this.order = sFilterCon;
        }
        if (_filter.getMaxRowNumber() > 0) {
            this.maxRowNumber = _filter.getMaxRowNumber();
        }
        this.m_nPageSize = _filter.m_nPageSize;
        if (_filter.getSearchValues() != null) {
            if (this.m_listSearchValues != null) {
                this.m_listSearchValues.addAll(_filter.getSearchValues());
            } else {
                this.m_listSearchValues = _filter.getSearchValues();
            }
        }
        this.m_SQL = null;
        return this;
    }

    public String toSQL() {
        if (this.m_SQL != null) {
            return this.m_SQL;
        }
        this.m_SQL = "select " + CMyString.showNull(this.select, "*") + " from " + this.from;
        if (this.where != null && this.where.length() > 0) {
            this.m_SQL = this.m_SQL + " where " + this.where;
        }
        if (this.order != null && this.order.length() > 0) {
            this.m_SQL = this.m_SQL + " order by " + this.order;
        }
        return this.m_SQL;
    }

    public String toString() {
        String sSQL = this.toSQL();
        if (this.m_listSearchValues == null) {
            return sSQL;
        }
        StringBuffer sbParamerts = new StringBuffer(sSQL.length() + 5 + this.m_listSearchValues.size() * 12);
        sbParamerts.append(sSQL);
        int nSize = this.m_listSearchValues.size();
        for (int i = 0; i < nSize; ++i) {
            sbParamerts.append('\n');
            sbParamerts.append("Param#");
            sbParamerts.append(i + 1);
            sbParamerts.append(":");
            sbParamerts.append(this.m_listSearchValues.get(i));
        }
        return sbParamerts.toString();
    }

    public boolean isToGetAll() {
        return this.where == null || this.where.trim().length() == 0;
    }

    public String findSelectField(String _fieldName) {
        int index;
        if (this.select == null || this.select.length() == 0) {
            return null;
        }
        String sToLook = this.select.toUpperCase();
        char[] buff = sToLook.toCharArray();
        String sField = _fieldName.toUpperCase();
        int nFieldLen = _fieldName.length();
        boolean bFound = false;
        int nPos = 0;
        do {
            if ((nPos = sToLook.indexOf(sField, nPos)) < 0) {
                return null;
            }
            if (nPos > 0 && buff[nPos - 1] != ' ' && buff[nPos - 1] != ',' && buff[nPos - 1] != '.') {
                nPos += nFieldLen;
                continue;
            }
            index = nPos + nFieldLen;
            if (index < buff.length) {
                if (buff[index] != ' ' && buff[index] != ',') {
                    nPos = index + 1;
                    continue;
                }
                while (++index < buff.length && buff[index] == ' ') {
                }
                if (buff[index] == 'A') {
                    nPos = index + 2;
                    continue;
                }
            }
            bFound = true;
            break;
        } while (!bFound);
        for (index = nPos - 1; index >= 0; --index) {
            if (buff[index] != ',') continue;
            ++index;
            break;
        }
        if (index < 0) {
            index = 0;
        }
        return this.select.substring(index, nPos + nFieldLen).trim();
    }

    public static void main(String[] args) {
        QueryFilter filter = new QueryFilter("", "", "", "Document.DocId");
        String[] arrSelect = new String[]{"WCMDocument.DocId", "WCMDocument.DocId as DocId2", "WCMDocument.DocId as DocId2, WCMTest.TestId as DocId", "WCMDocument.MyDocId", "distinct WCMDocument.docid,WCMDocument.doctitle,WCMDocument.docstatus,WCMDocument.docchannel,WCMDocument.docauthor,WCMDocument.crtime,WCMDocument.cruser,WCMDocument.RightDefined,WCMDocument.DocType"};
        for (int i = 0; i < arrSelect.length; ++i) {
            filter.setSelect(arrSelect[i]);
            System.out.println("[" + i + "] " + filter.findSelectField("DocId"));
        }
        QueryFilter oldFilter = new QueryFilter("", "", "docid asc", "", 10);
        QueryFilter newFilter = new QueryFilter("", "", "chnlid desc", "*", 20);
        newFilter.mergeWith(oldFilter);
        System.out.println(newFilter.getOrder());
        System.out.println(newFilter.getMaxRowNumber());
        System.out.println(newFilter.getSelect());
    }

    public List getSearchValues() {
        return this.m_listSearchValues;
    }

    public void setSearchValues(List searchValues) {
        this.m_listSearchValues = searchValues;
    }

    public void addSearchValues(int _nIndex, int _nSearchValue) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= _nIndex) {
            this.m_listSearchValues.add(_nIndex, new Integer(_nSearchValue));
        } else {
            this.m_listSearchValues.set(_nIndex, new Integer(_nSearchValue));
        }
    }

    public void addSearchValues(int _nSearchValue) {
        int nIndex = 0;
        if (this.m_listSearchValues != null) {
            nIndex = this.m_listSearchValues.size();
        }
        this.addSearchValues(nIndex, _nSearchValue);
    }

    public void addSearchValues(int _nIndex, float _fSearchValue) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= _nIndex) {
            this.m_listSearchValues.add(_nIndex, new Float(_fSearchValue));
        } else {
            this.m_listSearchValues.set(_nIndex, new Float(_fSearchValue));
        }
    }

    public void addSearchValues(float _value) {
        int nIndex = 0;
        if (this.m_listSearchValues != null) {
            nIndex = this.m_listSearchValues.size();
        }
        this.addSearchValues(nIndex, _value);
    }

    public void addSearchValues(int _nIndex, double _dSearchValue) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= _nIndex) {
            this.m_listSearchValues.add(_nIndex, new Double(_dSearchValue));
        } else {
            this.m_listSearchValues.set(_nIndex, new Double(_dSearchValue));
        }
    }

    public void addSearchValues(double _value) {
        int nIndex = 0;
        if (this.m_listSearchValues != null) {
            nIndex = this.m_listSearchValues.size();
        }
        this.addSearchValues(nIndex, _value);
    }

    public void addSearchValues(int _nIndex, String _sSearchValue) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= _nIndex) {
            this.m_listSearchValues.add(_nIndex, _sSearchValue);
        } else {
            this.m_listSearchValues.set(_nIndex, _sSearchValue);
        }
    }

    public void addSearchValues(String _value) {
        int nIndex = 0;
        if (this.m_listSearchValues != null) {
            nIndex = this.m_listSearchValues.size();
        }
        this.addSearchValues(nIndex, _value);
    }

    public void addSearchValues(int _nIndex, CMyDateTime _dtTime) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= _nIndex) {
            this.m_listSearchValues.add(_nIndex, _dtTime);
        } else {
            this.m_listSearchValues.set(_nIndex, _dtTime);
        }
    }

    public void addSearchValues(CMyDateTime _value) {
        int nIndex = 0;
        if (this.m_listSearchValues != null) {
            nIndex = this.m_listSearchValues.size();
        }
        this.addSearchValues(nIndex, _value);
    }

    public boolean isForceFirstLoadIds() {
        return this.m_bForceFirstLoadIds;
    }

    public void setForceFirstLoadIds(boolean forceFirstLoadIds) {
        this.m_bForceFirstLoadIds = forceFirstLoadIds;
    }

    public int getPageSize() {
        return this.m_nPageSize;
    }

    public void setPageSize(int pageSize) {
        this.m_nPageSize = pageSize;
    }
}

