/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.config;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.BaseConfigServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Loader;
import com.trs.infra.util.WCMDiscoveryFactory;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class TRSConfigServer {
    private static final String SERVER_CLASS_NAME_INI = "server.class.name.ini";
    private static Logger logger = Logger.getLogger(TRSConfigServer.class);
    private static String sPropertiesFilePath = null;
    private static final int STATUS_NOTSTART = 0;
    private static final int STATUS_STARTING = 1;
    private static final int STATUS_STARTED = 2;
    private static final int STATUS_STARTFAIL = 3;
    public static String FILENAME_APP_PROPERTIES = "TRSApp.properties";
    private static String KEY_ROOT_PATH = "config.root.path";
    private static String PATH_CONFIG_ROOT = null;
    private static int STATUS_CURRENT = 0;
    private static Map MAP_CONFIG_SERVER = null;
    private static String s_sAppRootPath = null;

    public static BaseConfigServer findConfigServerById(String _sConfigServerId) {
        if (MAP_CONFIG_SERVER == null) {
            TRSConfigServer.start();
        }
        return (BaseConfigServer)MAP_CONFIG_SERVER.get(_sConfigServerId.toLowerCase());
    }

    public static String getConfigRootPath() {
        if (PATH_CONFIG_ROOT == null) {
            try {
                TRSConfigServer.makeConfigRootPath();
            }
            catch (WCMException e) {
                throw new RuntimeException("Fail to load config root path!", e);
            }
        }
        return PATH_CONFIG_ROOT;
    }

    public static void start() {
        if (MAP_CONFIG_SERVER == null) {
            try {
                TRSConfigServer.init();
            }
            catch (Throwable e) {
                logger.error((Object)I18NMessage.get(TRSConfigServer.class, "TRSConfigServer.label1", "\u542f\u52a8ConfigServer\u5931\u8d25!"), e);
                STATUS_CURRENT = 3;
            }
        }
    }

    private static synchronized void init() throws WCMException {
        if (MAP_CONFIG_SERVER != null || STATUS_CURRENT == 3) {
            return;
        }
        STATUS_CURRENT = 1;
        TRSConfigServer.makeConfigRootPath();
        HashMap<String, BaseConfigServer> mTemp = new HashMap<String, BaseConfigServer>(10);
        Iterator itConvertos = WCMDiscoveryFactory.getDiscovery().getImplementors(BaseConfigServer.class.getName());
        while (itConvertos.hasNext()) {
            String sConfigServerClassName = (String)itConvertos.next();
            BaseConfigServer server = null;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u5f00\u59cb\u52a0\u8f7d\u670d\u52a1\uff1a" + sConfigServerClassName));
                }
                server = (BaseConfigServer)Class.forName(sConfigServerClassName).newInstance();
            }
            catch (Exception e) {
                logger.error((Object)(I18NMessage.get(TRSConfigServer.class, "TRSConfigServer.label2", "\u5b9e\u4f8b\u5316\u914d\u7f6e\u670d\u52a1\u5668\u5b9e\u4f8b\u5931\u8d25\uff01[Class=") + sConfigServerClassName + ", ClassName=" + sConfigServerClassName + "]"), (Throwable)e);
                continue;
            }
            try {
                server.startup();
            }
            catch (Throwable e) {
                logger.error((Object)(I18NMessage.get(TRSConfigServer.class, "TRSConfigServer.label3", "\u542f\u52a8\u914d\u7f6e\u670d\u52a1\u5668\u5b9e\u4f8b\u5931\u8d25\uff01[Class=") + sConfigServerClassName + ", ClassName=" + sConfigServerClassName + "]"), e);
            }
            mTemp.put(server.getServerName().toLowerCase(), server);
        }
        MAP_CONFIG_SERVER = mTemp;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MAP_CONFIG_SERVER\uff1a" + MAP_CONFIG_SERVER));
        }
        STATUS_CURRENT = 2;
    }

    private static synchronized void makeConfigRootPath() throws WCMException {
        FileService rootPath;
        if (PATH_CONFIG_ROOT != null) {
            return;
        }
        String sConfigFilesDir = TRSConfigServer.loadDefaultProperties();
        if (sConfigFilesDir == null) {
            throw new WCMException(I18NMessage.get(TRSConfigServer.class, "TRSConfigServer.label5", "\u8bfb\u53d6\u9ed8\u8ba4\u7684\u914d\u7f6e\u6587\u4ef6\u6839\u76ee\u5f55\u5931\u8d25\uff01"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sConfigFilesDir\uff1a" + sConfigFilesDir));
        }
        if (!(rootPath = new FileService(sConfigFilesDir)).exists() || !rootPath.isDirectory()) {
            sConfigFilesDir = CMyString.setStrEndWith(sConfigFilesDir, '/');
            URL urlServerClassNames = Loader.getResource(FILENAME_APP_PROPERTIES);
            FileService fileServerClasssNames = new FileService(urlServerClassNames.getFile());
            sConfigFilesDir = CMyFile.extractFilePath(fileServerClasssNames.getAbsolutePath()) + sConfigFilesDir;
            rootPath = new FileService(sConfigFilesDir);
        }
        if (!rootPath.exists() || !rootPath.isDirectory()) {
            throw new WCMException(I18NMessage.get(TRSConfigServer.class, "TRSConfigServer.label6", "\u8bbe\u7f6e\u7684\u76ee\u5f55[") + sConfigFilesDir + I18NMessage.get(TRSConfigServer.class, "TRSConfigServer.label4", "]\u4e0d\u6b63\u786e\uff01"));
        }
        if (File.separatorChar == '\\') {
            sConfigFilesDir = sConfigFilesDir.replace('/', File.separatorChar);
        }
        PATH_CONFIG_ROOT = CMyString.setStrEndWith(sConfigFilesDir, File.separatorChar);
    }

    private static String loadDefaultProperties() {
        URL url = Loader.getResource(FILENAME_APP_PROPERTIES);
        if (url == null) {
            throw new RuntimeException("Cannot find file[" + FILENAME_APP_PROPERTIES + "] at the root of application!");
        }
        InputStream is = null;
        try {
            sPropertiesFilePath = url.getFile();
            is = url.openStream();
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot find file[" + FILENAME_APP_PROPERTIES + "] at the root of application!", ex);
        }
        String result = null;
        if (is != null) {
            logger.info((Object)("Load service from properties: " + sPropertiesFilePath + ".."));
            Properties defaultProperties = new Properties();
            try {
                defaultProperties.load(is);
                result = defaultProperties.getProperty(KEY_ROOT_PATH);
            }
            catch (IOException e) {
                logger.info((Object)("Errors occur when reading " + sPropertiesFilePath + ", ommited"));
                e.printStackTrace();
            }
            logger.info((Object)"Finished to load service from properties.");
        }
        FileService file = new FileService(sPropertiesFilePath);
        s_sAppRootPath = file.getAbsolutePath();
        if (File.separatorChar == '\\') {
            s_sAppRootPath = s_sAppRootPath.replace('/', '\\');
        }
        s_sAppRootPath = CMyFile.extractFilePath(s_sAppRootPath);
        return result;
    }

    public static String getAppRootPath() {
        if (s_sAppRootPath != null) {
            return s_sAppRootPath;
        }
        TRSConfigServer.start();
        return s_sAppRootPath;
    }

    public static void main(String[] args) {
        try {
            System.out.println("result:" + TRSConfigServer.getConfigRootPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TRSConfigServer.start();
    }
}

