/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.config;

import com.trs.cluster.FileMsgProcessor;
import com.trs.infra.BaseConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class FileConfig
extends BaseConfig {
    private String sFileName;

    public FileConfig(String _sConfig, String _sValue) {
        String[] info = _sConfig.split(":");
        this.sFileName = info[1];
        this.sKey = info[2];
        this.sValue = _sValue;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws Exception {
        BufferedReader reader = null;
        InputStreamReader insr = null;
        InputStream ins = null;
        StringBuffer buffContent = null;
        OutputStream fos = null;
        Writer outWriter = null;
        String sRootPath = ConfigConstants.getConfigRootPath();
        this.sFileName = (sRootPath = sRootPath + ".." + File.separatorChar + ".." + File.separatorChar).endsWith(File.separator) ? sRootPath : CMyString.setStrEndWith(sRootPath, File.separatorChar) + this.sFileName;
        try {
            ins = new FileService(this.sFileName).getInputStream();
            insr = new InputStreamReader(ins, "GBK");
            reader = new BufferedReader(insr);
            String line = reader.readLine();
            while (line != null) {
                String[] lineInfo = line.split("=");
                if (lineInfo[0].trim().equalsIgnoreCase(this.sKey.trim())) {
                    lineInfo[1] = this.sValue;
                    line = lineInfo[0] + "=" + lineInfo[1];
                }
                if (buffContent == null) {
                    buffContent = new StringBuffer();
                } else {
                    buffContent.append("\n");
                }
                buffContent.append(line);
                line = reader.readLine();
            }
            if (buffContent == null) {
                return;
            }
            String sContent = buffContent.toString();
            fos = new FileService(this.sFileName).getOutputStream();
            outWriter = new OutputStreamWriter(fos, "GBK");
            outWriter.write(sContent);
            outWriter.flush();
        }
        finally {
            if (outWriter != null) {
                try {
                    outWriter.flush();
                    outWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (insr != null) {
                try {
                    insr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        FileMsgProcessor.send(new FileService(this.sFileName).getAbsolutePath());
    }

    public static void main(String[] args) throws WCMException {
        String sConfig = "pro:TRSWCMApp.ini:DOC_HTML_TAG_NAMES";
        String sValue = "zzz";
        try {
            new FileConfig(sConfig, sValue).save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\u7ed3\u679c\u662f.....");
    }
}

