/*
 * Decompiled with CFR 0.152.
 */
package com.trs.exchange.testmove;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.exchange.DataMigrationLogger;
import com.trs.exchange.MyDBManager;
import com.trs.exchange.metadata.MetaDataExchangeImpl;
import com.trs.exchange.metadata.MetaDataServiceHelper;
import com.trs.exchange.metadata.WebSiteConstants;
import com.trs.exchange.testmove.CommonUtil;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class ThreadNews
extends CommonUtil
implements Runnable {
    public List<Map<String, Object>> list;
    public int logCurrent;
    private String sqlClob;
    private String sqlVarchar;
    private String sqlLinks;
    private List<String> xlsName;
    public static int index = 0;

    public ThreadNews(MyDBManager _dbMgr, List<Map<String, Object>> list, int logCurrent, String sqlClob, String sqlVarchar, String sqlLinks, List<String> xlsName, int index, DataMigrationLogger m_oDLogger) {
        this.m_oDBMgr = _dbMgr;
        this.filesMan = FilesMan.getFilesMan();
        this.list = list;
        this.logCurrent = logCurrent;
        this.sqlClob = sqlClob;
        this.sqlVarchar = sqlVarchar;
        this.sqlLinks = sqlLinks;
        this.xlsName = xlsName;
        ThreadNews.index = index;
        try {
            this.m_oDLogger = m_oDLogger;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (true) {
                if (index >= this.list.size()) {
                    System.out.println("\u5b8c\u573a");
                    return;
                }
                Map<String, Object> map = null;
                String crname = null;
                String string = "";
                // MONITORENTER : ""
                map = this.list.get(index);
                System.out.println(index);
                ++index;
                crname = map.get("crUser").toString();
                map.remove("crUser");
                // MONITOREXIT : string
                this.logCurrent = Integer.parseInt(map.get("rowId").toString());
                String key = map.get("NewsId").toString();
                String NsqlClob = this.sqlClob + " where news_id='" + key + "'    and attribute_name in('content','left','right','top','down')";
                String NsqlVarchar = this.sqlVarchar + " where news_id='" + key + "'  and attribute_name in('bak3','bak1','bak2','guide_image','video_or_audio','bak5','sub_title')";
                String NsqlLink = this.sqlLinks + " where news_id='" + key + "'";
                map = this.getClobs(map, NsqlClob, NsqlVarchar, NsqlLink);
                MetaViewData oMetaViewData = MetaDataServiceHelper.makeMetaViewData(0, WebSiteConstants.getWebSiteMetaView());
                MetaDataServiceHelper.setMetaDataProperties(map, oMetaViewData);
                oMetaViewData.setProperty("DocStatus", Integer.parseInt(map.get("DocStatus").toString()));
                MetaDataExchangeImpl impl = new MetaDataExchangeImpl(this.m_oDBMgr);
                impl.dowithHtmlContent(oMetaViewData, "Content");
                impl.dowithHtmlContent(oMetaViewData, "AdditionalTextBottom");
                impl.dowithHtmlContent(oMetaViewData, "AdditionalTextTop");
                impl.dowithHtmlContent(oMetaViewData, "AdditionalTextLeft");
                impl.dowithHtmlContent(oMetaViewData, "AdditionalTextRight");
                if (this.xlsName.contains(crname)) {
                    User user = User.findByName(crname) != null ? User.findByName(crname) : User.findByName("admin");
                    ContextHelper.clear();
                    ContextHelper.initContext(user);
                    oMetaViewData.insert(ContextHelper.getLoginUser());
                } else {
                    ContextHelper.clear();
                    ContextHelper.initContext(User.findByName("admin"));
                    oMetaViewData.insert(ContextHelper.getLoginUser());
                }
                this.m_oDLogger.recordStartNews(Integer.parseInt(map.get("NewsId").toString()), Integer.parseInt(map.get("IsTopic").toString()), map.get("TemplateFile").toString(), crname);
            }
        }
        catch (Exception ex) {
            try {
                this.error("\u5904\u7406" + index + "\u6761\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff01", ex);
                ex.printStackTrace();
                return;
            }
            catch (WCMException e) {
                e.printStackTrace();
            }
            return;
        }
    }

    public Map<String, Object> getClobs(Map<String, Object> map, String sqlClobs, String sqlVarchar, String sqlLinks) throws WCMException {
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        String data = null;
        try {
            oConn = this.m_oDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(sqlClobs);
            result = oPreStmt.executeQuery();
            while (result.next()) {
                String attribute_name = result.getString(1);
                Clob clob = (Clob)result.getObject(2);
                data = this.ClobToString(clob);
                if (attribute_name.equals("content")) {
                    map.put("Content", data);
                    continue;
                }
                if (attribute_name.equals("down")) {
                    map.put("AdditionalTextBottom", data);
                    continue;
                }
                if (attribute_name.equals("top")) {
                    map.put("AdditionalTextTop", data);
                    continue;
                }
                if (attribute_name.equals("left")) {
                    map.put("AdditionalTextLeft", data);
                    continue;
                }
                if (!attribute_name.equals("right")) continue;
                map.put("AdditionalTextRight", data);
            }
            CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
            oConn = this.m_oDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(sqlVarchar);
            result = oPreStmt.executeQuery();
            String outLinePics = "";
            while (result.next()) {
                String attribute_name = result.getString("attribute_name");
                if (attribute_name.equals("bak3") || attribute_name.equals("guide_image") || attribute_name.equals("bak2")) {
                    outLinePics = outLinePics + result.getString("attribute_value") + ",";
                } else if (attribute_name.equals("video_or_audio")) {
                    map.put("AudioVideo", result.getString("attribute_value"));
                } else if (attribute_name.equals("bak1")) {
                    map.put("Author", result.getString("attribute_value"));
                } else if (attribute_name.equals("bak5")) {
                    map.put("MoveTitle", result.getString("attribute_value"));
                } else if (attribute_name.equals("sub_title")) {
                    map.put("HomeTitle", result.getString("attribute_value"));
                }
                if (outLinePics.length() <= 0) continue;
                map.put("OutLinePics", outLinePics);
            }
            CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
            oConn = this.m_oDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(sqlLinks);
            result = oPreStmt.executeQuery();
            if (result.next()) {
                map.put("RelatedNews", result.getString(1));
            }
            CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
        }
        catch (Exception ex) {
            CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
            ex.printStackTrace();
        }
        return map;
    }

    public String ClobToString(Clob clob) throws SQLException, IOException {
        String reString = "";
        Reader is = clob.getCharacterStream();
        BufferedReader br = new BufferedReader(is);
        String s = br.readLine();
        StringBuffer sb = new StringBuffer();
        while (s != null) {
            sb.append(s);
            s = br.readLine();
        }
        reString = sb.toString();
        return reString;
    }
}

