/*
 * Decompiled with CFR 0.152.
 */
package com.trs.exchange.metadata;

import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.components.metadata.definition.MetaView;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.Config;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;

public class ReleaseSourceConstants {
    public static final int USERCONFIG_TYPE = 20;
    public static final String DOC_SHARED_YES = "1";
    public static final String DOCSHARED_NO = "0";
    public static final int RELEASESOURCE_SITE_PARENTID = 0;
    public static final int RELEASESOURCE_SITE_SITETYPE = 4;
    public static final int RELEASESOURCE_DOC_SHARE_TO_GROUP = 0;
    public static final int RELEASESOURCE_PIC_SHARE_TO_GROUP = -1;
    private static int RELEASE_SOURCE_SITE_ID;
    private static int LATEST_RELEASE_SOURCE_COUNT;
    private static int FEATURE_QUERY_TIME_MONTH;
    private static int RELEASE_SOURCE_VIEW_ID;
    private static int RELEASE_SOURCE_IMGCENTER_ID;
    private static int RELEASE_SHAREDRECORD;
    public static int ROOT_VIRTUALGROUP_ID;

    public static void setReleaseSourceSiteId(int _nSiteId) throws WCMException {
        ReleaseSourceConstants.updateConfigValue("RELEASESOURCE_SITE_ID", Integer.toString(_nSiteId));
    }

    public static int getReleaseSourceSiteId() throws WCMException {
        RELEASE_SOURCE_SITE_ID = Integer.parseInt(ConfigServer.getServer().getSysConfigValue("RELEASESOURCE_SITE_ID", DOCSHARED_NO));
        return RELEASE_SOURCE_SITE_ID;
    }

    public static int getReleaseSourceViewId() throws WCMException {
        RELEASE_SOURCE_VIEW_ID = Integer.parseInt(ConfigServer.getServer().getSysConfigValue("RELEASESOURCE_VIEW_ID", DOCSHARED_NO));
        return RELEASE_SOURCE_VIEW_ID;
    }

    public static void setReleaseSourceViewId(int _nReleaseSourceViewId) throws WCMException {
        ConfigServer.getServer().updateConfigValue("RELEASESOURCE_VIEW_ID", Integer.toString(_nReleaseSourceViewId));
    }

    public static int getLatestReleaseSourceCount() throws WCMException {
        LATEST_RELEASE_SOURCE_COUNT = Integer.parseInt(ConfigServer.getServer().getSysConfigValue("LATEST_RELEASE_SOURCE_COUNT", "10"));
        return LATEST_RELEASE_SOURCE_COUNT;
    }

    public static int getFeatureQueryTimeMonth() throws WCMException {
        FEATURE_QUERY_TIME_MONTH = Integer.parseInt(ConfigServer.getServer().getSysConfigValue("FEATURE_QUERY_TIME_MONTH", "2"));
        return FEATURE_QUERY_TIME_MONTH;
    }

    public static void updateConfigValue(String _sConfigName, String _sValue) throws WCMException {
        if (_sConfigName == null || _sConfigName.length() == 0 || _sValue == null) {
            return;
        }
        Config currConfig = ConfigServer.getServer().getSysConfig(_sConfigName);
        if (currConfig == null || _sValue.equals(currConfig.getValue())) {
            currConfig = Config.createNewInstance();
            currConfig.setConfigKey(_sConfigName);
            currConfig.setType(20);
        }
        currConfig.setValue(_sValue);
        currConfig.save();
    }

    public static int getImgCenterReleaseId() throws WCMException {
        RELEASE_SOURCE_IMGCENTER_ID = Integer.parseInt(ConfigServer.getServer().getSysConfigValue("RELEASE_SOURCE_IMGCENTER_ID", DOCSHARED_NO));
        return RELEASE_SOURCE_IMGCENTER_ID;
    }

    public static Group getImgCenterGroup() throws WCMException {
        Group oImgCenterGroup = Group.findById(ReleaseSourceConstants.getImgCenterReleaseId());
        if (oImgCenterGroup == null) {
            throw new WCMException("\u56fe\u7247\u4e2d\u5fc3\u5bf9\u5e94\u7684\u9876\u7ea7\u7ec4\u7ec7\u6ca1\u6709\u5728\u7cfb\u7edf\u4e2d\u521d\u59cb\u5316\uff01");
        }
        return oImgCenterGroup;
    }

    public static MetaView getReleaseSourceView() throws WCMException {
        MetaView oReleaseSourceView = MetaView.findById(ReleaseSourceConstants.getReleaseSourceViewId());
        if (oReleaseSourceView == null) {
            throw new WCMException("\u7a3f\u6e90\u5e93\u89c6\u56fe\u6ca1\u6709\u5728\u7cfb\u7edf\u4e2d\u521d\u59cb\u5316!");
        }
        return oReleaseSourceView;
    }

    public static int getReleaseSharedRecord() throws WCMException {
        RELEASE_SHAREDRECORD = Integer.parseInt(ConfigServer.getServer().getSysConfigValue("RELEASE_SHAREDRECORD", DOCSHARED_NO));
        return RELEASE_SHAREDRECORD;
    }

    public static Map<String, Groups> getFusionCircle() throws WCMException {
        String sFusionCircle = ConfigServer.getServer().getSysConfigValue("RELEASE_FUSION_CIRCLE", "");
        HashMap<String, Groups> hCircles = new HashMap<String, Groups>();
        if (CMyString.isEmpty(sFusionCircle)) {
            return hCircles;
        }
        String[] arrCircles = sFusionCircle.split(";");
        if (arrCircles == null) {
            return hCircles;
        }
        for (int i = 0; i < arrCircles.length; ++i) {
            Groups groups;
            String[] arrCircle;
            if (CMyString.isEmpty(arrCircles[i]) || (arrCircle = arrCircles[i].split(":")) == null || (groups = Groups.findByIds(null, arrCircle[1])).isEmpty()) continue;
            hCircles.put(arrCircle[0], groups);
        }
        return hCircles;
    }

    public static int getRootVirtualGroupId() throws WCMException {
        ROOT_VIRTUALGROUP_ID = Integer.parseInt(ConfigServer.getServer().getSysConfigValue("ROOT_VIRTUALGROUP_ID", DOCSHARED_NO));
        return ROOT_VIRTUALGROUP_ID;
    }

    public static Group getRootVirtualGroup() throws WCMException {
        Group oGroup = Group.findById(ReleaseSourceConstants.getRootVirtualGroupId());
        if (null == oGroup) {
            throw new WCMException("\u8bf7\u6b63\u786e\u7684\u914d\u7f6e\u7cfb\u7edf\u53d8\u91cf\u9876\u7ea7\u7ec4\u7ec7\u53d8\u91cfID\u3010ROOT_VIRTUALGROUP_ID\u3011");
        }
        return oGroup;
    }

    static {
        LATEST_RELEASE_SOURCE_COUNT = 10;
    }
}

