/*
 * Decompiled with CFR 0.152.
 */
package com.trs.exchange.metadata;

import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.exchange.metadata.MetaDataConstants;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class MetaDataServiceHelper {
    public static MetaViewData setMetaDataProperties(Map<String, Object> mapParams, MetaViewData _oViewData) throws WCMException {
        for (String sParamName : mapParams.keySet()) {
            Object value = mapParams.get(sParamName);
            if (value instanceof String) {
                _oViewData.setProperty(sParamName, value.toString().trim());
                continue;
            }
            if (value instanceof String[]) {
                String[] pValues = (String[])value;
                _oViewData.setProperty(sParamName, pValues == null || pValues.length == 0 ? null : pValues[0].trim());
                continue;
            }
            _oViewData.setProperty(sParamName, value);
        }
        return _oViewData;
    }

    private static MetaViewData treatSpecialColumnFromJson(MetaViewData _MetaViewData2) throws WCMException {
        String[] columns = new String[]{"ListPics", "FocusImage", "Figure", "NewsAccessories", "ReadingPics", "ReadingPicsTwo", "ReadingPicsThree"};
        for (int i = 0; i < columns.length; ++i) {
            String sValue;
            if (!_MetaViewData2.containsProperty(columns[i])) continue;
            String string = sValue = _MetaViewData2.getId() > 0 ? _MetaViewData2.getNewPropertyAsString(columns[i]) : _MetaViewData2.getPropertyAsString(columns[i]);
            if (null == sValue || "".equals(sValue)) continue;
            StringBuilder sb = new StringBuilder();
            if (sValue.startsWith("[")) {
                JSONArray newArray = JSONArray.fromObject((Object)sValue);
                for (int j = 0; j < newArray.size(); ++j) {
                    JSONObject jObject = newArray.getJSONObject(j);
                    if (sb.length() == 0) {
                        sb.append(jObject.get("APPFILE") + "," + CMyString.filterForSQL(String.valueOf(jObject.get("APPDESC"))));
                        continue;
                    }
                    sb.append(";" + jObject.get("APPFILE") + "," + CMyString.filterForSQL(String.valueOf(jObject.get("APPDESC"))));
                }
            } else if (sValue.startsWith("{")) {
                JSONObject jObject = JSONObject.fromObject((Object)sValue);
                sb.append(jObject.get("APPFILE") + "," + CMyString.filterForSQL(String.valueOf(jObject.get("APPDESC"))));
            }
            _MetaViewData2.setProperty(columns[i], sb.toString());
        }
        return _MetaViewData2;
    }

    public static String reTreatSpecialColumnToJson(String _ColumnValue) throws WCMException {
        if (null == _ColumnValue || _ColumnValue.length() == 0 || "[]".equals(_ColumnValue)) {
            return "";
        }
        String[] objs = _ColumnValue.split(";");
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < objs.length; ++i) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put((Object)"APPFILE", (Object)objs[i].split(",")[0]);
                jsonObject.put((Object)"APPDESC", (Object)objs[i].split(",")[1]);
            }
            catch (Exception e) {
                throw new WCMException("\u7b2c\u3010" + i + "\u3011\u4e2a\u5b57\u7b26\u4e32\u683c\u5f0f\u975e\u6cd5\uff01");
            }
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray.toString();
    }

    public static MetaViewData makeMetaViewData(int _MetaDataId, MetaView _MetaView2) throws WCMException {
        if (_MetaDataId > 0) {
            return MetaViewData.findById(_MetaDataId);
        }
        if (_MetaDataId == 0) {
            return new MetaViewData(_MetaView2);
        }
        return null;
    }

    public static String buildHttpPathOfWCMFile(String _JsonArrayString, String _ParamName) throws WCMException {
        FilesMan oFilesMan = FilesMan.getFilesMan();
        String sPicurl = "";
        JSONArray oJSONArray = new JSONArray();
        if (!CMyString.isEmpty(_JsonArrayString) && MetaDataServiceHelper.isValidJsonArrayStr(_JsonArrayString)) {
            oJSONArray = JSONArray.fromObject((Object)_JsonArrayString);
            JSONObject oJsonObject = null;
            for (int i = 0; i < oJSONArray.size(); ++i) {
                oJsonObject = oJSONArray.getJSONObject(i);
                if (CMyString.isEmpty(oJsonObject.get(_ParamName).toString())) {
                    oJsonObject.put((Object)"PICURL", (Object)"");
                    oJsonObject.put((Object)"PERPICURL", (Object)"");
                    continue;
                }
                sPicurl = oFilesMan.mapFilePath(oJsonObject.get("APPFILE").toString(), 1);
                oJsonObject.put((Object)"PICURL", (Object)sPicurl);
                oJsonObject.put((Object)"PERPICURL", (Object)(MetaDataConstants.getSHost() + sPicurl + oJsonObject.get("APPFILE").toString()));
            }
        }
        return oJSONArray.toString();
    }

    public static boolean isValidJsonArrayStr(String _sJsonStr) {
        if (CMyString.isEmpty(_sJsonStr)) {
            return false;
        }
        return _sJsonStr.replaceAll("\\s", "").startsWith("[{") && _sJsonStr.replaceAll("\\s", "").endsWith("}]");
    }

    public static int getRecIdByMetaViewData(MetaViewData _metaViewData) throws WCMException {
        if (null == _metaViewData) {
            throw new WCMException("\u4f20\u5165\u7684\u5143\u6570\u636e\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        WCMFilter ofilter = new WCMFilter("WCMCHNLDOC", " DOCID = ? ", " RECID ");
        ofilter.addSearchValues(_metaViewData.getId());
        ChnlDocs oChnlDocs = ChnlDocs.openWCMObjs(null, ofilter);
        if (oChnlDocs.isEmpty()) {
            throw new WCMException("\u65e0\u6cd5\u627e\u5230DOCID[" + _metaViewData.getId() + "]\u5bf9\u5e94CHNLDOC!");
        }
        return oChnlDocs.getAt(0).getId();
    }
}

