/*
 * Decompiled with CFR 0.152.
 */
package com.trs.exchange.metadata;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaDataCenterClassInfoHelper;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.service.MetaDataCenterServiceProvider;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.exchange.DataMigrationLogger;
import com.trs.exchange.ExchangeHelper;
import com.trs.exchange.MyDBManager;
import com.trs.exchange.mas.MediaHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMy3WLib;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;

public abstract class MetaDataExchange {
    private static Logger logger = Logger.getLogger(MetaDataExchange.class);
    protected boolean m_bIgnoreAppendix = false;
    protected MyDBManager m_oDBMgr = null;
    private AppendixMgr m_oAppendixMgr = null;
    protected FilesMan filesMan = null;
    protected DataMigrationLogger m_oDLogger = null;
    private IMetaViewEmployerMgr m_oMetaViewEmployerMgr = null;
    private IMetaDataDefCacheMgr m_oDataDefCacheMgr = null;
    private String m_sMASURL = null;
    private int m_nDirId = 0;

    public MetaDataExchange(MyDBManager _dbMgr) {
        this.m_oDBMgr = _dbMgr;
        this.m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        this.m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
        this.m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
        this.filesMan = FilesMan.getFilesMan();
    }

    public void setMASInfo(String _sMASURL, int _nDirId) {
        this.m_sMASURL = _sMASURL;
        this.m_nDirId = _nDirId;
    }

    public void createMetaViewDatas(User _oCrUser, int _nDstChannelId, WCMFilter _filterForQuerySrcData, String _sIdFieldName, boolean _bOrderById) throws Exception {
        this.initLogger(_nDstChannelId);
        int nLasMigrationId = this.m_oDLogger.readLastInfo();
        if (nLasMigrationId == -1) {
            logger.warn((Object)("\u680f\u76ee[ID=" + _nDstChannelId + "]\u5df2\u7ecf\u8fc1\u79fb\u5b8c\uff0c\u91cd\u590d\u6267\u884c\uff01"));
            return;
        }
        Channel dstChannel = Channel.findById(_nDstChannelId);
        if (dstChannel == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u680f\u76ee\u65e0\u6548\uff01[\u680f\u76eeID=" + _nDstChannelId + "]");
        }
        logger.info((Object)("Begin Data Migration to [" + dstChannel + "].........."));
        this.m_oDLogger.recordStartChannel(_nDstChannelId);
        WCMFilter oQueryMinAndMaxFilter = new WCMFilter(_filterForQuerySrcData.getFrom(), _filterForQuerySrcData.getWhere(), "", "min(" + _sIdFieldName + "), max(" + _sIdFieldName + ")");
        int[] pTemp = this.queryMinAndMaxId(oQueryMinAndMaxFilter.toSQL());
        int nMinDataId = pTemp[0];
        int nMaxDataId = pTemp[1];
        if (nMinDataId < nLasMigrationId) {
            nMinDataId = nLasMigrationId;
        }
        int nMingrationSize = 3000;
        int nTempMaxDataId = nMinDataId;
        while (nTempMaxDataId <= nMaxDataId) {
            nMinDataId = nTempMaxDataId;
            WCMFilter filterForQueryRnageData = this.toRangeFilter(_filterForQuerySrcData, nMinDataId, nTempMaxDataId += nMingrationSize, _sIdFieldName);
            this.createRangeMetaViewDatas(_oCrUser, dstChannel, filterForQueryRnageData);
            nMinDataId = nTempMaxDataId;
        }
        if (!_bOrderById) {
            this.updateDocOrder(dstChannel, _filterForQuerySrcData, _sIdFieldName);
        }
        logger.info((Object)("End Data Migration to [" + dstChannel + "]!"));
        this.m_oDLogger.recordEndChannel(_nDstChannelId);
    }

    private WCMFilter toRangeFilter(WCMFilter _filterForQuerySrcData, int _nMinDataId, int _nMaxDataId, String _sIdFieldName) {
        String sWhere = " (" + _sIdFieldName + ">=? and " + _sIdFieldName + "<?) ";
        if (!CMyString.isEmpty(_filterForQuerySrcData.getWhere())) {
            sWhere = sWhere + " and " + _filterForQuerySrcData.getWhere();
        }
        WCMFilter filterForQueryRnageData = new WCMFilter(_filterForQuerySrcData.getFrom(), sWhere, _sIdFieldName + " asc", _filterForQuerySrcData.getSelect());
        filterForQueryRnageData.addSearchValues(_nMinDataId);
        filterForQueryRnageData.addSearchValues(_nMaxDataId);
        return filterForQueryRnageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRangeMetaViewDatas(User _oCrUser, Channel _dstChannel, WCMFilter _filterForQueryRangeSrcData) throws Exception {
        DBManager dbMgrForWCM = DBManager.getDBManager();
        MetaView view = this.findViewByChannel(_dstChannel);
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        int nSrcId = 0;
        try {
            oConn = this.m_oDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(_filterForQueryRangeSrcData.toSQL());
            this.m_oDBMgr.setParameters(oPreStmt, _filterForQueryRangeSrcData.getSearchValues());
            result = oPreStmt.executeQuery();
            while (result.next()) {
                List arAppendixes;
                MetaViewData oMetaData = new MetaViewData(view);
                ExchangeHelper.readFromRs(oMetaData, result, result.getMetaData(), this.m_oDBMgr.getDbType(), true);
                nSrcId = oMetaData.getPropertyAsInt("DocOutupId", 0);
                if (nSrcId <= 0) {
                    throw new WCMException("\u67e5\u8be2\u8bed\u53e5\u53ef\u80fd\u6709\u8bef\uff0c\u6ca1\u6709\u6307\u5b9aDocOutupId\uff1f[SQL=" + _filterForQueryRangeSrcData + "]");
                }
                logger.info((Object)("Begin to dowith the data[" + nSrcId + "] to " + _dstChannel + "....."));
                this.m_oDLogger.recordStartData(nSrcId);
                oMetaData.setProperty("ChannelId", _dstChannel.getId());
                MetaDataCenterClassInfoHelper.renderClassInfoFields(oMetaData);
                this.renderFields(oMetaData);
                this.doSomethingBeforeSave(oMetaData);
                oMetaData.save(_oCrUser);
                if (oMetaData.getDocument() == null) {
                    throw new WCMException("Fail to save metaviewdata![SrcId=" + nSrcId + "]");
                }
                dbMgrForWCM.sqlExecuteUpdate(new String[]{"update WCMDocument set DocOutupId=? where DocId=?"}, new int[]{nSrcId, oMetaData.getDocumentId()});
                this.doSomethingAfterSave(oMetaData);
                WCMFilter[] pFilterQueryAppendix = this.makeFilterQueryAppendixOfDocument(oMetaData);
                if (pFilterQueryAppendix != null && pFilterQueryAppendix.length > 0) {
                    for (int nFilterIndex = 0; nFilterIndex < pFilterQueryAppendix.length; ++nFilterIndex) {
                        this.createAppendixes(_oCrUser, oMetaData, pFilterQueryAppendix[nFilterIndex]);
                    }
                }
                if ((arAppendixes = this.makeAppendixesOfDocument(oMetaData)) != null && !arAppendixes.isEmpty()) {
                    int nAppendixSize = arAppendixes.size();
                    for (int nAppendixIndex = 0; nAppendixIndex < nAppendixSize; ++nAppendixIndex) {
                        Appendix appendix = (Appendix)arAppendixes.get(nAppendixIndex);
                        this.saveAppendix(oMetaData, appendix);
                    }
                }
                logger.info((Object)("END to dowith the data[" + nSrcId + "] to " + _dstChannel + "!"));
                this.m_oDLogger.recordEndData(nSrcId);
            }
        }
        catch (Exception ex) {
            if (nSrcId > 0) {
                this.error("\u5904\u7406\u8fd9\u6761\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff01[\u6570\u636eID=" + nSrcId + "]", ex);
            } else {
                this.error("\u67e5\u8be2\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff1f[SQL=" + _filterForQueryRangeSrcData + "]", ex);
            }
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                this.m_oDBMgr.freeConnection(oConn);
            }
        }
    }

    private void createAppendixes(User _oCrUser, MetaViewData _oMetaData, WCMFilter _filterForQueryAppendix) throws Exception {
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        try {
            oConn = this.m_oDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(_filterForQueryAppendix.toSQL());
            this.m_oDBMgr.setParameters(oPreStmt, _filterForQueryAppendix.getSearchValues());
            result = oPreStmt.executeQuery();
            while (result.next()) {
                Appendix appendix = Appendix.createNewInstance();
                ExchangeHelper.readFromRs(appendix, result, result.getMetaData(), this.m_oDBMgr.getDbType());
                logger.info((Object)("Begin to dowith the appendix[" + appendix + "] of " + _oMetaData + "....."));
                this.saveAppendix(_oMetaData, appendix);
                logger.info((Object)("END to dowith the appendix[" + appendix.getId() + "] of " + _oMetaData + "!"));
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to query data!", ex);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                this.m_oDBMgr.freeConnection(oConn);
            }
        }
    }

    private void saveAppendix(MetaViewData _oMetaData, Appendix _appendix) throws WCMException, Exception {
        String sNewFileName;
        String sAppFile = _appendix.getFile();
        if (CMyString.isEmpty(sAppFile)) {
            this.error("\u6307\u5b9a\u9644\u4ef6\u6ca1\u6709\u8bbe\u7f6eAppFile\u5c5e\u6027\uff01[\u6240\u5c5e\u6587\u6863=" + _oMetaData + "]");
        }
        _appendix.setDocId(_oMetaData.getId());
        if (_appendix.getFlag() <= 0) {
            _appendix.setFlag(10);
        }
        String sWCMFileType = null;
        if (_appendix.getFlag() == 10) {
            sWCMFileType = "P0";
        } else if (_appendix.getFlag() == 20) {
            sWCMFileType = "P0";
        }
        if (!(sWCMFileType == null || FilesMan.isValidFile(sAppFile, sWCMFileType) && this.filesMan.fileExists(sAppFile) || (sNewFileName = this.saveFile(_oMetaData, sAppFile, true)) == null)) {
            _appendix.setFile(sNewFileName);
        }
        this.m_oAppendixMgr.addAppendix(_oMetaData.getDocument(), _appendix);
    }

    protected abstract WCMFilter[] makeFilterQueryAppendixOfDocument(MetaViewData var1);

    protected abstract List makeAppendixesOfDocument(MetaViewData var1) throws Exception;

    public String dowithHtmlContent(MetaViewData _oMetaData, String _sHTMLFieldName) throws WCMException {
        String picAppdex = null;
        String sHTMLContent = _oMetaData.getPropertyAsString(_sHTMLFieldName);
        try {
            sHTMLContent = URLDecoder.decode(URLDecoder.decode(sHTMLContent, "GB2312"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String[] arResTagName = new String[]{"img", "table", "td", "script", "a"};
        String[] arResSrcName = new String[]{"src", "BACKGROUND", "BACKGROUND", "scr", "href"};
        int nTagSize = arResTagName.length > arResSrcName.length ? arResTagName.length : arResSrcName.length;
        HtmlElementFinder imgFinder = null;
        HtmlElement element = null;
        HashMap<String, String> hImgRecs = new HashMap<String, String>();
        boolean bFind = false;
        try {
            for (int nTagIndex = 0; nTagIndex < nTagSize; ++nTagIndex) {
                String currTagName = arResTagName[nTagIndex];
                String currTagSrcName = arResSrcName[nTagIndex];
                imgFinder = new HtmlElementFinder(sHTMLContent);
                while (true) {
                    imgFinder.putElement(element);
                    element = imgFinder.findNextElement(currTagName, true);
                    if (element == null) break;
                    String sResName = element.getAttributeValue(currTagSrcName);
                    if (sResName == null || (sResName = sResName.trim()).length() == 0) continue;
                    String sKey = sResName.toLowerCase();
                    String sUploadName = (String)hImgRecs.get(sKey);
                    if (sUploadName != null) {
                        element.setAttribute(currTagSrcName, sUploadName);
                        continue;
                    }
                    String sFileExt = ExchangeHelper.extractFileExt(sResName);
                    if ("jpg".equals(sFileExt) || "gif".equals(sFileExt) || "png".equals(sFileExt)) {
                        int flag = sKey.indexOf(".pub.");
                        if (flag > 0) {
                            sKey = sKey.substring(0, flag + 1) + sKey.substring(flag + 5);
                        }
                        if (!sKey.startsWith("http://")) {
                            sKey = "http://zjnews.zjol.com.cn" + sKey;
                        }
                        sResName = sKey;
                        element.setAttribute(currTagSrcName, sResName);
                        hImgRecs.put(sKey, sUploadName);
                        bFind = true;
                    }
                    if (currTagName.equalsIgnoreCase("A") && sFileExt != null && !sFileExt.endsWith("doc") && !sFileExt.endsWith("docx") && !sFileExt.endsWith("xls") || (sUploadName = this.saveFile(_oMetaData, sResName, false)) == null) continue;
                    bFind = true;
                    element.setAttribute(currTagSrcName, sUploadName);
                    element.setAttribute("UploadPic", sUploadName);
                    hImgRecs.put(sKey, sUploadName);
                }
                sHTMLContent = imgFinder.getContent();
            }
            if (bFind) {
                _oMetaData.setProperty(_sHTMLFieldName, sHTMLContent);
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "\u4fdd\u5b58\u56fe\u6587\u6df7\u6392\u5185\u5bb9\u5931\u8d25!", ex);
        }
        return picAppdex;
    }

    private void updateDocOrder(Channel _dstChannel, WCMFilter _filterForQuerySrcData, String _sIdFieldName) throws Exception {
        DBManager dbMgrForWCM = DBManager.getDBManager();
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        try {
            oConn = this.m_oDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(_filterForQuerySrcData.toSQL());
            this.m_oDBMgr.setParameters(oPreStmt, _filterForQuerySrcData.getSearchValues());
            result = oPreStmt.executeQuery();
            int nDocOrder = 0;
            while (result.next()) {
                int nSrcId = result.getInt(_sIdFieldName);
                logger.info((Object)("Begin to update the order of data[" + nSrcId + "]  " + _dstChannel + "....."));
                dbMgrForWCM.sqlExecuteUpdate(new String[]{"update WCMChnlDoc set DocOrder=? where ChnlId=? and DocId in(select DocId from WCMDocument where DocOutupId=\uff1f)"}, new int[]{++nDocOrder, _dstChannel.getId(), nSrcId});
                logger.info((Object)("End to update the order of data[" + nSrcId + "]  " + _dstChannel + "!"));
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to query data!", ex);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                this.m_oDBMgr.freeConnection(oConn);
            }
        }
    }

    private String saveFile(MetaViewData _oMetaData, String sResName, boolean _bAppendixs) throws Exception {
        String sFileExt = ExchangeHelper.extractFileExt(sResName);
        if (sFileExt == null || ExchangeHelper.isForbidFileExt(sFileExt)) {
            logger.error((Object)("\u6307\u5b9a\u6587\u4ef6\u7684\u540e\u7f00\u540d\u4e0d\u5728\u767d\u540d\u5355\u5141\u8bb8\u8303\u56f4\u4e4b\u5185\uff01[\u6587\u4ef6=" + sResName + "]"));
            return null;
        }
        String sResFullPahtName = this.makeResFullPathName(_oMetaData, sResName, false);
        if (CMyString.isEmpty(sResFullPahtName)) {
            return null;
        }
        String sAbsolutePathUpldateFileName = this.filesMan.getNextFilePathName("U0", sFileExt);
        String sUploadSrc = CMyFile.extractFileName(sAbsolutePathUpldateFileName);
        if (sResFullPahtName.startsWith("http")) {
            CMy3WLib.getFile(sResFullPahtName, sAbsolutePathUpldateFileName);
        } else if (CMyFile.fileExists(sResFullPahtName)) {
            CMyFile.copyFile(sResFullPahtName, sAbsolutePathUpldateFileName);
        } else {
            return null;
        }
        return sUploadSrc;
    }

    private void initLogger(int _nDstChannelId) throws Exception {
        this.m_oDLogger = new DataMigrationLogger(this.m_oDBMgr.getSrcNameOfDB(), _nDstChannelId);
        String sLogFilePath = this.filesMan.getPathConfigValue("N0", 0);
        sLogFilePath = CMyString.setStrEndWith(sLogFilePath, File.separatorChar);
        String sLogFileName = sLogFilePath + "exchange_" + this.m_oDBMgr.getSrcNameOfDB() + ".log";
        PatternLayout layout = new PatternLayout("[ExchangeLog] %m - %d - %-5p %x  - %c%l -%-4r [%t] %n");
        WriterAppender appender = new WriterAppender((Layout)layout, (OutputStream)new FileOutputStream(sLogFileName, true));
        appender.setEncoding("UTF-8");
        logger.removeAllAppenders();
        logger.addAppender((Appender)appender);
    }

    private int[] queryMinAndMaxId(String _sSQL) throws Exception {
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        try {
            oConn = this.m_oDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(_sSQL);
            result = oPreStmt.executeQuery();
            if (result.next()) {
                int[] nArray = new int[]{result.getInt(1), result.getInt(2)};
                return nArray;
            }
            try {
                throw new WCMException("Not find![SQL=" + _sSQL + "]");
            }
            catch (Exception ex) {
                throw new WCMException(1100, "Failed to query data![SQL=" + _sSQL + "]", ex);
            }
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                this.m_oDBMgr.freeConnection(oConn);
            }
        }
    }

    protected void warn(String _sInfo) throws WCMException {
        this.error(_sInfo, null);
    }

    protected void warn(String _sInfo, Exception _ex) throws WCMException {
        logger.error((Object)_sInfo, (Throwable)_ex);
    }

    protected void error(String _sInfo) throws WCMException {
        this.error(_sInfo, null);
    }

    protected void error(String _sInfo, Exception _ex) throws WCMException {
        logger.error((Object)_sInfo, (Throwable)_ex);
        throw new WCMException(_sInfo, _ex);
    }

    protected abstract String makeResFullPathName(MetaViewData var1, String var2, boolean var3) throws Exception;

    protected abstract String makeMedialPathName(MetaViewData var1, String var2) throws WCMException;

    protected void doSomethingBeforeSave(MetaViewData _oMetaData) {
    }

    protected void doSomethingAfterSave(MetaViewData _oMetaData) {
    }

    private MetaView findViewByChannel(Channel _channel) throws WCMException {
        MetaView view = this.m_oMetaViewEmployerMgr.getViewOfEmployer(_channel);
        if (view == null) {
            throw new WCMException(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label37", "\u6307\u5b9a\u680f\u76ee\u6ca1\u6709\u914d\u7f6e\u89c6\u56fe\uff01[\u680f\u76ee\u4fe1\u606f=") + _channel + "]");
        }
        return view;
    }

    private void renderFields(MetaViewData _oViewData) throws Exception {
        HashMap hFields = this.m_oDataDefCacheMgr.getMetaViewFields(_oViewData.getMetaView().getId());
        for (MetaViewField field : hFields.values()) {
            if (field == null || !field.isFromMainTable()) continue;
            switch (field.getType()) {
                case 12: 
                case 16: {
                    String sFieldName = field.getName();
                    String sFieldValue = _oViewData.getFinalPropertyAsString(sFieldName);
                    if (CMyString.isEmpty(sFieldValue)) break;
                    this.dowithHtmlContent(_oViewData, sFieldName);
                    break;
                }
                case 8: {
                    String sWCMFileName;
                    String sFieldName = field.getName();
                    String sFieldValue = _oViewData.getFinalPropertyAsString(sFieldName);
                    if (CMyString.isEmpty(sFieldValue) || (sWCMFileName = this.saveFile(_oViewData, sFieldValue, false)) == null) break;
                    _oViewData.setProperty(sFieldName, sWCMFileName);
                    break;
                }
                case 20: {
                    if (this.m_sMASURL == null || this.m_sMASURL.length() == 0) {
                        throw new WCMException("\u6ca1\u6709\u6307\u5b9aMAS\u7684\u76f8\u5173\u4fe1\u606f!");
                    }
                    String sFieldName = field.getName();
                    String sFieldValue = _oViewData.getFinalPropertyAsString(sFieldName);
                    String sMediaFileName = this.makeMedialPathName(_oViewData, sFieldValue);
                    int nMasId = MediaHelper.createMedia(this.m_sMASURL, this.m_nDirId, sMediaFileName);
                    _oViewData.setProperty(sFieldName, nMasId);
                }
            }
        }
    }
}

