/*
 * Decompiled with CFR 0.152.
 */
package com.trs.db.update;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;

public class DBUpdateLog
extends BaseObj {
    public static final int TYPE_UPDATE = 1;
    public static final int TYPE_ADD = 2;
    public static final int DB_TYPE_SQL = 2;
    public static final int DB_TYPE_ORACLE = 1;
    public static final int DB_TYPE_DB2 = 3;
    public static final int DB_TYPE_SYBASE = 4;
    public static final int DB_TYPE_MYSQL = 7;
    public static final String[] DB_AUTO_COMMIT = new String[100];
    public static final int OBJ_TYPE = 3001;
    public static final String DB_TABLE_NAME = "WCMDBUPDATELOG";
    public static final String DB_ID_NAME = "DBUPDATELOGID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 3001;
    }

    public String getTitle() {
        return this.getPropertyAsString("LOGTITLE");
    }

    public boolean setTitile(String _sTitile) throws WCMException {
        return this.setProperty("LOGTITLE", _sTitile);
    }

    public String getMemo() {
        return this.getPropertyAsString("LOGMEMO");
    }

    public boolean setMemo(String _sMemo) throws WCMException {
        return this.setProperty("LOGMEMO", _sMemo);
    }

    public String getSubmitor() {
        return this.getPropertyAsString("SUBMITOR");
    }

    public boolean setSubmitor(String _sSubmitor) throws WCMException {
        return this.setProperty("SUBMITOR", _sSubmitor);
    }

    public String getTableName() {
        return this.getPropertyAsString("TABLENAME");
    }

    public boolean setTableName(String _sTableName) throws WCMException {
        return this.setProperty("TABLENAME", _sTableName);
    }

    public int getType() {
        return this.getPropertyAsInt("LOGTYPE", 0);
    }

    public String getTypeDesc() {
        switch (this.getType()) {
            case 2: {
                return I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label1", "\u65b0\u589e");
            }
            case 1: {
                return I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label2", "\u4fee\u6539");
            }
        }
        return I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label3", "\u672a\u77e5");
    }

    public boolean setType(int _nType) throws WCMException {
        return this.setProperty("LOGTYPE", _nType);
    }

    public String getSQL(int _nDBType) throws WCMException {
        String currSql = null;
        switch (_nDBType) {
            case 2: {
                currSql = "print '" + CMyString.filterForSQL(this.toString()) + "'\n GO \n";
                currSql = currSql + this.getSQLServerSQL();
                break;
            }
            case 1: {
                currSql = this.getOracleSQL();
                if (currSql != null && currSql.indexOf(";") < 0) {
                    currSql = currSql + ";";
                }
                currSql = CMyString.showNull(currSql, "");
                currSql = "exec dbms_output.put_line('" + CMyString.filterForSQL(this.toString()) + "');\n" + currSql;
                break;
            }
            case 3: {
                currSql = this.getDB2SQL();
                break;
            }
            case 4: {
                currSql = this.getSysbaseSQL();
                break;
            }
            case 7: {
                currSql = this.getMysqlSQL();
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label4", "\u4e0d\u652f\u6301\u4f20\u5165\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff01"));
            }
        }
        return currSql;
    }

    public String getSQLServerSQL() {
        CDBText txtValue = (CDBText)this.getProperty("SQLSERVER");
        if (txtValue == null) {
            return null;
        }
        return txtValue.getText();
    }

    public boolean setSQLServerSQL(String _sSQLServerSQL) throws WCMException {
        return this.setProperty("SQLSERVER", new CDBText(this.getDBManager().getDBTypeAsInt(), _sSQLServerSQL));
    }

    public String getOracleSQL() {
        CDBText txtValue = (CDBText)this.getProperty("ORACLESQL");
        if (txtValue == null) {
            return null;
        }
        return txtValue.getText();
    }

    public boolean setOracleSQL(String _sOracleSQL) throws WCMException {
        return this.setProperty("ORACLESQL", new CDBText(this.getDBManager().getDBTypeAsInt(), _sOracleSQL));
    }

    public String getDB2SQL() {
        CDBText txtValue = (CDBText)this.getProperty("DB2SQL");
        if (txtValue == null) {
            return null;
        }
        return txtValue.getText();
    }

    public boolean setDB2SQL(String _sDB2SQL) throws WCMException {
        return this.setProperty("DB2SQL", new CDBText(this.getDBManager().getDBTypeAsInt(), _sDB2SQL));
    }

    public String getSysbaseSQL() {
        CDBText txtValue = (CDBText)this.getProperty("SYSBASESQL");
        if (txtValue == null) {
            return null;
        }
        return txtValue.getText();
    }

    public boolean setSysbaseSQL(String _sSysbaseSQL) throws WCMException {
        return this.setProperty("SYSBASESQL", new CDBText(this.getDBManager().getDBTypeAsInt(), _sSysbaseSQL));
    }

    public String getMysqlSQL() {
        CDBText txtValue = (CDBText)this.getProperty("MYSQL");
        if (txtValue == null) {
            return null;
        }
        return txtValue.getText();
    }

    public boolean setMysqlSQL(String _sMysqlSQL) throws WCMException {
        return this.setProperty("MYSQL", new CDBText(this.getDBManager().getDBTypeAsInt(), _sMysqlSQL));
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("LOGTITLE") == null) {
                throw new WCMException(1106, I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label5", "\u5c5e\u6027Titile\u6ca1\u6709\u8bbe\u7f6e(DBUpdateLog.isValid)"));
            }
            if (this.getProperty("SUBMITOR") == null) {
                throw new WCMException(1106, I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label6", "\u5c5e\u6027Submitor\u6ca1\u6709\u8bbe\u7f6e(DBUpdateLog.isValid)"));
            }
            if (this.getProperty("TABLENAME") == null) {
                throw new WCMException(1106, I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label7", "\u5c5e\u6027TableName\u6ca1\u6709\u8bbe\u7f6e(DBUpdateLog.isValid)"));
            }
            if (this.getProperty("LOGTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label8", "\u5c5e\u6027Type\u6ca1\u6709\u8bbe\u7f6e(DBUpdateLog.isValid)"));
            }
            if (this.getProperty("SQLSERVER") == null) {
                throw new WCMException(1106, I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label9", "\u5c5e\u6027SQLServerSQL\u6ca1\u6709\u8bbe\u7f6e(DBUpdateLog.isValid)"));
            }
        }
        return true;
    }

    public static final DBUpdateLog findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (DBUpdateLog)BaseObj.findById(DBUpdateLog.class, _nId);
    }

    public static final DBUpdateLog createNewInstance() throws WCMException {
        return (DBUpdateLog)BaseObj.createNewInstance(DBUpdateLog.class);
    }

    public static final DBUpdateLog findByKey(Object _oKey) throws WCMException {
        return (DBUpdateLog)BaseObj.findByKey(DBUpdateLog.class, _oKey);
    }

    public String toString() {
        return "DBUpdate-" + this.getId() + " " + this.getTitle();
    }

    static {
        DBUpdateLog.DB_AUTO_COMMIT[1] = "GO";
        DBUpdateLog.DB_AUTO_COMMIT[0] = "COMMIT;";
        DBUpdateLog.DB_AUTO_COMMIT[2] = "COMMIT;";
        DBUpdateLog.DB_AUTO_COMMIT[3] = "GO";
        DBUpdateLog.DB_AUTO_COMMIT[6] = "";
    }
}

