/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wechat.filter;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMySign;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.RemoteAddrUtil;
import com.trs.webframework.controler.JSPRequestProcessor;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class NewsImportor
extends HttpServlet {
    private static final String APP_WECHAT_IP = "APP_WECHAT_IP";
    private static final String PARAM_NAME_ENCODE = "RandomInfo";
    public static final String KEY_PRIVATE_PLATFORM_LOGIN = ConfigConstants.DIR_APPROOT + "public_platform_log.key";
    private static final Logger LOG = Logger.getLogger(NewsImportor.class);
    private static final long serialVersionUID = 1L;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.accessAble(request)) {
            response.setStatus(401);
            return;
        }
        String result = this.saveDocument(request);
        PrintWriter writer = response.getWriter();
        writer.write(result);
        writer.flush();
    }

    public String saveDocument(HttpServletRequest request) {
        String sEncodeInfo = request.getParameter(PARAM_NAME_ENCODE);
        return this.checkEncodeInfo(KEY_PRIVATE_PLATFORM_LOGIN, sEncodeInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkEncodeInfo(String sPublicKey, String sEncodeInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("sPublicKey:" + sPublicKey));
        }
        String sParam = "";
        String result = "";
        try {
            int nSignLen;
            byte[] buff = sEncodeInfo.getBytes();
            CMySign verify = CMySign.getVerify(sPublicKey);
            buff = verify.decodeRadix64(buff);
            ByteArrayInputStream baoins = new ByteArrayInputStream(buff);
            DataInputStream dataInputStream = new DataInputStream(baoins);
            int userId = dataInputStream.readInt();
            User user = User.findById(userId);
            ContextHelper.initContext(user);
            sParam = dataInputStream.readUTF();
            if (sParam == null) {
                sParam = "";
            }
            if (!verify.verify(buff, nSignLen = dataInputStream.readInt())) {
                LOG.error((Object)"Invalid random info: Signature doesn't matched.");
                String string = "";
                return string;
            }
            Map<String, String> map = NewsImportor.string2Map(sParam);
            String title = map.get("title");
            String desc = map.get("desc");
            String srcfileName = map.get("srcfile");
            String appendix = map.get("appendix");
            String detail = map.get("detail");
            String url = map.get("url");
            String chnlId = map.get("chnlId");
            String docId = map.get("docId");
            String content = map.get("content");
            JSPRequestProcessor processsor = new JSPRequestProcessor();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("chnlId", chnlId);
            params.put("docId", docId);
            params.put("title", title);
            params.put("detail", detail);
            params.put("description", desc);
            params.put("APPFILE", appendix);
            params.put("SRCFILE", srcfileName);
            params.put("content", content);
            params.put("url", url);
            result = (String)processsor.excute("wcm61_wxkeyword", "saveContent", params);
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to check login.", (Throwable)ex);
            String string = "";
            return string;
        }
        finally {
            ContextHelper.clear();
        }
        return result;
    }

    public static Map<String, String> string2Map(String properties) {
        return NewsImportor.string2Map(properties, "&", "=");
    }

    public static Map<String, String> string2Map(String properties, String outerSplitter, String innerSplitter) {
        if (CMyString.isEmpty(properties)) {
            return null;
        }
        Hashtable<String, String> outProperties = new Hashtable<String, String>();
        StringTokenizer tokenizerOuter = new StringTokenizer(properties, outerSplitter);
        while (tokenizerOuter.hasMoreTokens()) {
            String currProperty = tokenizerOuter.nextToken();
            int index = currProperty.indexOf(innerSplitter);
            if (index == -1) continue;
            String value = currProperty.substring(index + 1, currProperty.length());
            outProperties.put(currProperty.substring(0, index), value);
        }
        return outProperties;
    }

    private boolean accessAble(HttpServletRequest request) {
        String ip = RemoteAddrUtil.getRemoteAddr(request);
        try {
            String sAllowIP = ConfigServer.getServer().getSysConfigValue(APP_WECHAT_IP, "");
            LOG.debug((Object)("APP_WECHAT_IP:" + sAllowIP));
            LOG.debug((Object)("ip->" + ip));
            String[] pAllowIP = sAllowIP.split(",");
            return CMyString.isAllowIP(pAllowIP, ip);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to check the wechat ip.", (Throwable)e);
            return false;
        }
    }
}

