/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.version;

import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.version.IObjSpecialHandler;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.discover.IDiscovery;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ObjSpecialHandlerFactory {
    private static Map<String, IObjSpecialHandler> register;
    private static ObjSpecialHandlerFactory handlerFactory;

    private ObjSpecialHandlerFactory() throws WCMException {
        register = new HashMap<String, IObjSpecialHandler>();
        IDiscovery loggerDiscovery = WCMDiscoveryFactory.getDiscovery();
        Iterator itr = loggerDiscovery.getImplementors(IObjSpecialHandler.class.getName());
        if (itr == null) {
            return;
        }
        while (itr.hasNext()) {
            try {
                String sName = (String)itr.next();
                Class<?> clazz = Class.forName(sName);
                IObjSpecialHandler handler = (IObjSpecialHandler)clazz.newInstance();
                register.put(handler.getCMSObjType(), handler);
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(ObjSpecialHandlerFactory.class, "ObjSpecialHandlerFactory.lable1", "IObjSpecialHandler\u521d\u59cb\u5316\u5f02\u5e38"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjSpecialHandlerFactory getNewInstance() throws WCMException {
        if (handlerFactory != null) return handlerFactory;
        Class<ObjSpecialHandlerFactory> clazz = ObjSpecialHandlerFactory.class;
        synchronized (ObjSpecialHandlerFactory.class) {
            if (null != handlerFactory) return handlerFactory;
            handlerFactory = new ObjSpecialHandlerFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handlerFactory;
        }
    }

    public IObjSpecialHandler getSpecialHandler(Class<? extends CMSObj> clazz) throws WCMException {
        if (register == null || register.size() == 0) {
            throw new WCMException(I18NMessage.get(ObjSpecialHandlerFactory.class, "ObjSpecialHandlerFactory.lable1", "ObjSpecialHandlerFactory\u7c7b\u521d\u59cb\u5316\u5f02\u5e38"));
        }
        IObjSpecialHandler converter = register.get(clazz.getName());
        if (converter == null) {
            return register.get(CMSObj.class.getName());
        }
        return converter;
    }

    static {
        handlerFactory = null;
    }
}

