/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser.formater;

import com.trs.components.common.publish.domain.tagparser.ITagFormatter;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.List;

public abstract class WCMTagFormatterDocumentsBase
implements ITagFormatter {
    protected static final String[] IMPART_ATTRIBUTE_NAMES = new String[]{"TARGET", "LINKTEXT", "EXTRA"};
    protected static final String[] REMOVE_ATTRIBUTE_NAMES = new String[]{"TARGET", "LINKTEXT", "EXTRA", "TYPE", "TRS_OUTLINE_DESC", "ICON", "ICO", "ALINK", "AUTOLINK"};

    @Override
    public void standardize(TagItem _item) throws WCMException {
        if (!_item.getBooleanAttribute("AUTOLINK", true)) {
            this.removeAutoLink(_item);
        } else {
            this.impartLinkAttributes(_item);
        }
        for (int i = 0; i < REMOVE_ATTRIBUTE_NAMES.length; ++i) {
            _item.removeAttribute(REMOVE_ATTRIBUTE_NAMES[i]);
        }
        String sParent = _item.getAttribute("PARENT");
        if (_item.getAttribute("ID") == null && sParent != null) {
            _item.setAttribute("ID", sParent);
            _item.removeAttribute("PARENT");
        }
        this.standardizeSelf(_item);
    }

    protected abstract void standardizeSelf(TagItem var1) throws WCMException;

    private void removeAutoLink(TagItem _parentItem) throws WCMException {
        List children = _parentItem.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        boolean bContainsRecordTag = _parentItem.containsChild("TRS_RECORD");
        if (bContainsRecordTag) {
            for (int i = 0; i < children.size(); ++i) {
                TagItem record;
                Object child = children.get(i);
                if (!(child instanceof TagItem) || !(record = (TagItem)child).getName().equalsIgnoreCase("TRS_RECORD")) continue;
                this.removeAutoLink(record.getChildren());
            }
        } else {
            this.removeAutoLink(children);
        }
    }

    private void removeAutoLink(List _children) throws WCMException {
        List children = _children;
        if (children == null || children.isEmpty()) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            Object child = children.get(i);
            if (!(child instanceof TagItem)) continue;
            TagItem item = (TagItem)child;
            String sField = item.getAttribute("FIELD");
            if (sField == null || (sField = sField.trim()).length() <= 0) {
                sField = item.getAttribute("ID");
            }
            if (!"DOCTITLE".equalsIgnoreCase(sField) || item.getAttribute("AUTOLINK") != null) continue;
            item.setAttribute("AUTOLINK", false);
        }
    }

    private void impartLinkAttributes(TagItem _parentItem) throws WCMException {
        List children = _parentItem.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        boolean bContainsRecordTag = _parentItem.containsChild("TRS_RECORD");
        if (bContainsRecordTag) {
            for (int i = 0; i < children.size(); ++i) {
                TagItem record;
                Object child = children.get(i);
                if (!(child instanceof TagItem) || !(record = (TagItem)child).getName().equalsIgnoreCase("TRS_RECORD")) continue;
                this.impartLinkAttributes(_parentItem, record.getChildren());
            }
        } else {
            this.impartLinkAttributes(_parentItem, children);
        }
    }

    private void impartLinkAttributes(TagItem _parentItem, List _children) throws WCMException {
        List children = _children;
        if (children == null || children.isEmpty()) {
            return;
        }
        boolean bDocTitleIsLink = false;
        String sAlink = _parentItem.getAttribute("ALINK");
        if (sAlink == null || (sAlink = sAlink.trim().toUpperCase()).length() == 0 || sAlink.equals("DOCTITLE")) {
            sAlink = "DOCTITLE";
            bDocTitleIsLink = true;
        }
        for (int i = 0; i < children.size(); ++i) {
            TagItem item;
            Object child = children.get(i);
            if (!(child instanceof TagItem) || !(item = (TagItem)child).getBooleanAttribute("AUTOLINK", true) || !item.getName().equalsIgnoreCase("TRS_COLUMN") && !item.getName().equalsIgnoreCase("TRS_DOCUMENT")) continue;
            String sFieldName = item.getAttribute("ID");
            if (sFieldName == null || sFieldName.length() <= 0) {
                sFieldName = item.getAttribute("FIELD");
            }
            if (sFieldName == null || sFieldName.length() <= 0) {
                sFieldName = "DOCID";
            }
            if (bDocTitleIsLink) {
                if (!sFieldName.equalsIgnoreCase("DOCTITLE")) {
                    continue;
                }
            } else {
                if (sFieldName.equalsIgnoreCase("DOCTITLE")) {
                    if (item.getBooleanAttribute("AUTOLINK", false)) continue;
                    item.setAttribute("AUTOLINK", false);
                    continue;
                }
                if (!sAlink.equalsIgnoreCase(sFieldName)) continue;
            }
            if (_parentItem.getBooleanAttribute("AUTOLINK", true)) {
                item.setAttribute("AUTOLINK", true);
            }
            for (int j = 0; j < IMPART_ATTRIBUTE_NAMES.length; ++j) {
                String attr = IMPART_ATTRIBUTE_NAMES[j];
                String value = item.getAttribute(attr);
                if (!CMyString.isEmpty(value) || CMyString.isEmpty(value = _parentItem.getAttribute(attr))) continue;
                item.setAttribute(IMPART_ATTRIBUTE_NAMES[j], value);
            }
        }
    }
}

