/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.publish.PublishContentViewDataImpl;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import com.trs.infra.util.html.HtmlUtil;
import com.trs.infra.util.image.CMyImage;
import com.trs.infra.util.store.FileService;
import com.trs.presentation.plugin.PluginConfig;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.impl.ImageMagickCmd;
import com.trs.wcm.photo.impl.MagicImageImpl;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class XWCMImageAppendixTagParser
implements ITagParser {
    private static Logger logger = Logger.getLogger(XWCMImageAppendixTagParser.class);
    private static NamesRegister s_oAppendixTypeRegister = new NamesRegister();
    private Document m_oDocument = null;
    private TagItem m_tagItem = null;
    private static TagBeanInfo s_TagBeanInfo;
    private static int n_maxRepeatTimes;

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder arg0) throws WCMException {
        return null;
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_PHOTO");
            tbi.setDesc("TRS_PHOTO");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("INDEX");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("WIDTH");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("HEIGHT");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("EXTRA");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TARGET");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("_blank");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("LINKTEXT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("UrlIsAbs");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOLINK");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
        }
        return s_TagBeanInfo;
    }

    private AppendixMgr getAppMgr() {
        return (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_tagItem = _item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String compressImageFile(String _sCompressImageFullpath, PublishTagContext _context) throws Exception {
        int height;
        int width;
        if (!CMyFile.fileExists(_sCompressImageFullpath)) {
            return null;
        }
        int nTagHeight = _context.getAttribute("HEIGHT", 0);
        int nTagWidth = _context.getAttribute("WIDTH", 0);
        String newImage = null;
        String sSrcFileExt = CMyFile.extractFileExt(_sCompressImageFullpath);
        FileService compressFile = new FileService(_sCompressImageFullpath);
        int[] size = CMyImage.getImageSize(_sCompressImageFullpath);
        int nSrcWidth = size[0];
        int nSrcHeight = size[1];
        if (nTagWidth > 0 && nTagHeight > 0) {
            width = nTagWidth;
            height = width * nSrcHeight / nSrcWidth;
        } else if (nTagHeight <= 0 && nTagWidth > 0) {
            width = nTagWidth;
            height = width * nSrcHeight / nSrcWidth;
        } else if (nTagWidth <= 0 && nTagHeight > 0) {
            height = nTagHeight;
            width = height * nSrcWidth / nSrcHeight;
        } else {
            height = nSrcHeight;
            width = nSrcWidth;
        }
        IImageLibConfig m_libConf = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        String fn = CMyFile.extractFileName(_sCompressImageFullpath);
        if (m_libConf.isCmdUsed()) {
            ImageMagickCmd.ImageObj srcimg = new ImageMagickCmd.ImageObj();
            srcimg.setFilename(fn);
            FilesMan fileman = FilesMan.getFilesMan();
            String filename = fileman.getNextFileName("W0", CMyFile.extractFileExt(srcimg.filename), CMyDateTime.now(), true);
            ImageMagickCmd.ImageObj dstimg = new ImageMagickCmd.ImageObj(filename, width, height);
            ImageMagickCmd.scale(srcimg, dstimg);
            return dstimg.filename;
        }
        if (PluginConfig.isStartPhoto()) {
            MagicImageImpl oMagicImage = new MagicImageImpl();
            oMagicImage.initMagicImage(fn);
            oMagicImage.scaleImage(width, height);
            String result = oMagicImage.writeImageToSystemTemp();
            return result;
        }
        BufferedImage srcFile = ImageIO.read(compressFile.getInputStream());
        String sTagHeight = height + "";
        String sTagWidth = width + "";
        String sFileFullPathBeforePoint = _sCompressImageFullpath.substring(0, _sCompressImageFullpath.length() - sSrcFileExt.length() - 1);
        newImage = sFileFullPathBeforePoint + "_" + sTagWidth + "_" + sTagHeight + ".jpg";
        if (CMyFile.fileExists(newImage) && new FileService(newImage).length() > 10L) {
            return newImage;
        }
        BufferedImage bImage = new BufferedImage(width, height, 1);
        bImage.getGraphics().drawImage(srcFile, 0, 0, width, height, null);
        OutputStream out = null;
        for (int i = 0; i < n_maxRepeatTimes; ++i) {
            try {
                out = new FileService(newImage).getOutputStream();
                ImageIO.write((RenderedImage)bImage, CMyFile.extractFileExt(newImage), out);
                FileService file = new FileService(newImage);
                if (file.length() <= 20L) continue;
                if (out == null) break;
                out.close();
                break;
            }
            catch (Throwable e) {
                if (i == n_maxRepeatTimes - 1) {
                    throw new WCMException("Compress image failed [DOCID=" + this.m_oDocument.getDocId() + ",DOCTITLE=" + this.m_oDocument.getTitle() + "]", e);
                }
                Thread.sleep(30L);
                continue;
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        return newImage;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        this.m_oDocument = this.getDocument(_context);
        if (this.m_oDocument == null) {
            logger.debug((Object)("Document that contants tag named TRS_PHOTO  is null[CHANNELID=" + this.m_oDocument.getChannelId() + ",DOCID=" + this.m_oDocument.getId() + ", DOCTITLE=" + this.m_oDocument.getTitle() + "]"));
            return null;
        }
        int nAppType = 20;
        int nIndex = _context.getAttribute("INDEX", 0);
        Appendixes aApps = this.getAllAppendixes(_context, nAppType);
        if (aApps == null || aApps.size() == 0) {
            return null;
        }
        Appendix appendix = null;
        if (nIndex == -1) {
            String[] arrResult = new String[aApps.size()];
            for (int i = 1; i <= aApps.size(); ++i) {
                appendix = this.findAppendix(aApps, i);
                arrResult[i - 1] = this.parseAppendix(appendix, _context);
            }
            return arrResult;
        }
        appendix = this.findAppendix(aApps, nIndex);
        return new String[]{this.parseAppendix(appendix, _context)};
    }

    private String parseAppendix(Appendix appendix, PublishTagContext _context) throws WCMException {
        String sZipFilePathName;
        String sSrcPathName = this.findSrcPathName(appendix);
        IPublishElement upperHost = _context.getUpperHost();
        String sErrorInfo = "[DOCTITLE=" + this.m_oDocument.getTitle() + ",DOCID=" + this.m_oDocument.getId() + "\uff0cAPPENDIXID=" + appendix.getId() + "]";
        if (!CMyFile.fileExists(sSrcPathName)) {
            throw new WCMException("The uploaded file is not exist on the server " + sErrorInfo);
        }
        if (!XWCMImageAppendixTagParser.isValidImage(sSrcPathName)) {
            throw new WCMException("Not available image" + sErrorInfo);
        }
        try {
            sZipFilePathName = this.compressImageFile(sSrcPathName, _context);
        }
        catch (Exception e) {
            throw new WCMException("Exception caused when compressing image " + sErrorInfo, e);
        }
        String sZipImageName = CMyFile.extractFileName(sZipFilePathName);
        this.distributeImageFile(_context, upperHost, sZipImageName);
        String sField = _context.getAttribute("FIELD");
        if ("_RECURL".equalsIgnoreCase(sField)) {
            String sURL = XWCMImageAppendixTagParser.getApdHttpPath(_context) + sZipImageName;
            if (!_context.getAttribute("UrlIsAbs", false)) {
                sURL = HtmlUtil.calRelativePath(sURL, _context.getPageHttpPath());
            }
            return sURL;
        }
        PublishPathCompass compass = _context.getPathCompass();
        String sRelativeImageURL = HtmlUtil.calRelativePath(compass.getAbsoluteHttpPath(upperHost), _context.getPageHttpPath()) + sZipImageName;
        Document docuemnt = (Document)upperHost.getSubstance();
        String sImageDesc = docuemnt.getTitle();
        String sExtra = _context.getAttribute("EXTRA");
        String sResult = HtmlUtil.renderImage(sRelativeImageURL, sImageDesc, sExtra, null, null);
        if (_context.getAttribute("AUTOLINK", false)) {
            sResult = XWCMImageAppendixTagParser.addAutoLink(sResult, _context);
        }
        return sResult;
    }

    protected static String getApdHttpPath(PublishTagContext _context) throws WCMException {
        IPublishElement apdOwner = _context.getUpperHost();
        PublishPathCompass compass = _context.getPathCompass();
        return compass.getAbsoluteHttpPath(apdOwner);
    }

    private Appendix findAppendix(Appendixes aApps, int index) throws WCMException {
        if (index <= 0 || index > aApps.size()) {
            Appendix appendix = (Appendix)aApps.getAt(0);
            return appendix;
        }
        if (index > 0 && index <= aApps.size()) {
            return (Appendix)aApps.getAt(index - 1);
        }
        throw new WCMException("Your index setted is beyond the sum of images the document contants [CHANNELID=" + this.m_oDocument.getChannelId() + ",DOCID=" + this.m_oDocument.getId() + ",DOCTITLE=" + this.m_oDocument.getTitle() + "]");
    }

    protected static String addAutoLink(String _sValue, PublishTagContext _context) throws WCMException {
        String sTarget = _context.getAttribute("TARGET");
        String sExtra = "";
        String sLinkText = _context.getAttribute("LINKTEXT");
        String sAltText = null;
        String sUrl = XWCMImageAppendixTagParser.getAutoLinkUrl(_context);
        if (!_context.getUpperHost().isLink()) {
            sUrl = HtmlUtil.calRelativePath(sUrl, _context.getPageHttpPath());
        }
        return HtmlUtil.renderLink(sUrl, sTarget, sAltText, sExtra, _sValue, sLinkText);
    }

    protected static String getAutoLinkUrl(PublishTagContext _context) throws WCMException {
        IPublishElement element = _context.getUpperHost();
        IPublishContent content = (IPublishContent)element;
        PublishPathCompass compass = _context.getPathCompass();
        switch (content.getBodyType()) {
            case 40: {
                String sFileName = content.getFileName();
                return compass.getAbsoluteHttpPath(_context.getUpperHost()) + sFileName;
            }
            case 30: {
                return content.getLinkUrl();
            }
        }
        return compass.getHttpUrl((IPublishContent)_context.getUpperHost(), 0);
    }

    private void distributeImageFile(PublishTagContext _context, IPublishElement _upperHost, String _imageFile) throws WCMException {
        String sFileName = _imageFile;
        String sSrcFilePathName = FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName;
        if (!CMyFile.fileExists(sSrcFilePathName)) {
            _context.addWarning(_upperHost.getInfo() + "-image ", _upperHost.getId(), "Can't find image [" + sFileName + "]which belongs to(" + _upperHost.getInfo() + ")");
        }
        PublishPathCompass compass = _context.getPathCompass();
        boolean bPreview = _context.isPreview();
        String sLocalPath = CMyString.setStrEndWith(compass.getLocalPath(_upperHost, bPreview), File.separatorChar);
        PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
        if (CMyFile.fileExists(sLocalPath + sFileName)) {
            return;
        }
        for (int i = 0; i < n_maxRepeatTimes; ++i) {
            try {
                CMyFile.copyFile(sSrcFilePathName, sLocalPath + sFileName);
                if (new FileService(sSrcFilePathName).length() != new FileService(sLocalPath + sFileName).length()) continue;
                break;
            }
            catch (Throwable e) {
                if (i == n_maxRepeatTimes - 1) {
                    throw new WCMException("Exception caused at upperHost(" + _upperHost.getInfo() + ") when copying image [" + sFileName + "]", e);
                }
                try {
                    Thread.sleep(30L);
                    continue;
                }
                catch (InterruptedException e1) {
                    throw new WCMException("Interrupt Exception!", e1);
                }
            }
        }
        if (!bPreview) {
            _context.getFileDistributeShip().distributeFile(sSrcFilePathName, _upperHost);
        }
    }

    private String findSrcPathName(Appendix appendix) throws WCMException {
        String sSrcFilePathName = "";
        String sFileName = appendix.getFile();
        if (sFileName == null || sFileName.length() == 0) {
            return null;
        }
        sSrcFilePathName = FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName;
        return sSrcFilePathName;
    }

    private Appendixes getAllAppendixes(PublishTagContext _context, int nAppType) throws WCMException {
        String sRelatedColumn = _context.getAttribute("RELATEDCOLUMN");
        boolean bRelated = !CMyString.isEmpty(sRelatedColumn);
        Appendixes aApps = this.getAppMgr().getAppendixes(this.m_oDocument, nAppType);
        if (bRelated) {
            for (int n = aApps.size() - 1; n >= 0; --n) {
                Appendix appendix = (Appendix)aApps.getAt(n);
                if (appendix == null || sRelatedColumn.equals(appendix.getRelatedColumn())) continue;
                aApps.remove(appendix);
            }
        }
        return aApps;
    }

    private Document getDocument(PublishTagContext _context) throws WCMException {
        IPublishElement oElement = _context.getUpperHost();
        if (oElement instanceof PublishContentDocumentImpl) {
            return (Document)oElement.getSubstance();
        }
        if (oElement instanceof PublishContentViewDataImpl) {
            MetaViewData oViewData = (MetaViewData)oElement.getSubstance();
            return oViewData.getDocument();
        }
        return null;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
        if (this.m_oDocument != null) {
            this.m_oDocument = null;
        }
    }

    private static boolean isValidImage(String _sFileName) {
        int[] size = CMyImage.getImageSize(_sFileName);
        return size[0] >= 0 && size[1] >= 0;
    }

    static {
        s_oAppendixTypeRegister.register("LINK", 40);
        s_oAppendixTypeRegister.register("FILE", 10);
        s_oAppendixTypeRegister.register("PIC", 20);
        s_oAppendixTypeRegister.register("ALL", 60);
        s_TagBeanInfo = null;
        n_maxRepeatTimes = 5;
    }
}

