/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.region;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.publish.region.CellInfo;
import com.trs.components.wcm.publish.region.CellInfos;
import com.trs.components.wcm.publish.region.RegionEmploy;
import com.trs.components.wcm.publish.region.RegionEmployMgr;
import com.trs.components.wcm.publish.region.RegionEmploys;
import com.trs.components.wcm.publish.region.RegionInfo;
import com.trs.infra.common.WCMException;
import com.trs.webframework.config.ServiceListenerConfig;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IServiceListener;
import java.util.List;
import org.apache.log4j.Logger;

public class CellsSaveListenerForPublish
implements IServiceListener {
    private static Logger s_logger = Logger.getLogger(CellsSaveListenerForPublish.class);

    @Override
    public void afterServiceExecuted(ServiceListenerConfig listenerConfig, MethodContext methodContext, Object serviceResult) {
        int nRegionInfoId = methodContext.getValue("RegionInfoId", 0);
        boolean bPublish = methodContext.getValue("BPublish", false);
        User loginUser = ContextHelper.getLoginUser();
        RegionInfo regionInfo = null;
        try {
            CellInfos currCellInfos;
            int[] types;
            regionInfo = RegionInfo.findById(nRegionInfoId);
            if (regionInfo == null) {
                return;
            }
            int nRegionId = regionInfo.getId();
            RegionEmployMgr regionEmployMgr = (RegionEmployMgr)DreamFactory.createObjectById("RegionEmployMgr");
            RegionEmploys oRegionEmploys = regionEmployMgr.getRegionEmploysByRegionAndType(nRegionId, types = new int[]{605, 101, 601});
            if (oRegionEmploys != null) {
                oRegionEmploys.removeAll(true);
            }
            if ((currCellInfos = CellInfos.findCellInfos(regionInfo, null, loginUser)) != null) {
                for (int i = 0; i < currCellInfos.size(); ++i) {
                    CellInfo oCellInfo = (CellInfo)currCellInfos.getAt(i);
                    if (oCellInfo == null) continue;
                    int nChannelId = oCellInfo.getChnlId();
                    int nDocId = oCellInfo.getDocId();
                    int nAppendixId = oCellInfo.getAppendixId();
                    RegionEmploy oRegionEmploy = new RegionEmploy();
                    if (nChannelId > 0) {
                        oRegionEmploy.setObjId(nChannelId);
                        oRegionEmploy.setObjType(101);
                        oRegionEmploy.setRegionId(nRegionId);
                    } else {
                        if (nDocId <= 0) continue;
                        oRegionEmploy.setObjId(nDocId);
                        oRegionEmploy.setObjType(605);
                        oRegionEmploy.setRegionId(nRegionId);
                        if (nAppendixId > 0) {
                            RegionEmploy oNewRegionEmploy = new RegionEmploy();
                            oNewRegionEmploy.setObjId(nAppendixId);
                            oNewRegionEmploy.setObjType(601);
                            oNewRegionEmploy.setRegionId(nRegionId);
                            oNewRegionEmploy.save(loginUser);
                        }
                    }
                    oRegionEmploy.save(loginUser);
                }
            }
            if (!bPublish) {
                return;
            }
            int[] temType = new int[]{102};
            RegionEmploys oTemplateRegionEmploys = regionEmployMgr.getRegionEmploysByRegionAndType(nRegionId, temType);
            if (oTemplateRegionEmploys == null) {
                return;
            }
            TemplateEmployMgr templateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
            for (int m = 0; m < oTemplateRegionEmploys.size(); ++m) {
                List employers;
                int nTemplateId;
                Template oTemplate;
                RegionEmploy oTemRegionEmploy = (RegionEmploy)oTemplateRegionEmploys.getAt(m);
                if (oTemRegionEmploy == null || (oTemplate = Template.findById(nTemplateId = oTemRegionEmploy.getObjId())) == null || (employers = templateEmployMgr.getEmployers(oTemplate, null)) == null) continue;
                for (int k = 0; k < employers.size(); ++k) {
                    int nRightIndex;
                    IPublishElement content = (IPublishElement)employers.get(k);
                    if (content == null) continue;
                    int type = content.getType();
                    int n = nRightIndex = type == 103 ? 5 : 17;
                    if (!AuthServer.hasRight(ContextHelper.getLoginUser(), content.getSubstance(), nRightIndex)) {
                        s_logger.debug((Object)("\u7528\u6237" + ContextHelper.getLoginUser() + "\u6ca1\u6709\u6743\u9650\u53d1\u5e03\uff1a" + content.getSubstance()));
                        continue;
                    }
                    IPublishFolder folder = content.getFolder();
                    if (!folder.canDoOutlinePageTask()) continue;
                    PublishServer oPublishServer = PublishServer.getInstance();
                    oPublishServer.publishFolder((IPublishFolder)content, 8);
                }
            }
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
    }
}

