/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.HTMLContent;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.XmlToDocumentConverter;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.epress.EPressConf;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EPressImporter {
    private static final String PATTERN_HTML = "<{1}[^>]{1,}>{1}";
    protected XmlToDocumentConverter m_converter;
    private Map m_currChannels = null;
    private static Logger s_logger = Logger.getLogger(EPressImporter.class);
    private static final String CHILD_TAG_APPENDIXES = "WCMAPPENDIXS";
    private DocumentMgr m_documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    private static String[] HTML_TAG_NAMES;
    private static String[] HTML_TAG_SRCS;

    public EPressImporter() {
        this.m_converter = new XmlToDocumentConverter(1);
        this.m_converter.registPersistentObj("WCMDOCUMENT", Document.class);
        this.m_converter.registPersistentObj("WCMAPPENDIX", Appendix.class);
    }

    public void importDocuments(String _dataZipFile) throws WCMException {
        this.importDocuments(_dataZipFile, "");
    }

    public void importDocuments(String _dataZipFile, Channel _channel) throws WCMException {
        if (_channel == null) {
            throw new WCMException("\u65e0\u6548\u7684\u7535\u5b50\u62a5\u9891\u9053[null]!");
        }
        int nId = _channel.getId();
        this.m_currChannels = EPressConf.instance().getChannels(nId);
        if (this.m_currChannels == null) {
            throw new WCMException("\u65e0\u6548\u7684\u7535\u5b50\u62a5\u9891\u9053" + _channel + "!");
        }
        this.importData(_dataZipFile);
    }

    public void importDocuments(String _dataZipFile, String _epressKey) throws WCMException {
        this.m_currChannels = EPressConf.instance().getChannels(_epressKey);
        if (this.m_currChannels == null) {
            throw new WCMException("\u65e0\u6548\u7684\u7535\u5b50\u62a5\u9891\u9053\u6807\u8bc6[key=" + _epressKey + "]!");
        }
        this.importData(_dataZipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importData(String _dataZipFile) throws WCMException {
        String fn = this.getFullFileName(_dataZipFile);
        String temp = CMyFile.extractFilePath(fn) + "uziptemp";
        temp = temp + CMyFile.extractMainFileName(fn);
        String unzippath = temp + File.separator;
        CMyUnZipFile uzf = new CMyUnZipFile(fn, unzippath);
        boolean unzipOK = false;
        try {
            uzf.addFileExtFilters("xml");
            uzf.doUnZipAnd();
            unzipOK = true;
        }
        catch (CMyException e) {
            throw new WCMException(200, "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25!", e);
        }
        finally {
            if (unzipOK) {
                CMyFile.deleteFile(fn);
            }
        }
        try {
            ArrayList xmlFiles = uzf.getFilteredFiles();
            if (xmlFiles == null || xmlFiles.isEmpty()) {
                throw new WCMException(10, "\u6ca1\u6709\u6709\u6548\u7684XML\u6570\u636e\u6587\u4ef6.");
            }
            String xmlFile = null;
            XmlObject[] xmlData = null;
            if (xmlFiles != null && xmlFiles.size() > 0) {
                int size = xmlFiles.size();
                for (int i = 0; i < size; ++i) {
                    xmlFile = (String)xmlFiles.get(i);
                    if (xmlFile == null) continue;
                    xmlData = this.m_converter.convertXml(xmlFile, null, null);
                    this.importData0(xmlData, CMyFile.extractFilePath(xmlFile));
                }
            }
        }
        finally {
            uzf = null;
            CMyFile.deleteDir(unzippath);
        }
    }

    private void importData0(XmlObject[] _data, String _path) throws WCMException {
        XmlObject xmlObj = null;
        Document documentNew = null;
        User user = this.getLoginUser();
        ContextHelper.initContext(user);
        String pageNum = "";
        String publishDate = "";
        Object channelKey = null;
        Channel oldChannel = null;
        String cruser = null;
        String docTitle = null;
        for (int i = _data.length - 1; i >= 0; --i) {
            xmlObj = _data[i];
            documentNew = (Document)xmlObj.getCurrentObj();
            if (CMyString.isEmpty(pageNum) && CMyString.isEmpty(pageNum = documentNew.getPropertyAsString("PageNum"))) {
                throw new WCMException(10, "\u6ca1\u6709\u8bbe\u5b9a\u65b0\u95fb\u6240\u5c5e\u7248\u6b21");
            }
            docTitle = documentNew.getTitle();
            if (CMyString.isEmpty(docTitle)) {
                throw new WCMException(10, "\u6ca1\u6709\u8bbe\u5b9a\u65b0\u95fb\u6807\u9898");
            }
            oldChannel = documentNew.getChannel();
            if (oldChannel == null) {
                pageNum = pageNum.trim();
                documentNew.setProperty("PageNum", pageNum);
                if (pageNum.startsWith("0")) {
                    pageNum = Integer.valueOf(pageNum).toString();
                }
                if (this.m_currChannels != null) {
                    channelKey = this.m_currChannels.get(pageNum);
                }
                if (channelKey == null) {
                    throw new WCMException(1106, "\u6ca1\u6709\u8fd9\u4e2a\u7248\u9762[" + pageNum + "]");
                }
                documentNew.setProperty("DOCCHANNEL", channelKey);
                if (CMyString.isEmpty(publishDate)) {
                    publishDate = documentNew.getPropertyAsString("PUBLISHDATE");
                }
                publishDate = CMyString.isEmpty(publishDate) ? CMyDateTime.now().toString("yyyy.MM.dd") : this.makePubDate(publishDate);
                documentNew.setProperty("Publishdate", publishDate);
            }
            if ((cruser = documentNew.getCrUserName()) == null || User.findByName(cruser) == null) {
                cruser = "system";
            }
            documentNew.setProperty("CRUSER", cruser);
            documentNew.setProperty("CrTime", CMyDateTime.now());
            documentNew.removeProperty("DOCPUBTIME");
            documentNew = this.processHtmlContent(documentNew, _path);
            documentNew = this.updateIfExists(documentNew);
            this.m_documentMgr.save(documentNew);
            this.processAppendix(xmlObj, documentNew.getId(), _path);
        }
    }

    private Document updateIfExists(Document document) {
        int nChnlId = document.getChannelId();
        String sTitle = document.getTitle();
        String sPubDate = document.getPropertyAsString("PUBLISHDATE");
        WCMFilter filter = new WCMFilter("", "DOCCHANNEL=? and DOCTITLE=? and PUBLISHDATE=?", "", "DOCID");
        filter.addSearchValues(nChnlId);
        filter.addSearchValues(sTitle);
        filter.addSearchValues(sPubDate);
        filter.setMaxRowNumber(1);
        Documents documents = new Documents(this.getLoginUser());
        try {
            documents.open(filter);
            if (documents.isEmpty()) {
                return document;
            }
            Document doc = (Document)documents.getAt(0);
            doc.setProperties(document.getProperties());
            return doc;
        }
        catch (WCMException e) {
            return document;
        }
    }

    private String makePubDate(String publishDate) throws WCMException {
        StringBuffer buff = new StringBuffer(64);
        String[] parts = publishDate.split("\\.");
        if (parts.length != 3) {
            buff.append("\u65e0\u6548\u7684\u65e5\u671f[");
            buff.append(publishDate);
            buff.append("].\u53ef\u80fd\u662f\u683c\u5f0f\u4e0d\u6b63\u786e,\u8981\u6c42\u7684\u683c\u5f0f\u662f[yyyy.MM.dd]!");
            throw new WCMException(buff.toString());
        }
        int year = 0;
        int month = 0;
        int day = 0;
        boolean zVliad = false;
        try {
            year = Integer.parseInt(parts[0]);
            month = Integer.parseInt(parts[1]);
            day = Integer.parseInt(parts[2]);
            zVliad = year >= 1 && month >= 1 && month <= 12 && day >= 1 && day <= 31;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (zVliad) {
            if (month == 2) {
                zVliad = year % 400 == 0 || year % 4 == 0 && year % 100 != 0 ? day <= 29 : day <= 28;
            } else if ((month & 1) == 1) {
                zVliad = month < 8 && day <= 31 || month >= 8 && day <= 30;
            } else {
                boolean bl = zVliad = month >= 8 && day <= 31 || month < 8 && day <= 30;
            }
        }
        if (!zVliad) {
            buff.append("\u65e0\u6548\u7684\u65e5\u671f[");
            buff.append(publishDate);
            buff.append("]!");
            throw new WCMException(buff.toString());
        }
        buff.append(year);
        buff.append('.');
        if (month < 10) {
            buff.append('0');
        }
        buff.append(month);
        buff.append('.');
        if (day < 10) {
            buff.append('0');
        }
        buff.append(day);
        return buff.toString();
    }

    private Document processHtmlContent(Document _document, String _sUnZipFile) {
        if (20 != _document.getType()) {
            return _document;
        }
        String sHtmlContent = _document.getHtmlContent();
        if (sHtmlContent == null || sHtmlContent.length() == 0) {
            return _document;
        }
        try {
            HashMap mapApdFiles = this.getPicFiles(_document, _sUnZipFile);
            sHtmlContent = HTMLContent.saveHTMLContentFromOut(sHtmlContent, mapApdFiles);
            _document.setHtmlContent(sHtmlContent);
            sHtmlContent = sHtmlContent.replaceAll("<br>", "\n\r");
            _document.setContent(sHtmlContent.replaceAll(PATTERN_HTML, ""));
        }
        catch (WCMException e) {
            s_logger.warn((Object)"process htmlcon with exception.", (Throwable)e);
        }
        return _document;
    }

    private HashMap getPicFiles(Document _document, String _sUnZipFile) throws WCMException {
        HashMap<String, String> mapApdFiles = new HashMap<String, String>();
        String[] tags = this.getTagNames();
        if (tags == null) {
            return mapApdFiles;
        }
        String[] srcattrs = this.getTagAttrsrcNames();
        String htmlcon = _document.getHtmlContent();
        HtmlElementFinder finder = null;
        HtmlElement element = null;
        try {
            int nTagsLen = tags.length;
            int nAttrsLen = srcattrs.length;
            for (int index = 0; index < nTagsLen && index < nAttrsLen; ++index) {
                String tagname = tags[index];
                String attrname = srcattrs[index];
                finder = new HtmlElementFinder(htmlcon);
                while ((element = finder.findNextElement(tagname, true)) != null) {
                    String attrvalue = element.getAttributeValue(attrname);
                    if (attrvalue == null || attrvalue.trim().length() == 0) continue;
                    if (File.separatorChar != '/') {
                        attrvalue = attrvalue.replace('/', File.separatorChar);
                    }
                    attrvalue = CMyFile.extractFileName(attrvalue);
                    mapApdFiles.put(attrvalue.toLowerCase(), _sUnZipFile + attrvalue);
                }
            }
            return mapApdFiles;
        }
        catch (Exception e) {
            throw new WCMException(1100, "\u83b7\u53d6\u6b63\u6587\u4e2d\u9700\u8981\u5904\u7406\u7684\u7f6e\u6807\u8d44\u6e90\u5931\u8d25!", e);
        }
    }

    private String[] getTagNames() {
        if (HTML_TAG_NAMES != null) {
            return HTML_TAG_NAMES;
        }
        ConfigServer configServer = ConfigServer.getServer();
        String sTagNames = configServer.getInitProperty("DOC_HTML_TAG_NAMES");
        if (sTagNames == null || sTagNames.length() == 0) {
            return null;
        }
        try {
            HTML_TAG_NAMES = CMyString.split(sTagNames, ",");
        }
        catch (Exception ex) {
            HTML_TAG_NAMES = null;
        }
        return HTML_TAG_NAMES;
    }

    private String[] getTagAttrsrcNames() {
        if (HTML_TAG_SRCS != null) {
            return HTML_TAG_SRCS;
        }
        ConfigServer configServer = ConfigServer.getServer();
        String sTagSrcs = configServer.getInitProperty("DOC_HTML_TAG_SRCS");
        if (sTagSrcs == null || sTagSrcs.length() == 0) {
            return null;
        }
        try {
            HTML_TAG_SRCS = CMyString.split(sTagSrcs, ",");
        }
        catch (Exception ex) {
            HTML_TAG_SRCS = null;
        }
        return HTML_TAG_SRCS;
    }

    private void processAppendix(XmlObject _xmlObj, int _nDocId, String _sUnZipFile) throws WCMException {
        XmlObject[] children = _xmlObj.getChild(CHILD_TAG_APPENDIXES);
        if (children.length == 0) {
            return;
        }
        Appendixes appendixes = new Appendixes(this.getLoginUser());
        WCMFilter filter = new WCMFilter("", "APPDOCID=?", "");
        filter.addSearchValues(_nDocId);
        appendixes.open(filter);
        if (!appendixes.isEmpty()) {
            appendixes.removeAll(true);
        }
        Appendix appendix = null;
        String apdFileNew = null;
        String sPathInfo = null;
        FilesMan filesMan = FilesMan.getFilesMan();
        String sPath = _sUnZipFile;
        User user = this.getLoginUser();
        boolean zAttachPic = false;
        int len = children.length;
        for (int i = 0; i < len; ++i) {
            appendix = (Appendix)children[i].getCurrentObj();
            appendix.setDocId(_nDocId);
            appendix.setUsedByVersion(0, true);
            int nFlag = appendix.getFlag();
            if (nFlag != 40) {
                if (nFlag == 30) continue;
                appendix.setSrcFile(appendix.getFile());
                String strDesc = appendix.getDesc();
                if (strDesc == null || strDesc.length() == 0) {
                    appendix.setDesc(appendix.getFile());
                }
                if (nFlag == 20) {
                    apdFileNew = filesMan.getNextFileName("W0", appendix.getFileExt());
                    zAttachPic = true;
                } else {
                    apdFileNew = filesMan.getNextFileName("P0", appendix.getFileExt());
                }
                sPathInfo = filesMan.mapFilePath(apdFileNew, 0);
                try {
                    CMyFile.copyFile(sPath + appendix.getFile(), sPathInfo + apdFileNew);
                }
                catch (CMyException e) {
                    s_logger.warn((Object)("missing file:" + appendix.getFile()));
                    continue;
                }
                appendix.setFile(apdFileNew);
                if (appendix.getProperty("APPSERN") == null) {
                    appendix.setSerialNo(i + 1);
                }
            }
            appendix.save(user);
        }
        if (zAttachPic) {
            this.setAttachpicFlag(_nDocId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttachpicFlag(int docId) {
        DBManager dbmanager = DBManager.getDBManager();
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "update WCMDOCUMENT set ATTACHPIC=1 where DOCID=?";
        try {
            conn = dbmanager.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, docId);
            pstmt.executeUpdate();
        }
        catch (Exception ex) {
            if (s_logger.isDebugEnabled()) {
                s_logger.error((Object)"set flag fail", (Throwable)ex);
            }
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                dbmanager.freeConnection(conn);
            }
        }
    }

    private User getLoginUser() {
        User user = User.getSystem();
        try {
            user = ContextHelper.getLoginUser();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return user;
    }

    private String getFullFileName(String _fn) throws WCMException {
        String fn = _fn;
        if (!CMyFile.fileExists(_fn)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            String sPath = filesMan.mapFilePath(_fn, 0);
            fn = sPath + _fn;
        }
        return fn;
    }

    public static void main(String[] args) {
    }
}

