/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.trsserver;

import com.eprobiti.trs.TRSConnection;
import com.eprobiti.trs.TRSException;
import com.eprobiti.trs.TRSResultSet;
import com.trs.components.wcm.content.trsserver.DocsFromTRSServer;
import com.trs.components.wcm.content.trsserver.OuterKMTRSServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CPager;
import com.trs.infra.util.DebugTimer;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DatasFromTRSServer {
    private static Logger logger = Logger.getLogger(DocsFromTRSServer.class);
    private static String m_sTRSHost = "";
    private static String m_sTRSPort = "";
    private static String m_sTRSUsername = "";
    private static String m_sTRSPassword = "";
    private static String m_sTRSTABLE = "";
    private static String m_sTRSSELECT = "IR_SID,IR_URLTITLE,IR_URLTIME";
    private static String m_sTRSWHERE = "";
    private static String m_sTRSORDER = "-IR_URLTIME";

    public DatasFromTRSServer() {
        m_sTRSWHERE = "";
        m_sTRSSELECT = "IR_SID,IR_URLTITLE,IR_URLTIME";
        m_sTRSORDER = "-IR_URLTIME";
    }

    public void setSelect(String _select) {
        m_sTRSSELECT = _select;
    }

    public void setWhere(String _where) {
        m_sTRSWHERE = _where;
    }

    public void setOrder(String _order) {
        m_sTRSORDER = _order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDatasFromTRSServer(int _nCurrPage, int _nPageSize) throws WCMException {
        ArrayList<Object> result = new ArrayList<Object>();
        this.configTRS();
        TRSConnection trsConn = null;
        OuterKMTRSServer currServer = null;
        DebugTimer aTimer = new DebugTimer();
        try {
            trsConn = this.getValidConnection(m_sTRSHost, m_sTRSPort, m_sTRSUsername, m_sTRSPassword);
            TRSConnection.setCharset((int)3, (boolean)false);
            if (trsConn == null || trsConn.isClosed()) {
                throw new WCMException(1100, I18NMessage.get(DatasFromTRSServer.class, "DatasFromTRSServer.label2", "\u83b7\u53d6TRS\u8fde\u63a5\u5bf9\u8c61\u5931\u8d25\u5931\u8d25\uff01"));
            }
            aTimer.stop();
        }
        catch (Throwable ex) {
            result.add("1100");
            return result;
        }
        int nRecCount = 0;
        TRSResultSet trsRs = null;
        try {
            aTimer.start();
            trsRs = trsConn.executeSelect(m_sTRSTABLE, m_sTRSWHERE, m_sTRSORDER, "", "", 0, 115, false);
            aTimer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label3", "\u67e5\u8be2TRS\u5e93[") + m_sTRSTABLE + "][" + m_sTRSWHERE + "][" + m_sTRSORDER + I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label4", "]\u6240\u7528\u65f6\u95f4\u4e3a\uff1a") + aTimer.getTime() + I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label5", "\u6beb\u79d2")));
            }
            trsRs.setBufferSize(_nPageSize, _nPageSize);
            trsRs.setReadOptions(115, m_sTRSSELECT, null);
            trsRs.setCutSize(0, true);
            nRecCount = (int)trsRs.getRecordCount();
            if (nRecCount <= 0) {
                ArrayList<Object> arrayList = result;
                return arrayList;
            }
            CPager currPager = new CPager(_nPageSize);
            currPager.setItemCount(nRecCount);
            currPager.setCurrentPageIndex(_nCurrPage);
            int nStartIndex = (currPager.getCurrentPageIndex() - 1) * currPager.getPageSize();
            int nCount = 0;
            for (nCount = 0; nCount < currPager.getFirstItemIndex() - 1; ++nCount) {
                result.add(null);
            }
            try {
                int nExecCount = 0;
                trsRs.moveTo(0, (long)nStartIndex);
                aTimer.start();
                while (nExecCount < currPager.getPageSize()) {
                    ++nExecCount;
                    ++nCount;
                    HashMap<String, String> currMap = new HashMap<String, String>();
                    for (int i = 0; i < m_sTRSSELECT.split(",").length; ++i) {
                        String sTRSFieldValue = trsRs.getString(m_sTRSSELECT.split(",")[i]);
                        currMap.put(m_sTRSSELECT.split(",")[i], sTRSFieldValue);
                    }
                    result.add(currMap);
                    if (nExecCount < _nPageSize && trsRs.moveNext()) continue;
                    break;
                }
            }
            catch (TRSException e) {
                e.printStackTrace();
            }
            aTimer.stop();
            for (int i = nCount; i < nRecCount; ++i) {
                result.add(null);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label6", "\u83b7\u53d6\u6570\u636e\u6240\u7528\u65f6\u95f4\u4e3a\uff1a") + aTimer.getTime() + I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label5", "\u6beb\u79d2")));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (trsRs != null) {
                trsRs.close();
            }
            if (trsConn != null && currServer != null) {
                currServer.freeConnection(trsConn);
            }
        }
        return result;
    }

    private void configTRS() throws WCMException {
        ConfigServer configServer = ConfigServer.getServer();
        m_sTRSHost = configServer.getSysConfigValue("TRSSERVER_HOST", "127.0.0.1");
        m_sTRSPort = configServer.getSysConfigValue("TRSSERVER_PORT", "8888");
        m_sTRSUsername = configServer.getSysConfigValue("TRSSERVER_USER", "system");
        m_sTRSPassword = configServer.getSysConfigValue("TRSSERVER_PWD", "manager");
        m_sTRSTABLE = configServer.getSysConfigValue("TRSSERVER_DB", "AS$1$A$1");
    }

    public Object getDatasFromTRSServer(String _sWhere, int _nCurrPage, int _nPageSize) throws WCMException {
        return this.getDatasFromTRSServer(_nCurrPage, _nPageSize);
    }

    public TRSConnection getValidConnection(String host, String port, String username, String password) throws WCMException {
        OuterKMTRSServer currServer = OuterKMTRSServer.getOuterKMTRSServer(host, port, username, password);
        TRSConnection trsConn = null;
        try {
            trsConn = currServer.getConnection();
        }
        catch (Exception ex) {
            return null;
        }
        return trsConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws WCMException {
        OuterKMTRSServer currServer = OuterKMTRSServer.getOuterKMTRSServer(m_sTRSHost, m_sTRSPort, m_sTRSUsername, m_sTRSPassword);
        if (!currServer.isStarted() && !currServer.isStarting()) {
            return;
        }
        DebugTimer aTimer = new DebugTimer();
        TRSConnection trsConn = currServer.getConnection();
        TRSConnection.setCharset((int)3, (boolean)false);
        if (trsConn == null || trsConn.isClosed()) {
            throw new WCMException(1100, I18NMessage.get(DatasFromTRSServer.class, "DatasFromTRSServer.label2", "\u83b7\u53d6TRS\u8fde\u63a5\u5bf9\u8c61\u5931\u8d25\u5931\u8d25\uff01"));
        }
        aTimer.stop();
        int nRecCount = 0;
        TRSResultSet trsRs = null;
        ArrayList result = new ArrayList();
        try {
            aTimer.start();
            trsRs = trsConn.executeSelect(m_sTRSTABLE, m_sTRSWHERE, m_sTRSORDER, "", "", 0, 115, false);
            aTimer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label3", "\u67e5\u8be2TRS\u5e93[") + m_sTRSTABLE + "][" + m_sTRSWHERE + "][" + m_sTRSORDER + I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label4", "]\u6240\u7528\u65f6\u95f4\u4e3a\uff1a") + aTimer.getTime() + I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label5", "\u6beb\u79d2")));
            }
            trsRs.setBufferSize(20, 20);
            trsRs.setReadOptions(115, m_sTRSSELECT, null);
            trsRs.setCutSize(0, true);
            nRecCount = (int)trsRs.getRecordCount();
            CPager currPager = new CPager(20);
            currPager.setItemCount(nRecCount);
            currPager.setCurrentPageIndex(1);
            int nStartIndex = (currPager.getCurrentPageIndex() - 1) * currPager.getPageSize();
            try {
                int nExecCount = 0;
                trsRs.moveTo(0, (long)nStartIndex);
                aTimer.start();
                while (nExecCount < currPager.getPageSize()) {
                    ++nExecCount;
                    HashMap<String, String> currMap = new HashMap<String, String>();
                    for (int i = 0; i < m_sTRSSELECT.split(",").length; ++i) {
                        String sTRSFieldValue = trsRs.getString(m_sTRSSELECT.split(",")[i]);
                        currMap.put(m_sTRSSELECT.split(",")[i], sTRSFieldValue);
                    }
                    result.add(currMap);
                    if (nExecCount < 20 && trsRs.moveNext()) continue;
                    break;
                }
            }
            catch (TRSException e) {
                e.printStackTrace();
            }
            aTimer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label6", "\u83b7\u53d6\u6570\u636e\u6240\u7528\u65f6\u95f4\u4e3a\uff1a") + aTimer.getTime() + I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label5", "\u6beb\u79d2")));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (trsRs != null) {
                trsRs.close();
            }
            if (trsConn != null) {
                currServer.freeConnection(trsConn);
            }
        }
        for (int k = 0; k < result.size(); ++k) {
            HashMap curr = (HashMap)result.get(k);
            if (curr == null) continue;
            System.out.println("----" + curr.get("IR_URLTIME"));
        }
    }
}

