/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.ajaxservice.DocumentServiceProvider;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.FlowContentFactory;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.engine.FlowContext;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.domain.IDocKeywordMgr;
import com.trs.components.wcm.content.domain.IDocumentsTimeRangeMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.components.wcm.publish.logo.Logo;
import com.trs.components.wcm.publish.logo.Logos;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Report;
import com.trs.infra.util.Reports;
import com.trs.infra.util.database.TableInfo;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class DocumentMgr {
    private static Logger m_oLogger = Logger.getLogger(DocumentMgr.class);
    private static final String CONFIG_COPY_TITLE_PREFIX = "DOC_COPY_TITLE_PRE";
    private IDocKeywordMgr m_oDocKeywordMgr = (IDocKeywordMgr)DreamFactory.createObjectById("IDocKeywordMgr");
    private IDocumentsTimeRangeMgr m_oTimeRangeMgr = (IDocumentsTimeRangeMgr)DreamFactory.createObjectById("IDocumentsTimeRangeMgr");
    private IMetaViewEmployerMgr m_oEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;
    public static final int POSITION_BEFORE = 1;
    public static final int POSITION_AFTER = 0;
    public static final int POSITION_AFTER_NEW = -1;

    private void delete(ChnlDoc _currChnlDoc, boolean _bDrop) throws WCMException {
        if (_currChnlDoc == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label1", "\u9891\u9053\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        if (_bDrop) {
            _currChnlDoc.delete(this.getLoginUser());
        } else if (_currChnlDoc.canEdit(this.getLoginUser())) {
            _currChnlDoc.setDeleted(true);
            _currChnlDoc.setOperUser(this.getLoginUser());
            _currChnlDoc.setOperTime();
            _currChnlDoc.update(this.getLoginUser());
        }
    }

    private void delete(Document _currDocument, boolean _bDrop) throws WCMException {
        if (_currDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label1", "\u9891\u9053\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        if (_bDrop) {
            _currDocument.delete(this.getLoginUser());
        } else if (_currDocument.canEdit(this.getLoginUser())) {
            _currDocument.setDeleted(true);
            _currDocument.update(this.getLoginUser());
        }
    }

    private ChnlDoc moveTo(ChnlDoc _fromChnlDoc, Channel _toChannel) throws WCMException {
        User loginUser = this.getLoginUser();
        if (!_fromChnlDoc.canEdit(loginUser)) {
            throw new WCMException(1013, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label2", "\u5bf9\u8c61\u5df2\u88ab[") + _fromChnlDoc.getLockerUser() + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label3", "]\u9501\u5b9a\uff01"));
        }
        String sql = "SELECT MAX(DocOrder) FROM WCMCHNLDOC WHERE ChnlId=" + _toChannel.getId();
        int nMaxOrder = this.getDBManager().sqlExecuteIntQuery(sql);
        _fromChnlDoc.setDocOrder(nMaxOrder + 1);
        if (!Boolean.parseBoolean(ConfigServer.getServer().getSysConfigValue("DOCUMENT_SETTOP_ALLOW_SWITCH", "false"))) {
            _fromChnlDoc.setDocOrderPri(ChnlDoc.NOT_ON_TOP);
        } else {
            _fromChnlDoc.setDocOrderPri(1);
        }
        _fromChnlDoc.setChannelId(_toChannel.getId());
        _fromChnlDoc.save(loginUser);
        return _fromChnlDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Document _currDocument, Channel _currChannel, boolean _bDrop) throws WCMException {
        if (_currDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label4", "\u6587\u6863\u65e0\u6548\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        Channel currChannel = _currChannel;
        if (currChannel == null) {
            currChannel = _currDocument.getChannel();
        }
        if (currChannel == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label5", "\u9891\u9053\u65e0\u6548\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        boolean bEntiy = _currDocument.getChannelId() == currChannel.getId();
        User user = this.getLoginUser();
        if (bEntiy && _currDocument.isLocked()) {
            throw new WCMException(1013, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label6", "\u6587\u6863[") + _currDocument.getTitle() + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label7", "]\u5df2\u88ab[") + _currDocument.getLockerUser() + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label8", "]\u9501\u5b9a,\u65e0\u6cd5\u5220\u9664!"));
        }
        try {
            if (_bDrop && bEntiy) {
                if (currChannel.getId() == 0) {
                    this.delete(_currDocument, _bDrop);
                } else {
                    this.getChnlDocs(_currDocument.getId(), 0, null).removeAll(true);
                }
            } else if (currChannel.getId() == 0) {
                this.delete(_currDocument, _bDrop);
            } else {
                ChnlDoc delChnlDoc = this.findChnlDoc(_currDocument, currChannel);
                if (delChnlDoc == null) {
                    throw new WCMException(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label9", "\u6ca1\u6709\u627e\u5230\u9884\u5220\u9664\u7684\u9891\u9053\u6587\u6863!") + currChannel + ":" + _currDocument);
                }
                this.delete(delChnlDoc, _bDrop);
            }
        }
        finally {
            if (bEntiy && _currDocument.isLocked() && _currDocument.getLocker().lockUserIs(user)) {
                _currDocument.unlock();
            }
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private boolean isDocumentLink(Document _currDocument, Channel _currChannel) throws WCMException {
        if (_currDocument == null) {
            throw new WCMException(20, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label10", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5224\u65ad\u662f\u5426\u8f6c\u53d1\uff01"));
        }
        if (_currChannel == null || _currChannel.getId() == 0) {
            return false;
        }
        return _currDocument.getChannelId() != _currChannel.getId();
    }

    public ChnlDoc findChnlDoc(Document _currDocument, Channel _currChannel) throws WCMException {
        return ChnlDoc.findByDocAndChnl(_currDocument, _currChannel);
    }

    ChnlDoc createChnlDocWithEntity(Document _document, Channel _channel, boolean _bLinkModle) throws WCMException {
        ChnlDoc newChnldoc = new ChnlDoc();
        if (Document.SYNCHRONIZE_PROPERTIES_TO_CHNLDOC) {
            String sFieldName = null;
            for (int i = 0; i < Document.SYNCHRONIZED_FIELDS.length; ++i) {
                sFieldName = Document.SYNCHRONIZED_FIELDS[i];
                newChnldoc.setProperty(sFieldName, _document.getProperty(sFieldName));
            }
        }
        newChnldoc.setDocId(_document.getId());
        int nChnlId = _document.getChannelId();
        int nModal = 1;
        if (_channel != null && nChnlId != _channel.getId()) {
            int nChnlType = _channel.getType();
            nModal = _bLinkModle || nChnlType == 2 || nChnlType == 1 ? 2 : 3;
            nChnlId = _channel.getId();
        }
        newChnldoc.setModal(nModal);
        newChnldoc.setChannelId(nChnlId);
        int nOrgDocStatusId = _document.getStatusId();
        newChnldoc.setStatusId(_document.getStatusId());
        if (nModal != 1 && (nOrgDocStatusId == 10 || nOrgDocStatusId == 1027)) {
            int nTemp;
            WCMPubStatusConfig config = WCMPubStatusConfig.findOf(103, Channel.findById(nChnlId).getSiteId());
            int nStatusId = 2;
            if (config != null && (nTemp = config.getStatusIdAfterModify()) != 0) {
                nStatusId = nTemp;
            }
            newChnldoc.setStatusId(nStatusId);
        }
        int nSiteId = 0;
        if (_channel != null) {
            nSiteId = _channel.getSiteId();
        }
        newChnldoc.setSiteId(nSiteId);
        String sSql = "SELECT MAX(DOCORDER) FROM WCMCHNLDOC WHERE ChnlId=" + nChnlId;
        int nDocOrder = this.getDBManager().sqlExecuteIntQuery(sSql);
        newChnldoc.setDocOrder(++nDocOrder);
        return newChnldoc;
    }

    private Report transmitTo(Document _currDocument, Channel _toChannel, boolean _bIsLink) throws WCMException {
        return this.transmitTo(_currDocument, null, _toChannel, _bIsLink, "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Report transmitTo(Document _currDocument, Channel _fromChannel, Channel _toChannel, boolean _bIsLink, String _sIsPhoto) throws WCMException {
        int nStatusId;
        String sEntryName = I18NMessage.get(DocumentMgr.class, "DocumentMgr.label105", "\u6587\u6863");
        if (_sIsPhoto != null && _sIsPhoto.trim().equals("true")) {
            sEntryName = I18NMessage.get(DocumentMgr.class, "DocumentMgr.label106", "\u56fe\u7247");
        }
        if (_currDocument == null) {
            throw new WCMException(20, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label11", "{0}\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"), new String[]{sEntryName}));
        }
        if (_toChannel == null) {
            throw new WCMException(20, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label12", "\u76ee\u6807\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"));
        }
        if (_toChannel.getStatus() < 0) {
            return null;
        }
        if (_currDocument.getStatusId() == 1028) {
            throw new WCMException(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label121", "{1}[{0}]\u72b6\u6001\u4e3a\u8349\u7a3f\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"), new String[]{_currDocument.getTitle(), sEntryName}));
        }
        Report report = null;
        ChnlDoc newChnlDoc = null;
        DocumentMgr documentMgr = this;
        synchronized (documentMgr) {
            ChnlDoc oldChnlDoc = this.findChnlDoc(_currDocument, _toChannel);
            if (oldChnlDoc != null) {
                report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label101", "{0}\u5f15\u7528{5}[{1}][ID={2}]\u5230\u680f\u76ee[{3}][ID={4}]\u5931\u8d25\uff01"), new String[]{_bIsLink ? I18NMessage.get(DocumentMgr.class, "DocumentMgr.label13", "\u94fe\u63a5") : I18NMessage.get(DocumentMgr.class, "DocumentMgr.label14", "\u955c\u50cf"), _currDocument.getTitle(), String.valueOf(_currDocument.getId()), _toChannel.getDispDesc(), String.valueOf(_toChannel.getId()), sEntryName}));
                report.setRportDetail(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label18", "\u7531\u4e8e\u5f15\u7528\u5728") + (oldChnlDoc.isDeleted() ? I18NMessage.get(DocumentMgr.class, "DocumentMgr.label19", "\u56de\u6536\u7ad9") : I18NMessage.get(DocumentMgr.class, "DocumentMgr.label20", "\u76ee\u6807\u680f\u76ee" + this.getChnlDocStatusDesc(oldChnlDoc))) + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label21", "\u4e2d\u5df2\u7ecf\u5b58\u5728\uff01"));
                report.setType(5);
                return report;
            }
            MetaView fromView = this.m_oEmployerMgr.getViewOfEmployer(_fromChannel);
            MetaView toView = this.m_oEmployerMgr.getViewOfEmployer(_toChannel);
            if (fromView == null && toView != null) {
                report = new Report("\u5f15\u7528\u5931\u8d25\uff01 \u5f15\u7528\u7684\u8bb0\u5f55[" + _currDocument.getTitle() + "]\u7684\u539f\u59cb\u680f\u76ee[id=" + _fromChannel.getId() + "]\u672a\u8bbe\u7f6e\u89c6\u56fe\uff0c\u76ee\u6807\u680f\u76ee[id=" + _toChannel.getId() + "]\u8bbe\u7f6e\u4e86\u89c6\u56fe!");
                report.setType(5);
                return report;
            }
            if (fromView != null && toView != null && fromView.getId() != toView.getId()) {
                report = new Report("\u5f15\u7528\u5931\u8d25\uff01 \u5f15\u7528\u7684\u8bb0\u5f55[" + _currDocument.getTitle() + "]\u6240\u5728\u680f\u76ee[id=" + _fromChannel.getId() + "]\u4e0e\u76ee\u6807\u680f\u76ee[id=" + _toChannel.getId() + "]\u7684\u89c6\u56fe\u4e0d\u5339\u914d!");
                report.setType(5);
                return report;
            }
            newChnlDoc = this.createChnlDocWithEntity(_currDocument, _toChannel, _bIsLink);
            if (_fromChannel != null) {
                ChnlDoc fromChnlDoc = ChnlDoc.findByDocAndChnl(_currDocument, _fromChannel);
                boolean isAllowTopProperySyn = Boolean.parseBoolean(ConfigServer.getServer().getSysConfigValue("DOCUMENT_SETTOP_ALLOW_SWITCH", "false"));
                if (fromChnlDoc.isTopped() && isAllowTopProperySyn) {
                    newChnlDoc.setDocOrderPri(1);
                    newChnlDoc.setInvalidTime(fromChnlDoc.getInvalidTime());
                }
            }
            newChnlDoc.save(this.getLoginUser());
        }
        WCMPubStatusConfig config = WCMPubStatusConfig.findOf(103, newChnlDoc.getChannel().getSiteId());
        if (config != null && ((nStatusId = config.getStatusIdAfterModify()) == 10 || nStatusId == 1027) && _currDocument.getStatusId() == 10) {
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(newChnlDoc.getChannel());
            IPublishContent content = PublishElementFactory.makeContentFrom(newChnlDoc.getDocument(), folder);
            PublishServer.getInstance().publishContent(content, 3);
            if (nStatusId == 1027) {
                this.changeStatus(1027, newChnlDoc);
            }
        }
        report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label102", "{0}\u5f15\u7528{5}[{1}][ID={2}]\u5230\u680f\u76ee[{3}][ID={4}]\u6210\u529f\uff01"), new String[]{_bIsLink ? I18NMessage.get(DocumentMgr.class, "DocumentMgr.label13", "\u94fe\u63a5") : I18NMessage.get(DocumentMgr.class, "DocumentMgr.label14", "\u955c\u50cf"), _currDocument.getTitle(), String.valueOf(_currDocument.getId()), _toChannel.getDispDesc(), String.valueOf(_toChannel.getId()), sEntryName}));
        return report;
    }

    private String getChnlDocStatusDesc(ChnlDoc chnlDoc) throws WCMException {
        Status chnlDocStatus = chnlDoc.getStatus();
        return chnlDocStatus.translateIdToDesc(chnlDocStatus.getId());
    }

    public Status getDocStatus(Document _currDocument, int _nChnlId) throws WCMException {
        WCMFilter aFilter = new WCMFilter("WCMChnlDoc", "DocId=" + _currDocument.getId() + " and ChnlId=" + _nChnlId, "");
        aFilter.setMaxRowNumber(1);
        try {
            ChnlDocs aChnlDocs = ChnlDocs.openWCMObjs(this.getLoginUser(), aFilter);
            ChnlDoc aChnlDoc = (ChnlDoc)aChnlDocs.getAt(0);
            return aChnlDoc.getStatus();
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label23", "\u83b7\u53d6\u6587\u6863\u7684ChnlDoc\u5931\u8d25!"));
        }
    }

    public void changeStatus(Document _currDocument, Channel _currChannel, Status _newStatus) throws WCMException {
        if (_newStatus == null) {
            throw new WCMException(10, "New status required!");
        }
        this.changeStatus(_currDocument, _currChannel, _newStatus.getId());
    }

    public void changeStatus(Document _currDocument, Channel _currChannel, int _newStatusId) throws WCMException {
        if (_currDocument == null || _currChannel == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label24", "\u6587\u6863\u3001\u9891\u9053\u6216\u8005\u72b6\u6001\u53c2\u6570\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539\u6587\u6863\u72b6\u6001\uff01"));
        }
        ChnlDoc currChnlDoc = this.findChnlDoc(_currDocument, _currChannel);
        this.changeStatus(_newStatusId, currChnlDoc);
    }

    public void changeStatus(int _newStatusId, ChnlDoc _currChnlDoc) throws WCMException {
        if (_currChnlDoc == null) {
            return;
        }
        if (_currChnlDoc.getStatusId() == _newStatusId) {
            return;
        }
        User currUser = this.getLoginUser();
        if (_currChnlDoc.canEdit(currUser)) {
            boolean bPublished;
            boolean bl = bPublished = 10 == _currChnlDoc.getStatusId();
            if (bPublished) {
                _currChnlDoc.setDocPubTime(new CMyDateTime());
            }
            _currChnlDoc.setStatusId(_newStatusId);
            _currChnlDoc.save(currUser);
        }
        if (_currChnlDoc.isEntity() && _currChnlDoc.getStatusId() == 10) {
            DBManager manager = this.getDBManager();
            String sUpdateDocumentPubTimeSql = "update WCMDocument set DOCPUBTIME=NULL where DocId=" + _currChnlDoc.getDocId();
            manager.sqlExecuteUpdate(sUpdateDocumentPubTimeSql);
        }
    }

    public Documents getAllDocuments(BaseChannel _oChannel, WCMFilter _filter) throws WCMException {
        if (_oChannel == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label25", "\u6ca1\u6709\u6307\u5b9a\u7ad9\u70b9\u6216\u9891\u9053"));
        }
        WCMFilter docFilter = this.getFilterForDocuments(_oChannel, _filter);
        try {
            return Documents.openWCMObjs(this.getLoginUser(), docFilter);
        }
        catch (WCMException ex) {
            m_oLogger.debug((Object)"failed to get documents.", (Throwable)ex);
            throw new WCMException(1100, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label26", "\u83b7\u53d6\u9891\u9053\u7684\u6587\u6863\u96c6\u5408\u5931\u8d25"), ex);
        }
    }

    public Documents getDocuments(BaseChannel _oChannel, WCMFilter _filter) throws WCMException {
        if (_oChannel == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label27", "\u65e0\u6548\u7684\u7ad9\u70b9/\u9891\u9053\u5bf9\u8c61"));
        }
        boolean bSearchOrOrder = false;
        if (_filter != null && (_filter.getOrder() != null && _filter.getOrder().length() > 0 || _filter.getWhere() != null && _filter.getWhere().length() > 0)) {
            String sChannelOrder;
            bSearchOrOrder = _filter.getWhere() == null || _filter.getWhere().length() <= 0 ? (sChannelOrder = _filter.getOrder()) != null && sChannelOrder.trim().length() > 0 && sChannelOrder.toUpperCase().indexOf("DOCTITLE") > 0 : true;
        } else if (!_oChannel.isSite()) {
            Channel channel = (Channel)_oChannel;
            String sChannelOrder = channel.getOrderBy();
            bSearchOrOrder = sChannelOrder != null && sChannelOrder.trim().length() > 0 && sChannelOrder.toUpperCase().indexOf("DOCTITLE") > 0;
        }
        WCMFilter aFilter = null;
        if (_oChannel.isSite()) {
            aFilter = new WCMFilter("", "WCMDOCUMENT.DocStatus>0 and DocChannel>0", "");
        } else {
            if (!bSearchOrOrder && Document.DOCUMENTS_GET_OPTIMIZE) {
                return DocumentsGetHelper.getDocuments((Channel)_oChannel, _filter);
            }
            aFilter = new WCMFilter("", "WCMCHNLDOC.DocStatus>0 and WCMCHNLDOC.DocChannel>0 and WCMDocument.DocStatus>0", "");
        }
        aFilter.mergeWith(_filter);
        return this.getAllDocuments(_oChannel, aFilter);
    }

    public Documents getRecycleDocuments(BaseChannel _currChnl, WCMFilter _filter) throws WCMException {
        WCMFilter aFilter = null;
        aFilter = _currChnl.isSite() ? new WCMFilter("", "WCMDocument.DOCSTATUS<0", "") : new WCMFilter("", "(WCMCHNLDOC.DOCSTATUS<0  OR WCMCHNLDOC.Modal<0)", "");
        aFilter.mergeWith(_filter);
        return this.getAllDocuments(_currChnl, aFilter);
    }

    public WCMFilter getFilterForDocuments(BaseChannel _oChannel, WCMFilter _docFitler) throws WCMException {
        if (_oChannel.isSite()) {
            return this.makeFilterForSite((WebSite)_oChannel, _docFitler);
        }
        return this.makeFilterForChannel((Channel)_oChannel, _docFitler);
    }

    private WCMFilter makeFilterForSite(WebSite _currSite, WCMFilter _filter) {
        String sGetSiteDocumsntsWhere = "EXISTS(SELECT  CHANNELID FROM WCMCHANNEL where SiteId=? and Status=0 and CHANNELID=WCMDOCUMENT.DOCCHANNEL)";
        String sDefaulOrder = _currSite.getOrderBy();
        if (sDefaulOrder == null) {
            sDefaulOrder = "DocId DESC";
        }
        WCMFilter aFilter = new WCMFilter("", sGetSiteDocumsntsWhere, sDefaulOrder);
        aFilter.addSearchValues(0, _currSite.getId());
        CMyDateTime dtStartTime = this.m_oTimeRangeMgr.getStartDateTime(_currSite.getId(), 103);
        if (dtStartTime != null) {
            sGetSiteDocumsntsWhere = sGetSiteDocumsntsWhere + " and CrTime >= ?";
            aFilter.setWhere(sGetSiteDocumsntsWhere);
            aFilter.addSearchValues(1, dtStartTime);
        }
        aFilter.mergeWith(_filter);
        return aFilter;
    }

    private WCMFilter makeFilterForChannel(Channel _currChannel, WCMFilter _filter) throws WCMException {
        CMyDateTime dtStartTime;
        String sOrder;
        boolean bInCurrChannelSearch;
        StringBuffer buff = new StringBuffer();
        String sQuery = _currChannel.getQuery();
        boolean bl = bInCurrChannelSearch = !_currChannel.isOnlySearch();
        if (bInCurrChannelSearch) {
            buff.append("WCMCHNLDOC").append(".CHNLID=?");
            buff.append(" AND ");
        }
        buff.append("WCMCHNLDOC").append(".DOCID=");
        buff.append("WCMDOCUMENT").append(".DOCID");
        if (!CMyString.isEmpty(sQuery)) {
            buff.append(" AND (").append(sQuery).append(')');
        }
        if (_currChannel.isOnlySearch()) {
            buff.append(" AND (").append("WCMCHNLDOC").append(".MODAL=").append(1).append(')');
        }
        String sWhere = buff.toString();
        buff.setLength(0);
        String sUperCaseWhere = sWhere.toUpperCase();
        if (sUperCaseWhere.indexOf("SRCCHNLID=0") >= 0) {
            sWhere = sUperCaseWhere = CMyString.replaceStr(sUperCaseWhere, "SRCCHNLID=0", "MODAL=1");
        }
        if (sUperCaseWhere.indexOf("WCMDOCUMENT.DOCID=WCMCHNLDOC.DOCID") >= 0) {
            sWhere = sUperCaseWhere = CMyString.replaceStr(sUperCaseWhere, "WCMDOCUMENT.DOCID=WCMCHNLDOC.DOCID", "1=1");
        }
        if (((sOrder = _currChannel.getOrderBy()) == null || sOrder.trim().length() == 0) && (sOrder = _currChannel.getSite().getOrderBy()) == null) {
            sOrder = "";
        }
        IMetaViewEmployerMgr m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
        MetaView view = m_oMetaViewEmployerMgr.getViewOfEmployer(_currChannel);
        WCMFilter aFilter = null;
        aFilter = view != null ? new WCMFilter("WCMChnlDoc," + view.getTrueTableName(), sWhere, sOrder) : new WCMFilter("", sWhere, sOrder);
        int nSearchParamIndex = 0;
        if (bInCurrChannelSearch) {
            aFilter.addSearchValues(nSearchParamIndex++, _currChannel.getId());
        }
        if ((dtStartTime = this.m_oTimeRangeMgr.getStartDateTime(_currChannel.getId())) != null) {
            if (sWhere.length() > 0) {
                sWhere = sWhere + " and ";
            }
            sWhere = sWhere + "DocRelTime >= ?";
            aFilter.setWhere(sWhere);
            aFilter.addSearchValues(nSearchParamIndex, dtStartTime);
        }
        aFilter.mergeWith(_filter);
        return this.analyseFilterForChannel(aFilter);
    }

    private WCMFilter analyseFilterForChannel(WCMFilter _filter) throws WCMException {
        WCMFilter newFilter = new WCMFilter(_filter);
        String sSelect = _filter.getSelect();
        String sFrom = _filter.getFrom();
        String sWhere = _filter.getWhere();
        String sOrder = _filter.getOrder();
        try {
            sSelect = this.filterSelectForChannel(sSelect);
            newFilter.setSelect(sSelect);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label28", "\u91cd\u6574Select\u8bed\u53e5\u5931\u8d25\uff01"), ex);
        }
        sFrom = this.filterFromForChannel(sFrom);
        newFilter.setFrom(sFrom);
        try {
            sWhere = this.filterWhereForChannel(sWhere);
            newFilter.setWhere(sWhere);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label29", "\u91cd\u6574where\u8bed\u53e5\u5931\u8d25\uff01"), ex);
        }
        try {
            sOrder = this.filterOrderForChannel(sOrder);
            newFilter.setOrder(sOrder);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label30", "\u91cd\u6574Order\u8bed\u53e5\u5931\u8d25\uff01"), ex);
        }
        return newFilter;
    }

    private String filterSelectForChannel(String _sSelect) throws Exception {
        DBManager dbManager = DBManager.getDBManager();
        TableInfo tblDocument = dbManager.getTableInfo("WCMDOCUMENT");
        if (tblDocument == null) {
            return "*";
        }
        TableInfo tblChnlDoc = dbManager.getTableInfo("WCMCHNLDOC");
        if (tblChnlDoc == null) {
            return "*";
        }
        String sSelect = _sSelect;
        if (sSelect != null && sSelect.length() > 0) {
            Enumeration enFiledNames = tblChnlDoc.getFieldNames();
            String sFieldName = "";
            do {
                sFieldName = (String)enFiledNames.nextElement();
                sSelect = this.filterExpression(sSelect, sFieldName, "WCMDOCUMENT");
            } while (enFiledNames.hasMoreElements());
        }
        return sSelect;
    }

    private String filterFromForChannel(String _sFrom) {
        if (_sFrom == null || _sFrom.length() <= 0) {
            return "WCMCHNLDOC,WCMDOCUMENT";
        }
        String sFrom = _sFrom.toUpperCase();
        boolean bIncludeChnlDoc = false;
        boolean bIncludeDoc = false;
        StringTokenizer stTemp = new StringTokenizer(sFrom, ",");
        do {
            String sTemp;
            String sSingleTable;
            if ((sSingleTable = (sTemp = (String)stTemp.nextElement()).trim().toUpperCase()).equals("WCMCHNLDOC")) {
                bIncludeChnlDoc = true;
                continue;
            }
            if (!sSingleTable.equals("WCMDOCUMENT")) continue;
            bIncludeDoc = true;
        } while (stTemp.hasMoreElements());
        if (!bIncludeChnlDoc) {
            sFrom = sFrom + ",WCMCHNLDOC";
        }
        if (!bIncludeDoc) {
            sFrom = sFrom + ",WCMDOCUMENT";
        }
        return sFrom;
    }

    private String filterWhereForChannel(String _sWhere) throws Exception {
        if (_sWhere == null || _sWhere.trim().length() <= 0) {
            return "";
        }
        DBManager dbManager = DBManager.getDBManager();
        TableInfo tblDocument = dbManager.getTableInfo("WCMDOCUMENT");
        if (tblDocument == null) {
            return _sWhere;
        }
        TableInfo tblChnlDoc = dbManager.getTableInfo("WCMCHNLDOC");
        if (tblChnlDoc == null) {
            return _sWhere;
        }
        String sWhere = _sWhere;
        Enumeration enFiledNames = tblChnlDoc.getFieldNames();
        String sFieldName = "";
        do {
            sFieldName = (String)enFiledNames.nextElement();
            sWhere = this.filterExpression(sWhere, sFieldName, "WCMCHNLDOC");
        } while (enFiledNames.hasMoreElements());
        return sWhere;
    }

    private String filterOrderForChannel(String _sOrder) throws Exception {
        String sDefaultOrder = "";
        DBManager dbManager = DBManager.getDBManager();
        if (ChnlDoc.IS_ORDER_BY_PRI) {
            sDefaultOrder = "WCMCHNLDOC.DOCORDERPRI desc,";
        }
        sDefaultOrder = sDefaultOrder + "WCMCHNLDOC.DOCORDER desc ";
        if (_sOrder == null || _sOrder.length() == 0) {
            return sDefaultOrder;
        }
        TableInfo tblDocument = dbManager.getTableInfo("WCMDOCUMENT");
        if (tblDocument == null) {
            return sDefaultOrder;
        }
        TableInfo tblChnlDoc = dbManager.getTableInfo("WCMCHNLDOC");
        if (tblChnlDoc == null) {
            return sDefaultOrder;
        }
        String sNewOrder = "";
        StringTokenizer stOrderField = new StringTokenizer(_sOrder, ",");
        int i = -1;
        do {
            String sOrderFiled = (String)stOrderField.nextElement();
            sOrderFiled = sOrderFiled.trim();
            ++i;
            int nEndPose = sOrderFiled.indexOf(" ");
            String sField = "";
            String sOrderMode = "";
            if (nEndPose < 0) {
                sField = sOrderFiled;
                sOrderMode = "asc";
            } else {
                sField = sOrderFiled.substring(0, nEndPose).toUpperCase();
                sOrderMode = sOrderFiled.substring(nEndPose).toUpperCase();
            }
            int nTablePose = sField.indexOf(".");
            if (nTablePose >= 0) {
                if (i > 0) {
                    sNewOrder = sNewOrder + "," + sField + " " + sOrderMode;
                    continue;
                }
                sNewOrder = sField + " " + sOrderMode;
                continue;
            }
            if (tblDocument.getFieldInfo(sField) != null) {
                sField = "WCMDOCUMENT." + sField;
            } else if (tblChnlDoc.getFieldInfo(sField) != null) {
                sField = "WCMCHNLDOC." + sField;
            } else {
                Exception ex = new Exception(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label31", "\u5b57\u6bb5\u4e0d\u5b58\u5728!"));
                throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label32", "\u6307\u5b9a\u7684\u6392\u5e8f\u5b57\u6bb5[") + sField + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label33", "]\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728!"), ex);
            }
            sNewOrder = i > 0 ? sNewOrder + "," + sField + " " + sOrderMode : sField + " " + sOrderMode;
        } while (stOrderField.hasMoreElements());
        return sNewOrder;
    }

    private String filterExpression(String _sExpression, String _sFieldName, String _sPrexName) {
        if (_sExpression == null) {
            return "";
        }
        if (_sFieldName == null || _sFieldName.trim().length() == 0) {
            return _sExpression;
        }
        String sSrcExpress = _sExpression;
        String sFieldName = _sFieldName.toUpperCase();
        int nFieldLen = sFieldName.length();
        int nStartPose = 0;
        do {
            char chEnd;
            int nEndPose;
            String sTemp;
            if ((nStartPose = (sTemp = sSrcExpress.toUpperCase()).indexOf(sFieldName, nStartPose)) < 0) {
                return sSrcExpress;
            }
            if (nStartPose > 0) {
                char chStart = sTemp.charAt(nStartPose - 1);
                if (chStart >= 'A' && chStart <= 'Z') continue;
                if (chStart == '.') {
                    nStartPose += nFieldLen;
                    continue;
                }
            }
            if ((nEndPose = nStartPose + nFieldLen) < sTemp.length() && (chEnd = sTemp.charAt(nEndPose)) >= 'A' && chEnd <= 'Z') {
                nStartPose += nFieldLen;
                continue;
            }
            String sNewFieldName = _sPrexName + "." + sFieldName;
            sSrcExpress = sSrcExpress.substring(0, nStartPose) + sNewFieldName + sSrcExpress.substring(nEndPose);
            nStartPose += sNewFieldName.length();
        } while (nStartPose >= 0 && nStartPose < sSrcExpress.length());
        return sSrcExpress;
    }

    public int getMaxToppedNum() {
        try {
            ConfigServer server = ConfigServer.getServer();
            String sValue = server.getSysConfigValue("PRI_DOCS_SIZE", "");
            if ("".equals(sValue)) {
                return ChnlDoc.PRI_DOCS_SIZE;
            }
            return Integer.parseInt(sValue);
        }
        catch (Exception e) {
            return ChnlDoc.PRI_DOCS_SIZE;
        }
    }

    public boolean isTopEnabled() {
        try {
            ConfigServer server = ConfigServer.getServer();
            String sValue = server.getSysConfigValue("IS_ORDER_BY_PRI", "");
            if ("".equals(sValue)) {
                return ChnlDoc.IS_ORDER_BY_PRI;
            }
            return Boolean.getBoolean(sValue);
        }
        catch (Exception e) {
            return ChnlDoc.IS_ORDER_BY_PRI;
        }
    }

    public Documents getToppedDocuments(Channel _currChannel, WCMFilter _docFilter) throws WCMException {
        if (_currChannel == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label34", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u5f97\u5176\u4e0b\u7684\u7f6e\u9876\u6587\u6863\u96c6\u5408!"));
        }
        WCMFilter topDocFilter = new WCMFilter("", "WCMCHNLDOC.DOCORDERPRI>0", "");
        return this.getDocuments(_currChannel, topDocFilter.mergeWith(_docFilter));
    }

    public boolean isDocumentTopped(Document _currDocument, Channel _currChannel) throws WCMException {
        if (_currChannel == null || _currDocument == null) {
            return false;
        }
        ChnlDoc currChnlDoc = this.findChnlDoc(_currDocument, _currChannel);
        if (currChnlDoc == null) {
            return false;
        }
        return currChnlDoc.getPropertyAsInt("DOCORDERPRI", 0) > 0;
    }

    public void setTopDocument(Channel _currChannel, Document _currDocument, int _nToppedOrder, CMyDateTime _dtValidUntil) throws WCMException {
        ChnlDoc currChnlDoc = this.findChnlDoc(_currDocument, _currChannel);
        if (currChnlDoc == null) {
            return;
        }
        if (_currChannel == null || _currDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label35", "\u4f20\u5165\u7684\u6587\u6863\u548c\u9891\u9053\u53c2\u6570\u65e0\u6548\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u7f6e\u9876\u6807\u5fd7!"));
        }
        if (_nToppedOrder > this.getMaxToppedNum()) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label36", "\u5bf9\u4e0d\u8d77, \u6587\u6863\u7f6e\u9876\u7684\u4f4d\u7f6e\u65e0\u6548\uff0c\u65e0\u6cd5\u7ee7\u7eed!"));
        }
        if (_currDocument.isDraft()) {
            return;
        }
        if (_nToppedOrder == ChnlDoc.NOT_ON_TOP) {
            this.removeToppedDocument(_currChannel, _currDocument);
            return;
        }
        if (_nToppedOrder < 1) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label36", "\u5bf9\u4e0d\u8d77, \u6587\u6863\u7f6e\u9876\u7684\u4f4d\u7f6e\u65e0\u6548\uff0c\u65e0\u6cd5\u7ee7\u7eed!"));
        }
        if (_nToppedOrder == ChnlDoc.NOT_ON_TOP && currChnlDoc.getDocOrderPri() != ChnlDoc.NOT_ON_TOP) {
            return;
        }
        if (currChnlDoc.getDocOrderPri() != _nToppedOrder) {
            this.moveTopped(currChnlDoc, _nToppedOrder);
        }
        if (currChnlDoc.getInvalidTime() == null && _dtValidUntil == null) {
            return;
        }
        User loginUser = this.getLoginUser();
        if (_dtValidUntil == null) {
            if (!currChnlDoc.canEdit(loginUser)) {
                throw new WCMException(1013, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label37", "\u5bf9\u4e0d\u8d77\uff0c\u9891\u9053\u4e0b\u7684\u6587\u6863\u5bf9\u8c61\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5176\u7f6e\u9876!"));
            }
            currChnlDoc.removeProperty("INVALIDTIME");
            currChnlDoc.save(loginUser);
            return;
        }
        if (!currChnlDoc.canEdit(loginUser)) {
            throw new WCMException(1013, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label37", "\u5bf9\u4e0d\u8d77\uff0c\u9891\u9053\u4e0b\u7684\u6587\u6863\u5bf9\u8c61\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5176\u7f6e\u9876!"));
        }
        currChnlDoc.setDocOrderPri(_nToppedOrder);
        currChnlDoc.setInvalidTime(_dtValidUntil);
        currChnlDoc.save(loginUser);
    }

    public void setTopedDocument(Document _document, Channel _channel, int _nTopOrder, CMyDateTime _dtTopedValid) throws WCMException {
        ChnlDoc chnldoc = this.findChnlDoc(_document, _channel);
        if (chnldoc == null) {
            return;
        }
        if (!chnldoc.canEdit(this.getLoginUser())) {
            throw new WCMException(1013, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label38", "\u5bf9\u4e0d\u8d77,\u6587\u6863\u5df2\u88ab") + chnldoc.getLockerUser() + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label39", "\u9501\u5b9a!"));
        }
        chnldoc.setDocTopPriOrder(_nTopOrder);
        chnldoc.setInvalidTime(_dtTopedValid);
        chnldoc.save(this.getLoginUser());
    }

    public void removeToppedDocument(Channel _currChannel, Document _currDocument) throws WCMException {
        if (_currChannel == null || _currDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label35", "\u4f20\u5165\u7684\u6587\u6863\u548c\u9891\u9053\u53c2\u6570\u65e0\u6548\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u7f6e\u9876\u6807\u5fd7!"));
        }
        if (_currDocument.isDraft()) {
            return;
        }
        if (!this.isDocumentTopped(_currDocument, _currChannel)) {
            return;
        }
        User loginUser = this.getLoginUser();
        ChnlDoc currChnlDoc = this.findChnlDoc(_currDocument, _currChannel);
        if (currChnlDoc == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label40", "\u627e\u4e0d\u5230\u9891\u9053\u4e0b\u5bf9\u5e94\u7684\u6587\u6863\uff0c\u65e0\u6cd5\u7f6e\u9876!"));
        }
        if (!currChnlDoc.canEdit(loginUser)) {
            throw new WCMException(1013, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label41", "\u5bf9\u4e0d\u8d77\uff0c\u9891\u9053\u4e0b\u7684\u6587\u6863\u5bf9\u8c61\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u53d6\u6d88\u5176\u7f6e\u9876\u8bbe\u7f6e!"));
        }
        currChnlDoc.setDocOrderPri(ChnlDoc.NOT_ON_TOP);
        currChnlDoc.removeProperty("INVALIDTIME");
        currChnlDoc.save(loginUser);
    }

    private void moveTopped(ChnlDoc _currChnlDoc, int _nNewToppedOrder) throws WCMException {
        if (_currChnlDoc == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label42", "\u9891\u9053\u6587\u6863\u65e0\u6548\uff0c\u65e0\u6cd5\u79fb\u52a8\u5176\u7f6e\u9876\u987a\u5e8f!"));
        }
        if (_nNewToppedOrder < 1 || _nNewToppedOrder > ChnlDoc.PRI_DOCS_SIZE) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label43", "\u5bf9\u4e0d\u8d77, \u6587\u6863\u65b0\u7684\u7f6e\u9876\u4f4d\u7f6e\u65e0\u6548\uff0c\u65e0\u6cd5\u7ee7\u7eed!"));
        }
        if (_currChnlDoc.getDocOrderPri() == _nNewToppedOrder) {
            return;
        }
        User loginUser = this.getLoginUser();
        ChnlDoc oldChnlDoc = this.findChnlDoc(_currChnlDoc.getChannel(), _nNewToppedOrder);
        if (oldChnlDoc != null) {
            this.moveTopped(oldChnlDoc, _nNewToppedOrder + 1);
        }
        if (!_currChnlDoc.canEdit(loginUser)) {
            throw new WCMException(1013, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label44", "\u5bf9\u4e0d\u8d77\uff0c\u9891\u9053\u4e0b\u7684\u6587\u6863\u5bf9\u8c61\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u79fb\u52a8\u5176\u7f6e\u9876\u5c5e\u6027!"));
        }
        _currChnlDoc.setDocOrderPri(_nNewToppedOrder);
        _currChnlDoc.save(loginUser);
    }

    private ChnlDoc findChnlDoc(Channel _currChannel, int _nTopOrder) throws WCMException {
        if (_currChannel == null) {
            return null;
        }
        WCMFilter aFilter = new WCMFilter("", "ChnlId=" + _currChannel.getId() + " and DocOrderPri=" + (this.getMaxToppedNum() + 1 - _nTopOrder), "");
        ChnlDocs aChnlDocs = ChnlDocs.openWCMObjs(this.getLoginUser(), aFilter);
        if (aChnlDocs == null || aChnlDocs.isEmpty()) {
            return null;
        }
        return (ChnlDoc)aChnlDocs.getAt(0);
    }

    public int getTopPosition(Channel _currChannel, Document _currDocument) throws WCMException {
        if (_currChannel == null || _currDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label45", "\u9891\u9053\u6216\u8005\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u5f97\u5176\u7f6e\u9876\u987a\u5e8f!"));
        }
        ChnlDoc currChnlDoc = this.findChnlDoc(_currDocument, _currChannel);
        if (currChnlDoc == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label46", "\u9891\u9053\u6587\u6863\u6ca1\u6709\u627e\u5230\uff0c\u65e0\u6cd5\u83b7\u5f97\u5176\u7f6e\u9876\u987a\u5e8f\uff01"));
        }
        return currChnlDoc.getDocOrderPri();
    }

    public Document save(Document _currDocument) throws WCMException {
        ChnlDoc currChnlDoc;
        boolean bStatusChanged;
        if (_currDocument == null) {
            throw new BizError(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label47", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        if (_currDocument.isDoMove()) {
            throw new BizError(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label48", "\u79fb\u52a8\u6587\u6863\u5230\u53e6\u4e00\u4e2a\u680f\u76ee\u8bf7\u901a\u8fc7\u79fb\u52a8\u64cd\u4f5c\u8fdb\u884c\uff0c\u65e0\u6cd5\u901a\u8fc7\u76f4\u63a5\u4fee\u6539\u6587\u6863\u5c5e\u6027\u5b8c\u6210\uff01"));
        }
        if (_currDocument.isDoDelete()) {
            throw new BizError(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label49", "\u5220\u9664\u6587\u6863\u5230\u56de\u6536\u7ad9\u8bf7\u901a\u8fc7\u5220\u9664\u64cd\u4f5c\u8fdb\u884c\uff0c\u65e0\u6cd5\u901a\u8fc7\u76f4\u63a5\u4fee\u6539\u6587\u6863\u5c5e\u6027\u5b8c\u6210\uff01"));
        }
        if (_currDocument.isDoRecover()) {
            throw new BizError(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label50", "\u4ece\u56de\u6536\u7ad9\u4e2d\u6062\u590d\u6587\u6863\u8bf7\u901a\u8fc7\u6062\u590d\u64cd\u4f5c\u8fdb\u884c\uff0c\u65e0\u6cd5\u901a\u8fc7\u76f4\u63a5\u4fee\u6539\u6587\u6863\u5c5e\u6027\u5b8c\u6210\uff01"));
        }
        boolean bIsAddmode = _currDocument.isAddMode();
        boolean bIsDraft = _currDocument.isDraft();
        boolean bl = bStatusChanged = !bIsAddmode && _currDocument.isChangeProperty("DOCSTATUS");
        if (!bStatusChanged && 1 == _currDocument.getStatusId() && !bIsAddmode) {
            _currDocument.setStatus(2);
            bStatusChanged = true;
        }
        if (bIsAddmode && 40 == _currDocument.getType()) {
            String sFile = _currDocument.getPropertyAsString("DOCFILENAME");
            FilesMan filesMan = FilesMan.getFilesMan();
            String sFileProtected = filesMan.copyWCMFile(sFile, "P0");
            _currDocument.setProperty("DOCFILENAME", CMyFile.extractFileName(sFileProtected));
            try {
                if (sFile.indexOf("U0") == 0) {
                    filesMan.deleteFile(sFile);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (_currDocument.isChangeProperty("DOCTYPE")) {
            this.clearOldContent(_currDocument);
        }
        User loginUser = this.getLoginUser();
        _currDocument.setPropertyWithString("OperUser", loginUser.getName());
        _currDocument.setProperty("OperTime", CMyDateTime.now());
        boolean bContentHasImage = _currDocument.hasImgInDocContent();
        int nAttachPic = _currDocument.getAttachPic();
        if (nAttachPic == 1) {
            if (bContentHasImage) {
                _currDocument.setAttachPic(3);
            }
        } else if (bContentHasImage) {
            _currDocument.setAttachPic(2);
        } else {
            _currDocument.setAttachPic(0);
        }
        _currDocument.save(loginUser);
        if (bIsDraft) {
            return _currDocument;
        }
        if (bIsAddmode) {
            if (_currDocument.getDbTableName().equals("WCMDOCUMENT")) {
                String sCrUser;
                ChnlDoc newChnlDoc = this.createChnlDocWithEntity(_currDocument, _currDocument.getChannel(), false);
                String sCrTime = _currDocument.getPropertyAsString("CrTime");
                if (sCrTime != null) {
                    newChnlDoc.setPropertyWithString("CrTime", sCrTime);
                }
                if ((sCrUser = _currDocument.getPropertyAsString("CrUser")) != null) {
                    newChnlDoc.setPropertyWithString("CrUser", sCrUser);
                }
                newChnlDoc.setPropertyWithString("OperUser", loginUser.getName());
                newChnlDoc.setProperty("OperTime", CMyDateTime.now());
                newChnlDoc.save(this.getLoginUser());
            }
            return _currDocument;
        }
        if (bStatusChanged) {
            currChnlDoc = this.findChnlDoc(_currDocument, _currDocument.getChannel());
            if (!currChnlDoc.canEdit(this.getLoginUser())) {
                throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label51", "\u4fdd\u5b58\u6587\u6863\u65f6,\u7531\u4e8eChnlDoc\u88ab") + currChnlDoc.getLockerUser() + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label52", "\u9501\u5b9a,\u65e0\u6cd5\u540c\u6b65\u5176\u5c5e\u6027"));
            }
            currChnlDoc.setStatusId(_currDocument.getStatusId());
            currChnlDoc.save(this.getLoginUser());
        }
        if (!bStatusChanged && !bIsAddmode) {
            currChnlDoc = this.findChnlDoc(_currDocument, _currDocument.getChannel());
            currChnlDoc.setPropertyWithString("OperUser", loginUser.getName());
            currChnlDoc.setProperty("OperTime", CMyDateTime.now());
            currChnlDoc.save(this.getLoginUser());
        }
        return _currDocument;
    }

    private void clearOldContent(Document _currDocument) throws WCMException {
        int nFormDocType = _currDocument.getType();
        int nToDocType = _currDocument.getNewPropertyAsInt("DOCTYPE", 20);
        switch (nFormDocType) {
            case 20: {
                List listFiles;
                if (this.unUsedByDocBak(_currDocument.getId(), 20) && (listFiles = _currDocument.getHTMLWCMFiles()) != null) {
                    String sFile = null;
                    for (int i = 0; i < listFiles.size(); ++i) {
                        sFile = (String)listFiles.get(i);
                        if (sFile == null || sFile.trim().length() <= 0) continue;
                        try {
                            FilesMan.getFilesMan().deleteFile(sFile);
                            continue;
                        }
                        catch (Exception ex) {
                            if (!m_oLogger.isDebugEnabled()) continue;
                            m_oLogger.debug((Object)(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label53", "\u5220\u9664\u6587\u6863\u5305\u542b\u7684HTML\u6587\u4ef6[") + sFile + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label54", "]\u65f6\u53d1\u751f\u5f02\u5e38\uff01")), (Throwable)ex);
                        }
                    }
                }
                _currDocument.setPropertyWithString("DOCHTMLCON", "");
                if (nToDocType == 10) break;
                _currDocument.setPropertyWithString("DOCCONTENT", "");
                break;
            }
            case 10: {
                _currDocument.setPropertyWithString("DOCCONTENT", "");
                if (nToDocType == 20) break;
                _currDocument.setPropertyWithString("DOCHTMLCON", "");
                break;
            }
            case 30: {
                _currDocument.setPropertyWithString("DOCLINK", "");
                break;
            }
            case 40: {
                FilesMan filesMan;
                String sExternalFile = _currDocument.getPropertyAsString("DOCFILENAME");
                if (sExternalFile != null && sExternalFile.trim().length() > 0 && (filesMan = FilesMan.getFilesMan()).fileExists(sExternalFile) && this.unUsed(_currDocument.getId(), sExternalFile)) {
                    filesMan.deleteFile(sExternalFile);
                }
                _currDocument.setPropertyWithString("DOCFILENAME", "");
            }
        }
    }

    private boolean unUsed(int _nDocId, String _sFile) throws WCMException {
        String sql = "SELECT COUNT(DocBakId) FROM WCMDOCBAK WHERE DocId=" + _nDocId + " AND DocFileName='" + _sFile + "'";
        return DBManager.getDBManager().sqlExecuteIntQuery(sql) == 0;
    }

    private boolean unUsedByDocBak(int _nDocId, int _nDocType) throws WCMException {
        String sSQL = "SELECT COUNT(DocBakId) FROM WCMDOCBAK WHERE DocId=" + _nDocId + " AND DocType=" + _nDocType;
        return DBManager.getDBManager().sqlExecuteIntQuery(sSQL) == 0;
    }

    public Document copyDocument(Document _fromDocument, Channel _fromChannel, Channel _toChannel) throws WCMException {
        boolean bInheritFromSrcDocument;
        Channel fromChannel;
        User loginUser = this.getLoginUser();
        if (_fromDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label55", "\u539f\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u590d\u5236\u6587\u6863\uff01"));
        }
        if (_toChannel == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label56", "\u76ee\u6807\u680f\u76ee\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u590d\u5236\u6587\u6863\uff01"));
        }
        Channel channel = fromChannel = _fromChannel == null ? _fromDocument.getChannel() : _fromChannel;
        if (_fromDocument.isDraft()) {
            fromChannel = Channel.DRAFT_CHANNEL;
        }
        if (fromChannel == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label57", "\u539f\u59cb\u680f\u76ee\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u590d\u5236\u6587\u6863\uff01"));
        }
        if (_fromDocument.getStatusId() == 1028) {
            throw new WCMException(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label122", "\u6587\u6863[{0}]\u72b6\u6001\u4e3a\u8349\u7a3f\uff0c\u65e0\u6cd5\u590d\u5236\uff01"), new String[]{_fromDocument.getTitle()}));
        }
        if (!this.isDocumentLink(_fromDocument, fromChannel)) {
            String sChangeStatus;
            int nDocKind;
            if (_toChannel.getType() != fromChannel.getType()) {
                throw new WCMException(10, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label111", "\u590d\u5236\u6587\u6863[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u5931\u8d25\uff01\u56e0\u4e3a\u4e0d\u540c\u7c7b\u578b\u4e4b\u95f4\u7684\u680f\u76ee\u4e0d\u5141\u8bb8\u590d\u5236\u6570\u636e\uff01"), new String[]{_fromDocument.getTitle(), _toChannel.getDispDesc(), String.valueOf(_toChannel.getId())}));
            }
            if (fromChannel.getType() == 13) {
                String strInChannelIds = fromChannel.getId() + "," + _toChannel.getId();
                String sqlQuery = "select count(distinct InfoViewId) from WCMInfoViewEmploy where EmployerType=101 and EmployerID in(" + strInChannelIds + ")";
                int nCount = DBManager.getDBManager().sqlExecuteIntQuery(sqlQuery);
                if (nCount > 1) {
                    throw new WCMException(10, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label112", "\u590d\u5236\u6587\u6863[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u5931\u8d25\uff01\u56e0\u4e3a\u914d\u7f6e\u4e86\u4e0d\u540c\u8868\u5355\u7684\u680f\u76ee\u4e0d\u5141\u8bb8\u590d\u5236\u6570\u636e\uff01"), new String[]{_fromDocument.getTitle(), _toChannel.getDispDesc(), String.valueOf(_toChannel.getId())}));
                }
            }
            if ((nDocKind = _fromDocument.getPropertyAsInt("DocKind", 0)) != 0) {
                int nToChnlId = _toChannel.getId();
                String sqlQuery = "select count(distinct ViewId) from XWCMMetaViewEmployer where XWCMMetaViewEmployer.ChannelId=" + nToChnlId + " and XWCMMetaViewEmployer.ViewId=" + nDocKind;
                int nCount = DBManager.getDBManager().sqlExecuteIntQuery(sqlQuery);
                if (nCount <= 0) {
                    throw new WCMException(10, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label114", "\u590d\u5236\u6587\u6863[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u5931\u8d25\uff01\u56e0\u4e3a\u914d\u7f6e\u4e86\u4e0d\u540c\u89c6\u56fe\u7684\u680f\u76ee\u4e0d\u5141\u8bb8\u590d\u5236\u6570\u636e\uff01"), new String[]{_fromDocument.getTitle(), _toChannel.getDispDesc(), String.valueOf(_toChannel.getId())}));
                }
            }
            Document newDoc = (Document)_fromDocument.cloneToNewWCMObj();
            newDoc.setChannel(_toChannel);
            newDoc.setTitle(this.getDoctitleWhenCopy(newDoc.getTitle()));
            boolean bInheritFromDocument = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("DOCUMENT_COPY_INHERIT", "false"));
            if (bInheritFromDocument) {
                newDoc.setProperty("CRTIME", _fromDocument.getCrTime());
                if (_fromDocument.getStatusId() == 10 || _fromDocument.getStatusId() == 1027) {
                    newDoc.setStatus(1);
                }
            } else {
                newDoc.setStatus(1);
            }
            if ("true".equalsIgnoreCase(sChangeStatus = ConfigServer.getServer().getSysConfigValue("CHANGENAME", "false"))) {
                newDoc.setCrUser(loginUser.getName());
            }
            newDoc.setOutUpId(_fromDocument.getId());
            newDoc.setProperty("DOCFIRSTPUBTIME", null);
            newDoc = this.save(newDoc);
            Logos currLogos = Logos.findOf(loginUser, 605, _fromDocument.getDocId(), null);
            int nSize = currLogos.size();
            for (int k = 0; k < nSize; ++k) {
                Logo logo = (Logo)currLogos.getAt(k);
                if (logo == null) continue;
                Logo temp = (Logo)logo.cloneToNewObj();
                temp.removeProperty("CRTIME");
                temp.setHostId(newDoc.getId());
                temp.save(loginUser);
            }
            boolean bDocumentInFlowOnCopy = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("DOCUMENT_INFLOW_ONCOPY", "false"));
            if (bDocumentInFlowOnCopy) {
                this.startInFlow(newDoc);
            }
            ChnlDoc fromChnlDoc = this.findChnlDoc(_fromDocument, _fromChannel);
            ChnlDoc toChnlDoc = this.findChnlDoc(newDoc, _toChannel);
            if (fromChnlDoc.isTopped() && Boolean.parseBoolean(ConfigServer.getServer().getSysConfigValue("DOCUMENT_SETTOP_ALLOW_SWITCH", "false"))) {
                toChnlDoc.setDocOrderPri(1);
                toChnlDoc.setInvalidTime(fromChnlDoc.getInvalidTime());
                toChnlDoc.update();
            }
            return newDoc;
        }
        if (ChnlDoc.findByDocAndChnl(_fromDocument, _toChannel) != null) {
            return null;
        }
        ChnlDoc fromChnlDoc = this.findChnlDoc(_fromDocument, fromChannel);
        ChnlDoc newChnlDoc = (ChnlDoc)fromChnlDoc.cloneToNewObj();
        newChnlDoc.setChannelId(_toChannel.getId());
        if (fromChnlDoc.isTopped() && Boolean.parseBoolean(ConfigServer.getServer().getSysConfigValue("DOCUMENT_SETTOP_ALLOW_SWITCH", "false"))) {
            newChnlDoc.setDocOrderPri(1);
            newChnlDoc.setInvalidTime(fromChnlDoc.getInvalidTime());
        }
        if (bInheritFromSrcDocument = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("DOCUMENT_COPY_INHERIT", "false"))) {
            newChnlDoc.setProperty("CRTIME", fromChnlDoc.getCrTime());
        }
        newChnlDoc.save(this.getLoginUser());
        return _fromDocument;
    }

    private void startInFlow(Document _newDoc) throws WCMException {
        IFlowServer flowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
        IFlowContent flowContent = FlowContentFactory.makeFlowContent(_newDoc);
        FlowContext flowContext = null;
        if (flowContent.getOwnerFlow() == null) {
            return;
        }
        flowContext = new FlowContext(ContextHelper.getLoginUser(), flowContent);
        flowContext.setPostDesc(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label58", "\u7cfb\u7edf\u6839\u636e\u680f\u76ee\u5de5\u4f5c\u6d41\u914d\u7f6e\u81ea\u52a8\u9a71\u52a8\u6d41\u8f6c\uff01"));
        flowServer.submitTo(flowContext);
    }

    public Channels getQutoedChannels(Document _currDocument, int _nDocModal, String _sExtraChnlDocWhere) throws WCMException {
        return this.getQutoedChannels(_currDocument, _nDocModal, _sExtraChnlDocWhere, false);
    }

    public Channels getQutoedChannels(Document _currDocument, int _nDocModal, String _sExtraChnlDocWhere, boolean _bIsIncludeTrashed) throws WCMException {
        if (_currDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label59", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61,\u83b7\u53d6\u5b58\u5728\u8be5\u6587\u6863\u955c\u50cf\u7684\u6240\u6709\u9891\u9053\u5931\u8d25"));
        }
        if (_currDocument.isDraft()) {
            return null;
        }
        StringBuffer sbWhere = new StringBuffer(128);
        sbWhere.append("DocId=").append(_currDocument.getId());
        sbWhere.append(" AND ChnlId>0");
        if (!_bIsIncludeTrashed) {
            sbWhere.append(" AND DocStatus>0");
        }
        sbWhere.append(" AND (ChnlId>");
        sbWhere.append(_currDocument.getChannelId());
        sbWhere.append(" OR ChnlId<");
        sbWhere.append(_currDocument.getChannelId()).append(")");
        if (_nDocModal != 0) {
            sbWhere.append(" AND Modal=").append(_nDocModal);
        }
        if (!CMyString.isEmpty(_sExtraChnlDocWhere)) {
            sbWhere.append(" AND (").append(_sExtraChnlDocWhere).append(")");
        }
        Channels channels = new Channels(this.getLoginUser());
        WCMFilter aFilter = new WCMFilter("WCMChnlDoc", sbWhere.toString(), "", "ChnlId as ChannelId");
        channels.open(aFilter);
        return channels;
    }

    public Channels getChannels(Document _currDocument, int _nDocModal, String _sExtraChnlDocWhere) throws WCMException {
        if (_currDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label59", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61,\u83b7\u53d6\u5b58\u5728\u8be5\u6587\u6863\u955c\u50cf\u7684\u6240\u6709\u9891\u9053\u5931\u8d25"));
        }
        if (_currDocument.isDraft()) {
            return null;
        }
        StringBuffer sbWhere = new StringBuffer(128);
        sbWhere.append("DocId=?  AND ChnlId>0 AND DocStatus>0 ");
        if (_nDocModal != 0) {
            sbWhere.append(" AND Modal=?");
        }
        if (!CMyString.isEmpty(_sExtraChnlDocWhere)) {
            sbWhere.append(" AND (").append(_sExtraChnlDocWhere).append(")");
        }
        Channels channels = new Channels(this.getLoginUser());
        WCMFilter aFilter = new WCMFilter("WCMChnlDoc", sbWhere.toString(), "", "ChnlId as ChannelId");
        aFilter.addSearchValues(_currDocument.getId());
        if (_nDocModal != 0) {
            aFilter.addSearchValues(_nDocModal);
        }
        channels.open(aFilter);
        return channels;
    }

    public Report moveTo(Document _fromDocument, Channel _fromChannel, Channel _toChannel) throws WCMException {
        return this.moveTo(_fromDocument, _fromChannel, _toChannel, "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Report moveTo(Document _fromDocument, Channel _fromChannel, Channel _toChannel, String _sIsPhoto) throws WCMException {
        Channel fromChannel;
        String sEntryName = I18NMessage.get(DocumentMgr.class, "DocumentMgr.label105", "\u6587\u6863");
        if (_sIsPhoto != null && _sIsPhoto.trim().equals("true")) {
            sEntryName = I18NMessage.get(DocumentMgr.class, "DocumentMgr.label106", "\u56fe\u7247");
        }
        if (_fromDocument == null) {
            throw new WCMException(10, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label108", "{0}\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u79fb\u52a8\uff01"), new String[]{sEntryName}));
        }
        Channel channel = fromChannel = _fromChannel == null ? _fromDocument.getChannel() : _fromChannel;
        if (_fromDocument.isDraft()) {
            fromChannel = Channel.DRAFT_CHANNEL;
        }
        if (fromChannel == null) {
            throw new WCMException(10, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label107", "\u539f\u59cb\u680f\u76ee\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u79fb\u52a8{0}\uff01"), new String[]{sEntryName}));
        }
        Report report = null;
        ChnlDoc dest = ChnlDoc.findByDocAndChnl(_fromDocument, _toChannel);
        if (dest != null && dest.getChannelId() == _toChannel.getId()) {
            report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label96", "\u79fb\u52a8{3}[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u5931\u8d25\uff01"), new String[]{_fromDocument.getTitle(), _toChannel.getDispDesc(), String.valueOf(_toChannel.getId()), sEntryName}));
            report.setRportDetail(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label104", "\u56e0\u4e3a\u5df2\u7ecf\u5728\u76ee\u6807\u680f\u76ee\u4e2d\u5b58\u5728\uff01"));
            report.setType(5);
            return report;
        }
        if (fromChannel == Channel.DRAFT_CHANNEL) {
            ChnlDoc newChnlDoc = this.createChnlDocWithEntity(_fromDocument, _toChannel, false);
            newChnlDoc.setModal(1);
            newChnlDoc.save(this.getLoginUser());
            report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label97", "\u79fb\u52a8{3}[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u6210\u529f\uff01"), new String[]{_fromDocument.getTitle(), _toChannel.getDispDesc(), String.valueOf(_toChannel.getId()), sEntryName}));
            report.setType(3);
            return report;
        }
        if (_fromDocument.getStatusId() == 1028) {
            report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label120", "{1}[{0}]\u72b6\u6001\u4e3a\u8349\u7a3f\uff0c\u65e0\u6cd5\u79fb\u52a8\uff01"), new String[]{_fromDocument.getTitle(), sEntryName}));
            report.setType(5);
            return report;
        }
        ChnlDoc srcChnlDoc = this.findChnlDoc(_fromDocument, fromChannel);
        if (srcChnlDoc.isEntity()) {
            User loginUser;
            int nDocKind;
            if (_toChannel.getType() != fromChannel.getType()) {
                report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label98", "\u79fb\u52a8{3}[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u5931\u8d25\uff01\u56e0\u4e3a\u4e0d\u540c\u7c7b\u578b\u4e4b\u95f4\u7684\u680f\u76ee\u4e0d\u5141\u8bb8\u79fb\u52a8\u6570\u636e\uff01"), new String[]{_fromDocument.getTitle(), _toChannel.getDispDesc(), String.valueOf(_toChannel.getId()), sEntryName}));
                report.setType(5);
                return report;
            }
            if (fromChannel.getType() == 13) {
                String strInChannelIds = fromChannel.getId() + "," + _toChannel.getId();
                String sqlQuery = "select count(distinct InfoViewId) from WCMInfoViewEmploy where EmployerType=101 and EmployerID in(" + strInChannelIds + ")";
                int nCount = DBManager.getDBManager().sqlExecuteIntQuery(sqlQuery);
                if (nCount > 1) {
                    report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label110", "\u79fb\u52a8{3}[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u5931\u8d25\uff01\u56e0\u4e3a\u914d\u7f6e\u4e86\u4e0d\u540c\u8868\u5355\u7684\u680f\u76ee\u4e0d\u5141\u8bb8\u79fb\u52a8\u6570\u636e\uff01"), new String[]{_fromDocument.getTitle(), _toChannel.getDispDesc(), String.valueOf(_toChannel.getId()), sEntryName}));
                    report.setType(5);
                    return report;
                }
            }
            if ((nDocKind = srcChnlDoc.getPropertyAsInt("DocKind", 0)) != 0) {
                int nToChnlId = _toChannel.getId();
                String sqlQuery = "select count(distinct ViewId) from XWCMMetaViewEmployer where XWCMMetaViewEmployer.ChannelId=" + nToChnlId + " and XWCMMetaViewEmployer.ViewId=" + nDocKind;
                int nCount = DBManager.getDBManager().sqlExecuteIntQuery(sqlQuery);
                if (nCount <= 0) {
                    report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label113", "\u79fb\u52a8{3}[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u5931\u8d25\uff01\u56e0\u4e3a\u914d\u7f6e\u4e86\u4e0d\u540c\u89c6\u56fe\u7684\u680f\u76ee\u4e0d\u5141\u8bb8\u79fb\u52a8\u6570\u636e\uff01"), new String[]{_fromDocument.getTitle(), _toChannel.getDispDesc(), String.valueOf(_toChannel.getId()), sEntryName}));
                    report.setType(5);
                    return report;
                }
            }
            if (!_fromDocument.canEdit(loginUser = this.getLoginUser())) {
                report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label99", "\u79fb\u52a8{4}[{0}]\u5230\u680f\u76ee[{1}][ID={3}]\u5931\u8d25\uff01\u56e0\u4e3a{4}\u88ab{2}\u9501\u5b9a\uff01"), new String[]{_fromDocument.getTitle(), _toChannel.getDispDesc(), _fromDocument.getLockerUserName(), String.valueOf(_toChannel.getId()), sEntryName}));
                report.setType(5);
                return report;
            }
            try {
                this.moveTo(srcChnlDoc, _toChannel);
            }
            finally {
                _fromDocument.unlock();
            }
        } else {
            this.moveTo(srcChnlDoc, _toChannel);
        }
        report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label97", "\u79fb\u52a8{3}[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u6210\u529f\uff01"), new String[]{_fromDocument.getTitle(), _toChannel.getDispDesc(), String.valueOf(_toChannel.getId()), sEntryName}));
        report.setType(3);
        return report;
    }

    public void restore(Document _delDocument, Channel _currChannel) throws WCMException {
        Channel currChannel;
        if (_delDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label66", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61,\u4e0d\u80fd\u8fdb\u884c\u6062\u590d\u64cd\u4f5c!"));
        }
        Channel channel = currChannel = _currChannel == null ? _delDocument.getChannel() : _currChannel;
        if (_delDocument.isDraft()) {
            currChannel = Channel.DRAFT_CHANNEL;
        }
        if (currChannel == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label67", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6062\u590d\u6587\u6863\uff01"));
        }
        if (currChannel.getId() == 0) {
            if (_delDocument.canEdit(this.getLoginUser())) {
                _delDocument.setDeleted(false);
                _delDocument.update(this.getLoginUser());
            }
        } else {
            this.restore(this.findChnlDoc(_delDocument, currChannel));
        }
    }

    public void restore(ChnlDoc _oChnlDocDeleted) throws WCMException {
        if (_oChnlDocDeleted == null) {
            throw new WCMException(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label68", "\u65e0\u6cd5\u627e\u5230\u9891\u9053\u6587\u6863\uff0c\u4e0d\u80fd\u8fdb\u884c\u6062\u590d\u64cd\u4f5c\uff01"));
        }
        if (!_oChnlDocDeleted.canEdit(this.getLoginUser())) {
            throw new WCMException(1013, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label69", "\u5f53\u524d\u6587\u6863\u5df2\u7ecf\u88ab\u5176\u4ed6\u7528\u6237\u9501\u5b9a\uff0c\u65e0\u6cd5\u6062\u590d\uff01"));
        }
        _oChnlDocDeleted.setDeleted(false);
        _oChnlDocDeleted.setOperUser(this.getLoginUser());
        _oChnlDocDeleted.setOperTime();
        _oChnlDocDeleted.update(this.getLoginUser());
    }

    public void restoreAll(User _currUser, BaseChannel _oSiteOrChannel) throws WCMException {
        String sQueryChnlDocsSQL;
        boolean bClearInChannel = true;
        if (_oSiteOrChannel.isSite()) {
            bClearInChannel = false;
            sQueryChnlDocsSQL = "(DocStatus<0 or Modal<0) and exists( select c.ChannelId from WCMChannel c   Where c.Status>=0 and c.SiteId=? and WCMChnlDoc.ChnlId=c.ChannelId)";
        } else {
            sQueryChnlDocsSQL = "ChnlId=? and (DocStatus<0 or Modal<0)";
        }
        WCMFilter filter = new WCMFilter("WCMChnlDoc", sQueryChnlDocsSQL, "");
        filter.addSearchValues(_oSiteOrChannel.getId());
        ChnlDocs chnlDocs = ChnlDocs.openWCMObjs(null, filter);
        int nSize = chnlDocs.size();
        for (int i = 0; i < nSize; ++i) {
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null || !chnlDoc.isDeleted() || (bClearInChannel ? DocumentAuthServer.isDefineRightOnDocument(chnlDoc.getDocId()) && !DocumentAuthServer.hasRight(_currUser, chnlDoc, 33) : !DocumentAuthServer.hasRight(_currUser, chnlDoc, 33))) continue;
            this.restore(chnlDoc);
        }
    }

    public void clearAll(User _currUser, BaseChannel _oSiteOrChannel) throws WCMException {
        String sQueryChnlDocsSQL;
        boolean bClearInChannel = true;
        if (_oSiteOrChannel.isSite()) {
            bClearInChannel = false;
            sQueryChnlDocsSQL = "(DocStatus<0 or Modal<0) and exists( select c.ChannelId from WCMChannel c   Where c.Status>=0 and c.SiteId=? and WCMChnlDoc.ChnlId=c.ChannelId)";
        } else {
            sQueryChnlDocsSQL = "ChnlId=? and (DocStatus<0 or Modal<0)";
        }
        WCMFilter filter = new WCMFilter("WCMChnlDoc", sQueryChnlDocsSQL, "");
        filter.addSearchValues(_oSiteOrChannel.getId());
        ChnlDocs chnlDocs = ChnlDocs.openWCMObjs(null, filter);
        int nSize = chnlDocs.size();
        for (int i = 0; i < nSize; ++i) {
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null || (!bClearInChannel ? !DocumentAuthServer.hasRight(_currUser, chnlDoc, 33) : DocumentAuthServer.isDefineRightOnDocument(chnlDoc.getDocId()) && !DocumentAuthServer.hasRight(_currUser, chnlDoc, 33))) continue;
            if (chnlDoc.isEntity()) {
                this.getChnlDocs(chnlDoc.getDocId(), 0, null).removeAll(true);
            }
            try {
                this.delete(chnlDoc, true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Report quoteTo(Document _fromDocument, Channel _toChannel) throws WCMException {
        return this.quoteTo(_fromDocument, null, _toChannel, "false");
    }

    public Report quoteTo(Document _fromDocument, Channel _fromChannel, Channel _toChannel) throws WCMException {
        return this.quoteTo(_fromDocument, _fromChannel, _toChannel, "false");
    }

    public Report quoteTo(Document _fromDocument, Channel _toChannel, String _sIsPhoto) throws WCMException {
        return this.quoteTo(_fromDocument, _toChannel, _sIsPhoto);
    }

    public Report quoteTo(Document _fromDocument, Channel _fromChannel, Channel _toChannel, String _sIsPhoto) throws WCMException {
        String sEntryName = I18NMessage.get(DocumentMgr.class, "DocumentMgr.label105", "\u6587\u6863");
        if (_sIsPhoto != null && _sIsPhoto.trim().equals("true")) {
            sEntryName = I18NMessage.get(DocumentMgr.class, "DocumentMgr.label106", "\u56fe\u7247");
        }
        if (_fromDocument == null) {
            throw new WCMException(10, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label70", "{0}\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"), new String[]{sEntryName}));
        }
        if (_fromDocument.getChannel() == null) {
            throw new WCMException(10, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label71", "{0}\u4e0d\u5c5e\u4e8e\u4efb\u4f55\u9891\u9053\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"), new String[]{sEntryName}));
        }
        if (_fromDocument.isDraft()) {
            throw new WCMException(10, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label72", "\u65e0\u6cd5\u4ece\u8349\u7a3f\u7bb1\u4e2d\u8f6c\u53d1{0}\uff01"), new String[]{sEntryName}));
        }
        return this.transmitTo(_fromDocument, _fromChannel, _toChannel, true, _sIsPhoto);
    }

    public Report mirrorTo(Document _fromDocument, Channel _toChannel) throws WCMException {
        return this.mirrorTo(_fromDocument, null, _toChannel);
    }

    public Report mirrorTo(Document _fromDocument, Channel _fromChannel, Channel _toChannel) throws WCMException {
        if (_fromDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label70", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"));
        }
        if (_fromDocument.getChannel() == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label71", "\u6587\u6863\u4e0d\u5c5e\u4e8e\u4efb\u4f55\u9891\u9053\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"));
        }
        if (_fromDocument.isDraft()) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label72", "\u65e0\u6cd5\u4ece\u8349\u7a3f\u7bb1\u4e2d\u8f6c\u53d1\u6587\u6863\uff01"));
        }
        return this.transmitTo(_fromDocument, _fromChannel, _toChannel, false, "false");
    }

    public Documents getRelatedDocuments(Document _currDocument, int _nGetByWhich, WCMFilter _filter) throws WCMException {
        return this.getRelatedDocuments(_currDocument, _nGetByWhich, _filter, true, false);
    }

    public Documents getRelatedDocuments(Document _currDocument, int _nGetByWhich, WCMFilter _filter, boolean _bExactMatch, boolean _bMultiSites) throws WCMException {
        return this.getRelatedDocuments(_currDocument, _nGetByWhich, _filter, _bExactMatch, _bMultiSites, null, true);
    }

    public Documents getRelatedDocuments(Document _currDocument, int _nGetByWhich, WCMFilter _filter, boolean _bExactMatch, boolean _bMultiSites, boolean bRemoveRepeatTitle) throws WCMException {
        return this.getRelatedDocuments(_currDocument, _nGetByWhich, _filter, _bExactMatch, _bMultiSites, null, bRemoveRepeatTitle);
    }

    private Documents getRelatedDocuments(Document _currDocument, int _nGetByWhich, WCMFilter _filter, boolean _bExactMatch, boolean _bMultiSites, ArrayList _arExistDocumentTitles, boolean bRemoveRepeatTitle) throws WCMException {
        if (_currDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label73", "\u5f53\u524d\u6587\u6863\u4e3a\u7a7a,\u65e0\u6cd5\u53d6\u5230\u4e0e\u5b83\u76f8\u5173\u7684\u6587\u6863!"));
        }
        WCMFilter docFilter = null;
        switch (_nGetByWhich) {
            case 0: {
                return this.getAllRelatedDocuments(_currDocument, _filter, _bExactMatch, _bMultiSites);
            }
            case 30: {
                docFilter = this.constructRelationFilter(_currDocument, _filter, _bMultiSites);
                break;
            }
            case 10: 
            case 20: {
                int[] pStatusesId = new int[]{10};
                boolean bFilterStatus = false;
                int nMaxSize = 100;
                String sSelectFields = "";
                if (_filter != null) {
                    sSelectFields = _filter.getSelect();
                    nMaxSize = _filter.getMaxRowNumber();
                    String sWhere = _filter.getWhere().toUpperCase();
                    if (sWhere.indexOf("DOCSTATUS") >= 0 && sWhere.indexOf(String.valueOf(10)) > 0) {
                        bFilterStatus = true;
                    }
                }
                return this.m_oDocKeywordMgr.getRelatedDocumentsByKeywords(_currDocument, nMaxSize, sSelectFields, (int[])(bFilterStatus ? pStatusesId : null), _bMultiSites, _arExistDocumentTitles, bRemoveRepeatTitle);
            }
            default: {
                throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label74", "\u65e0\u6548\u7684\u76f8\u5173\u6587\u6863\u83b7\u53d6\u65b9\u5f0f!"));
            }
        }
        try {
            return Documents.openWCMObjs(this.getLoginUser(), docFilter);
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label75", "\u83b7\u53d6\u4e0e\u5f53\u524d\u6587\u6863\u76f8\u5173\u7684\u6587\u6863\u96c6\u5408\u5931\u8d25!"), ex);
        }
    }

    private Documents getAllRelatedDocuments(Document _currDocument, WCMFilter _filter, boolean _bExactMatch, boolean _bMultiSites) throws WCMException {
        int nMaxSize;
        Documents allRelDocs = null;
        Documents relDocs = null;
        int nSize = nMaxSize = _filter == null || _filter.getMaxRowNumber() <= 0 ? 30 : _filter.getMaxRowNumber();
        allRelDocs = this.getRelatedDocuments(_currDocument, 30, _filter, _bExactMatch, _bMultiSites);
        allRelDocs.setMaxBufferSize(allRelDocs.size());
        ArrayList<String> arExistDocumentTitles = new ArrayList<String>(nSize);
        for (int i = allRelDocs.size() - 1; i >= 0; --i) {
            Document document = (Document)allRelDocs.getAt(i);
            if (document == null) {
                allRelDocs.removeAt(i, false);
                continue;
            }
            String sTitle = document.getTitle();
            if (arExistDocumentTitles.contains(sTitle)) {
                allRelDocs.removeAt(i, false);
                continue;
            }
            arExistDocumentTitles.add(sTitle);
        }
        if (allRelDocs.size() >= nSize) {
            return allRelDocs;
        }
        nSize = nMaxSize - allRelDocs.size();
        if (_filter != null) {
            _filter.setMaxRowNumber(nSize);
        }
        relDocs = this.getRelatedDocuments(_currDocument, 10, _filter, _bExactMatch, _bMultiSites, arExistDocumentTitles, true);
        allRelDocs.addWith(relDocs);
        return allRelDocs;
    }

    private WCMFilter constructRelationFilter(Document _currDocument, WCMFilter _filter, boolean _bMultiSite) throws WCMException {
        Channel currChannel = _currDocument.getChannel();
        int nSiteId = currChannel.getSiteId();
        String sFrom = "WCMDocument,WCMRelation";
        String sOrder = "WCMRelation.SERN";
        String sWhere = "(WCMRelation.DocId=?) and (WCMDocument.DocId=WCMRelation.RelDocId) and (WCMDocument.DocStatus>0) AND (WCMDocument.DocChannel>0)";
        if (!_bMultiSite) {
            sWhere = sWhere + "and exists(select 1 from WCMChannel where WCMChannel.Siteid=? and WCMChannel.Channelid=WCMDocument.DocChannel)";
        }
        WCMFilter relationFilter = new WCMFilter(sFrom, sWhere, sOrder);
        relationFilter.addSearchValues(_currDocument.getId());
        if (!_bMultiSite) {
            relationFilter.addSearchValues(nSiteId);
        }
        if (_filter != null) {
            String sSelect = _filter.getSelect();
            sSelect = this.filterSelectForRelations(sSelect);
            _filter.setSelect(sSelect);
        }
        relationFilter.mergeWith(_filter);
        return relationFilter;
    }

    private String filterSelectForRelations(String _sSelect) {
        String sSelect = "";
        if (_sSelect != null && _sSelect.length() > 0) {
            sSelect = _sSelect.trim().toUpperCase();
            int nPos = 0;
            nPos = sSelect.indexOf("DOCID", nPos);
            while (nPos >= 0) {
                if (nPos == 0 || nPos > 0 && sSelect.charAt(nPos - 1) != '.') {
                    sSelect = sSelect.substring(0, nPos) + "WCMDocument." + sSelect.substring(nPos);
                }
                nPos = sSelect.indexOf("DOCID", nPos + 18);
            }
        }
        return sSelect;
    }

    private DBManager getDBManager() throws WCMException {
        DBManager currDBManager = DBManager.getDBManager();
        if (currDBManager == null || !currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label76", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label77", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return currDBManager;
    }

    public CMyDateTime getDocumentTopTime(Document _currDocument, Channel _currChannel) throws WCMException {
        if (_currDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label78", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u5f97\u5176\u7f6e\u9876\u622a\u6b62\u65f6\u95f4\uff01"));
        }
        if (_currChannel == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label79", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u5f97\u5176\u4e0b\u6587\u6863\u7684\u7f6e\u9876\u622a\u6b62\u65f6\u95f4\uff01"));
        }
        if (!this.isDocumentTopped(_currDocument, _currChannel)) {
            return null;
        }
        ChnlDoc currChnlDoc = this.findChnlDoc(_currDocument, _currChannel);
        if (currChnlDoc.getInvalidTime() == null || currChnlDoc.getInvalidTime().isNull()) {
            return null;
        }
        return currChnlDoc.getInvalidTime();
    }

    public ChnlDocs getChnlDocs(int _nDocId, int _nDocModal, WCMFilter _extraFilter, int excludedChnlId) throws WCMException {
        ChnlDocs chnldocs = new ChnlDocs(this.getLoginUser());
        WCMFilter filter = new WCMFilter();
        filter.addSearchValues(_nDocId);
        String sWhere = "DOCID=?";
        if (excludedChnlId > 0) {
            sWhere = sWhere + " and CHNLID <> ?";
            filter.addSearchValues(excludedChnlId);
        }
        if (_nDocModal != 0) {
            sWhere = sWhere + " and MODAL=?";
            filter.addSearchValues(_nDocModal);
        }
        filter.setWhere(sWhere);
        if (_extraFilter != null) {
            filter.mergeWith(_extraFilter);
        }
        chnldocs.open(filter);
        return chnldocs;
    }

    public ChnlDocs getChnlDocs(int _nDocId, int _nDocModal, WCMFilter _extraFilter) throws WCMException {
        return this.getChnlDocs(_nDocId, _nDocModal, _extraFilter, 0);
    }

    public void deleteDocQuotes(Document _currDocument, String _sExcludeChannelIds) throws WCMException {
        this.addQuoteType(_currDocument, _sExcludeChannelIds, 5);
    }

    public void deleteDocMirrors(Document _currDocument, String _sExcludeChannelIds) throws WCMException {
        this.addQuoteType(_currDocument, _sExcludeChannelIds, 3);
    }

    private void addQuoteType(Document _currDocument, String _sExcludeChannelIds, int _nQuoteType) throws WCMException {
        if (_currDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label80", "\u6587\u6863\u4e3a\u7a7a\uff0c\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"));
        }
        String sWhere = "";
        if (_sExcludeChannelIds != null && _sExcludeChannelIds.trim().length() != 0) {
            sWhere = "CHNLID NOT IN(" + _sExcludeChannelIds + ")";
        }
        WCMFilter unusedFilter = new WCMFilter("", sWhere, "");
        ChnlDocs delChnlDocs = this.getChnlDocs(_currDocument.getId(), _nQuoteType, unusedFilter);
        delChnlDocs.removeAll(true);
    }

    private String getDoctitleWhenCopy(String _sOldTitle) {
        if (_sOldTitle == null || _sOldTitle.trim().length() == 0) {
            return _sOldTitle;
        }
        return this.getCopyPrefix() + _sOldTitle;
    }

    private String getCopyPrefix() {
        String sPrefix = "";
        try {
            sPrefix = ConfigServer.getServer().getSysConfigValue(CONFIG_COPY_TITLE_PREFIX, "");
        }
        catch (Exception ex) {
            m_oLogger.debug((Object)I18NMessage.get(DocumentMgr.class, "DocumentMgr.label81", "\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u6587\u6863\u590d\u5236\u65f6\u9700\u8981\u589e\u52a0\u7684\u524d\u7f00\u9879\u76ee\u5931\u8d25\uff01"));
            return "";
        }
        return sPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDocumentInChannel(Document _fromDocument, Document _toDocument, Channel _currChannel, int _nPosition) throws WCMException {
        if (_currChannel == null || _currChannel.isOnlySearch()) {
            return;
        }
        Object object = _currChannel.getDocOrderLock();
        synchronized (object) {
            ChnlDoc fromChnlDoc = this.findChnlDoc(_fromDocument, _currChannel);
            ChnlDoc toChnlDoc = this.findChnlDoc(_toDocument, _currChannel);
            if (fromChnlDoc == null || toChnlDoc == null) {
                throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label82", "\u65e0\u6cd5\u627e\u5230\u9891\u9053\u4e0b\u7684\u6587\u6863\uff01"));
            }
            if (fromChnlDoc.isTopped()) {
                throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label83", "\u8fd9\u7bc7\u6587\u6863\u662f\u7f6e\u9876\u6587\u6863\uff0c\u60a8\u4e0d\u80fd\u8fd9\u6837\u5bf9\u5176\u8c03\u6574\u987a\u5e8f\uff0c\u8bf7\u901a\u8fc7\u6539\u53d8\u7f6e\u9876\u987a\u5e8f\u5b8c\u6210\u8fd9\u6837\u7684\u64cd\u4f5c\uff01"));
            }
            if (toChnlDoc.isTopped()) {
                throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label109", "\u60a8\u65e0\u6cd5\u5c06\u8fd9\u7bc7\u6587\u6863\u4e0e\u7f6e\u9876\u6587\u6863\u8c03\u6574\u987a\u5e8f\uff0c\u8bf7\u9009\u62e9\u5176\u5b83\u4f4d\u7f6e\uff01"));
            }
            int nFromDocOrder = fromChnlDoc.getDocOrder();
            int nToDocOrder = toChnlDoc.getDocOrder();
            if (fromChnlDoc.equals(toChnlDoc) || nFromDocOrder == nToDocOrder) {
                return;
            }
            int nNewOrder = nFromDocOrder;
            int nOldOffset = nFromDocOrder - nToDocOrder;
            int nMoveBeginAt = 0;
            int nMoveEndAt = 0;
            int nMoveDirection = 0;
            switch (_nPosition) {
                case 1: {
                    if (nOldOffset == 1) {
                        return;
                    }
                    if (nOldOffset > 0) {
                        nMoveBeginAt = nToDocOrder + 1;
                        nMoveEndAt = nFromDocOrder - 1;
                        nNewOrder = nMoveBeginAt;
                        nMoveDirection = 1;
                        break;
                    }
                    if (nOldOffset >= 0) break;
                    nMoveBeginAt = nFromDocOrder + 1;
                    nNewOrder = nMoveEndAt = nToDocOrder;
                    nMoveDirection = -1;
                    break;
                }
                case 0: {
                    if (nOldOffset == -1) {
                        return;
                    }
                    if (nOldOffset > 0) {
                        nMoveBeginAt = nToDocOrder;
                        nMoveEndAt = nFromDocOrder - 1;
                        nNewOrder = nMoveBeginAt;
                        nMoveDirection = 1;
                        break;
                    }
                    if (nOldOffset >= 0) break;
                    nMoveBeginAt = nFromDocOrder + 1;
                    nNewOrder = nMoveEndAt = nToDocOrder - 1;
                    nMoveDirection = -1;
                }
            }
            String sRegionWhere = "DocOrder>=? AND DocOrder <=? and ChnlId=?";
            String sMoveSql = "UPDATE WCMChnlDoc SET DocOrder = DocOrder+(" + nMoveDirection + ") WHERE " + "DocOrder>=? AND DocOrder <=? and ChnlId=?";
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{sMoveSql}, new int[]{nMoveBeginAt, nMoveEndAt, _currChannel.getId()});
            fromChnlDoc.canEdit(this.getLoginUser());
            fromChnlDoc.setDocOrder(nNewOrder);
            fromChnlDoc.save(this.getLoginUser());
        }
    }

    public void moveDocumentInChannel(Document _fromDocument, Document _toDocument, Channel _currChannel) throws WCMException {
        this.moveDocumentInChannel(_fromDocument, _toDocument, _currChannel, 1);
    }

    public ChnlDoc getPreviousChnlDoc(ChnlDoc _currChnlDoc, boolean _bIncludeTop) throws WCMException {
        if (_currChnlDoc == null) {
            return null;
        }
        String sSql = "";
        sSql = _bIncludeTop ? "SELECT MIN(DOCORDER) FROM WCMCHNLDOC WHERE DOCORDER>" + _currChnlDoc.getDocOrder() + " AND CHNLID=" + _currChnlDoc.getChannelId() : "SELECT MIN(DOCORDER) FROM WCMCHNLDOC WHERE DOCORDER>" + _currChnlDoc.getDocOrder() + " AND CHNLID=" + _currChnlDoc.getChannelId() + " AND DOCORDERPRI=" + ChnlDoc.NOT_ON_TOP;
        int nCurrOrder = DBManager.getDBManager().sqlExecuteIntQuery(sSql);
        if (nCurrOrder == 0) {
            return null;
        }
        return this.getChnlDocByDocOrder(_currChnlDoc.getChannel(), nCurrOrder);
    }

    public ChnlDoc getNextChnlDoc(ChnlDoc _currChnlDoc, boolean _bIncludeTop) throws WCMException {
        if (_currChnlDoc == null) {
            return null;
        }
        String sSql = "";
        sSql = _bIncludeTop ? "SELECT MAX(DOCORDER) FROM WCMCHNLDOC WHERE DOCORDER<" + _currChnlDoc.getDocOrder() + " AND CHNLID=" + _currChnlDoc.getChannelId() : "SELECT MAX(DOCORDER) FROM WCMCHNLDOC WHERE DOCORDER<" + _currChnlDoc.getDocOrder() + " AND CHNLID=" + _currChnlDoc.getChannelId() + " AND DOCORDERPRI=" + ChnlDoc.NOT_ON_TOP;
        int nCurrOrder = DBManager.getDBManager().sqlExecuteIntQuery(sSql);
        if (nCurrOrder == 0) {
            return null;
        }
        return this.getChnlDocByDocOrder(_currChnlDoc.getChannel(), nCurrOrder);
    }

    public ChnlDoc getFirstChnlDoc(ChnlDoc _currChnlDoc, boolean _bIncludeTop) throws WCMException {
        if (_currChnlDoc == null) {
            return null;
        }
        String sSql = "";
        sSql = _bIncludeTop ? "SELECT MAX(DOCORDER) FROM WCMCHNLDOC WHERE CHNLID=" + _currChnlDoc.getChannelId() : "SELECT MAX(DOCORDER) FROM WCMCHNLDOC WHERE CHNLID=" + _currChnlDoc.getChannelId() + " AND DOCORDERPRI=" + ChnlDoc.NOT_ON_TOP;
        int nCurrOrder = DBManager.getDBManager().sqlExecuteIntQuery(sSql);
        if (nCurrOrder == 0) {
            return null;
        }
        return this.getChnlDocByDocOrder(_currChnlDoc.getChannel(), nCurrOrder);
    }

    public ChnlDoc getLastChnlDoc(ChnlDoc _currChnlDoc, boolean _bIncludeTop) throws WCMException {
        if (_currChnlDoc == null) {
            return null;
        }
        String sSql = "";
        sSql = _bIncludeTop ? "SELECT MIN(DOCORDER) FROM WCMCHNLDOC WHERE CHNLID=" + _currChnlDoc.getChannelId() : "SELECT MIN(DOCORDER) FROM WCMCHNLDOC WHERE CHNLID=" + _currChnlDoc.getChannelId() + " AND DOCORDERPRI=" + ChnlDoc.NOT_ON_TOP;
        int nCurrOrder = DBManager.getDBManager().sqlExecuteIntQuery(sSql);
        if (nCurrOrder == 0) {
            return null;
        }
        return this.getChnlDocByDocOrder(_currChnlDoc.getChannel(), nCurrOrder);
    }

    private ChnlDoc getChnlDocByDocOrder(Channel _currChannel, int _nDocOrder) throws WCMException {
        if (_currChannel == null) {
            return null;
        }
        String sWhere = "DOCORDER=" + _nDocOrder + " AND CHNLID=" + _currChannel.getId();
        WCMFilter currFilter = new WCMFilter("", sWhere, "");
        ChnlDocs aChnlDocs = ChnlDocs.openWCMObjs(this.getLoginUser(), currFilter);
        if (aChnlDocs == null || aChnlDocs.isEmpty()) {
            return null;
        }
        return (ChnlDoc)aChnlDocs.getAt(0);
    }

    private boolean hasRight(User _loginUser, BaseChannel _channelOrSite, Document _document, int _nRightIndex) throws WCMException {
        return DocumentAuthServer.hasRight(_loginUser, _channelOrSite, _document, _nRightIndex);
    }

    public Reports moveAllDocumentsToChannel(Channel _fromChannel, Channel _toChannel) throws WCMException {
        WCMFilter filter = new WCMFilter("", "DocChannel=? and DocStatus>0", "");
        filter.addSearchValues(_fromChannel.getId());
        ViewDocuments viewDocuments = new ViewDocuments(this.getLoginUser(), 1, 1);
        viewDocuments.setPageSize(-1);
        viewDocuments.open(_fromChannel, filter);
        return this.moveDocumentsToChannel(viewDocuments, _fromChannel, _toChannel);
    }

    public Reports moveDocumentsToChannel(ViewDocuments _sViewDocuments, Channel _fromChannel, Channel _toChannel) throws WCMException {
        if (_fromChannel == null || _toChannel == null) {
            Reports reports = new Reports(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label84", "\u79fb\u52a8\u6240\u6709\u6587\u6863\uff01"));
            reports.addFailedReport(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label85", "\u6307\u5b9a\u680f\u76ee\u4e0d\u5b58\u5728\uff01"), null);
            return reports;
        }
        String sDesc = CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label87", "\u4ece\u680f\u76ee\u3010{0}\u3011\u79fb\u52a8\u6240\u6709\u6587\u6863\u5230\u3010{1}\u3011"), new String[]{_fromChannel.getDispDesc(), _toChannel.getDispDesc()});
        Reports reports = new Reports(sDesc);
        for (int i = _sViewDocuments.size() - 1; i >= 0; --i) {
            ViewDocument currViewDocument = (ViewDocument)_sViewDocuments.getAt(i);
            if (currViewDocument == null) continue;
            Document document = currViewDocument.getDocument();
            try {
                reports.addReport(this.moveTo(document, _fromChannel, _toChannel));
                continue;
            }
            catch (Throwable e) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label102", "\u4ece\u680f\u76ee[{0}\u79fb\u52a8\u6587\u6863[{1}]\u5230\u680f\u76ee[{2}]\u5931\u8d25."), new String[]{_fromChannel.getDispDesc(), document.getTitle(), _toChannel.getDispDesc()}), e);
            }
        }
        return reports;
    }

    public void setTopDocument(Channel _currChannel, Document _fromDocument, Document _toDocument, int _nPosition, CMyDateTime dtValid) throws WCMException {
        if (_currChannel == null || _currChannel.isOnlySearch()) {
            return;
        }
        User loginUser = this.getLoginUser();
        ChnlDoc fromChnlDoc = this.findChnlDoc(_fromDocument, _currChannel);
        if (fromChnlDoc == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label91", "\u65e0\u6cd5\u627e\u5230\u9891\u9053[") + _currChannel + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label92", "]\u4e0b\u7684\u6587\u6863[") + _fromDocument + "]\uff01");
        }
        if (_toDocument == null) {
            fromChnlDoc.validCanEditAndLock(loginUser);
            if (!fromChnlDoc.isTopped()) {
                fromChnlDoc.setProperty("DOCORDERPRI", this.getMaxDocOrderPri(_currChannel));
            }
            if (dtValid != null && !dtValid.isNull()) {
                fromChnlDoc.setInvalidTime(dtValid);
            } else if (dtValid == null) {
                fromChnlDoc.setInvalidTime(null);
            }
            fromChnlDoc.save(loginUser);
            return;
        }
        ChnlDoc toChnlDoc = this.findChnlDoc(_toDocument, _currChannel);
        if (toChnlDoc == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label91", "\u65e0\u6cd5\u627e\u5230\u9891\u9053[") + _currChannel + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label92", "]\u4e0b\u7684\u6587\u6863[") + _toDocument + "]\uff01");
        }
        if (!toChnlDoc.isTopped()) {
            throw new WCMException(1101, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label93", "\u76ee\u6807\u9891\u9053\u6ca1\u6709\u7f6e\u9876\uff0c\u4f20\u5165\u7684TargetDocument[Id=") + toChnlDoc.getDocId() + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label94", "]\u6709\u8bef\uff01"));
        }
        int nFromDocOrderPri = fromChnlDoc.getDocOrderPri(true);
        int nToDocOrderPri = toChnlDoc.getDocOrderPri(true);
        int nNewOrder = nFromDocOrderPri;
        int nOldOffset = nFromDocOrderPri - nToDocOrderPri;
        int nMoveBeginAt = 0;
        int nMoveEndAt = 0;
        int nMoveDirection = 0;
        if (!fromChnlDoc.isTopped()) {
            nMoveBeginAt = nToDocOrderPri + _nPosition;
            nMoveEndAt = this.getMaxDocOrderPri(_currChannel);
            nNewOrder = nMoveBeginAt;
            nMoveDirection = 1;
        } else {
            switch (_nPosition) {
                case 1: {
                    if (nOldOffset == 1) break;
                    if (nOldOffset > 0) {
                        nMoveBeginAt = nToDocOrderPri + 1;
                        nMoveEndAt = nFromDocOrderPri - 1;
                        nNewOrder = nMoveBeginAt;
                        nMoveDirection = 1;
                        break;
                    }
                    if (nOldOffset >= 0) break;
                    nMoveBeginAt = nFromDocOrderPri + 1;
                    nNewOrder = nMoveEndAt = nToDocOrderPri;
                    nMoveDirection = -1;
                    break;
                }
                case 0: {
                    if (nOldOffset == -1) break;
                    if (nOldOffset > 0) {
                        nMoveBeginAt = nToDocOrderPri;
                        nMoveEndAt = nFromDocOrderPri - 1;
                        nNewOrder = nMoveBeginAt;
                        nMoveDirection = 1;
                        break;
                    }
                    if (nOldOffset >= 0) break;
                    nMoveBeginAt = nFromDocOrderPri + 1;
                    nNewOrder = nMoveEndAt = nToDocOrderPri - 1;
                    nMoveDirection = -1;
                }
            }
        }
        if (nNewOrder != nFromDocOrderPri) {
            String sRegionWhere = "DocOrderPri>=? AND DocOrderPri <=? and ChnlId=? and DocOrderPri>0";
            String sMoveSql = "UPDATE WCMChnlDoc SET DocOrderPri = DocOrderPri+(" + nMoveDirection + ") WHERE " + "DocOrderPri>=? AND DocOrderPri <=? and ChnlId=? and DocOrderPri>0";
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{sMoveSql}, new int[]{nMoveBeginAt, nMoveEndAt, _currChannel.getId()});
            fromChnlDoc.setProperty("DOCORDERPRI", nNewOrder);
        }
        fromChnlDoc.canEdit(loginUser);
        if (dtValid != null && !dtValid.isNull()) {
            fromChnlDoc.setInvalidTime(dtValid);
        } else if (dtValid == null) {
            fromChnlDoc.setInvalidTime(null);
        }
        fromChnlDoc.save(loginUser);
    }

    private int getMaxDocOrderPri(Channel _currChannel) throws WCMException {
        String SQL = "select max(DocOrderPri) from WCMChnlDoc where ChnlId=? and DocOrderPri>0";
        int nMaxDocOrderPri = DBManager.getDBManager().sqlExecuteIntQuery("select max(DocOrderPri) from WCMChnlDoc where ChnlId=? and DocOrderPri>0", new int[]{_currChannel.getId()});
        return nMaxDocOrderPri > 0 ? nMaxDocOrderPri : 1;
    }

    private int getMaxDocOrder(Channel _currChannel) throws WCMException {
        String SQL = "select max(DocOrder) from WCMChnlDoc where ChnlId=?";
        int nMaxDocOrder = DBManager.getDBManager().sqlExecuteIntQuery("select max(DocOrder) from WCMChnlDoc where ChnlId=?", new int[]{_currChannel.getId()});
        return nMaxDocOrder > 0 ? nMaxDocOrder : 0;
    }

    public void deleteDocQuotesInDelChnlIds(Document _currDocument, String _sDelChannelIds) throws WCMException {
        if (_currDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label80", "\u6587\u6863\u4e3a\u7a7a\uff0c\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"));
        }
        String sWhere = "";
        if (_sDelChannelIds != null && _sDelChannelIds.trim().length() != 0) {
            sWhere = "CHNLID IN(" + _sDelChannelIds + ")";
        }
        WCMFilter unusedFilter = new WCMFilter("", sWhere, "");
        ChnlDocs delChnlDocs = this.getChnlDocs(_currDocument.getId(), 2, unusedFilter);
        delChnlDocs.removeAll(true);
        delChnlDocs = this.getChnlDocs(_currDocument.getId(), 3, unusedFilter);
        delChnlDocs.removeAll(true);
    }
}

