/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.stat.BaseStatHandler;
import com.trs.infra.common.WCMException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class HitsStatHandler4User
extends BaseStatHandler {
    private static Logger logger = Logger.getLogger(HitsStatHandler4User.class);
    private int[] filterDocIds = null;
    private boolean bFilterByDocument = false;

    public HitsStatHandler4User() {
    }

    public HitsStatHandler4User(int[] _filterDocIds) {
        this.filterDocIds = _filterDocIds;
        this.bFilterByDocument = true;
    }

    @Override
    public void visitStatItem(ResultSet resultSet, int nSQLIndex) throws WCMException {
        try {
            int nCurrHitsCount = resultSet.getInt(1);
            if (nCurrHitsCount == 0) {
                return;
            }
            int nDocumentId = resultSet.getInt(2);
            if (this.bFilterByDocument) {
                if (this.filterDocIds == null) {
                    return;
                }
                boolean bContains = false;
                for (int k = 0; k < this.filterDocIds.length; ++k) {
                    if (nDocumentId != this.filterDocIds[k]) continue;
                    bContains = true;
                    break;
                }
                if (!bContains) {
                    return;
                }
            }
            String sUserName = resultSet.getString(3);
            int nHitsCount = this.getValue(nSQLIndex, sUserName);
            this.setValue(nSQLIndex, sUserName, nHitsCount += nCurrHitsCount);
            this.addMajorObject(sUserName);
        }
        catch (SQLException e) {
            logger.debug((Object)"\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new WCMException("\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
    }
}

