/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.element.PublishElementsCMSObjsImpl;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.RelationMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.Relation;
import com.trs.components.wcm.content.persistent.Relations;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WCMTagParserRelNewsForViewData
implements ITagParser,
ITagParser4List {
    private TagItem m_tagItem = null;
    private IPublishElements m_contents;
    private int m_nCurrPos = 0;
    private int m_nCurrDocId = 0;
    protected int m_nCurrNumber = 1;
    private PublishTagContext m_nextRecordContext = null;
    private static NamesRegister s_oNameRegister = new NamesRegister();
    private static TagBeanInfo s_TagBeanInfo;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_RELNEWS");
            tbi.setDesc("TRS_RELNEWS");
            tbi.setType(TagBeanInfo.BodyType.TAMPLATE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NUM");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("STARTPOS");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TARGET");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("_blank");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MODE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"USERDEF", "KEYWORDS", "ALL"});
            tbai.setDefaultValue("USERDEF");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MULTISITE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CHNLID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("SITEIDS");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CONTAINCHILDREN");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CHNLIDS");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TIMEFIELD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TIMECONDITION");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("PARENTCHANNELID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_tagItem = _item;
    }

    public void clear() {
        if (this.m_contents != null) {
            this.m_contents.clear();
        }
        if (this.m_nextRecordContext != null) {
            this.m_nextRecordContext = null;
        }
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        Documents relateDocs = this.getDocuments(_context);
        this.m_contents = new PublishElementsCMSObjsImpl(relateDocs);
        if (this.m_contents == null || this.m_contents.isEmpty()) {
            return null;
        }
        this.m_nextRecordContext = new PublishTagContext(_context, this.m_tagItem, this);
        String[] results = TagParseHelper.parse4List(this.m_tagItem, _context, this);
        return results;
    }

    private Documents getDocuments(PublishTagContext _context) throws WCMException {
        int i;
        Document doc = null;
        IPublishElement upperHost = _context.getUpperHost();
        if (!(upperHost instanceof IPublishContent)) {
            throw new WCMException(I18NMessage.get(WCMTagParserRelNewsForViewData.class, "WCMTagParserRelNewsForViewData.label1", "TRS_RELNEWS\u53ea\u80fd\u5e94\u7528\u5230\u6587\u6863\u4e0a!\u5f53\u524d\u5bf9\u8c61\u662f[") + upperHost.getInfo() + "]");
        }
        String sIdFields = _context.getAttribute("ID");
        if (!CMyString.isEmpty(sIdFields)) {
            MetaViewData viewData = this.findViewData(_context);
            if (viewData == null) {
                return Documents.createNewInstance(null);
            }
            Documents oDocs = Documents.findByIds(null, viewData.getPropertyAsString(sIdFields));
            this.excludeInvalidDocuments(oDocs);
            return oDocs;
        }
        try {
            doc = (Document)upperHost.getSubstance();
        }
        catch (ClassCastException ex) {
            throw new WCMException(I18NMessage.get(WCMTagParserRelNewsForViewData.class, "WCMTagParserRelNewsForViewData.label2", "TRS_RELNEWS\u53ea\u80fd\u5e94\u7528\u5230\u6587\u6863\u4e0a!\u76f8\u5173\u5bf9\u8c61\u662f\uff1a[") + upperHost.getSubstance() + "]", ex);
        }
        this.m_nCurrDocId = doc.getDocId();
        String sMode = _context.getAttribute("MODE");
        if (sMode == null || (sMode = sMode.trim()).length() == 0) {
            sMode = "USERDEF";
        }
        int nGetRelateMode = s_oNameRegister.lookup(sMode.toUpperCase(), 30);
        boolean bMultiSite = _context.getAttribute("MULTISITE", false);
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        WCMFilter filter = new WCMFilter("", "DocStatus=10 and DocChannel>0", "");
        String sChnlIds = _context.getAttribute("CHNLIDS");
        String sSiteIds = _context.getAttribute("SITEIDS");
        String sParentChannelId = _context.getAttribute("PARENTCHANNELID");
        if (!(CMyString.isEmpty(sChnlIds) && CMyString.isEmpty(sSiteIds) && CMyString.isEmpty(sParentChannelId))) {
            bMultiSite = true;
        }
        int nMaxNum = _context.getAttribute("NUM", 100);
        filter.setMaxRowNumber(nMaxNum);
        Documents relateDocs = documentMgr.getRelatedDocuments(doc, nGetRelateMode, filter, true, bMultiSite, false);
        ArrayList<String> lSiteIds = new ArrayList<String>();
        if (!CMyString.isEmpty(sSiteIds)) {
            if ("SELF".equalsIgnoreCase(sSiteIds)) {
                int nSiteId = doc.getChannel().getSiteId();
                lSiteIds.add(String.valueOf(nSiteId));
            } else {
                String[] ssSiteIds = sSiteIds.split(",");
                try {
                    for (int i2 = 0; i2 < ssSiteIds.length; ++i2) {
                        lSiteIds.add(ssSiteIds[i2].trim());
                    }
                }
                catch (Exception e) {
                    lSiteIds.clear();
                }
            }
        }
        int nChannelId = 0;
        ArrayList<String> ChannelIds = new ArrayList<String>();
        if (CMyString.isEmpty(sChnlIds)) {
            sChnlIds = _context.getAttribute("CHNLID");
        }
        if ("SELF".equalsIgnoreCase(sChnlIds)) {
            nChannelId = doc.getChannelId();
            ChannelIds.add(String.valueOf(nChannelId));
        } else if (!CMyString.isEmpty(sChnlIds)) {
            String[] sChannelIds = sChnlIds.split(",");
            try {
                for (i = 0; i < sChannelIds.length; ++i) {
                    ChannelIds.add(sChannelIds[i].trim());
                }
            }
            catch (Exception ex) {
                ChannelIds.clear();
            }
        }
        int nParentChannelId = 0;
        if ("SELF".equalsIgnoreCase(sParentChannelId)) {
            nParentChannelId = doc.getChannelId();
        } else if (!CMyString.isEmpty(sParentChannelId)) {
            try {
                nParentChannelId = Integer.parseInt(sParentChannelId);
            }
            catch (Exception ex) {
                nParentChannelId = 0;
            }
        }
        if (lSiteIds.size() > 0 || ChannelIds.size() > 0 || nParentChannelId != 0) {
            for (i = relateDocs.size() - 1; i >= 0; --i) {
                Channel parentChannel;
                int j;
                Document tmpDoc = (Document)relateDocs.getAt(i);
                if (tmpDoc == null) {
                    relateDocs.removeAt(i, false);
                    continue;
                }
                boolean bExist = false;
                for (j = lSiteIds.size() - 1; j >= 0; --j) {
                    int iSiteId = Integer.parseInt(lSiteIds.get(j).toString());
                    if (tmpDoc.getChannel().getSiteId() != iSiteId) continue;
                    bExist = true;
                    break;
                }
                if (bExist) continue;
                for (j = ChannelIds.size() - 1; j >= 0; --j) {
                    Channel parentChannel2;
                    int iChnlId = Integer.parseInt(ChannelIds.get(j).toString());
                    if (tmpDoc.getChannelId() == iChnlId) {
                        bExist = true;
                        break;
                    }
                    boolean bContainChildren = _context.getAttribute("CONTAINCHILDREN", false);
                    if (bContainChildren && (bExist = this.isAncestor(iChnlId, parentChannel2 = tmpDoc.getChannel().getParent()))) break;
                }
                if (bExist || nParentChannelId != 0 && (bExist = this.isAncestor(nParentChannelId, parentChannel = tmpDoc.getChannel().getParent())) || bExist) continue;
                relateDocs.removeAt(i, false);
            }
        }
        String timeFilterField = _context.getAttribute("TIMEFIELD");
        String timeFilterCondition = _context.getAttribute("TIMECONDITION");
        if (timeFilterField != null && timeFilterCondition != null) {
            CMyDateTime m_nCurrDocTime = doc.getPropertyAsDateTime(timeFilterField);
            for (int i3 = relateDocs.size() - 1; i3 >= 0; --i3) {
                Document tmpDoc = (Document)relateDocs.getAt(i3);
                if (tmpDoc == null) {
                    relateDocs.removeAt(i3, false);
                    continue;
                }
                CMyDateTime docTime = tmpDoc.getPropertyAsDateTime(timeFilterField);
                long timeDiffer = m_nCurrDocTime.compareTo(docTime);
                if (timeFilterCondition.equals(">") && timeDiffer > 0L) {
                    relateDocs.removeAt(i3, false);
                    continue;
                }
                if (!timeFilterCondition.equals("<") || timeDiffer >= 0L) continue;
                relateDocs.removeAt(i3, false);
            }
        }
        ArrayList<String> arExistDocumentTitles = new ArrayList<String>(relateDocs.size());
        arExistDocumentTitles.add(doc.getTitle().trim());
        for (int i4 = relateDocs.size() - 1; i4 >= 0; --i4) {
            Document document = (Document)relateDocs.getAt(i4);
            if (document == null) {
                relateDocs.removeAt(i4, false);
                continue;
            }
            String sTitle = document.getTitle().trim();
            if (arExistDocumentTitles.contains(sTitle)) {
                relateDocs.removeAt(i4, false);
                continue;
            }
            arExistDocumentTitles.add(sTitle);
        }
        return relateDocs;
    }

    private boolean isAncestor(int nAncestorChnlId, Channel oChannel) throws WCMException {
        while (oChannel != null) {
            if (oChannel.getId() == nAncestorChnlId) {
                return true;
            }
            oChannel = oChannel.getParent();
        }
        return false;
    }

    private void getAllChildChannelIds(List _oChildChannelIds, int _nParentChannelId) throws WCMException {
        List<Channel> tmpChannels;
        Channel parentChannel = Channel.findById(_nParentChannelId);
        if (parentChannel != null && (tmpChannels = parentChannel.getAllChildren(null)) != null && tmpChannels.size() > 0) {
            int length = tmpChannels.size();
            for (int i = 0; i < length; ++i) {
                Channel tmpChannel = tmpChannels.get(i);
                int nChannelId = tmpChannel.getId();
                _oChildChannelIds.add(nChannelId);
                this.getAllChildChannelIds(_oChildChannelIds, nChannelId);
            }
        }
    }

    private void excludeInvalidDocuments(Documents oDocs) throws WCMException {
        if (oDocs == null) {
            return;
        }
        for (int i = oDocs.size() - 1; i >= 0; --i) {
            Document oDocument = (Document)oDocs.getAt(i);
            if (oDocument != null && !oDocument.isDeleted()) continue;
            oDocs.removeAt(i, false);
        }
    }

    @Override
    public int getRecordSize() {
        return this.m_contents == null ? 0 : this.m_contents.size();
    }

    @Override
    public void setStartPos(int _nPos) {
        this.m_nCurrPos = _nPos;
    }

    @Override
    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            IPublishContent content = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            WCMFilter aFilter = new WCMFilter("", "RelDocId=?", "SERN");
            aFilter.addSearchValues(content.getId());
            WCMFilter mergeFilter = new WCMFilter("", "DocId=?", "SERN");
            mergeFilter.addSearchValues(this.m_nCurrDocId);
            aFilter.mergeWith(mergeFilter);
            RelationMgr currRelationMgr = (RelationMgr)DreamFactory.createObjectById("RelationMgr");
            Relations relations = currRelationMgr.getRelations(aFilter);
            if (relations.size() > 0) {
                Relation relation = (Relation)relations.getAt(0);
                int nChannelId = relation.getPropertyAsInt("CHANNELID", 0);
                if (Channel.findById(nChannelId) != null) {
                    IPublishFolder publishElement = (IPublishFolder)PublishElementFactory.lookupElement(101, nChannelId);
                    content.setFolder(publishElement);
                } else {
                    content.setFolder(content.getOriginalHome());
                }
            } else {
                content.setFolder(content.getOriginalHome());
            }
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(content);
            return this.m_nextRecordContext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }

    @Override
    public PublishTagContext getDelegatedContext() {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        this.m_nextRecordContext.setUpperHost(null);
        return this.m_nextRecordContext;
    }

    @Override
    public PublishTagContext substantiateContext(PublishTagContext _tagConext) throws WCMException {
        try {
            IPublishContent content = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            content.setFolder(content.getOriginalHome());
            _tagConext.setSequenceNumber(this.m_nCurrNumber++);
            _tagConext.setUpperHost(content);
            return _tagConext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }

    private MetaViewData findViewData(PublishTagContext _context) throws WCMException {
        IPublishElement upperHost = _context.getUpperHost();
        CMSObj obj = upperHost.getSubstance();
        if (obj instanceof MetaViewData) {
            return (MetaViewData)obj;
        }
        if (obj instanceof Document) {
            MetaView view = this.getMetaViewCachedByTagContext(_context, (Document)obj);
            return this.getViewDataCachedByTagContext(_context, obj, view);
        }
        throw new WCMException(I18NMessage.get(WCMTagParserRelNewsForViewData.class, "WCMTagParserRelNewsForViewData.label3", "TRS_ViewData\u7f6e\u6807\u4e0d\u80fd\u5e94\u7528\u5230\u5f53\u524d\u573a\u666f\u4e0b\uff01[UpperHost=") + obj.getClassName(true) + "]");
    }

    private MetaView getMetaViewCachedByTagContext(PublishTagContext _oTagContext, Document _document) throws WCMException {
        String sKey;
        MetaView view;
        HashMap<String, MetaView> hExtraAttributes = _oTagContext.getExtraAttributes();
        if (hExtraAttributes == null) {
            hExtraAttributes = new HashMap<String, MetaView>(1);
            _oTagContext.setExtraAttributes(hExtraAttributes);
        }
        if ((view = (MetaView)hExtraAttributes.get(sKey = "Curr.View." + _document.getId())) == null) {
            view = MetaView.findById(_document.getKindId());
            if (view == null) {
                throw new WCMException(I18NMessage.get(WCMTagParserRelNewsForViewData.class, "WCMTagParserRelNewsForViewData.label4", "\u5f53\u524d\u6587\u6863\u5173\u8054\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[DocId=") + _document.getId() + ",ViewId=" + _document.getKindId() + "]");
            }
            hExtraAttributes.put(sKey, view);
        }
        return view;
    }

    private MetaViewData getViewDataCachedByTagContext(PublishTagContext _oTagContext, CMSObj _host, MetaView _view) throws WCMException {
        String sKey;
        MetaViewData viewData;
        HashMap<String, MetaViewData> hExtraAttributes = _oTagContext.getExtraAttributes();
        if (hExtraAttributes == null) {
            hExtraAttributes = new HashMap<String, MetaViewData>(1);
            _oTagContext.setExtraAttributes(hExtraAttributes);
        }
        if ((viewData = (MetaViewData)hExtraAttributes.get(sKey = "Curr.ViewData." + _host.getId())) != null) {
            return viewData;
        }
        viewData = new MetaViewData(_view);
        viewData.loadById(_host.getId(), "");
        hExtraAttributes.put(sKey, viewData);
        return viewData;
    }

    static {
        s_oNameRegister.register("USERDEF", 30);
        s_oNameRegister.register("RELWORDS", 20);
        s_oNameRegister.register("KEYWORDS", 10);
        s_oNameRegister.register("ALL", 0);
        s_TagBeanInfo = null;
    }
}

