/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class MetaViewHelper {
    public static MetaViews findViews(User _currUser) throws WCMException {
        MetaViews metaViews;
        if (_currUser.isAdministrator()) {
            String sWhere = "select viewId from XWCMMetaViewEmployer where exists(select 1 from WCMChannel where Status>=0 and XWCMMetaViewEmployer.ChannelId=WCMChannel.ChannelId)";
            sWhere = "viewInfoId in  (" + sWhere + ")";
            WCMFilter filter = new WCMFilter("XWCMVIEWINFO", sWhere, "");
            return MetaViews.openWCMObjs(null, filter);
        }
        Connection oConn = null;
        Statement oStmt = null;
        ResultSet rsData = null;
        DBManager dbMgr = DBManager.getDBManager();
        String strSQL = "select ViewId,ChannelId from XWCMMetaViewEmployer order by ViewId";
        try {
            oConn = dbMgr.getConnection();
            oStmt = oConn.createStatement();
            oStmt.setFetchSize(1000);
            oStmt.setMaxRows(3000);
            rsData = oStmt.executeQuery(strSQL);
            ArrayList<Integer> arViewIds = new ArrayList<Integer>();
            while (rsData.next()) {
                int nChannelId;
                Channel channel;
                int nViewId = rsData.getInt(1);
                Integer iViewId = new Integer(nViewId);
                if (arViewIds.indexOf(iViewId) >= 0 || (channel = Channel.findById(nChannelId = rsData.getInt(2))) == null || !AuthServer.hasRight(_currUser, (CMSObj)channel, 31)) continue;
                arViewIds.add(iViewId);
            }
            if (arViewIds.isEmpty()) {
                MetaViews nViewId = new MetaViews(null);
                return nViewId;
            }
            StringBuffer sbIds = new StringBuffer(arViewIds.size() * 5);
            int nSize = arViewIds.size();
            for (int i = 0; i < nSize; ++i) {
                Integer iViewId = (Integer)arViewIds.get(i);
                if (iViewId == null) continue;
                sbIds.append(iViewId);
                sbIds.append(",");
            }
            sbIds.setLength(sbIds.length() - 1);
            metaViews = MetaViews.findByIds(null, sbIds.toString());
        }
        catch (SQLException ex) {
            throw new WCMException(I18NMessage.get(MetaViewHelper.class, "MetaViewHelper.label1", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(I18NMessage.get(MetaViewHelper.class, "MetaViewHelper.label1", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + strSQL, ex);
        }
        finally {
            if (oConn != null) {
                dbMgr.freeConnection(oConn);
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
        }
        return metaViews;
    }
}

