/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.infoview.InfoViewEmployMgr;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewDatas;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class WCMTagParserInfoViewDatas
extends BaseTagParser4List {
    private static Logger logger = Logger.getLogger(WCMTagParserInfoViewDatas.class);
    private static ArrayList FIELDS_DEFAULT_LIST_OF_DOCUMENT = new ArrayList(16);
    private static ArrayList FIELDS_DEFAULT_LIST_OF_INFOVIEWDATA;
    private InfoViewEmployMgr m_oInfoViewEmployMgr = null;
    private InfoView m_oCurrInfoview = null;
    private BaseChannel m_oChannel = null;
    private TagItem m_oTagItem = null;
    private Logger m_oLogger = Logger.getLogger(WCMTagParserInfoViewDatas.class);

    public WCMTagParserInfoViewDatas() {
        this.m_oInfoViewEmployMgr = (InfoViewEmployMgr)DreamFactory.createObjectById("InfoViewEmployMgr");
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        this.makeCurrChannel(_context);
        if (this.m_oChannel != null) {
            this.m_oCurrFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(this.m_oChannel);
        }
        return super.parse(_context);
    }

    private void makeCurrChannel(PublishTagContext _context) {
        try {
            int nChannelId = _context.getAttribute("ChannelId", 0);
            this.m_oChannel = nChannelId != 0 ? Channel.findById(nChannelId) : WCMTagParserHelper.findFolderHost(_context.getTagItem(), _context, false);
            this.m_oLogger.debug((Object)("\u5f53\u524d\u680f\u76ee\u662f\uff1a----" + this.m_oChannel.getName()));
        }
        catch (Exception e) {
            this.m_oLogger.debug((Object)e);
        }
    }

    @Override
    protected CMSBaseObjs findObjects(PublishTagContext _context) throws WCMException {
        this.makeCurrInfoview(_context);
        String sExtraWhere = _context.getAttribute("Where");
        String sOrder = _context.getAttribute("Order");
        if (this.m_oChannel == null || _context.getAttribute("DirectFromInfoViewTable", false)) {
            WCMFilter filter = new WCMFilter(null, null, null);
            StringBuffer sbWhere = new StringBuffer(300);
            sbWhere.append("exists(select WCMChnlDoc.DocId from WCMChnlDoc where WCMChnlDoc.DocId=");
            sbWhere.append(this.m_oCurrInfoview.getTrueTableName() + ".DocumentId");
            sbWhere.append(" and WCMChnlDoc.docFlag =? ");
            filter.addSearchValues(this.m_oCurrInfoview.getId());
            int[] _pStatuses = new int[]{10};
            if (_context.isPreview() && this.m_oChannel != null) {
                IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(this.m_oChannel);
                _pStatuses = this.getPreviewStatus(folder);
            }
            sbWhere.append(" and WCMChnlDoc.DOCSTATUS in(");
            for (int i = 0; i < _pStatuses.length; ++i) {
                sbWhere.append("?,");
                filter.addSearchValues(_pStatuses[i]);
            }
            if (_pStatuses.length > 0) {
                sbWhere.setLength(sbWhere.length() - 1);
            }
            sbWhere.append(")");
            if (this.m_oChannel != null && !_context.getAttribute("IgnoreChannel", false)) {
                if (this.m_oChannel.isSite()) {
                    sbWhere.append(" and WCMChnlDoc.ChnlId in(select WCMChannel.ChannelId from WCMChannel where WCMChannel.SiteId=?)");
                    filter.addSearchValues(this.m_oChannel.getId());
                } else {
                    String sQuery;
                    Channel oChannel = (Channel)this.m_oChannel;
                    if (!oChannel.isOnlySearch()) {
                        sbWhere.append(" and WCMChnlDoc.ChnlId=?");
                        filter.addSearchValues(this.m_oChannel.getId());
                    }
                    if ((sQuery = oChannel.getQuery()) != null && sQuery.length() > 0) {
                        sbWhere.append(sbWhere.length() > 0 ? " and (" : "(");
                        sbWhere.append(sQuery);
                        sbWhere.append(')');
                    }
                }
            }
            sbWhere.append(")");
            if (!CMyString.isEmpty(sExtraWhere)) {
                sbWhere.append(" and (" + sExtraWhere + ")");
            }
            filter.setWhere(sbWhere.toString());
            if (!CMyString.isEmpty(sOrder)) {
                filter.setOrder(sOrder);
            } else {
                filter.setOrder("CRTIME desc");
            }
            InfoViewDatas infoviewDatas = new InfoViewDatas(this.m_oCurrInfoview.getId());
            String sSelectFields = this.getSelectFields(this.m_oCurrInfoview.getTrueTableName().toUpperCase(), "TRS_INFOVIEWDATA", _context);
            filter.setSelect(sSelectFields);
            int nMaxNum = _context.getAttribute("NUM", -1);
            if (nMaxNum == -1) {
                nMaxNum = 300;
                _context.getTagItem().setAttribute("NUM", nMaxNum);
            }
            infoviewDatas.setPageSize(nMaxNum);
            infoviewDatas.setMaxBufferSize(nMaxNum);
            infoviewDatas.open(filter);
            return infoviewDatas;
        }
        WCMFilter extraFilter = new WCMFilter(null, null, sOrder);
        sExtraWhere = !CMyString.isEmpty(sExtraWhere) ? "exists(select " + this.m_oCurrInfoview.getTrueTableName() + ".DocumentId from " + this.m_oCurrInfoview.getTrueTableName() + " where (" + sExtraWhere + ") and WCMChnlDoc.DocId=" + this.m_oCurrInfoview.getTrueTableName() + ".DocumentId)" : "exists(select " + this.m_oCurrInfoview.getTrueTableName() + ".DocumentId from " + this.m_oCurrInfoview.getTrueTableName() + " where WCMChnlDoc.DocId=" + this.m_oCurrInfoview.getTrueTableName() + ".DocumentId)";
        extraFilter.setWhere(sExtraWhere);
        WCMFilter filter = new WCMFilter("WCMChnlDoc", "WCMChnlDoc.DocFlag=?", "", this.getSelectFields("WCMDOCUMENT", "TRS_DOCUMENT", _context));
        filter.mergeWith(extraFilter);
        filter.addSearchValues(this.m_oCurrInfoview.getId());
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(this.m_oChannel);
        if (_context.isPreview()) {
            return this.getPreviewContents(folder, filter);
        }
        return this.getPublishedContents(filter);
    }

    @Override
    protected boolean isValidate(PublishTagContext _context) throws WCMException {
        this.makeCurrInfoview(_context);
        return true;
    }

    private void makeCurrInfoview(PublishTagContext _context) throws WCMException {
        if (this.m_oCurrInfoview != null) {
            return;
        }
        int nInfoViewId = _context.getAttribute("InfoViewId", 0);
        if (nInfoViewId > 0) {
            System.out.println("----infoviewId:---------" + nInfoViewId);
            this.m_oCurrInfoview = InfoView.findById(nInfoViewId);
        } else {
            IPublishElement upperHost = _context.getUpperHost();
            CMSObj subinstance = upperHost.getSubstance();
            if (this.m_oChannel == null || !(this.m_oChannel instanceof Channel)) {
                throw new WCMException("\u7f6e\u6807\u4f7f\u7528\u573a\u666f\u4e0d\u5bf9\uff0c\u53ea\u80fd\u7528\u5728\u6307\u5b9a\u680f\u76ee\u6216\u8005\u6307\u5b9a\u6587\u6863\u4e0a\uff01\u5f53\u524d\u5bf9\u8c61\u662f[" + subinstance.getClassName(true) + "]\u7684\u5b9e\u4f8b");
            }
            int nChannelId = this.m_oChannel.getId();
            List lstInfoViews = this.m_oInfoViewEmployMgr.getEmployedInfoViews(101, nChannelId);
            if (lstInfoViews != null && lstInfoViews.size() > 0) {
                this.m_oCurrInfoview = (InfoView)lstInfoViews.get(0);
            }
        }
        if (this.m_oCurrInfoview == null) {
            throw new WCMException("\u6ca1\u6709\u5173\u8054\u5230\u6709\u6548\u7684\u8868\u5355");
        }
        this.m_oLogger.debug((Object)("\u5f53\u524d\u8868\u5355\u662f\uff1a----" + this.m_oCurrInfoview.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectFields(String _sTableName, String _sElementTagName, PublishTagContext _tagContext) {
        String sKey = (_sTableName + ".SELECT").toUpperCase();
        String sSelectFields = _tagContext.getTagItem().getExtraAttributeValue(sKey);
        if (sSelectFields == null) {
            TagItem tagItem = _tagContext.getTagItem();
            synchronized (tagItem) {
                sSelectFields = _tagContext.getTagItem().getExtraAttributeValue(sKey);
                if (sSelectFields == null) {
                    sSelectFields = this.makeSelectFields(_sTableName, _sElementTagName, _tagContext);
                    _tagContext.getTagItem().setExtraAttribute(sKey, sSelectFields);
                }
            }
        }
        return sSelectFields;
    }

    private String makeSelectFields(String _sTableName, String _sTagName, PublishTagContext _tagContext) {
        ArrayList arDefaultFields = null;
        arDefaultFields = _sTableName.equalsIgnoreCase("WCMDOCUMENT") ? FIELDS_DEFAULT_LIST_OF_DOCUMENT : FIELDS_DEFAULT_LIST_OF_INFOVIEWDATA;
        String sSelectFields = (String)arDefaultFields.get(0);
        int nSize = arDefaultFields.size();
        for (int i = 1; i < nSize; ++i) {
            sSelectFields = sSelectFields + "," + arDefaultFields.get(i);
        }
        ArrayList listChildFields = TagParseHelper.makeSelectFields(_tagContext.getTagItem(), _sTagName);
        DBManager dbMgr = DBManager.getDBManager();
        int nSize2 = listChildFields.size();
        for (int i = 0; i < nSize2; ++i) {
            String sFieldName = (String)listChildFields.get(i);
            if (arDefaultFields.indexOf(sFieldName) >= 0) continue;
            try {
                if (dbMgr.getFieldInfo(_sTableName, sFieldName) == null) {
                    _tagContext.addWarning("TRS_DOCUMENT\u7f6e\u6807\u6307\u5b9a\u7684Field[" + sFieldName + "]\u5728WCMDocument\u8868\u4e2d\u4e0d\u5b58\u5728\uff01");
                    continue;
                }
            }
            catch (WCMException ex) {
                ex.printStackTrace();
                try {
                    _tagContext.addWarning("\u83b7\u53d6\u6307\u5b9a\u7684Field[" + sFieldName + "]\u4eceWCMDocument\u8868\u4e2d\u53d1\u751f\u5f02\u5e38\uff01" + CMyException.getStackTraceText(ex));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sSelectFields = sSelectFields + "," + sFieldName;
        }
        return sSelectFields;
    }

    private CMSBaseObjs getPreviewContents(IPublishFolder _folder, WCMFilter _filter) throws WCMException {
        return this.getContents(this.getPreviewStatus(_folder), _filter);
    }

    private CMSBaseObjs getPublishedContents(WCMFilter _filter) throws WCMException {
        return this.getContents(this.getPublishStatus(), _filter);
    }

    private CMSBaseObjs getContents(int[] _pStatuses, WCMFilter _filter) throws WCMException {
        this.m_oLogger.debug((Object)("sql\u662f\uff1a----" + _filter));
        if (_pStatuses == null || _pStatuses.length <= 0) {
            return null;
        }
        DebugTimer aTimer = new DebugTimer();
        aTimer.start();
        WCMFilter filter = new WCMFilter("", "", "");
        filter.setMaxRowNumber(PublishServerConfigMapper.getTemplateParseConfig().getWcmOutlineContentsMaxNum());
        String sWhere = "WCMCHNLDOC.DOCSTATUS in(?";
        filter.addSearchValues(0, _pStatuses[0]);
        int nSize = _pStatuses.length;
        for (int i = 1; i < nSize; ++i) {
            sWhere = sWhere + ",?";
            filter.addSearchValues(i, _pStatuses[i]);
        }
        sWhere = sWhere + ")";
        filter.setWhere(sWhere);
        if (_filter != null) {
            filter.mergeWith(_filter);
        }
        this.m_oLogger.debug((Object)("sql2\u662f\uff1a----" + _filter));
        Documents docs = null;
        if (Document.DOCUMENTS_GET_OPTIMIZE) {
            if (this.m_oChannel == null || !(this.m_oChannel instanceof Channel)) {
                throw new WCMException("\u7f6e\u6807\u4f7f\u7528\u573a\u666f\u4e0d\u5bf9\uff0c\u53ea\u80fd\u7528\u5728\u8868\u5355\u6216\u6307\u5b9a\u680f\u76ee\u4e0a\uff01\u5f53\u524d\u5bf9\u8c61\u662f[" + this.m_oChannel + "]\u7684\u5b9e\u4f8b");
            }
            docs = DocumentsGetHelper.getDocuments((Channel)this.m_oChannel, filter);
        } else {
            DocumentMgr mgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
            docs = mgr.getDocuments(this.m_oChannel, filter);
        }
        aTimer.stop();
        return docs;
    }

    private int[] getPreviewStatus(IPublishFolder _folder) throws WCMException {
        IPublishFolder root = _folder.getRoot();
        IFolderPubStatusCacheMgr m_oCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        int[] pCanDoPubStatusIds = m_oCacheMgr.findStatusesCanDoIncreasePub(root.getType(), root.getId());
        if (pCanDoPubStatusIds == null) {
            return new int[]{10};
        }
        int[] pStatusIds = new int[pCanDoPubStatusIds.length + 1];
        System.arraycopy(pCanDoPubStatusIds, 0, pStatusIds, 0, pCanDoPubStatusIds.length);
        pStatusIds[pStatusIds.length - 1] = 10;
        return pStatusIds;
    }

    private int[] getPublishStatus() throws WCMException {
        return new int[]{10};
    }

    static {
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCID");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCCHANNEL");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCSTATUS");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCTITLE");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCFLAG");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("CRTIME");
        FIELDS_DEFAULT_LIST_OF_INFOVIEWDATA = new ArrayList(4);
        FIELDS_DEFAULT_LIST_OF_INFOVIEWDATA.add("ChannelId");
        FIELDS_DEFAULT_LIST_OF_INFOVIEWDATA.add("CRTIME");
        FIELDS_DEFAULT_LIST_OF_INFOVIEWDATA.add("DOCTITLE");
    }
}

