/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.extract;

import com.trs.components.infoview.extract.XSLTViewBuilder;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewField;
import com.trs.components.infoview.persistent.InfoViewGroup;
import com.trs.components.infoview.persistent.InfoViewView;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class XSLTViewConstrainter {
    private InfoView m_oInfoView;
    private InfoViewView m_oInfoViewView;
    String m_sXSLPrefix;
    private List m_lstViewFields = null;
    private List m_lstViewGroups = null;

    public void init(InfoView _oInfoView, InfoViewView _oInfoViewView) throws WCMException {
        this.init(_oInfoView, _oInfoViewView, null, null);
    }

    public void init(InfoView _oInfoView, InfoViewView _oInfoViewView, List _lsGroups, List _lsFields) throws WCMException {
        this.m_oInfoView = _oInfoView;
        this.m_oInfoViewView = _oInfoViewView;
        this.m_sXSLPrefix = this.m_oInfoViewView.getXSLPrefix();
        this.m_lstViewFields = _lsFields == null ? this.m_oInfoView.allFields() : _lsFields;
        this.m_lstViewGroups = _lsGroups == null ? this.m_oInfoView.allGroups() : _lsGroups;
    }

    public boolean rebuild(Document _oXslDocument) throws WCMException {
        boolean bResult = false;
        bResult = this.reformFields(_oXslDocument);
        bResult = this.reformGroups(_oXslDocument) || bResult;
        return bResult;
    }

    private boolean reformFields(Document _oXslDocument) throws WCMException {
        if (this.m_lstViewFields == null) {
            return false;
        }
        Element root = _oXslDocument.getRootElement();
        if (root == null) {
            return false;
        }
        Iterator itr = root.elementIterator("template");
        while (itr.hasNext()) {
            Element templateElement = (Element)itr.next();
            for (InfoViewField oField : this.m_lstViewFields) {
                String sXPath = oField.getXPath();
                if (sXPath == null) continue;
                for (Element oElement : templateElement.selectNodes("//*[@trs_temp_id=\"" + sXPath + "\"]")) {
                    this.reformHTMLElement(oElement, oField);
                }
            }
        }
        return true;
    }

    private boolean reformGroups(Document _oXslDocument) {
        if (this.m_lstViewGroups == null) {
            return false;
        }
        String sAttrXPath = "//*/@trs_obj_type";
        List list = _oXslDocument.selectNodes(sAttrXPath);
        if (list == null) {
            return false;
        }
        HashMap<String, InfoViewGroup> hsGroups = new HashMap<String, InfoViewGroup>();
        for (InfoViewGroup oGroup : this.m_lstViewGroups) {
            hsGroups.put(String.valueOf(oGroup.getId()), oGroup);
        }
        Iterator itrNodes = list.iterator();
        boolean bChanged = false;
        while (itrNodes.hasNext()) {
            Element elDiv;
            String id;
            InfoViewGroup oGroup;
            Attribute attr = (Attribute)itrNodes.next();
            if (!XSLTViewBuilder.TYPE_DATA_SECTION.equals(attr.getValue()) || (oGroup = (InfoViewGroup)hsGroups.get(id = (elDiv = attr.getParent()).attributeValue("trs_obj_id"))) == null) continue;
            String sFlag = oGroup.isPublicFill() ? "1" : "0";
            elDiv.addAttribute("trs_obj_publish", sFlag);
            bChanged = true;
        }
        return bChanged;
    }

    private void reformHTMLElement(Element element, InfoViewField _oField) throws WCMException {
        if (_oField == null) {
            return;
        }
        String sCtrlName = element.attributeValue("xctname");
        if (sCtrlName == null) {
            return;
        }
        element.addAttribute("title", CMyString.filterForXsltValue(_oField.getDesc()));
        String sValidation = null;
        if (!_oField.isNillable()) {
            element.addAttribute("not_null", "1");
            sValidation = "required:true";
        } else {
            Attribute attrValidation;
            Attribute attrNotNull = element.attribute("not_null");
            if (attrNotNull != null) {
                element.remove(attrNotNull);
            }
            if ((attrValidation = element.attribute("validation")) != null) {
                element.remove(attrValidation);
            }
        }
        if (sValidation == null) {
            sValidation = _oField.getDataControl();
        } else {
            String sDataControl = _oField.getDataControl();
            if (!CMyString.isEmpty(sDataControl)) {
                sValidation = sDataControl + "," + sValidation;
            }
        }
        element.addAttribute("default_value", CMyString.filterForXsltValue(CMyString.showNull(_oField.getDefaultValue())));
        element.addAttribute("gateway_binding", CMyString.filterForXsltValue(CMyString.showNull(_oField.getGateWayBinding())));
        element.addAttribute("trs_readonly_field", Integer.toString(_oField.isReadOnly() ? 1 : 0));
        element.addAttribute("trs_backreadonly_field", Integer.toString(_oField.isBackReadOnly() ? 1 : 0));
        element.addAttribute("trs_backshow_field", Integer.toString(_oField.isBackShowAble() ? 1 : 0));
        if (!CMyString.isEmpty(sValidation)) {
            element.addAttribute("validation", CMyString.filterForXsltValue(sValidation));
        }
        element.addAttribute("data_pattern", CMyString.filterForXsltValue(CMyString.showNull(_oField.getDataPattern())));
        element.addAttribute("data_type", CMyString.filterForXsltValue(CMyString.showNull(_oField.getDataTypeAsString())));
    }
}

